//
//  WCTableViewController+CompanyCardModel.m
//
//
//  Created by Howard on 2016/4/14.
//
//

#import "WCTableViewController+CompanyCardModel.h"


@implementation WCTableViewController (CompanyCardModel)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (NSUInteger)contactCardCount
{
    NSUInteger count = 0;
    
    for(WCCardSectionModel *sectionModel in self.allCardSectionArray)
    {
        count+=[sectionModel.cardArray count];
    }
    
    return count;
}


//================================================================================
//
//================================================================================
- (WCTCompanyCardModelDownloadStatus)contactDownloadStatusWithCardID:(NSString *)cardID
{
    WCTCompanyCardModelDownloadStatus downloadStatus = WCTCompanyCardModelDownloadStatus_UnDone;
    
    do
    {
        if([cardID length]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        downloadStatus = [self companyCardModelWithCardID:cardID].downloadStatus;
        
    }
    while (0);
    
    return downloadStatus;
}


//================================================================================
//
//================================================================================
- (WCTCompanyCardModel *)companyCardModelWithCardID:(NSString *)cardID
{
    WCTCompanyCardModel *cardModel = nil;

    do
    {
        if([cardID length]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        cardModel = [self.multiSelectCardModelMapping objectForKey:cardID];
        
        if(cardModel!=nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        for(WCCardSectionModel *cardSecitonModel in self.allCardSectionArray)
        {
            for(WCTCompanyCardModel *companyCardModel in cardSecitonModel.cardArray)
            {
                if([companyCardModel.ID compare:cardID]==NSOrderedSame)
                {
                    cardModel = companyCardModel;
                    
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            
            if(cardModel!=nil)
            {
                break;
            }
        }

    }
    while (0);
    
    return cardModel;
}


//================================================================================
//
//================================================================================
- (WCTCompanyCardModel *)companyCardModelWithIndexPath:(NSIndexPath *)indexPath
{
    WCTCompanyCardModel *cardModel = nil;
    
    do
    {
        if(self.allCardSectionArray.count<=indexPath.section)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        WCCardSectionModel *sectionModel = [self.allCardSectionArray objectAtIndex:indexPath.section];
        
        if(sectionModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if(sectionModel.cardArray.count<=indexPath.row)
        {
            break;
        }
        
        cardModel = [sectionModel.cardArray objectAtIndex:indexPath.row];
    }
    while (0);
    
    return cardModel;
}


//================================================================================
//
//================================================================================
- (NSIndexPath *)indexPathForCompanyCardModel:(WCTCompanyCardModel *)companyCardModel
{
    NSIndexPath *indexPath = nil;
    
    do
    {
        if(companyCardModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(WCCardSectionModel *sectionModel in self.allCardSectionArray)
        {
            for(WCTCompanyCardModel *existCompanyCardModel in sectionModel.cardArray)
            {
                if(companyCardModel==existCompanyCardModel)
                {
                    indexPath = [NSIndexPath indexPathForRow:[sectionModel.cardArray indexOfObject:existCompanyCardModel]
                                                   inSection:[self.allCardSectionArray indexOfObject:sectionModel]];
                    break;
                }
            }
        }
    }
    while (0);

    
    return indexPath;
}


//================================================================================
//
//================================================================================
- (NSInteger)sectionForCardModel:(WCTCompanyCardModel *)cardModel
{
    NSInteger section = NSNotFound;
    
    do
    {
        if(cardModel==nil ||
           [[cardModel sectionTitle] length]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        for(WCCardSectionModel *sectionModel in self.allCardSectionArray)
        {
            if([[cardModel sectionTitle] compare:sectionModel.title options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                section = [self.allCardSectionArray indexOfObject:sectionModel];
                
                break;
            }
        }
    }
    while (0);
    
    return section;
}
@end
