//
//  WCTAdvancedSearchViewController.m
//  Extension
//
//  Created by AndrewLai on 2018/3/2.
//

#import "WCTAdvancedSearchViewController.h"

// define
#import "WCTAdvancedSearchViewController+ParameterDefine.h"
#import "WCTAdvancedSearchViewController+ResourceDefine.h"
#import "WCAppearanceDefine.h"
#import "ContactApperanceDefine.h"


// category
#import "NSObject+PPBusyView.h"
#import "NSDate+Format.h"

// view
#import "SearchAccountDetailTableViewCell.h"

// viewcontroller

#import "SearchAccountSelectViewController.h"
#import "WCToastController.h"
#import "SearchMultiSelectViewController.h"

#import "UIColor+Contact.h"

//
//
//////////////////////////////////////////////////////////////////////////////////////////////////////
//typedef NS_ENUM(NSInteger, WCAdvancedSearchViewController_OptionCategory)
//{
//    
//};
const WCAdvancedSearchViewController_OptionCategory WCTAdvancedSearchViewController_OptionCategory_Account = WCAdvancedSearchViewController_OptionCategory_Date+1;
const WCAdvancedSearchViewController_OptionCategory WCTAdvancedSearchViewController_OptionCategory_UserDefine = WCAdvancedSearchViewController_OptionCategory_Date+2;

@interface WCTAdvancedSearchViewController () <SearchAccountSelectViewControllerDelegate, SearchMultiSelectViewControllerDelegate>

@property (nonatomic, retain)            NSMutableArray                 *currentCustomFieldArray;

@end
////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCTAdvancedSearchViewController Implementation

@implementation WCTAdvancedSearchViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [self initWithModelClass:[WCTAdvancedSearchModel class]];
    if (self)
    {
        [((WCTAdvancedSearchModel *)self.currentAdvancedSearchModel).accountConditions addObject:WCAdvancedSearchViewController_NewSearchOption];
        [((WCTAdvancedSearchModel *)self.currentAdvancedSearchModel).customFieldConditions addObject:WCAdvancedSearchViewController_NewSearchOption];
        //////////////////////////////////////////////////
        [self.currentOptionCategoryArray addObjectsFromArray:@[@(WCTAdvancedSearchViewController_OptionCategory_Account),
                                                               @(WCTAdvancedSearchViewController_OptionCategory_UserDefine)]];
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    
    [_currentCustomFieldArray removeAllObjects];
    [_currentCustomFieldArray release];
    _currentCustomFieldArray = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    //////////////////////////////////////////////////
    [self setBusy:@(YES)];
    
    __block typeof(self) blockSelf = self;
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        if ([blockSelf.delegateForWCT respondsToSelector:@selector(requestCustomFieldInfoArrayInAdvancedSearchViewController:)]==YES)
        {
            blockSelf.currentCustomFieldArray = [blockSelf.delegateForWCT requestCustomFieldInfoArrayInAdvancedSearchViewController:blockSelf];
        }
        
        dispatch_async(dispatch_get_main_queue(), ^{
            [blockSelf.advanceSearchView.advanceSearchTableView reloadData];
            [blockSelf setBusy:@(NO)];
        });
    });
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark -


//================================================================================
//
//================================================================================
- (void)loadAdvancedSearchModel:(WCAdvancedSearchModel *)advancedSearchModel
{
    WCTAdvancedSearchModel *adjustSearchModel = [(WCTAdvancedSearchModel *)advancedSearchModel copy];
    
    //////////////////////////////////////////////////
    if ([adjustSearchModel.accountConditions count]==0)
    {
        [adjustSearchModel.accountConditions addObject:WCAdvancedSearchViewController_NewSearchOption];
    }
    
    //////////////////////////////////////////////////
    if ([adjustSearchModel.customFieldConditions count]==0)
    {
        [adjustSearchModel.customFieldConditions addObject:WCAdvancedSearchViewController_NewSearchOption];
    }
    else
    {
        if ([adjustSearchModel.customFieldConditions count]<WCAdvancedSearchViewController_MaxOptionCount)
        {
            id tempObject = [adjustSearchModel.customFieldConditions lastObject];
            if ([tempObject isKindOfClass:[WCSearchOptionModel class]]==YES)
            {
                [adjustSearchModel.customFieldConditions addObject:WCAdvancedSearchViewController_NewSearchOption];
            }
        }
    }
    
    //////////////////////////////////////////////////
    [super loadAdvancedSearchModel:adjustSearchModel];
    [adjustSearchModel release];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - utility


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)conditionsWithOptionCategory:(WCAdvancedSearchViewController_OptionCategory)optionCategory
{
    switch (optionCategory)
    {
        case WCTAdvancedSearchViewController_OptionCategory_Account:
        {
            return ((WCTAdvancedSearchModel *)self.currentAdvancedSearchModel).accountConditions;
        }
        case WCTAdvancedSearchViewController_OptionCategory_UserDefine:
        {
            return ((WCTAdvancedSearchModel *)self.currentAdvancedSearchModel).customFieldConditions;
        }
            
        default:
            return [super conditionsWithOptionCategory:optionCategory];
    }
}

//==============================================================================
//
//==============================================================================
- (NSString *)fieldTypeStringFromType:(WCSearchType)searchType
{
    if(searchType>=WCSearchType_Custom)
    {
        switch (searchType)
        {
            case WCSearchType_UserDefine:
                return WCCV_MLS_UserDefine;
            case WCTSearchType_Creator:
                return WCCV_MLS_SearchTypeCreater;
            case WCTSearchType_Editor:
                return WCTASVC_MLS_SearchTypeEditor;
            case WCTSearchType_Owner:
            default:
                return WCTASVC_MLS_SearchTypeOwner;
        }
    }
    else
    {
        return [super fieldTypeStringFromType:searchType];
    }
}


//==============================================================================
//
//==============================================================================
- (PPSectionModel *)customFieldSectionModel
{
    PPSectionModel *sectionModel = [[[PPSectionModel alloc] init] autorelease];
    
    for (WCCustomFieldInfo *fieldInfo in self.currentCustomFieldArray)
    {
        NSString *itemText = fieldInfo.name;
        [sectionModel.rowModels addObject:[PPRowModel rowModelWithRow:[self.currentCustomFieldArray indexOfObject:fieldInfo]
                                                                 text:itemText
                                                           detailText:nil
                                                               object:nil]];
    }

    return sectionModel;
}


//==============================================================================
//
//==============================================================================
- (WCAdvancedSearchModel *)correctAdvnacedSearchModelWithReturnedErrorFieldTitle:(NSString **)errorFieldTitle
{
    NSString *errorContentTitle = nil;
    WCTAdvancedSearchModel * advancedSearchModel = (WCTAdvancedSearchModel *)[super correctAdvnacedSearchModelWithReturnedErrorFieldTitle:errorFieldTitle];
    
    do {
        //////////////////////////////////////////////////
        NSMutableArray *customFieldConditions = [self conditionsWithOptionCategory:WCTAdvancedSearchViewController_OptionCategory_UserDefine];
        for (id tempModel in customFieldConditions)
        {
            if ([tempModel isKindOfClass:[WCSearchOptionModel class]]==YES)
            {
                WCSearchOptionModel *customFieldOption = tempModel;
                WCCustomFieldInfo *customFieldInfo = nil;
                for (WCCustomFieldInfo *fieldInfo in self.currentCustomFieldArray)
                {
                    if ([fieldInfo.guid isEqualToString:customFieldOption.customFieldID]==YES)
                    {
                        customFieldInfo = fieldInfo;
                        break;
                    }
                }
                
                switch (customFieldOption.customFieldType)
                {
                    case WCCustomFieldContentType_Text:
                    case WCCustomFieldContentType_URL:
                    case WCCustomFieldContentType_Email:
                    {
                        if ([customFieldOption.customFieldValue length]>0)
                        {
                            [advancedSearchModel.customFieldConditions addObject:tempModel];
                        }
                        else
                        {
                            errorContentTitle = customFieldInfo.name;
                        }
                        
                        break;
                    }
                    case WCCustomFieldContentType_Date:
                    case WCCustomFieldContentType_DateTime:
                    {
                        if (customFieldOption.fromDate!=nil || customFieldOption.toDate!=nil)
                        {
                            [advancedSearchModel.customFieldConditions addObject:tempModel];
                        }
                        else
                        {
                            errorContentTitle = customFieldInfo.name;
                        }
                        
                        break;
                    }
                    case WCCustomFieldContentType_Integer:
                    case WCCustomFieldContentType_Float:
                    {
                        if ([customFieldOption.customFieldValueFrom length]>0 || [customFieldOption.customFieldValueTo length]>0)
                        {
                            [advancedSearchModel.customFieldConditions addObject:tempModel];
                        }
                        else
                        {
                            errorContentTitle = customFieldInfo.name;
                        }
                        
                        break;
                    }
                    case WCCustomFieldContentType_Picklist:
                    {
                        if ([customFieldOption.text length]>0)
                        {
                            [advancedSearchModel.customFieldConditions addObject:tempModel];
                        }
                        else
                        {
                            errorContentTitle = customFieldInfo.name;
                        }
                        
                        break;
                    }
                    default:
                    {
                        break;
                    }
                }
                
                if ([errorContentTitle length]>0)
                {
                    break;
                }
            }
        }
        
        //////////////////////////////////////////////////
        if ([errorContentTitle length]>0)
        {
            break;
        }
        //////////////////////////////////////////////////
        NSMutableArray *accountConditions = [self conditionsWithOptionCategory:WCTAdvancedSearchViewController_OptionCategory_Account];
        for (id tempModel in accountConditions)
        {
            if ([tempModel isKindOfClass:[WCSearchOptionModel class]]==YES)
            {
                [advancedSearchModel.accountConditions addObject:tempModel];
            }
        }
    } while (0);

    if([errorContentTitle length]>0)
    {
        if(errorFieldTitle!=NULL)
        {
            *errorFieldTitle = errorContentTitle;
        }
    }
    return advancedSearchModel;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - AdvanceSearchViewDataSource


//==============================================================================
//
//==============================================================================
- (NSString *)advanceSearchView:(AdvanceSearchView *)advanceSearchView titleForHeaderInSection:(NSInteger)section
{
    // !! WCT特有的欄位
    NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:section];
    WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;

    switch (optionCategory)
    {
        case WCTAdvancedSearchViewController_OptionCategory_Account:
        {
            return WCTASVC_MLS_SectionTitleAccount;
        }
        case WCTAdvancedSearchViewController_OptionCategory_UserDefine:
        {
            return WCTASVC_MLS_SectionTitleCustomField;
        }
        default:
            return [super advanceSearchView:advanceSearchView titleForHeaderInSection:section];
    }
}


//================================================================================
// MARK: 產生Cell欄位
//================================================================================
- (UITableViewCell *)advanceSearchView:(AdvanceSearchView *)advanceSearchView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [super advanceSearchView:advanceSearchView cellForRowAtIndexPath:indexPath];
    
    // !! WCT特有的欄位
    NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:indexPath.section];
    WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;

    if ([super isAddSearchOptionAtIndexPath:indexPath]==YES)
    {
        if(optionCategory==WCTAdvancedSearchViewController_OptionCategory_UserDefine)
        {
            //這邊tableview 是編輯狀態，導致箭號消失
            cell.editingAccessoryType  = UITableViewCellAccessoryNone;
            cell.textLabel.text = WCASVC_MLS_OptionOperatorAdd;
        }
    }
    else
    {
        switch (optionCategory)
        {
            case WCTAdvancedSearchViewController_OptionCategory_Account:
            {
                cell = [advanceSearchView.advanceSearchTableView dequeueReusableCellWithIdentifier:[NSString stringWithFormat:@"%td-%td",indexPath.section,indexPath.row]];

                //////////////////////////////////////////////////
                if(cell==nil)
                {
                    cell = [[[SearchAccountDetailTableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle
                                                                    reuseIdentifier:[NSString stringWithFormat:@"%td-%td",indexPath.section,indexPath.row]] autorelease];
                }

                //////////////////////////////////////////////////
                cell.editingAccessoryType = UITableViewCellAccessoryDisclosureIndicator;
                [cell.textLabel setTextColor:WCAppearanceDefine_CellTitleColor];

                NSMutableArray *conditions = [self conditionsWithOptionCategory:optionCategory];
                WCTSearchOptionModel *currentOptionModel = [conditions objectAtIndex:indexPath.row];
                cell.textLabel.text = [self fieldTypeStringFromType:currentOptionModel.searchType];
                cell.detailTextLabel.numberOfLines = 0;
                cell.detailTextLabel.lineBreakMode = NSLineBreakByWordWrapping;
                cell.detailTextLabel.text = currentOptionModel.text;
                cell.detailTextLabel.adjustsFontSizeToFitWidth = NO;
                cell.detailTextLabel.font = [UIFont systemFontOfSize:WCAdvancedSearchViewControllerTableViewCellAccountDetailTextFontSize];

                break;
            }
                
            case WCTAdvancedSearchViewController_OptionCategory_UserDefine:
            {
                NSMutableArray *conditions = [self conditionsWithOptionCategory:optionCategory];
                WCTSearchOptionModel *currentOptionModel = [conditions objectAtIndex:indexPath.row];
                WCCustomFieldInfo *customFieldInfo = nil;
                for (WCCustomFieldInfo *fieldInfo in self.currentCustomFieldArray)
                {
                    if ([fieldInfo.guid isEqualToString:currentOptionModel.customFieldID]==YES)
                    {
                        customFieldInfo = fieldInfo;
                        break;
                    }
                }

                switch (customFieldInfo.contentType)
                {
                    case WCCustomFieldContentType_Text:
                    case WCCustomFieldContentType_URL:
                    case WCCustomFieldContentType_Email:
                    {
                        NSString *indentifiler = [NSString stringWithFormat:@"%td", customFieldInfo.contentType];
                        cell = [advanceSearchView.advanceSearchTableView dequeueReusableCellWithIdentifier:[TextFieldTableViewCell stringByAppendingString:indentifiler]];

                        //////////////////////////////////////////////////
                        if(cell==nil)
                        {
                            cell = [[[SearchTextFieldTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:[TextFieldTableViewCell stringByAppendingString:indentifiler]] autorelease];
                        }

                        //////////////////////////////////////////////////
                        SearchTextFieldTableViewCell *textFieldCell = (SearchTextFieldTableViewCell *)cell;
                        [textFieldCell.textLabel setTextColor:WCAppearanceDefine_CellTitleColor];

                        textFieldCell.delegate  = self.advanceSearchView;
                        textFieldCell.contactKeyboardToolBarViewDelegate = self.advanceSearchView;
                        textFieldCell.operatorDelegate = self.advanceSearchView;

                        //////////////////////////////////////////////////
                        textFieldCell.ignoreCustomLabelFrame = YES;

                        //////////////////////////////////////////////////
                        [textFieldCell.textLabel setText:customFieldInfo.name];
                        [textFieldCell.textField setText:currentOptionModel.customFieldValue];

                        //////////////////////////////////////////////////
                        textFieldCell.textField.inputAccessoryView.frame = CGRectMake(0, 0, self.view.bounds.size.width,ContactKeyboardToolBarViewButtonHeight);

                        //////////////////////////////////////////////////
                        if (customFieldInfo.contentType==WCCustomFieldContentType_Email)
                        {
                            textFieldCell.textField.keyboardType = UIKeyboardTypeEmailAddress;
                            textFieldCell.textField.autocapitalizationType = UITextAutocapitalizationTypeNone;
                        }
                        else if (customFieldInfo.contentType==WCCustomFieldContentType_URL)
                        {
                            textFieldCell.textField.keyboardType = UIKeyboardTypeURL;
                            textFieldCell.textField.autocapitalizationType = UITextAutocapitalizationTypeNone;
                        }
                        else
                        {
                            textFieldCell.textField.keyboardType = UIKeyboardTypeDefault;
                            textFieldCell.textField.autocapitalizationType = UITextAutocapitalizationTypeWords;
                        }

                        //////////////////////////////////////////////////
                        if (indexPath.row==0)
                        {
                            textFieldCell.searchOperatorButton.enabled = NO;
                            textFieldCell.directionImageView.hidden = YES;

                            [textFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorFirst maxWidth:0.0];
                        }
                        else
                        {
                            textFieldCell.searchOperatorButton.enabled = YES;
                            textFieldCell.directionImageView.hidden = NO;

                            if (currentOptionModel.searchOperator==WCSearchOperator_OR)
                            {
                                [textFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorOr maxWidth:0.0];
                            }
                            else
                            {
                                [textFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorAnd maxWidth:0.0];
                            }
                        }

                        break;
                    }
                    case WCCustomFieldContentType_Integer:
                    case WCCustomFieldContentType_Float:
                    {
                        NSString *indentifiler = [NSString stringWithFormat:@"%td", customFieldInfo.contentType];
                        cell = [advanceSearchView.advanceSearchTableView dequeueReusableCellWithIdentifier:indentifiler];

                        //////////////////////////////////////////////////
                        if(cell==nil)
                        {
                            cell = [[[SearchNumberTextFieldTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:indentifiler] autorelease];
                        }

                        //////////////////////////////////////////////////
                        SearchNumberTextFieldTableViewCell *numberTextFieldCell = (SearchNumberTextFieldTableViewCell *)cell;
                        [numberTextFieldCell.textLabel setTextColor:WCAppearanceDefine_CellTitleColor];
                        numberTextFieldCell.delegate = self.advanceSearchView;
                        numberTextFieldCell.contactKeyboardToolBarViewDelegate = self.advanceSearchView;
                        numberTextFieldCell.operatorDelegate = self.advanceSearchView;

                        ////////////////////////////////////////////////
                        numberTextFieldCell.textField.inputAccessoryView.frame = CGRectMake(0, 0, self.view.bounds.size.width,ContactKeyboardToolBarViewButtonHeight);
                        numberTextFieldCell.subTextField.inputAccessoryView.frame = CGRectMake(0, 0, self.view.bounds.size.width,ContactKeyboardToolBarViewButtonHeight);

                        //////////////////////////////////////////////////
                        numberTextFieldCell.ignoreCustomLabelFrame = YES;

                        //////////////////////////////////////////////////
                        [numberTextFieldCell.textLabel setText:customFieldInfo.name];
                        [numberTextFieldCell.textField setText:currentOptionModel.customFieldValueFrom];
                        [numberTextFieldCell.textField setFont:[UIFont systemFontOfSize:WCAdvancedSearchViewControllerTableViewCellDateTextFontSize]];
                        [numberTextFieldCell.subTextField setText:currentOptionModel.customFieldValueTo];
                        [numberTextFieldCell.subTextField setFont:[UIFont systemFontOfSize:WCAdvancedSearchViewControllerTableViewCellDateTextFontSize]];

                        //////////////////////////////////////////////////
                        if (indexPath.row==0)
                        {
                            numberTextFieldCell.searchOperatorButton.enabled = NO;
                            numberTextFieldCell.directionImageView.hidden = YES;

                            [numberTextFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorFirst maxWidth:0.0];
                        }
                        else
                        {
                            numberTextFieldCell.searchOperatorButton.enabled = YES;
                            numberTextFieldCell.directionImageView.hidden = NO;

                            if (currentOptionModel.searchOperator==WCSearchOperator_OR)
                            {
                                [numberTextFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorOr maxWidth:0.0];
                            }
                            else
                            {
                                [numberTextFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorAnd maxWidth:0.0];
                            }
                        }

                        //////////////////////////////////////////////////
                        if (customFieldInfo.contentType==WCCustomFieldContentType_Float)
                        {
                            numberTextFieldCell.textField.keyboardType = UIKeyboardTypeDecimalPad;
                            numberTextFieldCell.textField.autocapitalizationType = UITextAutocapitalizationTypeNone;
                            numberTextFieldCell.subTextField.keyboardType = UIKeyboardTypeDecimalPad;
                            numberTextFieldCell.subTextField.autocapitalizationType = UITextAutocapitalizationTypeNone;
                        }
                        else if (customFieldInfo.contentType==WCCustomFieldContentType_Integer)
                        {
                            numberTextFieldCell.textField.keyboardType = UIKeyboardTypeNumberPad;
                            numberTextFieldCell.textField.autocapitalizationType = UITextAutocapitalizationTypeNone;
                            numberTextFieldCell.subTextField.keyboardType = UIKeyboardTypeNumberPad;
                            numberTextFieldCell.subTextField.autocapitalizationType = UITextAutocapitalizationTypeNone;
                        }
                        else
                        {
                            numberTextFieldCell.textField.keyboardType = UIKeyboardTypeDefault;
                            numberTextFieldCell.textField.autocapitalizationType = UITextAutocapitalizationTypeWords;
                            numberTextFieldCell.subTextField.keyboardType = UIKeyboardTypeDefault;
                            numberTextFieldCell.subTextField.autocapitalizationType = UITextAutocapitalizationTypeWords;
                        }

                        break;
                    }
                    case WCCustomFieldContentType_Date:
                    case WCCustomFieldContentType_DateTime:
                    {
                        NSString *indentifiler = [NSString stringWithFormat:@"%td", customFieldInfo.contentType];
                        cell = [advanceSearchView.advanceSearchTableView dequeueReusableCellWithIdentifier:indentifiler];

                        //////////////////////////////////////////////////
                        if(cell==nil)
                        {
                            cell = [[[SearchDateAndTimeTextFieldTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:indentifiler] autorelease];
                        }

                        //////////////////////////////////////////////////
                        //!!讓游標顏色消失
                        SearchDateAndTimeTextFieldTableViewCell *dateTextFieldCell = (SearchDateAndTimeTextFieldTableViewCell *)cell;
                        [dateTextFieldCell.textLabel setTextColor:WCAppearanceDefine_CellTitleColor];

                        dateTextFieldCell.textField.tintColor = [UIColor clearColor];
                        dateTextFieldCell.subTextField.tintColor = [UIColor clearColor];

                        dateTextFieldCell.delegate = self.advanceSearchView;
                        dateTextFieldCell.contactKeyboardToolBarViewDelegate = self.advanceSearchView;
                        dateTextFieldCell.operatorDelegate = self.advanceSearchView;

                        ////////////////////////////////////////////////
                        dateTextFieldCell.textField.inputAccessoryView.frame = CGRectMake(0, 0, self.view.bounds.size.width,ContactKeyboardToolBarViewButtonHeight);
                        dateTextFieldCell.subTextField.inputAccessoryView.frame = CGRectMake(0, 0, self.view.bounds.size.width,ContactKeyboardToolBarViewButtonHeight);

                        //////////////////////////////////////////////////
                        dateTextFieldCell.ignoreCustomLabelFrame = YES;

                        //////////////////////////////////////////////////
                        [dateTextFieldCell.textLabel setText:customFieldInfo.name];

                        //////////////////////////////////////////////////
                        dateTextFieldCell.datePicker.datePickerMode = UIDatePickerModeDate;

                        //////////////////////////////////////////////////
                        NSDateFormatter *dateFormatter = [[[NSDateFormatter alloc] init] autorelease];
                        [dateFormatter setDateFormat:NSDateFormat_Day];

                        NSString *fromDateString = [dateFormatter stringFromDate:currentOptionModel.fromDate];
                        [dateTextFieldCell.textField setText:fromDateString];
                        [dateTextFieldCell.textField setFont:[UIFont systemFontOfSize:WCAdvancedSearchViewControllerTableViewCellDateTextFontSize]];

                        NSString *toDateString = [dateFormatter stringFromDate:currentOptionModel.toDate];
                        [dateTextFieldCell.subTextField setText:toDateString];
                        [dateTextFieldCell.subTextField setFont:[UIFont systemFontOfSize:WCAdvancedSearchViewControllerTableViewCellDateTextFontSize]];

                        //////////////////////////////////////////////////
                        if (indexPath.row==0)
                        {
                            dateTextFieldCell.searchOperatorButton.enabled = NO;
                            dateTextFieldCell.directionImageView.hidden = YES;

                            [dateTextFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorFirst maxWidth:0.0];
                        }
                        else
                        {
                            dateTextFieldCell.searchOperatorButton.enabled = YES;
                            dateTextFieldCell.directionImageView.hidden = NO;

                            if (currentOptionModel.searchOperator==WCSearchOperator_OR)
                            {
                                [dateTextFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorOr maxWidth:0.0];
                            }
                            else
                            {
                                [dateTextFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorAnd maxWidth:0.0];
                            }
                        }

                        break;
                    }
                    case WCCustomFieldContentType_Picklist:
                    {
                        NSString *indentifiler = [NSString stringWithFormat:@"%td", customFieldInfo.contentType];
                        cell = [advanceSearchView.advanceSearchTableView dequeueReusableCellWithIdentifier:indentifiler];

                        //////////////////////////////////////////////////
                        if(cell==nil)
                        {
                            cell = [[[SearchPicklistChoiceTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:indentifiler] autorelease];
                        }

                        //////////////////////////////////////////////////
                        SearchPicklistChoiceTableViewCell *picklistTextFieldCell = (SearchPicklistChoiceTableViewCell *)cell;

                        [picklistTextFieldCell.textLabel setTextColor:WCAppearanceDefine_CellTitleColor];
                        picklistTextFieldCell.delegate  = self.advanceSearchView;
                        picklistTextFieldCell.contactKeyboardToolBarViewDelegate = self.advanceSearchView;
                        picklistTextFieldCell.operatorDelegate = self.advanceSearchView;

                        //////////////////////////////////////////////////
                        picklistTextFieldCell.ignoreCustomLabelFrame = YES;

                        //////////////////////////////////////////////////
                        [picklistTextFieldCell.textLabel setText:customFieldInfo.name];

                        if (currentOptionModel.customFieldListItemIDs.count==0)
                        {
                            [picklistTextFieldCell.searchChoiceButton setTitleColor:[UIColor colorWithWhite:0.8 alpha:1.0]];
                            [picklistTextFieldCell.searchChoiceButton.titleLabel setFont:[UIFont systemFontOfSize:14]];
                            [picklistTextFieldCell.searchChoiceButton setTitle:WCASVC_MLS_OptionOperatorEmpty maxWidth:0.0];
                        }
                        else
                        {
                            [picklistTextFieldCell.searchChoiceButton setTitleColor:[UIColor contactEditViewInputFieldTextColor]];
                            [picklistTextFieldCell.searchChoiceButton setTitle:currentOptionModel.text maxWidth:0.0];
                        }

                        //////////////////////////////////////////////////
                        if (indexPath.row==0)
                        {
                            picklistTextFieldCell.searchOperatorButton.enabled = NO;
                            picklistTextFieldCell.directionImageView.hidden = YES;

                            [picklistTextFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorFirst maxWidth:0.0];
                        }
                        else
                        {
                            picklistTextFieldCell.searchOperatorButton.enabled = YES;
                            picklistTextFieldCell.directionImageView.hidden = NO;

                            if (currentOptionModel.searchOperator==WCSearchOperator_OR)
                            {
                                [picklistTextFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorOr maxWidth:0.0];
                            }
                            else
                            {
                                [picklistTextFieldCell.searchOperatorButton setTitle:WCASVC_MLS_OptionOperatorAnd maxWidth:0.0];
                            }
                        }

                        break;
                    }
                    default:
                        break;
                }

                break;
            }

            default:
                break;
        }
    
    }
    return cell;
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AdvanceSearchViewDelegate


//==============================================================================
//
//==============================================================================
- (CGFloat)advanceSearchView:(AdvanceSearchView *)advanceSearchView estimatedHeightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if ([self isAddSearchOptionAtIndexPath:indexPath]==YES)
    {
        // 新增欄位由parent決定
        return [super advanceSearchView:advanceSearchView estimatedHeightForRowAtIndexPath:indexPath];
    }
    else
    {
        NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:indexPath.section];
        WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
        switch (optionCategory)
        {
            case WCTAdvancedSearchViewController_OptionCategory_Account:
            {
                NSMutableArray *conditions = [self conditionsWithOptionCategory:optionCategory];
                WCSearchOptionModel *optionModel = [conditions objectAtIndex:indexPath.row];
                
                NSMutableParagraphStyle *style = [[NSParagraphStyle defaultParagraphStyle] mutableCopy];
                [style setLineBreakMode:NSLineBreakByWordWrapping];
                NSDictionary *attributes = @{NSFontAttributeName:[UIFont systemFontOfSize:WCAdvancedSearchViewControllerTableViewCellAccountDetailTextFontSize], NSParagraphStyleAttributeName:style};
                [style release];
                
                CGRect boundingRect = [optionModel.text boundingRectWithSize:CGSizeMake(self.view.bounds.size.width-100, 10000)
                                                                     options:NSStringDrawingUsesLineFragmentOrigin
                                                                  attributes:attributes
                                                                     context:nil];
                return boundingRect.size.height+WCAdvancedSearchViewControllerTableViewCellHeightInset;
            }
            case WCTAdvancedSearchViewController_OptionCategory_UserDefine:
            {
                CGFloat rowHeight = advanceSearchView.advanceSearchTableView.estimatedRowHeight*2;
                NSMutableArray *conditions = [self conditionsWithOptionCategory:optionCategory];
                WCSearchOptionModel *currentOptionModel = [conditions objectAtIndex:indexPath.row];
                WCCustomFieldInfo *currentFieldInfo = nil;
                for (WCCustomFieldInfo *fieldInfo in self.currentCustomFieldArray)
                {
                    if ([fieldInfo.guid isEqualToString:currentOptionModel.customFieldID]==YES)
                    {
                        currentFieldInfo = fieldInfo;
                        break;
                    }
                }
                
                if (currentFieldInfo!=nil)
                {
                    switch (currentFieldInfo.contentType)
                    {
                        case WCCustomFieldContentType_Integer:
                        case WCCustomFieldContentType_Float:
                        case WCCustomFieldContentType_Date:
                        case WCCustomFieldContentType_DateTime:
                        {
                            rowHeight = advanceSearchView.advanceSearchTableView.estimatedRowHeight*3;
                            break;
                        }
                        default:
                            break;
                    }
                }
                
                return rowHeight;
            }
            default:
                // 其他還是由parent決定
                return [super advanceSearchView:advanceSearchView estimatedHeightForRowAtIndexPath:indexPath];
        }
    }
}


//==============================================================================
//
//==============================================================================
- (CGFloat)advanceSearchView:(AdvanceSearchView *)advanceSearchView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return [self advanceSearchView:advanceSearchView estimatedHeightForRowAtIndexPath:indexPath];
}

//==============================================================================
//
//==============================================================================
- (UITableViewCellEditingStyle)advanceSearchView:(AdvanceSearchView *)advanceSearchView editingStyleForRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:indexPath.section];
    WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
    switch (optionCategory)
    {
        case WCTAdvancedSearchViewController_OptionCategory_UserDefine:
        {
            if ([self isAddSearchOptionAtIndexPath:indexPath]==YES)
            {
                return UITableViewCellEditingStyleInsert;
            }
            else
            {
                return UITableViewCellEditingStyleDelete;
            }
        }
        default:
        {
            return [super advanceSearchView:advanceSearchView editingStyleForRowAtIndexPath:indexPath];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath
{
    // !! 如果沒有自訂欄位不能新增欄位
    NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:indexPath.section];
    WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
    if(optionCategory==WCTAdvancedSearchViewController_OptionCategory_UserDefine)
    {
        if([self.currentCustomFieldArray count]==0)
        {
            [WCToastController showMessageToastFromSuperView:self.view
                                                 withMessage:WCTASVC_MLS_CustomFieldNotExist
                                                    position:PPToastPositionCenter];
            return ;
        }
        else
        {
            // 顯示自訂選單
            
            if(editingStyle==UITableViewCellEditingStyleInsert)
            {
                [self showSelectItemViewControllerWithTitle:WCTASVC_MLS_NavigationUserDefineAdd
                                                  indexPath:indexPath
                                               sectionModel:[self customFieldSectionModel]
                                            completeHandler:^(PPSectionModel * _Nonnull selectedSectionModel, PPRowModel * _Nonnull selectedRowModel)
                 {
                     WCTSearchOptionModel *optionModel = [WCTSearchOptionModel searchOptionModelForAND];
                     if (optionModel!=nil)
                     {
                         if (selectedRowModel.row < [self.currentCustomFieldArray count])
                         {
                             WCCustomFieldInfo *customField = [self.currentCustomFieldArray objectAtIndex:selectedRowModel.row];
                             if (customField!=nil)
                             {
                                 optionModel.customFieldID = customField.guid;
                                 optionModel.searchType    = WCSearchType_UserDefine;
                                 optionModel.customFieldType = customField.contentType;
                             }
                         }
                     }
                     [self insertCellWithOptionModel:optionModel optionCategory:optionCategory];
                     
                 }];
            }
            else if (editingStyle==UITableViewCellEditingStyleDelete)
            {
                __block typeof(self) blockSelf = self;
                dispatch_async(dispatch_get_main_queue(), ^{
                    [blockSelf removeCellAtIndexPath:indexPath];
                });
            }
        }
    }
    else
    {
        [super advanceSearchView:advanceSearchView commitEditingStyle:editingStyle forRowAtIndexPath:indexPath];
    }
}


//================================================================================
//
//================================================================================
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [super advanceSearchView:advanceSearchView didSelectRowAtIndexPath:indexPath];
    
    //////////////////////////////////////////////////
    // !! WCT新增的處理
    UITableViewCell *cell = [self.advanceSearchView.advanceSearchTableView cellForRowAtIndexPath:indexPath];
    
    NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:indexPath.section];
    WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
    switch (optionCategory)
    {
        case WCTAdvancedSearchViewController_OptionCategory_Account:
        {
            self.currentSelectIndexPath = indexPath;
            
            NSMutableArray *conditions = [self conditionsWithOptionCategory:optionCategory];
            id tempModel = [conditions objectAtIndex:indexPath.row];
            
            SearchAccountSelectViewController *accountSelectViewController = [[SearchAccountSelectViewController alloc] init];
            if(accountSelectViewController!=nil)
            {
                accountSelectViewController.delegate = self;
                
                if ([tempModel isKindOfClass:[WCTSearchOptionModel class]]==YES)
                {
                    //初始化
                    WCTSearchOptionModel *currentOptionModel = tempModel;
                    accountSelectViewController.currentSearchTypeSelected = (WCTSearchType)currentOptionModel.searchType;
                    accountSelectViewController.accountSelected = currentOptionModel.accountGuids;
                }
                
                [self.navigationController pushViewController:accountSelectViewController animated:YES];
                [accountSelectViewController release];
            }
            
            break;
        }
        case WCTAdvancedSearchViewController_OptionCategory_UserDefine:
        {
            if(cell.editingStyle==UITableViewCellEditingStyleInsert)
            {
                [self advanceSearchView:advanceSearchView commitEditingStyle:UITableViewCellEditingStyleInsert forRowAtIndexPath:indexPath];
            }
            
            break;
        }
        default:
            break;
    }
}


//================================================================================
//
//================================================================================
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView ppTextFieldTableViewCellDidEndEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell atIndexPath:(NSIndexPath *)indexPath
{
    NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:indexPath.section];
    WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
    switch (optionCategory)
    {
        case WCTAdvancedSearchViewController_OptionCategory_UserDefine:
        {
            NSMutableArray *conditions = [self conditionsWithOptionCategory:optionCategory];
            WCSearchOptionModel *currentOptionModel = [conditions objectAtIndex:indexPath.row];
            WCCustomFieldInfo *currentFieldInfo = nil;
            for (WCCustomFieldInfo *fieldInfo in self.currentCustomFieldArray)
            {
                if ([fieldInfo.guid isEqualToString:currentOptionModel.customFieldID]==YES)
                {
                    currentFieldInfo = fieldInfo;
                    break;
                }
            }
            
            switch (currentFieldInfo.contentType)
            {
                case WCCustomFieldContentType_Text:
                case WCCustomFieldContentType_URL:
                case WCCustomFieldContentType_Email:
                {
                    currentOptionModel.customFieldValue = textFieldTableViewCell.textField.text;
                    break;
                }
                case WCCustomFieldContentType_Date:
                case WCCustomFieldContentType_DateTime:
                {
                    SearchDateAndTimeTextFieldTableViewCell *dateTimeTextFieldCell = (SearchDateAndTimeTextFieldTableViewCell *)textFieldTableViewCell;
                    currentOptionModel.customFieldValueFrom = dateTimeTextFieldCell.textField.text;
                    currentOptionModel.customFieldValueTo   = dateTimeTextFieldCell.subTextField.text;
                    
                    NSDateFormatter *dateFormatter = [[[NSDateFormatter alloc] init] autorelease];
                    [dateFormatter setDateFormat:NSDateFormat_Day];
                    currentOptionModel.fromDate = [dateFormatter dateFromString:currentOptionModel.customFieldValueFrom];
                    currentOptionModel.toDate   = [dateFormatter dateFromString:currentOptionModel.customFieldValueTo];
                    break;
                }
                case WCCustomFieldContentType_Integer:
                case WCCustomFieldContentType_Float:
                {
                    SearchNumberTextFieldTableViewCell *numberTextFieldCell = (SearchNumberTextFieldTableViewCell *)textFieldTableViewCell;
                    currentOptionModel.customFieldValueFrom = numberTextFieldCell.textField.text;
                    currentOptionModel.customFieldValueTo   = numberTextFieldCell.subTextField.text;
                    
                    break;
                }
                default:
                    break;
            }
            break;
        }
        default:
        {
            [super advanceSearchView:advanceSearchView ppTextFieldTableViewCellDidEndEditing:textFieldTableViewCell atIndexPath:indexPath];
            break;
        }
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - SearchAccountSelectViewControllerDelegate

//================================================================================
//MARK: 上方運算子點選(目前僅聯絡人/自訂)
//================================================================================
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView searchTableViewCellDidClickOperatorButton:(UITableViewCell *)searchTableViewCell
{
    NSNumber *optionCategoryNumber = [self.currentOptionCategoryArray objectAtIndex:self.currentSelectIndexPath.section];
    WCAdvancedSearchViewController_OptionCategory optionCategory = optionCategoryNumber.integerValue;
    
    if (optionCategory==WCTAdvancedSearchViewController_OptionCategory_UserDefine)
    {
        NSIndexPath *indexPath = [advanceSearchView.advanceSearchTableView indexPathForCell:searchTableViewCell];
        [self showOperatorSelectionWithIndexPath:indexPath completeHandler:^(NSUInteger itemIndex, NSString * _Nonnull itemString) {
            
            NSMutableArray *conditions = [self conditionsWithOptionCategory:optionCategory];
            if([conditions count]>indexPath.row)
            {
                WCSearchOptionModel *currentOptionModel = [conditions objectAtIndex:indexPath.row];
                
                //////////////////////////////////////////////////
                if([itemString isEqualToString:WCASVC_MLS_OptionOperatorAnd]==YES)
                {
                    currentOptionModel.searchOperator = WCSearchOperator_AND;
                }
                else
                {
                    currentOptionModel.searchOperator = WCSearchOperator_OR;
                }
            }
        }];
    }
    else
    {
        [super advanceSearchView:advanceSearchView searchTableViewCellDidClickOperatorButton:searchTableViewCell];
    }
}


//================================================================================
//MARK: 下方選單按鈕點選
//================================================================================
- (void)advanceSearchView:(AdvanceSearchView *)advanceSearchView searchTableViewCellDidClickChoiceButton:(SearchPicklistChoiceTableViewCell *)picklistChoiceTableViewCell
{
    self.currentSelectIndexPath = [advanceSearchView.advanceSearchTableView indexPathForCell:picklistChoiceTableViewCell];
    
    SearchMultiSelectViewController *searchMultiSelectViewController = [[SearchMultiSelectViewController alloc] init];
    if(searchMultiSelectViewController!=nil)
    {
        searchMultiSelectViewController.delegate = self;
        
        [self.navigationController pushViewController:searchMultiSelectViewController animated:YES];
        [searchMultiSelectViewController release];
    }
}

//================================================================================
//
//================================================================================
- (NSMutableArray<WCTAccountRelationModel *> *)requestAccountListInSearchAccountSelectViewController:(SearchAccountSelectViewController *)searchAccountSelectViewController
{
    NSMutableArray *accountList = nil;

    if ([self.delegateForWCT respondsToSelector:@selector(requestAccountListInAdvancedSearchViewController:)]==YES)
    {
        accountList = [self.delegateForWCT requestAccountListInAdvancedSearchViewController:self];
    }

    return accountList;
}


//================================================================================
//
//================================================================================
- (void)searchAccountSelectViewController:(SearchAccountSelectViewController *)searchAccountSelectViewController didFinishSelectAccounts:(NSMutableArray<WCTAccountRelationModel *> *)accountList
{
    __block typeof(self) blockSelf = self;
    dispatch_async(dispatch_get_main_queue(), ^{
        WCTSearchOptionModel *accountOptionModel = nil;
        
        if([accountList count]>0)
        {
            accountOptionModel = [WCTSearchOptionModel searchOptionModelForAND];
            if (accountOptionModel!=nil)
            {
                NSString *accountString = @"";
                NSMutableArray *accountGuids = [NSMutableArray array];
                for (WCTAccountRelationModel *accountRelation in accountList)
                {
                    if ([accountList indexOfObject:accountRelation]==accountList.count-1)
                    {
                        accountString = [NSString stringWithFormat:@"%@%@", accountString, accountRelation.name];
                    }
                    else
                    {
                        accountString = [NSString stringWithFormat:@"%@%@;", accountString, accountRelation.name];
                    }
                    
                    [accountGuids addObject:accountRelation.guid];
                }
                
                accountOptionModel.text = accountString;
                accountOptionModel.searchType = (WCSearchType)searchAccountSelectViewController.currentSearchTypeSelected;
                accountOptionModel.accountGuids = accountGuids;

            }
        }
        [blockSelf updateCellWithOptionModel:accountOptionModel optionCategory:WCTAdvancedSearchViewController_OptionCategory_Account];
    });
}







////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - SearchMultiSelectViewControllerDelegate

//================================================================================
//
//================================================================================
- (NSMutableArray<SearchSelectModel *> *)requestListInSearchMultiSelectViewController:(SearchMultiSelectViewController *)searchMultiSelectViewController
{
    NSMutableArray *conditions = [self conditionsWithOptionCategory:WCTAdvancedSearchViewController_OptionCategory_UserDefine];
    WCSearchOptionModel *currentOptionModel = [conditions objectAtIndex:self.currentSelectIndexPath.row];
    WCCustomFieldInfo *currentFieldInfo = nil;
    for (WCCustomFieldInfo *fieldInfo in self.currentCustomFieldArray)
    {
        if ([fieldInfo.guid isEqualToString:currentOptionModel.customFieldID]==YES)
        {
            currentFieldInfo = fieldInfo;
            break;
        }
    }
    
    //////////////////////////////////////////////////
    NSMutableArray *selectList = [NSMutableArray array];
    for (WCCustomFieldListItem *fieldListItem in currentFieldInfo.picklistItems)
    {
        @autoreleasepool
        {
            SearchSelectModel *selectModel = [[[SearchSelectModel alloc] init] autorelease];
            selectModel.relationModel = fieldListItem;
            selectModel.selectItemString = fieldListItem.itemText;
            
            [selectList addObject:selectModel];
            
            for (NSString *itemGuid in currentOptionModel.customFieldListItemIDs)
            {
                if ([itemGuid isEqualToString:fieldListItem.guid]==YES)
                {
                    selectModel.isSelected = YES;
                }
            }
        }
    }
    
    return selectList;
}


//================================================================================
//
//================================================================================
- (void)searchMultiSelectViewController:(SearchMultiSelectViewController *)searchMultiSelectViewController didFinishSelectModels:(NSMutableArray<SearchSelectModel *> *)selectList
{
    NSMutableArray *conditions = [self conditionsWithOptionCategory:WCTAdvancedSearchViewController_OptionCategory_UserDefine];
    WCSearchOptionModel *currentOptionModel = [conditions objectAtIndex:self.currentSelectIndexPath.row];
    if (currentOptionModel!=nil)
    {
        NSString *pickListString = @"";
        NSMutableArray *picklistIDs = [NSMutableArray array];
        for (SearchSelectModel *selectModel in selectList)
        {
            if ([selectList indexOfObject:selectModel]==selectList.count-1)
            {
                pickListString = [NSString stringWithFormat:@"%@%@", pickListString, selectModel.selectItemString];
            }
            else
            {
                pickListString = [NSString stringWithFormat:@"%@%@;", pickListString, selectModel.selectItemString];
            }
            
            WCCustomFieldListItem *listItem = selectModel.relationModel;
            [picklistIDs addObject:listItem.guid];
        }
        
        currentOptionModel.text = pickListString;
        currentOptionModel.customFieldListItemIDs = picklistIDs;
        
        [self.advanceSearchView.advanceSearchTableView reloadRowsAtIndexPaths:[NSArray arrayWithObject:self.currentSelectIndexPath] withRowAnimation:UITableViewRowAnimationAutomatic];
    }
}
@end
