//
//  WCTAccountSelectViewController.m
//  Pods
//
//  Created by AndrewLai on 2016/4/19.
//
//

#import "WCTAccountSelectViewController.h"

// Define
#import "WCTAccountSelectViewController+ResourceDefine.h"

//Model
#import "NSString+Additions.h"
#import "UIColor+HexString.h"

//View
#import "PPBusyView.h"
#import "PPButton+Factory.h"
#import "PPNavigationBarView.h"
#import "PPTableView.h"
#import "ASVCCheckBoxAccountCell.h"
#import "ASVCTableViewCell.h"

//Controllers
#import "ASVCSectionController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
#define WCTAppearanceDefine_IconButtonImageEdgeInset             UIEdgeInsetsMake(10, 10, 10, 10)
#define WCTAppearanceDefine_IconButtonHighlightedBackgroundColor [UIColor colorWithHexString:@"#2c538f"]

static NSString * const WCTAccountSelectViewController_ImageNameOfAccountSelectDone = @"AccountSelectDone";

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSUInteger, WCTAccountSelectViewControllerButtonTag)
{
    WCTAccountSelectViewControllerButtonTag_Back = 1,
    WCTAccountSelectViewControllerButtonTag_Done
};

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - WCTAccountSelectViewController Extension

@interface WCTAccountSelectViewController () <PPButtonDelegate, UITableViewDataSource, UITableViewDelegate>
@property (nonatomic, retain) PPBusyView          *busyView;
@property (nonatomic, retain) PPButton            *ppButtonBack;
@property (nonatomic, retain) PPButton            *ppButtonDone;
@property (nonatomic, retain) PPNavigationBarView *ppNavigationBarView;

@property (nonatomic, retain) ASVCSectionController *accountSelectSectionController;
@property (nonatomic, retain) NSOperationQueue      *fetchListOperationQueue;
@property (nonatomic, retain) PPTableView           *selectTableView;
@end





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - WCTAccountSelectViewController Implementation

@implementation WCTAccountSelectViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if (self = [super init])
    {
        _accountSelectSectionController = [[ASVCSectionController alloc] init];
        
        //////////////////////////////////////////////////
        _fetchListOperationQueue = [[NSOperationQueue alloc] init];
        if (self.fetchListOperationQueue!=nil)
        {
            [self.fetchListOperationQueue setMaxConcurrentOperationCount:1];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_fetchListOperationQueue cancelAllOperations];
    [_fetchListOperationQueue release];
    _fetchListOperationQueue = nil;
    
    //////////////////////////////////////////////////
    [_accountSelectSectionController release];
    _accountSelectSectionController = nil;
    
    [_userInfo release];
    _userInfo = nil;
    
    [_busyView removeFromSuperview];
    [_busyView release];
    _busyView = nil;
    
    [self.ppButtonBack removeFromSuperview];
    self.ppButtonBack.delegate = nil;
    self.ppButtonBack = nil;
    
    [self.ppButtonDone removeFromSuperview];
    self.ppButtonDone.delegate = nil;
    self.ppButtonDone = nil;
    
    [self.ppNavigationBarView removeFromSuperview];
    self.ppNavigationBarView = nil;
    
    [self.selectTableView removeFromSuperview];
    self.selectTableView.dataSource = nil;
    self.selectTableView.delegate = nil;
    self.selectTableView = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    self.backgroundImageView.backgroundColor = [UIColor whiteColor];
    
    //////////////////////////////////////////////////
    _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    if (self.ppNavigationBarView!=nil)
    {
        self.ppNavigationBarView.style = PPBarViewStyle_CenteredAbsolute;
        
        //////////////////////////////////////////////////
        _ppButtonBack = [[PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                         tag:WCTAccountSelectViewControllerButtonTag_Back
                                                    delegate:self
                                       normalBackgroundColor:nil
                                  highlightedBackgroundColor:WCTAppearanceDefine_IconButtonHighlightedBackgroundColor
                                             imageEdgeInsets:WCTAppearanceDefine_IconButtonImageEdgeInset] retain];
        if (self.ppButtonBack!=nil)
        {
            [self.ppButtonBack addControlEvents:UIControlEventTouchUpInside];
            
            PPBarViewItemModel *backItemModel  = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
            if (backItemModel!=nil)
            {
                backItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                [self.ppNavigationBarView setItemModels:@[backItemModel] forBlockType:PPBarViewBlockType_Left];
            }
        }
        
        //////////////////////////////////////////////////
        switch (self.style)
        {
            case WCTAccountSelectViewControllerStyle_ShareToColleague:
            {
                [self.ppNavigationBarView.titleLabel setText:WASVC_MLS_ShareToColleague];
                break;
            }
            case WCTAccountSelectViewControllerStyle_ChangeVisibleAccounts:
            {
                [self.ppNavigationBarView.titleLabel setText:WASVC_MLS_ChangeVisibleAccounts];
                break;
            }
            case WCTAccountSelectViewControllerStyle_ViewAccountSwitch:
            {
                [self.ppNavigationBarView.titleLabel setText:WASVC_MLS_ViewAccountSwitch];
                break;
            }
            case WCTAccountSelectViewControllerStyle_ChangeOwner:
            {
                [self.ppNavigationBarView.titleLabel setText:WASVC_MLS_ChangeOwner];
                break;
            }
            default:
                break;
        }
        
        //////////////////////////////////////////////////
        
        if (self.style!=WCTAccountSelectViewControllerStyle_ViewAccountSwitch)
        {
            _ppButtonDone = [[PPButton ppButtonWithIconImageName:WCTAccountSelectViewController_ImageNameOfAccountSelectDone
                                                             tag:WCTAccountSelectViewControllerButtonTag_Done
                                                        delegate:self
                                           normalBackgroundColor:nil
                                      highlightedBackgroundColor:WCTAppearanceDefine_IconButtonHighlightedBackgroundColor
                                                 imageEdgeInsets:WCTAppearanceDefine_IconButtonImageEdgeInset] retain];
            if (self.ppButtonDone!=nil)
            {
                [self.ppButtonDone addControlEvents:UIControlEventTouchUpInside];
                
                PPBarViewItemModel *doneItemModel  = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonDone];
                if (doneItemModel!=nil)
                {
                    doneItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                    [self.ppNavigationBarView setItemModels:@[doneItemModel] forBlockType:PPBarViewBlockType_Right];
                }
            }
        }
        
        self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
    }
    
    //////////////////////////////////////////////////
    _selectTableView = [[PPTableView alloc] initWithFrame:CGRectZero];
    if (self.selectTableView!=nil)
    {
        self.selectTableView.backgroundColor = [UIColor whiteColor];
        self.selectTableView.dataSource      = self;
        self.selectTableView.delegate        = self;
        
        [self fetchAccountListDictionary];
        [self.view addSubview:self.selectTableView];
    }
}


//================================================================================
//
//================================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    [self.fetchListOperationQueue cancelAllOperations];
    
    //////////////////////////////////////////////////
    [super viewWillDisappear:animated];
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self.ppButtonBack removeFromSuperview];
    self.ppButtonBack.delegate = nil;
    self.ppButtonBack = nil;
    
    [self.ppButtonDone removeFromSuperview];
    self.ppButtonDone.delegate = nil;
    self.ppButtonDone = nil;
    
    [self.ppNavigationBarView removeFromSuperview];
    self.ppNavigationBarView = nil;
    
    [self.selectTableView removeFromSuperview];
    self.selectTableView.dataSource = nil;
    self.selectTableView.delegate = nil;
    self.selectTableView = nil;
    
    //////////////////////////////////////////////////
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    self.selectTableView.frame = self.view.bounds;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)fetchAccountListDictionary
{
    do
    {
        [self showBusyView:YES];
        
        //////////////////////////////////////////////////
        //!! 先判斷是否有歷史紀錄，切回頁面時，不應該重新Load資訊，除非有更新資訊！
        NSMutableArray *selectSectionModels = [[self.accountSelectSectionController sectionModelsForSearching:NO] retain];
        if (selectSectionModels!=nil && [selectSectionModels count]>0)
        {
            [self.selectTableView reloadData];
            
            [selectSectionModels release];
            [self showBusyView:NO];
            break;
        }
        [selectSectionModels release];

        //////////////////////////////////////////////////
        // 進行Background Thread抓取資訊
        if (self.fetchListOperationQueue==nil)
        {
            break;
        }
        
        __block NSBlockOperation *blockOperation = [[[NSBlockOperation alloc] init] autorelease];
        if (blockOperation==nil)
        {
            break;
        }

        //////////////////////////////////////////////////
        __block typeof(self) blockSelf = self;
        [blockOperation addExecutionBlock:^{
            NSArray *otherAccountList = nil;
            NSArray *selectedAccountGuidList = nil;
            NSString *ownerAccountGuid = nil;
            
            if (blockSelf.style==WCTAccountSelectViewControllerStyle_ViewAccountSwitch)
            {
                if (blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(viewAccountListForAccountSelectViewController:)]==YES)
                {
                    otherAccountList = [blockSelf.delegate viewAccountListForAccountSelectViewController:blockSelf];

                }
                
                if (blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(selectedAccountGuidListForAccountSelectViewController:)]==YES)
                {
                    selectedAccountGuidList = [blockSelf.delegate selectedAccountGuidListForAccountSelectViewController:blockSelf];
                    
                    //////////////////////////////////////////////////

                    
                    if(selectedAccountGuidList!=nil)
                    {
                        NSMutableArray *attachAccountGuidList = [NSMutableArray arrayWithObject:@""];
                        
                        if(attachAccountGuidList!=nil)
                        {
                            [attachAccountGuidList addObjectsFromArray:selectedAccountGuidList];
                            
                            selectedAccountGuidList = attachAccountGuidList;
                        }
                    }
                }
            }
            else
            {
                if (blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(allAccountListForAccountSelectViewController:)]==YES)
                {
                    otherAccountList = [blockSelf.delegate allAccountListForAccountSelectViewController:blockSelf];
                    
                    otherAccountList = [otherAccountList sortedArrayUsingComparator:^NSComparisonResult(WCTAccountRelationModel *obj1, WCTAccountRelationModel *obj2) {
                        
                        return [obj1.name compare:obj2.name options:NSCaseInsensitiveSearch|NSDiacriticInsensitiveSearch|NSNumericSearch|NSForcedOrderingSearch];
                    }];
                }
                
                //////////////////////////////////////////////////
                if (blockSelf.style==WCTAccountSelectViewControllerStyle_ShareToColleague)
                {
                    for (WCTAccountRelationModel *infoModel in otherAccountList)
                    {
                        if (infoModel.relation==WCTAccountRelationModel_Relation_Account)
                        {
                            NSMutableArray *translateArray = [NSMutableArray arrayWithArray:otherAccountList];
                            [translateArray removeObject:infoModel];
                            otherAccountList = translateArray;
                        }
                        
                        if (infoModel.relation==WCTAccountRelationModel_Relation_Boss)
                        {
                            NSMutableArray *translateArray = [NSMutableArray arrayWithArray:otherAccountList];
                            [translateArray removeObject:infoModel];
                            otherAccountList = translateArray;
                        }
                    }
                    
                    //!! 為了設定而新增預設勾選帳號
                    if (blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(selectedAccountGuidListForAccountSelectViewController:)]==YES)
                    {
                        selectedAccountGuidList = [blockSelf.delegate selectedAccountGuidListForAccountSelectViewController:blockSelf];
                    }
                }
                
                //////////////////////////////////////////////////
                if (blockSelf.style==WCTAccountSelectViewControllerStyle_ChangeVisibleAccounts)
                {
                    for (WCTAccountRelationModel *infoModel in otherAccountList)
                    {
                        if (infoModel.relation==WCTAccountRelationModel_Relation_Boss)
                        {
                            NSMutableArray *translateArray = [NSMutableArray arrayWithArray:otherAccountList];
                            [translateArray removeObject:infoModel];
                            otherAccountList = translateArray;
                        }
                    }
                    
                    if (blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(selectedAccountGuidListForAccountSelectViewController:)]==YES)
                    {
                        selectedAccountGuidList = [blockSelf.delegate selectedAccountGuidListForAccountSelectViewController:blockSelf];
                    }
                    
                    if (blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(ownerAccountGuidForAccountSelectViewController:)]==YES)
                    {
                        ownerAccountGuid = [blockSelf.delegate ownerAccountGuidForAccountSelectViewController:blockSelf];
                    }
                }
                
                //////////////////////////////////////////////////
                if (blockSelf.style==WCTAccountSelectViewControllerStyle_ChangeOwner)
                {
                    for (WCTAccountRelationModel *infoModel in otherAccountList)
                    {
                        if (infoModel.relation==WCTAccountRelationModel_Relation_Boss)
                        {
                            infoModel.relation = WCTAccountRelationModel_Relation_None;
                        }
                    }
                    
                    if (blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(ownerAccountGuidForAccountSelectViewController:)]==YES)
                    {
                        ownerAccountGuid = [blockSelf.delegate ownerAccountGuidForAccountSelectViewController:blockSelf];
                        selectedAccountGuidList = [NSArray arrayWithObject:ownerAccountGuid];
                    }
                }
            }
            
            [blockSelf.accountSelectSectionController fetchAccountListFromSourceArray:otherAccountList
                                                                    selectedGuidArray:selectedAccountGuidList
                                                                            ownerGuid:ownerAccountGuid
                                                            sectionModelsForSearching:NO];
            
            //////////////////////////////////////////////////
            __block NSBlockOperation *blockMainOperation = [NSBlockOperation blockOperationWithBlock:^{
                [blockSelf.selectTableView reloadData];
                [blockSelf showBusyView:NO];
            }];
            
            @synchronized([NSOperationQueue mainQueue])
            {
                [[NSOperationQueue mainQueue] addOperation:blockMainOperation];
            }
        }];

        @synchronized(self.fetchListOperationQueue)
        {
            if([self.fetchListOperationQueue operationCount]>0)
            {
                [self.fetchListOperationQueue cancelAllOperations];
            }
            
            [self.fetchListOperationQueue addOperation:blockOperation];
        }
    } while (0);
}


//================================================================================
//
//================================================================================
- (void)showBusyView:(BOOL)show
{
    if(show==YES)
    {
        if(self.busyView==nil)
        {
            _busyView = [[PPBusyView alloc] initWithSuperView:self.navigationController.view];
        }
    }
    else
    {
        [self.busyView removeFromSuperview];
        self.busyView = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Instance Method





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCTAccountSelectViewControllerButtonTag_Back:
        {
            [self goBackAnimated:YES];
            
            break;
        }
        case WCTAccountSelectViewControllerButtonTag_Done:
        {
            NSMutableArray *selectAccountArray = [NSMutableArray array];
            
            for (NSInteger index=0; index<[self.accountSelectSectionController numberOfRowsInSection:0 forSearching:NO]; index++)
            {
                NSIndexPath *indexPath = [NSIndexPath indexPathForRow:index inSection:0];
                PPRowModel *rowModel = [self.accountSelectSectionController rowModelAtIndexPath:indexPath forSearching:NO];
                ASVCAccountSelectModel *accountModel = rowModel.object;
                if (accountModel.isSelected==YES)
                {
                    [selectAccountArray addObject:[self.accountSelectSectionController.sourceArray objectAtIndex:index]];
                }
            }
            
            //////////////////////////////////////////////////
            //回傳選擇結果
            if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(accountSelectViewController:didSelectAccountArray:)]==YES)
            {
                [self.delegate accountSelectViewController:self didSelectAccountArray:selectAccountArray];
            }
            
            break;
        }
        default:
            break;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - UITableViewDataSource

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return [self.accountSelectSectionController numberOfSectionsForSearching:NO];
}


//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [self.accountSelectSectionController numberOfRowsInSection:section forSearching:NO];
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = nil;
    
    PPRowModel *rowModel  = [self.accountSelectSectionController rowModelAtIndexPath:indexPath forSearching:NO];
    
    switch (self.style)
    {
        case WCTAccountSelectViewControllerStyle_ShareToColleague:
        case WCTAccountSelectViewControllerStyle_ChangeVisibleAccounts:
        case WCTAccountSelectViewControllerStyle_ChangeOwner:
        {
            cell = [tableView dequeueReusableCellWithIdentifier:@"ASVCCheckBoxAccountCellIdentifier"];
            if (cell==nil)
            {
                cell = [[[ASVCCheckBoxAccountCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"ASVCCheckBoxAccountCellIdentifier"] autorelease];
            }
            
            ASVCCheckBoxAccountCell *checkCell = (ASVCCheckBoxAccountCell *)cell;
            checkCell.textLabel.text = rowModel.text;
            checkCell.selectionStyle = UITableViewCellSelectionStyleNone;
            
            ASVCAccountSelectModel *accountModel = rowModel.object;
            [checkCell setCheckBoxViewStatus:accountModel.isSelected];
            
            break;
        }
        case WCTAccountSelectViewControllerStyle_ViewAccountSwitch:
        default:
        {
            cell = [tableView dequeueReusableCellWithIdentifier:@"UITableViewCellIdentifier"];
            if (cell==nil)
            {
                cell = [[[ASVCTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:@"UITableViewCellIdentifier"] autorelease];
            }
            
            ASVCTableViewCell *tableViewCell = (ASVCTableViewCell *)cell;
            
            ASVCAccountSelectModel *accountModel = rowModel.object;
            tableViewCell.textLabel.text = rowModel.text;
            [tableViewCell.textLabel setNumberOfLines:2];
            
            [tableViewCell setCardCount:accountModel.shareContactCount];
            
            break;
        }
    }
    
    
    
    
    return cell;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - UITableViewDelegate

//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    PPRowModel *rowModel = [self.accountSelectSectionController rowModelAtIndexPath:indexPath forSearching:NO];
    ASVCAccountSelectModel *accountModel = rowModel.object;
    
    if (accountModel.accountRole==ASVCAccountSelectModel_AccountRole_Normal)
    {
        if (self.style==WCTAccountSelectViewControllerStyle_ViewAccountSwitch)
        {
            if (accountModel.isSelected==NO)
            {
                //實作單選，取消已選擇帳號
                for (NSInteger index=0; index<[self.accountSelectSectionController numberOfRowsInSection:indexPath.section forSearching:NO]; index++)
                {
                    NSIndexPath *otherIndexPath = [NSIndexPath indexPathForRow:index inSection:indexPath.section];
                    PPRowModel *otherRowModel = [self.accountSelectSectionController rowModelAtIndexPath:otherIndexPath forSearching:NO];
                    ASVCAccountSelectModel *otherAccountModel = otherRowModel.object;
                    if (otherAccountModel.isSelected==YES)
                    {
                        otherAccountModel.isSelected = NO;
                        [self.selectTableView reloadRowsAtIndexPaths:[NSArray arrayWithObject:otherIndexPath] withRowAnimation:UITableViewRowAnimationFade];
                        break;
                    }
                }
                
                //////////////////////////////////////////////////
                // 回傳選擇結果，外部應該直接關閉頁面
                accountModel.isSelected = YES;
                [self.selectTableView reloadRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
            }
            
            //////////////////////////////////////////////////
            //回傳選擇結果
            NSMutableArray *selectAccountArray = [NSMutableArray array];
            [selectAccountArray addObject:[self.accountSelectSectionController.sourceArray objectAtIndex:indexPath.row]];
                
            if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(accountSelectViewController:didSelectAccountArray:)]==YES)
            {
                [self.delegate accountSelectViewController:self didSelectAccountArray:selectAccountArray];
            }
        }
        if (self.style==WCTAccountSelectViewControllerStyle_ChangeOwner)
        {
            if (accountModel.isSelected==NO)
            {
                //////////////////////////////////////////////////
                //實作單選，取消已選擇帳號
                for (NSInteger index=0; index<[self.accountSelectSectionController numberOfRowsInSection:indexPath.section forSearching:NO]; index++)
                {
                    NSIndexPath *otherIndexPath = [NSIndexPath indexPathForRow:index inSection:indexPath.section];
                    PPRowModel *otherRowModel = [self.accountSelectSectionController rowModelAtIndexPath:otherIndexPath forSearching:NO];
                    ASVCAccountSelectModel *otherAccountModel = otherRowModel.object;
                    if (otherAccountModel.isSelected==YES)
                    {
                        otherAccountModel.isSelected = NO;
                        [self.selectTableView reloadRowsAtIndexPaths:[NSArray arrayWithObject:otherIndexPath] withRowAnimation:UITableViewRowAnimationFade];
                        break;
                    }
                }
                
                //////////////////////////////////////////////////
                // 勾選選擇的帳號
                accountModel.isSelected = YES;
                [self.selectTableView reloadRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
            }
        }
        else
        {
            accountModel.isSelected = !accountModel.isSelected;
            [self.selectTableView reloadRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (NSArray *)fetchViewAccountListWithError:(NSError **)error allCompanyContact:(BOOL)allCompanyContact
{
    NSError *returnError = nil;
    NSMutableArray *viewAccounts = [NSMutableArray array];
    if (viewAccounts!=nil)
    {
        WCTRCSharedAccountsResponseResult *viewResult = [[WCTRestClientController shareRestClientController] shareAccountsWithError:&returnError];
        if (viewResult!=nil && returnError==nil)
        {
            NSUInteger allCompanyContactCount = 0;
            
            for (NSInteger index=0; index<viewResult.data.count; index++)
            {
                @autoreleasepool
                {
                    WCTRCContactSharedAccountsInfo *accountInfo = [viewResult.data objectAtIndex:index];
                    WCTAccountRelationModel *infoModel = [WCTAccountRelationModel accountRelationModelWithGuid:accountInfo.accountGuid
                                                                                                          name:accountInfo.accountName
                                                                                                         email:nil
                                                                                             shareContactCount:accountInfo.sharedContactCount
                                                                                                      relation:WCTAccountRelationModel_Relation_None];
                    if (infoModel!=nil)
                    {
                        allCompanyContactCount+=accountInfo.sharedContactCount;
                        [viewAccounts addObject:infoModel];
                    }
                }
            }
            
            
            [viewAccounts sortUsingComparator:^NSComparisonResult(WCTAccountRelationModel *obj1, WCTAccountRelationModel *obj2) {
                
                return [obj1.name compare:obj2.name options:NSCaseInsensitiveSearch|NSDiacriticInsensitiveSearch|NSNumericSearch|NSForcedOrderingSearch];
            }];
            //////////////////////////////////////////////////

            // 加入全公司聯絡人選項
            if(allCompanyContact)
            {
                [viewAccounts insertObject:[WCTAccountRelationModel accountRelationModelWithGuid:@""
                                                                                            name:WASVC_MLS_AllCompany
                                                                                           email:nil
                                                                               shareContactCount:allCompanyContactCount
                                                                                        relation:WCTAccountRelationModel_Relation_None]
                                   atIndex:0];
            }
        }
        
        //////////////////////////////////////////////////
        //使用者帳號
        //        WCTRCAccountInfoResponseResult *userResult = [[WCTRestClientController shareRestClientController] accountInfoWithError:&error];
        //        if (userResult!=nil && error==nil)
        //        {
        //            WCTRCAccountInfo *accountInfo      = [userResult.data firstObject];
        //            WCTAccountRelationModel *infoModel = [WCTAccountRelationModel accountRelationModelWithGuid:accountInfo.guid
        //                                                                                                  name:accountInfo.name
        //                                                                                                 email:accountInfo.email
        //                                                                                              relation:WCTAccountRelationModel_Relation_UserSelected];
        //            if (infoModel!=nil)
        //            {
        //                [viewAccounts insertObject:infoModel atIndex:0];
        //            }
        //        }
    }
    
    //////////////////////////////////////////////////
    //返回錯誤訊息與結果
    if (returnError!=nil)
    {
        if(error!=NULL)
        {
            *error = returnError;
        }
    }
    
    return viewAccounts;
}

@end
