//
//  WCTAccountInfoViewController.m
//  Pods
//
//  Created by AndrewLai on 2016/4/11.
//
//

#import "WCTAccountInfoViewController.h"

//define
#import "WCAppearanceDefine.h"

// Category
#import "UIColor+HexString.h"
#import "NSString+Additions.h"
#import "WCTAccountInfoViewController+ResourceDefine.h"

// Views
#import "PPBusyView.h"
#import "PPButton+Factory.h"
#import "PPNavigationBarView.h"
#import "PPTableView.h"
#import "PPTopButtonsActionSheet.h"
#import "PPFitLabelSizeTableViewCell.h"

// Cell
#import "AIVCCardImageCell.h"
#import "AIVCImageViewCustomCell.h"
#import "AIVCShareModeButtonsCell.h"

// Controllers
#import "AIVCSectionController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Button中image的內縮範圍
#define WCTAppearanceDefine_IconButtonImageEdgeInset             UIEdgeInsetsMake(10, 10, 10, 10)
#define WCTAppearanceDefine_LogoutButtonEdgeInset                UIEdgeInsetsMake(8, 8, 8, 8)
#define WCTAppearanceDefine_IconButtonHighlightedBackgroundColor WCAppearanceDefine_ButtonBackgroundColor

#define WCTAccountInfoViewControllerTableViewCellDetailTextFontColor      WCAppearanceDefine_CellTitleColor
#define WCTAccountInfoViewControllerTableViewSectionHeaderBackgroundColor WCAppearanceDefine_SectionHeaderBGColor

static NSString  *const TableViewCellIdentifier = @"TableViewCellIdentifier";
static NSString  *const ImageNameWCTAccountInfoViewControllerNavigationBarButtonMore = @"More";

static CGFloat    const WCTAccountInfoViewController_TableViewLogoutButtonHeight      = 64.0f;
static CGFloat    const WCTAccountInfoViewController_TableSectionHeaderHeight         = 24.0f;
static NSUInteger const WCTAccountInfoViewController_TableCellDefaultHeight           = 48.0f;
static NSUInteger const WCTAccountInfoViewController_TableCellAccountInfoHeight       = 56.0f;
static NSUInteger const WCTAccountInfoViewController_TableHeaderTextLabelFontSize     = 14;
static NSUInteger const WCTAccountInfoViewController_TableCellTextLabelFontSize       = 16;
static NSUInteger const WCTAccountInfoViewController_TableCellDetailTextLabelFontSize = 14	;

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSUInteger, WCTAccountInfoViewControllerButtonTag)
{
    WCTAccountInfoViewControllerButtonTag_Back = 1,
    WCTAccountInfoViewControllerButtonTag_Edit,
    WCTAccountInfoViewControllerButtonTag_Logout,
    WCTAccountInfoViewControllerButtonTag_More,
    WCTAccountInfoViewControllerButtonTag_Template
};

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - WCTAccountInfoViewController Extension

@interface WCTAccountInfoViewController () <PPButtonDelegate, PPTopButtonsActionSheetDelegate, UITableViewDataSource, UITableViewDelegate>
@property (nonatomic, retain) PPBusyView                            *busyView;
@property (nonatomic, retain) PPButton                              *ppButtonBack;
@property (nonatomic, retain) PPButton                              *ppButtonMore;
@property (nonatomic, retain) PPNavigationBarView                   *ppNavigationBarView;
@property (nonatomic, retain) PPTopButtonsActionSheet               *ppTopButtonsActionSheet;

//Table相關
@property (nonatomic, retain) NSArray               *prepareOrders;
@property (nonatomic, retain) AIVCSectionController *accountInfoSectionController;
@property (nonatomic, retain) NSOperationQueue      *fetchCardOperationQueue;
@property (nonatomic, retain) NSOperationQueue      *fetchInfoOperationQueue;
@property (nonatomic, retain) PPTableView           *infoTableView;
@end





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - WCTAccountInfoViewController Implementation

@implementation WCTAccountInfoViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self = [super init])
    {
        _accountInfoSectionController = [[AIVCSectionController alloc] init];
        _prepareOrders = nil;
        
        //////////////////////////////////////////////////
        _fetchCardOperationQueue = [[NSOperationQueue alloc] init];
        if (self.fetchCardOperationQueue!=nil)
        {
            [self.fetchCardOperationQueue setMaxConcurrentOperationCount:1];
        }
        
        _fetchInfoOperationQueue = [[NSOperationQueue alloc] init];
        if (self.fetchInfoOperationQueue!=nil)
        {
            [self.fetchInfoOperationQueue setMaxConcurrentOperationCount:1];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_fetchCardOperationQueue cancelAllOperations];
    [_fetchCardOperationQueue release];
    _fetchCardOperationQueue = nil;
    
    [_fetchInfoOperationQueue cancelAllOperations];
    [_fetchInfoOperationQueue release];
    _fetchInfoOperationQueue = nil;
    
    //////////////////////////////////////////////////    [self.ppButtonBack removeFromSuperview];
    self.ppButtonBack.delegate = nil;
    self.ppButtonBack = nil;
    
    [self.ppButtonMore removeFromSuperview];
    self.ppButtonMore.delegate = nil;
    self.ppButtonMore = nil;
    
    [self.ppNavigationBarView removeFromSuperview];
    self.ppNavigationBarView = nil;
    
    [self.infoTableView removeFromSuperview];
    self.infoTableView.dataSource = nil;
    self.infoTableView.delegate = nil;
    self.infoTableView = nil;
    
    [self.ppTopButtonsActionSheet removeFromSuperview];
    self.ppTopButtonsActionSheet.delegate = nil;
    self.ppTopButtonsActionSheet = nil;
    
    [self.busyView removeFromSuperview];
    self.busyView = nil;
    
    //////////////////////////////////////////////////
    
    [_prepareOrders release];
    _prepareOrders = nil;
    
    [_accountInfoSectionController release];
    _accountInfoSectionController = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    self.backgroundImageView.backgroundColor = [UIColor whiteColor];
    
    //////////////////////////////////////////////////
    _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    if (self.ppNavigationBarView!=nil)
    {
        self.ppNavigationBarView.style = PPBarViewStyle_CenteredAbsolute;
        
        //////////////////////////////////////////////////
        _ppButtonBack = [[PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                         tag:WCTAccountInfoViewControllerButtonTag_Back
                                                    delegate:self
                                       normalBackgroundColor:nil
                                  highlightedBackgroundColor:WCTAppearanceDefine_IconButtonHighlightedBackgroundColor
                                             imageEdgeInsets:WCTAppearanceDefine_IconButtonImageEdgeInset] retain];
        if (self.ppButtonBack!=nil)
        {
            [self.ppButtonBack addControlEvents:UIControlEventTouchUpInside];
            
            PPBarViewItemModel *backItemModel  = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
            if (backItemModel!=nil)
            {
                backItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                [self.ppNavigationBarView setItemModels:@[backItemModel] forBlockType:PPBarViewBlockType_Left];
            }
        }
        
        //////////////////////////////////////////////////
        [self.ppNavigationBarView.titleLabel setText:WCTAccountInfoViewControllerString_AccountInfo];
        
        //////////////////////////////////////////////////
        if (Demo==NO)
        {
            _ppButtonMore = [[PPButton ppButtonWithIconImageName:ImageNameWCTAccountInfoViewControllerNavigationBarButtonMore
                                                             tag:WCTAccountInfoViewControllerButtonTag_More
                                                        delegate:self
                                           normalBackgroundColor:nil
                                      highlightedBackgroundColor:WCTAppearanceDefine_IconButtonHighlightedBackgroundColor
                                                 imageEdgeInsets:WCTAppearanceDefine_IconButtonImageEdgeInset] retain];
            if (self.ppButtonMore!=nil)
            {
                [self.ppButtonMore addControlEvents:UIControlEventTouchUpInside];
                
                PPBarViewItemModel *moreItemModel  = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonMore];
                if (moreItemModel!=nil)
                {
                    moreItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                    [self.ppNavigationBarView setItemModels:@[moreItemModel] forBlockType:PPBarViewBlockType_Right];
                }
            }
        }
        
        self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
    }
    
    //////////////////////////////////////////////////
    _infoTableView = [[PPTableView alloc] initWithFrame:CGRectZero];
    if (self.infoTableView!=nil)
    {
        self.infoTableView.backgroundColor = [UIColor whiteColor];
        self.infoTableView.dataSource      = self;
        self.infoTableView.delegate        = self;
        
        [self fetchAccountInfoDictionary];
        [self fetchContactCardImagesData];
        
        [self.view addSubview:self.infoTableView];
    }
}


//================================================================================
//
//================================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    [self.fetchCardOperationQueue cancelAllOperations];
    [self.fetchInfoOperationQueue cancelAllOperations];

    //////////////////////////////////////////////////
    [super viewWillDisappear:animated];
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self.ppButtonBack removeFromSuperview];
    self.ppButtonBack.delegate = nil;
    self.ppButtonBack = nil;
    
    [self.ppButtonMore removeFromSuperview];
    self.ppButtonMore.delegate = nil;
    self.ppButtonMore = nil;
    
    [self.ppNavigationBarView removeFromSuperview];
    self.ppNavigationBarView = nil;
    
    [self.infoTableView removeFromSuperview];
    self.infoTableView.dataSource = nil;
    self.infoTableView.delegate = nil;
    self.infoTableView = nil;
    
    [self.ppTopButtonsActionSheet removeFromSuperview];
    self.ppTopButtonsActionSheet.delegate = nil;
    self.ppTopButtonsActionSheet = nil;
    
    //////////////////////////////////////////////////
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    self.infoTableView.frame = self.view.bounds;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)addTableFooterView
{
    UIView *buttonBoundary = [[UIView alloc] initWithFrame:CGRectMake(0, 0, self.view.bounds.size.width, WCTAccountInfoViewController_TableViewLogoutButtonHeight)];
    if (buttonBoundary!=nil)
    {
        PPButton *buttonLogout = [[PPButton alloc] initWithFrame:CGRectMake(WCTAppearanceDefine_LogoutButtonEdgeInset.left,
                                                                            WCTAppearanceDefine_LogoutButtonEdgeInset.top,
                                                                            buttonBoundary.bounds.size.width-WCTAppearanceDefine_LogoutButtonEdgeInset.left-WCTAppearanceDefine_LogoutButtonEdgeInset.right,
                                                                            buttonBoundary.bounds.size.height-WCTAppearanceDefine_LogoutButtonEdgeInset.top)];
        
        if (buttonLogout!=nil)
        {
            buttonLogout.layer.cornerRadius = 5.0f;
            
            buttonLogout.tag = WCTAccountInfoViewControllerButtonTag_Logout;
            buttonLogout.delegate = self;
            buttonLogout.titleLabel.font = [UIFont boldSystemFontOfSize:20.0f];
            
            [buttonLogout setTitle:WCTAccountInfoViewControllerString_Logout maxWidth:0.0];
            [buttonLogout setTitleColor:PPButtonLogout_TextColor_Normal];
            [buttonLogout setBackgroundImage:[UIImage imageWithColor:PPButtonLogout_BackgroundColor_Normal] forState:UIControlStateNormal];
            [buttonLogout setBackgroundImage:[UIImage imageWithColor:PPButtonLogout_BackgroundColor_Highlighted] forState:UIControlStateHighlighted];

            [buttonLogout addControlEvents:UIControlEventTouchUpInside];
            [buttonBoundary addSubview:buttonLogout];
            [buttonLogout release];
        }
        
        self.infoTableView.tableFooterView = buttonBoundary;
        [buttonBoundary release];
    }
}


//================================================================================
//
//================================================================================
- (void)fetchAccountInfoDictionary
{
    do
    {
        [self showBusyView:YES];
        
        //////////////////////////////////////////////////
        // !! 改為每次每來都更新，這邊先保留以免之後要再加回去
        //!! 先判斷是否有歷史紀錄，切回頁面時，不應該重新Load資訊，除非有更新資訊！
//        NSMutableArray *infoSectionModels = [[self.accountInfoSectionController sectionModelsForSearching:NO] retain];
//        
//        if (infoSectionModels!=nil && [infoSectionModels count]>0)
//        {
//            [self.infoTableView reloadData];
//            [self addTableFooterView];
//            
//            [self showBusyView:NO];
//            [infoSectionModels release];
//            break;
//        }
//        
//        [infoSectionModels release];

        //////////////////////////////////////////////////
        // 進行Background Thread抓取資訊
        if (self.fetchInfoOperationQueue==nil)
        {
            break;
        }
        
        __block NSBlockOperation *blockOperation = [[[NSBlockOperation alloc] init] autorelease];
        if (blockOperation==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        __block typeof(self) blockSelf = self;
        [blockOperation addExecutionBlock:^{
            
            blockSelf.prepareOrders = [NSArray arrayWithObjects:@(AccountInfoMainType_Account),
                                                                @(AccountInfoMainType_ShareMyCard),
                                                                @(AccountInfoMainType_ColleaguesRelationship),
                                                                @(AccountInfoMainType_Ability), nil];
            
            //////////////////////////////////////////////////
            // 聯絡人抓取所有資訊
            [blockSelf.accountInfoSectionController fetchAccountInfoWithMainTypeOrders:blockSelf.prepareOrders toSectionModelsForSearching:NO];
            
            //////////////////////////////////////////////////
            __block NSBlockOperation *blockMainOperation = [NSBlockOperation blockOperationWithBlock:^{
                [blockSelf.infoTableView reloadData];
                [blockSelf addTableFooterView];
                [blockSelf showBusyView:NO];
            }];
            
            @synchronized([NSOperationQueue mainQueue])
            {
                [[NSOperationQueue mainQueue] addOperation:blockMainOperation];
            }
        }];
        
        @synchronized(self.fetchInfoOperationQueue)
        {
            if([self.fetchInfoOperationQueue operationCount]>0)
            {
                [self.fetchInfoOperationQueue cancelAllOperations];
            }
            
            [self.fetchInfoOperationQueue addOperation:blockOperation];
        }
    } while (0);
}


//================================================================================
//
//================================================================================
- (void)fetchContactCardImagesData
{
    //TODO: 影像API尚未明瞭
}


//================================================================================
//
//================================================================================
- (NSArray *)otherCapabilityButtonArray
{
    NSMutableArray *capabilityButtonArray = [NSMutableArray array];
    
    //////////////////////////////////////////////////
    PPCommentButton *editButton = [[PPCommentButton alloc] initWithFrame:CGRectZero
                                                         buttonImageName:ImageNameWCTAccountInfoViewControllerMoreButtonEdit
                                                           buttonComment:WCTAccountInfoViewControllerString_Edit];
    if (editButton!=nil)
    {
        editButton.tag = WCTAccountInfoViewControllerButtonTag_Edit;
        
        [capabilityButtonArray addObject:editButton];
        [editButton release];
    }
    
    //////////////////////////////////////////////////
    PPCommentButton *templateButton = [[PPCommentButton alloc] initWithFrame:CGRectZero
                                                             buttonImageName:ImageNameWCTAccountInfoViewControllerMoreButtonTemplate
                                                               buttonComment:WCTAccountInfoViewControllerString_Template];
    if (templateButton!=nil)
    {
        templateButton.tag = WCTAccountInfoViewControllerButtonTag_Template;
        
        [capabilityButtonArray addObject:templateButton];
        [templateButton release];
    }
    
    //////////////////////////////////////////////////
    for(PPCommentButton *button in capabilityButtonArray)
    {
        [button setBackgroundImage:[UIImage imageWithColor:PPTopButtonBackgroundColorHighlighted]
                          forState:UIControlStateHighlighted];
        
        [button setCommentTextColorNormal:PPTopButtonFontColorNormal];
        [button setCommentTextColorHighlighted:PPTopButtonFontColorHighlighted];
    }
    
    return capabilityButtonArray;
}


//===============================================================================
//
//===============================================================================
- (void)showBusyView:(BOOL)show
{
    if(show==YES)
    {
        if(self.busyView==nil)
        {
            _busyView = [[PPBusyView alloc] initWithSuperView:self.navigationController.view];
        }
    }
    else
    {
        [self.busyView removeFromSuperview];
        self.busyView = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (PPFitLabelSizeTableViewCell *)relationCellWithRowModel:(PPRowModel *)rowModel
{
    PPFitLabelSizeTableViewCell *colleagueCell = [[[PPFitLabelSizeTableViewCell alloc] initWithReuseIdentifier:[TableViewCellIdentifier stringByAppendingString:[NSString stringWithFormat:@"%td", rowModel.row]]] autorelease];
    
    colleagueCell.selectionStyle           = UITableViewCellSelectionStyleNone;
    
    colleagueCell.textLabel.numberOfLines  = 0;
    colleagueCell.textLabel.font           = [UIFont systemFontOfSize:WCTAccountInfoViewController_TableCellTextLabelFontSize];
    colleagueCell.textLabel.textColor      = WCTAccountInfoViewControllerTableViewCellDetailTextFontColor;

    colleagueCell.detailTextLabel.numberOfLines  = 0;
    colleagueCell.detailTextLabel.font     = [UIFont systemFontOfSize:WCTAccountInfoViewController_TableCellDetailTextLabelFontSize];
    colleagueCell.detailTextLabel.textColor= WCTAccountInfoViewControllerTableViewCellDetailTextFontColor;
    
    colleagueCell.textLabel.text           = rowModel.text;
    colleagueCell.detailTextLabel.text     = rowModel.detailText;
    
    return colleagueCell;
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - public


//==============================================================================
//
//==============================================================================
- (void)reloadData
{
    [[self.accountInfoSectionController sectionModelsForSearching:NO] removeAllObjects];
    [self fetchAccountInfoDictionary];
    [self fetchContactCardImagesData];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCTAccountInfoViewControllerButtonTag_Back:
        {
            if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(accountInfoViewController:didSelectAction:)]==YES)
            {
                [self.delegate accountInfoViewController:self didSelectAction:WCTAccountInfoViewControllerAction_Back];
            }
            
            break;
        }
        case WCTAccountInfoViewControllerButtonTag_Logout:
        {
            if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(accountInfoViewController:didSelectAction:)]==YES)
            {
                [self.delegate accountInfoViewController:self didSelectAction:WCTAccountInfoViewControllerAction_Logout];
            }
            
            break;
        }
        case WCTAccountInfoViewControllerButtonTag_More:
        {
            if (self.ppTopButtonsActionSheet==nil)
            {
                _ppTopButtonsActionSheet = [[PPTopButtonsActionSheet alloc] initWithFrame:self.navigationController.view.bounds];
                if (self.ppTopButtonsActionSheet!=nil)
                {
                    self.ppTopButtonsActionSheet.capabilityButtonArray = [self otherCapabilityButtonArray];
                    self.ppTopButtonsActionSheet.delegate = self;
                    
                    self.ppTopButtonsActionSheet.buttonListViewBackgroundColor = PPTopButtonsActionSheetViewBackgroundColor;
                }
            }
            
            [self.ppTopButtonsActionSheet showFromSuperView:self.navigationController.view animated:YES];
            
            break;
        }
        default:
        {
            NSLog(@"%s: Error Button Tag!", __FUNCTION__);
            
            //////////////////////////////////////////////////
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - PPTopButtonsActionSheetDelegate

//================================================================================
//
//================================================================================
- (void)ppTopButtonsActionSheet:(PPTopButtonsActionSheet *)ppTopButtonsActionSheet capabilityButtonSelectedTag:(NSInteger)buttonTag
{
    WCTAccountInfoViewControllerAction capabiltiy = WCTAccountInfoViewControllerAction_Account;
    
    switch (buttonTag)
    {
        case WCTAccountInfoViewControllerButtonTag_Edit:
        {
            capabiltiy = WCTAccountInfoViewControllerAction_Edit;
            break;
        }
        case WCTAccountInfoViewControllerButtonTag_Template:
        {
            capabiltiy = WCTAccountInfoViewControllerAction_Template;
            break;
        }
        default:
            break;
    }
    
    if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(accountInfoViewController:didSelectAction:)]==YES)
    {
        [self.delegate accountInfoViewController:self didSelectAction:capabiltiy];
    }
}


//================================================================================
//
//================================================================================
- (void)ppTopButtonsActionSheetDidDismiss:(PPTopButtonsActionSheet *)ppTopButtonsActionSheet
{

}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - UITableViewDataSource

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return [self.accountInfoSectionController numberOfSectionsForSearching:NO];
}


//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [self.accountInfoSectionController numberOfRowsInSection:section forSearching:NO];
}


//================================================================================
//TODO: 修改假資料
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = nil;
    
    do
    {
        PPRowModel *rowModel  = [self.accountInfoSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        NSNumber *infoSubType = rowModel.object;
        
        //////////////////////////////////////////////////
        switch ([infoSubType unsignedIntegerValue])
        {
            case AccountInfoSubType_Account_InfoText:
            default:
            {
                cell = [tableView dequeueReusableCellWithIdentifier:[TableViewCellIdentifier stringByAppendingString:[NSString stringWithFormat:@"%td", AccountInfoSubType_Account_InfoText]]];
                if (cell==nil)
                {
                    cell = [[[AIVCImageViewCustomCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:[TableViewCellIdentifier stringByAppendingString:[NSString stringWithFormat:@"%td", AccountInfoSubType_Account_InfoText]]] autorelease];
                }
                
                //////////////////////////////////////////////////
                AIVCImageViewCustomCell *infoCell  = (AIVCImageViewCustomCell *)cell;
                infoCell.selectionStyle            = UITableViewCellSelectionStyleNone;
                infoCell.textLabel.text            = rowModel.text;
                infoCell.textLabel.font            = [UIFont boldSystemFontOfSize:WCTAccountInfoViewController_TableCellTextLabelFontSize];
                infoCell.detailTextLabel.text      = rowModel.detailText;
                infoCell.detailTextLabel.font      = [UIFont systemFontOfSize:WCTAccountInfoViewController_TableCellDetailTextLabelFontSize];
                
                infoCell.accessoryType             = UITableViewCellAccessoryDisclosureIndicator;
                infoCell.subType                   = AccountInfoSubType_Account_InfoText;
                infoCell.headImageView.image       = [UIImage imageWithName:@"AccountDefaultImage"];
                infoCell.detailTextLabel.textColor = WCTAccountInfoViewControllerTableViewCellDetailTextFontColor;
                
                break;
            }
            case AccountInfoSubType_Account_CardImage:
            {
                cell = [tableView dequeueReusableCellWithIdentifier:[TableViewCellIdentifier stringByAppendingString:[NSString stringWithFormat:@"%td", AccountInfoSubType_Account_CardImage]]];
                if (cell==nil)
                {
                    cell = [[[AIVCCardImageCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:[TableViewCellIdentifier stringByAppendingString:[NSString stringWithFormat:@"%td", AccountInfoSubType_Account_CardImage]]] autorelease];
                }
                
                //////////////////////////////////////////////////
                cell.selectionStyle  = UITableViewCellSelectionStyleNone;
                cell.imageView.image = [UIImage imageWithName:@"Front.jpg"];
                
                break;
            }
            case AccountInfoSubType_ShareMyCard_ModeButtons:
            {
                cell = [tableView dequeueReusableCellWithIdentifier:[TableViewCellIdentifier stringByAppendingString:[NSString stringWithFormat:@"%td", AccountInfoSubType_ShareMyCard_ModeButtons]]];
                if (cell==nil)
                {
                    cell = [[[AIVCShareModeButtonsCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:[TableViewCellIdentifier stringByAppendingString:[NSString stringWithFormat:@"%td", AccountInfoSubType_ShareMyCard_ModeButtons]]] autorelease];
                }
                
                //////////////////////////////////////////////////
                cell.selectionStyle = UITableViewCellSelectionStyleNone;
                
                break;
            }
            case AccountInfoSubType_ColleaguesRelationship_Boss:
            case AccountInfoSubType_ColleaguesRelationship_Subordinate:
            {
                cell = [tableView dequeueReusableCellWithIdentifier:[TableViewCellIdentifier stringByAppendingString:[NSString stringWithFormat:@"%td", rowModel.row]]];
                if (cell==nil)
                {
                    cell = [self relationCellWithRowModel:rowModel];
                }
                
                break;
            }
            case AccountInfoSubType_ExportAbility:
            case AccountInfoSubType_SecretaryAbility:
            case AccountInfoSubType_PrintAbility:
            case AccountInfoSubType_NoAbility:
            {
                cell = [tableView dequeueReusableCellWithIdentifier:[TableViewCellIdentifier stringByAppendingString:[NSString stringWithFormat:@"%td", [infoSubType unsignedIntegerValue]]]];
                if (cell==nil)
                {
                    cell = [[[AIVCImageViewCustomCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:[TableViewCellIdentifier stringByAppendingString:[NSString stringWithFormat:@"%td", [infoSubType unsignedIntegerValue]]]] autorelease];
                }
                
                //////////////////////////////////////////////////
                AIVCImageViewCustomCell *authorutyCell = (AIVCImageViewCustomCell *)cell;
                authorutyCell.contentInsets            = UIEdgeInsetsMake(0, 0, 0, 8);
                authorutyCell.selectionStyle           = UITableViewCellSelectionStyleNone;
                authorutyCell.textLabel.text           = rowModel.text;
                authorutyCell.textLabel.font           = [UIFont systemFontOfSize:WCTAccountInfoViewController_TableCellTextLabelFontSize];
                authorutyCell.textLabel.textColor      = WCTAccountInfoViewControllerTableViewCellDetailTextFontColor;
                authorutyCell.detailTextLabel.text     = rowModel.detailText;
                authorutyCell.detailTextLabel.font     = [UIFont systemFontOfSize:WCTAccountInfoViewController_TableCellDetailTextLabelFontSize];
                authorutyCell.detailTextLabel.textColor= WCTAccountInfoViewControllerTableViewCellDetailTextFontColor;
                
                break;
            }
        }
    }
    while (0);
    
    return cell;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableView Delegate

//================================================================================
//TODO: 假資料
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    PPRowModel *rowModel   = [self.accountInfoSectionController rowModelAtIndexPath:indexPath forSearching:NO];
    NSUInteger infoSubType = [rowModel.object integerValue];
    
    // !! infoSubType每個cell都不同，所以直接用switch
    
    switch (infoSubType)
    {
        case AccountInfoSubType_Account_CardImage:
        {
            UIImage *testImage = [UIImage imageWithName:@"Front.jpg"];
            return testImage.size.height/(testImage.size.width/tableView.bounds.size.width);
        }
        case AccountInfoSubType_Account_InfoText:
        {
            return WCTAccountInfoViewController_TableCellAccountInfoHeight;
        }
        case AccountInfoSubType_ColleaguesRelationship_Boss:
        case AccountInfoSubType_ColleaguesRelationship_Subordinate:
        {
            PPFitLabelSizeTableViewCell *cell = [self relationCellWithRowModel:rowModel];
            
            return [cell cellHeight];
        }
        default:
            return WCTAccountInfoViewController_TableCellDefaultHeight;
    }

}


//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    CGFloat headerHeight = 0;
    
    switch (section)
    {
        case AccountInfoMainType_ShareMyCard:
        {
            if (Demo==NO)
            {
                UILabel *headerLabel = [[[UILabel alloc] initWithFrame:CGRectMake(0, 0, self.view.bounds.size.width, WCTAccountInfoViewController_TableSectionHeaderHeight)] autorelease];
                headerLabel.text = WCTAccountInfoViewControllerString_ShareMyCardTitle;
                headerLabel.font = [UIFont boldSystemFontOfSize:headerLabel.font.pointSize];
                
                [headerLabel sizeToFit];
                headerHeight = headerLabel.frame.size.height;
                
                break;
            }
        }
        case AccountInfoMainType_ColleaguesRelationship:
        case AccountInfoMainType_Ability:
        {
            headerHeight = WCTAccountInfoViewController_TableSectionHeaderHeight;
            break;
        }
        case AccountInfoMainType_Account:
        default:
            break;
    }
    
    return headerHeight;
}


//================================================================================
//
//================================================================================
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    switch (section)
    {
        case AccountInfoMainType_ShareMyCard:
        {
            if (Demo==NO)
            {
                UILabel *headerLabel = [[[UILabel alloc] initWithFrame:CGRectMake(0, 0, self.view.bounds.size.width, WCTAccountInfoViewController_TableSectionHeaderHeight)] autorelease];
                headerLabel.backgroundColor = WCTAccountInfoViewControllerTableViewSectionHeaderBackgroundColor;
                headerLabel.text = WCTAccountInfoViewControllerString_ShareMyCardTitle;
                headerLabel.font = [UIFont boldSystemFontOfSize:headerLabel.font.pointSize];
                
                return headerLabel;
            }
        }
        case AccountInfoMainType_ColleaguesRelationship:
        case AccountInfoMainType_Ability:
        {
            PPSectionHeaderView *headerView = [self.accountInfoSectionController viewForHeaderInSection:section forSearching:NO];
                        headerView.backgroundColor = WCTAccountInfoViewControllerTableViewSectionHeaderBackgroundColor;
            headerView.textLabel.font = [UIFont boldSystemFontOfSize:WCTAccountInfoViewController_TableHeaderTextLabelFontSize];
            [headerView.textLabel setTextColor:WCAppearanceDefine_SectionIndexTitleColor];
            return headerView;
        }
        case AccountInfoMainType_Account:
        default:
            return nil;
    }
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    PPRowModel *rowModel   = [self.accountInfoSectionController rowModelAtIndexPath:indexPath forSearching:NO];
    NSUInteger infoSubType = [rowModel.object integerValue];
    
    if (infoSubType==AccountInfoSubType_Account_InfoText)
    {
        if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(accountInfoViewController:didSelectAction:)]==YES)
        {
            [self.delegate accountInfoViewController:self didSelectAction:WCTAccountInfoViewControllerAction_Account];
        }
    }
}

@end
