//
//  SFCShareViewController.m
//  Pods
//
//  Created by Andrew on 2015/8/3.
//
//

#import "SFCShareViewController.h"

// Define
#import "UIColor+HexString.h"
#import "UIViewController+ShareApplication.h"
#import "WCAppearanceDefine.h"

// Controller
#import "SFCPreferenceController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, SFCShareViewController_ButtonAction)
{
    SFCShareViewController_ButtonAction_None  = 0,
    SFCShareViewController_ButtonAction_Back,
    SFCShareViewController_ButtonAction_Share
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - SFCShareViewController

@interface SFCShareViewController () <PPButtonDelegate, WCFileTypeSelectViewDelegate>

@property (nonatomic, retain) PPButton                 *ppButtonBack;
@property (nonatomic, retain) PPNavigationBarView      *ppNavigationBarView;
@property (nonatomic, retain) WCFileTypeSelectView     *fileTypeSelectView;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - SFCShareViewController Implementation

@implementation SFCShareViewController





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    
    self.fileTypeOrderSource = nil;
    
    [self.fileTypeSelectView removeFromSuperview];
    self.fileTypeSelectView.delegate = nil;
    self.fileTypeSelectView = nil;
    
    [self.ppButtonBack removeFromSuperview];
    self.ppButtonBack.delegate = nil;
    self.ppButtonBack = nil;
    
    [self.ppNavigationBarView removeFromSuperview];
    self.ppNavigationBarView = nil;
    
    [self.ppButtonShare removeFromSuperview];
    self.ppButtonShare.delegate = nil;
    self.ppButtonShare = nil;
    
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding To View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    WCFileTypeSelectView_ContactFileType initFileType = [[self.fileTypeOrderSource firstObject] integerValue];
    
    [SFCPreferenceController setDefaultContactFileShareFormat:initFileType];
    [SFCPreferenceController setDefaultContactFileShareTextInfo:WCFileTypeSelectView_FileTypeTextInfo_All];
    
    //////////////////////////////////////////////////
    
    _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    if (self.ppNavigationBarView!=nil)
    {
        self.ppNavigationBarView.style = PPBarViewStyle_CenteredAbsolute;
        self.ppNavigationBarView.backgroundImageView.image = nil; //因為navigationBar在init時會塞入預設圖
        self.ppNavigationBarView.backgroundColor = [UIColor colorWithHexString:@"#3F79CF"];
        
        self.ppNavigationBarView.titleLabel.text      = WCSFC_MLS_Share;
        self.ppNavigationBarView.titleLabel.textColor = [UIColor whiteColor];
        
        _ppButtonBack = [[PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                         tag:SFCShareViewController_ButtonAction_Back
                                                    delegate:self
                                       normalBackgroundColor:nil
                                  highlightedBackgroundColor:[UIColor colorWithHexString:@"#2c538f"]
                                             imageEdgeInsets:WCShareFlowControllerNavigationBarButtonImageEdgeInsets] retain];
        if (self.ppButtonBack!=nil)
        {
            [self.ppButtonBack addControlEvents:UIControlEventTouchUpInside];
            
            //////////////////////////////////////////////////
            
            PPBarViewItemModel *itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
            if(itemModel!=nil)
            {
                itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                
                [self.ppNavigationBarView setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
            }
        }
        
        //////////////////////////////////////////////////
        
        _ppButtonShare = [[PPButton ppButtonWithIconImageName:ImageNameWCShareFlowControllerButtonShare
                                                          tag:SFCShareViewController_ButtonAction_Share
                                                     delegate:self
                                        normalBackgroundColor:nil
                                   highlightedBackgroundColor:[UIColor colorWithHexString:@"#2c538f"]
                                              imageEdgeInsets:WCShareFlowControllerNavigationBarButtonImageEdgeInsets] retain];
        if (self.ppButtonShare!=nil)
        {
            [self.ppButtonShare addControlEvents:UIControlEventTouchUpInside];
            
            //////////////////////////////////////////////////
            
            PPBarViewItemModel *itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonShare];
            if(itemModel!=nil)
            {
                itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                
                [self.ppNavigationBarView setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Right];
            }
        }
        
        self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
    }
    
    //////////////////////////////////////////////////
    
    _fileTypeSelectView = [[WCFileTypeSelectView alloc] initWithFrame:CGRectZero];
    if (self.fileTypeSelectView!=nil)
    {
        self.fileTypeSelectView.delegate                 = self;
        self.fileTypeSelectView.supportFileTypes         = self.fileTypeOrderSource;
        self.fileTypeSelectView.contactFileTypeSelected  = [SFCPreferenceController contactFileShareFormat];
        self.fileTypeSelectView.fileTypeTextInfoSelected = [SFCPreferenceController contactFileShareTextInfo];
        
        self.fileTypeSelectView.fileTypeSelectorTitle   = WCSFC_MLS_ShareToFileContent;
        self.fileTypeSelectView.textInfoCheckBoxTitle   = WCSFC_MLS_ShareInfoText;
        self.fileTypeSelectView.tableSectionColor       = WCAppearanceDefine_SectionHeaderBGColor;

        //!! 因為設定footerView後，下方才不會顯示持續顯示Cell的Separator
        UIView *footerView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, self.view.bounds.size.width, 0)];
        if (footerView!=nil)
        {
            footerView.backgroundColor = [UIColor whiteColor];
            self.fileTypeSelectView.selectFooterView = footerView;
            
            [self.view addSubview:self.fileTypeSelectView];
            [footerView release];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self.fileTypeSelectView removeFromSuperview];
    self.fileTypeSelectView.delegate = nil;
    self.fileTypeSelectView = nil;
    
    [self.ppButtonBack removeFromSuperview];
    self.ppButtonBack.delegate = nil;
    self.ppButtonBack = nil;
    
    [self.ppNavigationBarView removeFromSuperview];
    self.ppNavigationBarView = nil;
    
    [self.ppButtonShare removeFromSuperview];
    self.ppButtonShare.delegate = nil;
    self.ppButtonShare = nil;
    
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    CGRect viewRegion = [self layoutFrame];
    
    //////////////////////////////////////////////////
    
    CGRect selectViewFrame = viewRegion;
    self.fileTypeSelectView.frame = selectViewFrame;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    [SFCPreferenceController setContactFileShareFormat:self.fileTypeSelectView.contactFileTypeSelected];
    
    if ((self.fileTypeSelectView.contactFileTypeSelected&WCFileTypeSelectView_ContactFileType_Text)==WCFileTypeSelectView_ContactFileType_Text)
    {
        [SFCPreferenceController setContactFileShareTextInfo:self.fileTypeSelectView.fileTypeTextInfoSelected];
    }

    //////////////////////////////////////////////////
    
    switch (ppButton.tag)
    {
        case SFCShareViewController_ButtonAction_Back:
        {
            [self goBackAnimated:YES];
            break;
        }
        case SFCShareViewController_ButtonAction_Share:
        {
            if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(shareViewController:didSelectContactFileType:fileTypeTextInfoSelected:)]==YES)
            {
                [self.delegate shareViewController:self
                          didSelectContactFileType:self.fileTypeSelectView.contactFileTypeSelected
                          fileTypeTextInfoSelected:self.fileTypeSelectView.fileTypeTextInfoSelected];
            }
            
            break;
        }
        default:
            break;
    }
}

@end
