//
//  PPSearchBar.m
//  
//
//  Created by  Eddie on 12/6/26.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "PPSearchBar.h"

@interface PPSearchBar()
@property (nonatomic,assign) CGRect internalRect;
@end

@implementation PPSearchBar

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//===============================================================================
//
//===============================================================================
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    self.internalRect=frame;
    
    if (self) 
    {
        [self setInternalFrame:frame];
        [self setFrame:frame];

    }
    return self;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//===============================================================================
//
//===============================================================================
- (void)setPrefixIcon:(UIImage *)icon iconFrame:(CGRect)iconFrame
{
    for(id subview in self.subviews)
    {
        if([subview isKindOfClass:[UITextField class]])
        {
            UITextField *textField = (UITextField *)subview;
            UIImageView *imageView = [[UIImageView alloc] initWithImage:icon];            
            
            imageView.frame = iconFrame;
            textField.leftView = imageView;
            [imageView release];
        }
    }
}


//===============================================================================
//
//===============================================================================
- (void)setPrefixText:(NSString *)text fontSize:(NSInteger)size
{
    for(id subview in self.subviews)
    {
        if([subview isKindOfClass:[UITextField class]])
        {
            UITextField *textField = (UITextField *)subview;
            UIFont *font=[UIFont fontWithName:@"Baskerville-Bold" size:size];
            
            NSMutableParagraphStyle * paragraphStyle = [[NSMutableParagraphStyle alloc] init];
            paragraphStyle.lineBreakMode = NSLineBreakByWordWrapping;
            paragraphStyle.alignment = NSTextAlignmentLeft;
            
            CGRect rect = [text boundingRectWithSize:CGSizeMake(300,21)
                                                    options:NSStringDrawingUsesLineFragmentOrigin
                                                 attributes:@{NSFontAttributeName:font,
                                                              NSParagraphStyleAttributeName:paragraphStyle}
                                                    context:nil];

            [paragraphStyle release];
            
            //////////////////////////////////////////////////
            
            UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, ceilf(rect.size.width), ceilf(rect.size.height))];
            [label setText:text];
            label.lineBreakMode=NSLineBreakByWordWrapping;
            label.font=font;
            label.numberOfLines=99;
            label.backgroundColor=[UIColor clearColor];
            
            textField.leftView = label;
            [label release];
        }
    }
}


//===============================================================================
//
//===============================================================================
- (void)setInternalFrame:(CGRect)frame
{
    self.internalRect=frame;
}


//===============================================================================
//
//===============================================================================
- (void)setFrame:(CGRect)frame
{
    
    if(CGRectIsNull(self.internalRect))
    {
        [super setFrame:frame];
    }
    else if(CGRectEqualToRect(frame, self.internalRect))
    {
        [super setFrame:frame];
    }
    else
    {
        return;
    }
}

@end
