//
//  WCRecognitionContextModel.m
//
//
//  Created by Howard.Lin on 13/12/10.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "WCRecognitionContextModel.h"
#import "CrossPlatformDefine.h"

@implementation WCRecognitionContextModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
 isCJKStringValue        = isCJKStringValue_,
 contextString           = contextString_,
 recognitionRect         = recognitionRect_,
 recognitionFieldSubType = recognitionFieldSubType_;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//===============================================================================
//
//===============================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{self.recognitionFieldSubType:%tu self.isCJKStringValue:%d,self.recognitionRect:%@,self.contextString:%@}",
            [super description],
            self.recognitionFieldSubType,
            self.isCJKStringValue,
            CPStringFromRect(self.recognitionRect),
            self.contextString];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//===============================================================================
//
//===============================================================================
- (id)init
{
    if(self=[super init])
    {
        isCJKStringValue_ = NO;
    }
    
    return self;
}


//===============================================================================
//
//===============================================================================
- (void)dealloc
{
    [contextString_ release];
    contextString_ = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//===============================================================================
//
//===============================================================================
+ (WCRecognitionContextModel *)recognitionContextModelWithContextString:(NSString *)contextString
                                                        recognitionRect:(CGRect)recognitionRect
                                                       isCJKStringValue:(BOOL)isCJKStringValue
{
    WCRecognitionContextModel *recognitionContextModel = [[WCRecognitionContextModel alloc] init];
    
    if(recognitionContextModel!=nil)
    {
        recognitionContextModel.contextString    = contextString;
        recognitionContextModel.recognitionRect  = recognitionRect;
        recognitionContextModel.isCJKStringValue = isCJKStringValue;
    }
    
    return [recognitionContextModel autorelease];
}


@end
