//
//  WCRecognitionCardModel.m
//
//
//  Created by Howard.Lin on 13/12/5.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "WCRecognitionCardModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCRecognitionCardModel()

- (void)existRecognitionFieldModel:(WCRecognitionFieldModel *)existRecognitionFieldModel
     saveFromRecognitionFieldModel:(WCRecognitionFieldModel *)recognitionFieldModel;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCRecognitionCardModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
 createdTime               = createdTime_,
 modifiedTime              = modifiedTime_,
 frontRecognitionLanguage  = frontRecognitionLanguage_,
 backRecognitionLanguage   = backRecognitionLanguage_,
 cardID                    = cardID_,
 fieldModelArrayDictionary = fieldModelArrayDictionary_,
 sourceImageType           = sourceImageType_;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying , and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
		frontRecognitionLanguage_  = -1;
		backRecognitionLanguage_   = -1;
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [createdTime_ release];
    createdTime_ = nil;
    
    [modifiedTime_ release];
    modifiedTime_ = nil;
    
    [fieldModelArrayDictionary_ removeAllObjects];
    [fieldModelArrayDictionary_ release];
    fieldModelArrayDictionary_ = nil;
    
    [cardID_ release];
    cardID_ = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//===============================================================================
//
//===============================================================================
- (void)existRecognitionFieldModel:(WCRecognitionFieldModel *)existRecognitionFieldModel
     saveFromRecognitionFieldModel:(WCRecognitionFieldModel *)recognitionFieldModel
{
    //!!將目前欄位全部加入
    for(id key in recognitionFieldModel.recognitionContextModelDictionary.allKeys)
    {
        [existRecognitionFieldModel.recognitionContextModelDictionary setObject:[recognitionFieldModel.recognitionContextModelDictionary objectForKey:key] forKey:key];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//===============================================================================
//
//===============================================================================
- (NSString *)description
{
    NSMutableString *totalContextModelDescription = [NSMutableString stringWithFormat:@""];
    
    for (id key in self.fieldModelArrayDictionary.allKeys)
    {
        @autoreleasepool
        {
            NSArray *fieldArray = [self.fieldModelArrayDictionary objectForKey:key];
            
            for(WCRecognitionFieldModel *recognitionFieldModel in fieldArray)
            {
                [totalContextModelDescription appendString:[recognitionFieldModel description]];
                [totalContextModelDescription appendString:@"\n"];
            }
        }
    }
    
    return totalContextModelDescription;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//===============================================================================
//
//===============================================================================
- (void)addRecognitionFieldModel:(WCRecognitionFieldModel *)fieldModel
{
    NSMutableArray *fieldModelArray = [self.fieldModelArrayDictionary objectForKey:[NSNumber numberWithUnsignedInteger:fieldModel.fieldMainType]];
    
    //!!不存在資料，直接取代
    if(fieldModelArray==nil || fieldModelArray.count<=0)
    {
        fieldModelArray = [self recognitionFieldModelArrayWithType:fieldModel.fieldMainType];
        
        [fieldModelArray addObject:fieldModel];
        
        [self.fieldModelArrayDictionary setObject:fieldModelArray forKey:[NSNumber numberWithUnsignedInteger:fieldModel.fieldMainType]];
    }
    //!!已存在資料，則將新辨識的資料欄位寫入
    else
    {
        [fieldModelArray addObject:fieldModel];
    }
}


//================================================================================
//
//================================================================================
- (BOOL)insertWCRecognitionFieldModel:(WCRecognitionFieldModel *)recognitionFieldModel
{
    BOOL result = NO;
    
    @autoreleasepool
    {
        NSMutableArray *fieldModelArray = [self.fieldModelArrayDictionary objectForKey:[NSNumber numberWithUnsignedInteger:recognitionFieldModel.fieldMainType]];
        
        if(fieldModelArray== nil)
        {
            [self addRecognitionFieldModel:recognitionFieldModel];
        }
        else
        {
            BOOL sameCompany = NO;
            
            //!!若是公司欄位，則要判斷是否為兩間不一樣的公司
            if(recognitionFieldModel.fieldMainType==WCRecognitionFieldMainType_Company)
            {
                //!!目前先用公司欄位檢查
                for(WCRecognitionFieldModel *existRecognitionFieldModel in fieldModelArray)
                {
                    WCRecognitionContextModel *recognitionContextModel = [recognitionFieldModel.recognitionContextModelDictionary objectForKey:[NSNumber numberWithUnsignedInteger:WCRecognitionFieldSubType_Company_Name]];
                    
                    //////////////////////////////////////////////////
                    
                    WCRecognitionContextModel *existRecognitionContextModel = [existRecognitionFieldModel.recognitionContextModelDictionary objectForKey:[NSNumber numberWithUnsignedInteger:WCRecognitionFieldSubType_Company_Name]];
                    
                    //////////////////////////////////////////////////
                    
                    //!!此次加入的不是公司名稱欄位，拿最後一筆公司來加入
                    if(recognitionContextModel==nil)
                    {
                        existRecognitionFieldModel = [fieldModelArray objectAtIndex:fieldModelArray.count-1];
                        
                        //!!將目前欄位全部加入
                        [self existRecognitionFieldModel:existRecognitionFieldModel
                           saveFromRecognitionFieldModel:recognitionFieldModel];
                        
                        sameCompany = YES;
                        
                        break;
                    }
                    //!!檢查公司名稱欄位，發現同一間公司，或目前欄位不存在公司欄位
                    else if(existRecognitionContextModel.contextString==nil || existRecognitionContextModel.contextString==recognitionContextModel.contextString)
                    {
                        //!!將目前欄位全部加入
                        [self existRecognitionFieldModel:existRecognitionFieldModel
                           saveFromRecognitionFieldModel:recognitionFieldModel];
                        
                        sameCompany = YES;
                        
                        break;
                    }
                }
            }
            
            //////////////////////////////////////////////////
            
            //!!不存在名稱一樣的公司，直接加入
            if(sameCompany==NO)
            {
                [fieldModelArray addObject:recognitionFieldModel];
            }
        }
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (NSInteger)fieldCountWithWCRecognitionFieldMainType:(WCRecognitionFieldMainType)fieldType
{
    NSDictionary *fieldDictionary = [self.fieldModelArrayDictionary objectForKey:[NSNumber numberWithUnsignedInteger:fieldType]];
    
    return fieldDictionary.count;
}


//================================================================================
// get field array by specified type
// retuen : array of WCRecognitionFieldModel
//================================================================================
- (NSMutableArray *)recognitionFieldModelArrayWithType:(WCRecognitionFieldMainType)fieldMainType
{
    if(self.fieldModelArrayDictionary==nil)
    {
		fieldModelArrayDictionary_ = [[NSMutableDictionary alloc] init];
	}
    
    /////////////////////////////////////////////
    
	NSMutableArray *fieldModelArray = [fieldModelArrayDictionary_ objectForKey:[NSNumber numberWithUnsignedInteger:fieldMainType]];
	
	if(!fieldModelArray)
	{
		fieldModelArray = [[NSMutableArray alloc] init];
        
		[self.fieldModelArrayDictionary setObject:fieldModelArray forKey:[NSNumber numberWithUnsignedInteger:fieldMainType]];
        
		[fieldModelArray release];
	}
	
	return fieldModelArray;

}


//===============================================================================
//
//===============================================================================
- (WCRecognitionFieldModel *)recognitionFieldModelWithRecognitionFieldMainType:(WCRecognitionFieldMainType)mainType atIndex:(NSUInteger)fieldIndex
{
    NSMutableArray *fieldArray = [self recognitionFieldModelArrayWithType:mainType];
    
    if(fieldArray!=nil && fieldArray.count > fieldIndex )
    {
        return [fieldArray objectAtIndex:fieldIndex];
    }
    else
    {
        return nil;
    }
}


@end
