//
//  DemoStringTextView.m
//  
//
//  Created by Howard on 2015/11/23.
//
//

#import "DemoStringTextView.h"

@implementation DemoStringTextView

//================================================================================
//
//================================================================================
- (id)init
{
    if(self = [super init])
    {
        self.editable = NO;
        self.userInteractionEnabled = NO;
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    //////////////////////////////////////////////////

    [super dealloc];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (BOOL)canPerformAction:(SEL)action withSender:(id)sender
{
    NSString *actionName = NSStringFromSelector(action);

    if([actionName compare:@"cut:"]==NSOrderedSame ||
       [actionName compare:@"paste:"]==NSOrderedSame ||
       [actionName compare:@"copy:"]==NSOrderedSame)
    {
        return YES;
    }
    else
    {
        return NO;
    }
}


//================================================================================
//
//================================================================================
- (BOOL)canBecomeFirstResponder
{
    return YES;
}


//================================================================================
//
//================================================================================
- (void)cut:(id)sender
{
    __block typeof(self) blockself = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        [blockself becomeFirstResponder];
        [blockself showMenuWithAnimated:NO];
    });
}


//================================================================================
//
//================================================================================
- (void)paste:(id)sender
{
    __block typeof(self) blockself = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        [blockself becomeFirstResponder];
        [blockself showMenuWithAnimated:NO];
    });
    
}


//================================================================================
//
//================================================================================
- (void)copy:(id)sender
{
    __block typeof(self) blockself = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        [blockself becomeFirstResponder];
        [blockself showMenuWithAnimated:NO];
    });
}


//================================================================================
//
//================================================================================
- (void)showMenuWithAnimated:(BOOL)animated
{
    UIMenuController *menu = [UIMenuController sharedMenuController];

    if([menu isMenuVisible]==NO)
    {
        [menu setTargetRect:self.frame inView:self.superview];
        [menu setMenuVisible:YES animated:animated];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)showMenu
{
    [self becomeFirstResponder];
    
    //////////////////////////////////////////////////

    self.selectedRange = NSMakeRange(0, self.text.length-1);

    //////////////////////////////////////////////////

    [self showMenuWithAnimated:YES];
}


//================================================================================
//
//================================================================================
- (void)hideMenu
{
    self.selectedRange = NSMakeRange(0, 0);
    
    //////////////////////////////////////////////////

    UIMenuController *menu = [UIMenuController sharedMenuController];
    
    if([menu isMenuVisible]==YES)
    {
        [menu setMenuVisible:NO animated:YES];
    }
}

@end
