//
//  NCFCTextSignatureFlowController.m
//  Pods
//
//  Created by eddie on 2015/7/16.
//
//

#import "NCFCTextSignatureFlowController.h"

// Define
#import "WCAppearanceDefine.h"

// Controller
#import "PPSignatureViewController.h"
#import "PPNavigationController.h"

// Category
#import "WCNewCardFlowController+ResourceDefine.h"
#import "NCFCBaseFlowController+Private.h"
#import "NSError+Custom.h"
#import "UIColor+HexString.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface NCFCTextSignatureFlowController() <PPSignatureViewControllerDelegate>

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation NCFCTextSignatureFlowController


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)start
{
    
    self.curNewCardCount = [[CardRecognitionController shareRecognitionInstance] silentRecognitionCount];
    
#if defined (PRODUCTLINE_WCSF) ||defined (PRODUCTLINE_WCO365)
    self.showSubscribeWhenReachMaxCount = YES;
#endif
    
    //////////////////////////////////////////////////

    NSError *error = nil;
    
    do
    {
        __block typeof(self) blockSelf = self;
        
        if([self canNewCardWithError:&error] == NO)
        {            
            [self showAlertWithError:error title:WCNCFC_MLS_FailedToNewCard completion:^(BOOL didSubscribeNow) {
                
                if(didSubscribeNow)
                {
                    NSError *subscribeError = PPErrorMake(WCNewCardFlow_Error_SubscribeNow, @"馬上訂閱", error);
                    [blockSelf didFinishWithError:subscribeError];
                }
                else
                {
                    [blockSelf didFinishWithError:error];
                }
            }];
            //////////////////////////////////////////////////
            
            break;
        }
        
        //////////////////////////////////////////////////
        
        //呼叫簽名視圖
        
        PPSignatureViewController *signatureViewController = [[PPSignatureViewController alloc] init];
        
        if(signatureViewController==nil)
        {
            break;
        }
        
        signatureViewController.delegate = self;
        
        signatureViewController.hidesBottomBarWhenPushed = YES;
        
        //////////////////////////////////////////////////

        signatureViewController.topBarButtonHighlightedBackgroundColor = PPSignatureControllerTopBarButtonHighlightedColor;
        signatureViewController.textViewTextColor = PPSignatureControllerTextViewTextColor;
        signatureViewController.bottomBarBackgroundColor = PPSignatureControllerBottomBarBackgroundColor;
        signatureViewController.bottomBarFontColor = PPSignatureControllerBottomBarFontColor;
        signatureViewController.buttonImageEdgeInset = WCAppearanceDefine_ButtonImageEdgeInset;
        signatureViewController.bottomBarFontSize = FontSizeForPPSignatureControllerBottomView;
        signatureViewController.contentFontSize   = FontSizeForPPSignatureControllerContentView;
        
        //////////////////////////////////////////////////
        
        if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
        {
            PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:signatureViewController];
            
            if(navigationController!=nil)
            {
                [self.superViewController presentViewController:navigationController animated:YES completion:nil];
            }
            
            [navigationController release];
        }
        else
        {
            if(self.superViewController.navigationController!=nil)
            {
                [self.superViewController.navigationController pushViewController:signatureViewController animated:YES];
            }
            else
            {
                PPNavigationController *navigationContorller = [[PPNavigationController alloc] initWithRootViewController:signatureViewController];
                
                if(navigationContorller==nil)
                {
                    break;
                }
                
                [self.superViewController presentViewController:navigationContorller
                                                       animated:YES
                                                     completion:nil];
                
                [navigationContorller release];
            }
            
        }
        
    } while(0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPSignatureViewControllerDelegate Method

//================================================================================
//
//================================================================================
- (void)ppSignatureViewController:(PPSignatureViewController *)signatureController action:(PPSignatureViewControllerAction)action
{
    switch (action)
    {
        case PPSignatureViewControllerAction_Recognition:
        {
            NSError *returnError = nil;
            
            WCCardModel *cardModel = [self requestRecogWithSourceString:[signatureController recognitionString]
                                                            newCardMode:WCNewCardFlowController_Mode_TextSignature
                                                                  error:&returnError];
            
            if(cardModel!=nil)
            {
                [cardModel setGroupIDArray:[self requestCardModelWithCardModelDefaultGroupIDArray] isInitCard:YES];
                
                //////////////////////////////////////////////////
#ifdef PRODUCTLINE_WCE
                // !! WCE 情況下，要塞 CategoryGuid
                if([[cardModel groupIDArray] count]>0 &&
                   [cardModel respondsToSelector:@selector(setCategoryGuid:)]==YES)
                {
                    [cardModel performSelector:@selector(setCategoryGuid:) withObject:[[cardModel groupIDArray] firstObject]];
                }
#endif

                //////////////////////////////////////////////////

                [self showContactEditViewControllerWithCardModel:cardModel
                                                    idPhotoImage:nil
                                                  frontCardImage:nil
                                                   rearCardImage:nil];
            }
            else
            {
                __block typeof(self) blockself = self;
                
                [self.superViewController dismissViewControllerAnimated:YES completion:^{
                    [blockself didFinishWithError:nil];
                }];
            }
            
            break;
        }
        case PPSignatureViewControllerAction_Back:
        {
            __block typeof(self) blockself = self;
            
            [signatureController dismissViewControllerAnimated:YES completion:^{
                [blockself didFinishWithError:nil];
            }];
            
            break;
        }
        default:
        {
            break;
        }
    }
}

@end
