//
//  NCFCCaptureFlowController.m
//

#import "NCFCHelpScanCaptureFlowController.h"

// Define
#import "NCFCBaseFlowController+ParameterDefine.h"
#import "WCNewCardFlowController+ResourceDefine.h"
#import "WCNewCardFlowController+SettingsKey.h"
#import "WCCaptureViewController+SettingsKey.h"
#import "WCCaptureFlowController+SettingKey.h"

// Controller
#import "WCImageBrowseViewController.h"
#import "PPLogController.h"
#import "PPNavigationController.h"
#import "PPSettingsController.h"
#import "WCVCFDataController.h"
#import "WCCaptureFlowController.h"
#import "WCToastController.h"

// Category
#import "NSError+Custom.h"
#import "NCFCBaseFlowController+Private.h"
#import "NSObject+PPBusyView.h"

#if defined (PRODUCTLINE_WCE)
#import "WCECardModel.h"
#import "WCEFieldModel.h"
#endif

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface NCFCHelpScanCaptureFlowController () <WCCaptureFlowControllerDatasource,WCCaptureFlowControllerDelegate>

@property (nonatomic,assign) BOOL noQRCodeResult;
@property (nonatomic,retain) WCCaptureFlowController *captureFlowController;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation NCFCHelpScanCaptureFlowController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Life cycle methods

//================================================================================
//
//================================================================================
- (id)init
{
    if(self = [super init])
    {

    }
    
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.captureFlowController = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override methods

//================================================================================
//
//================================================================================
- (void)start
{
    self.curNewCardCount = [[CardRecognitionController shareRecognitionInstance] silentRecognitionCount];

    //////////////////////////////////////////////////

    [PPSettingsController setIntegerValue:[PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_FrontCardRecogLanguage]
                                  withKey:WCCaptureFlowController_SettingsKey_FrontCardRecogLanguage];
    
    [PPSettingsController setIntegerValue:[PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_RearCardRecogLanguage]
                                  withKey:WCCaptureFlowController_SettingsKey_RearCardRecogLanguage];
    
    //////////////////////////////////////////////////

    self.captureFlowController = [[[WCCaptureFlowController alloc] init] autorelease];
    
    if(self.captureFlowController!=nil)
    {
        [self.captureFlowController setCaptureFlowDatasource:self];
        [self.captureFlowController setCaptureFlowDelegate:self];
        [self.captureFlowController setCurCaptureCardCount:self.curNewCardCount];
        [self.captureFlowController setMaxCaptureCardCount:self.maxNewCardCount];
        
        [self.captureFlowController setHideNextCardButton:YES];
        [self.captureFlowController setHideCaptureCount:YES];
        //////////////////////////////////////////////////

        NSArray *captureModes = nil;
        captureModes = @[@(CaptureMode_Manual)];

        
        //////////////////////////////////////////////////
        // 單張不能用雙面，所以還是用多張來拍
        [self.captureFlowController presentMultiModeFromViewController:self.superViewController
                                                           captureSide:CaptureSide_Front
                                                          captureCount:0
                                                   supportCaptureModes:captureModes
                                                     activeCaptureMode:CaptureMode_Manual
                                                     presentCompletion:nil];
    }
}

#pragma mark override WCContactAccessFlowControllerDelegate
//================================================================================
//
//================================================================================
- (BOOL)contactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController
                             action:(WCContactFlowControllerAction)action
                         withCardID:(NSString *)cardID
                              error:(NSError **)error
{
    // MARK: 動作
    PPLogFunction(@" %s",__func__);
    
    //////////////////////////////////////////////////
    
    switch (action)
    {
        case WCContactFlowControllerAction_Delete:
        {
            // 新增連絡人不會刪除
            break;
        }
        case WCContactFlowControllerAction_SetBackFieldAsFront:
        {
            break;
        }
        case WCContactFlowControllerAction_SetBackFieldAsManul:
        {
            break;
        }
        case WCContactFlowControllerAction_SetFrontFieldAsManul:
        {
            break;
        }
        case WCContactFlowControllerAction_SwitchFavorite:
        {
            // TODO: 新增連絡人至我的最愛
            break;
        }
        case WCContactFlowControllerAction_EditSuccessful:
        {
            PPLogFunction(@"WCContactFlowControllerAction_EditSuccessful");

            dispatch_async(dispatch_get_main_queue(), ^{
                [contactAccessFlowController.contactEditViewController setBusy:@(YES)];
            });

            //////////////////////////////////////////////////
            __block BOOL saveCard = NO;
            
            //////////////////////////////////////////////////
            
            __block typeof(self) blockSelf = self;
            
            NSError *returnError = nil;
            saveCard = [self requestSaveWithSingleCardModel:contactAccessFlowController.userInfo
                                               idPhotoImage:self.headImage
                                             frontSideImage:self.frontCardImage
                                              backSideImage:self.rearCardImage
                                                   sourceID:nil
                                                    groupID:nil
                                                   personID:nil
                                                      error:&returnError];
            
            [returnError retain];

            //////////////////////////////////////////////////
            dispatch_async(dispatch_get_main_queue(), ^{
                //////////////////////////////////////////////////
                
                [contactAccessFlowController.contactEditViewController setBusy:@(NO)];
                __block typeof(self) blockself = self;
                
                if(saveCard==YES)
                {
                    NSString *message = [NSString stringWithFormat:WCNCFC_MLS_SendToColleagueSuccess, self.helpScanTargetAccountName];
                    
                    [WCToastController showMessageToastFromSuperView:contactAccessFlowController.contactEditViewController.view
                                                         withMessage:message
                                                            position:PPToastPositionCenter];

                    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                        
                        //////////////////////////////////////////////////
                        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.5 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{

                            //////////////////////////////////////////////////
                            
                            [self.superViewController dismissAnimated:YES completion:^{
                                
                                // !!help scan特殊做法，讓收到的人知道要再開一次拍照
                                if(contactAccessFlowController.contactEditViewController.isHelpScanAddNext==YES)
                                {
                                    if([blockself.delegate respondsToSelector:@selector(setUserInfo:)])
                                    {
                                        [blockself.delegate performSelector:@selector(setUserInfo:) withObject:@(YES)];
                                    }
                                }
                                [blockself didFinishWithError:nil];
                                [returnError release];
                            }];
                        });
                    });
                }
                else
                {
                    [self showAlertWithError:returnError title:WCNCFC_MLS_FailedToNewCard completion:^(BOOL didSubscribeNow) {
                        [self.superViewController dismissViewControllerAnimated:YES completion:^{
                            [blockself didFinishWithError:returnError];
                            [returnError release];
                        }];
                    }];
                }
            });
            
            
            return saveCard;
        }
        case WCContactFlowControllerAction_GoBack:
        {
            PPLogFunction(@"WCContactFlowControllerAction_GoBack");
            
            __block typeof(self) blockself = self;
            
            [self.superViewController dismissViewControllerAnimated:YES completion:^{
                [blockself didFinishWithError:nil];
            }];
            
            break;
        }
        default:
        {
            break;
        }
    }
    return YES;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Setting Key Write Method

//================================================================================
//
//================================================================================
- (void)updateNewCardFlowSettingKeyWithCapture
{
//    [PPSettingsController setIntegerValue:[PPSettingsController integerValueWithKey:WCCaptureFlowController_SettingsKey_LastCaptureMode]
//                                  withKey:WCNewCardFlowController_SettingsKey_HelpScan_LastCaptureMode];
    
    [PPSettingsController setIntegerValue:[PPSettingsController integerValueWithKey:WCCaptureFlowController_SettingsKey_FrontCardRecogLanguage]
                                  withKey:WCNewCardFlowController_SettingsKey_FrontCardRecogLanguage];
    
    [PPSettingsController setIntegerValue:[PPSettingsController integerValueWithKey:WCCaptureFlowController_SettingsKey_RearCardRecogLanguage]
                                  withKey:WCNewCardFlowController_SettingsKey_RearCardRecogLanguage];
}


//================================================================================
//
//================================================================================
- (BOOL)showContactEditViewControllerWithCardModel:(WCCardModel *)cardModel
                                      idPhotoImage:(UIImage *)idPhotoImage
                                    frontCardImage:(UIImage *)frontCardImage
                                     rearCardImage:(UIImage *)rearCardImage
{
    BOOL result = NO;
    
    do
    {
        WCContactAccessFlowController *contactAccessFlowController = [[WCContactAccessFlowController alloc] init];
        
        if(contactAccessFlowController==nil)
        {
            break;
        }
 
        //////////////////////////////////////////////////
        
        self.headImage = idPhotoImage;
        self.frontCardImage = frontCardImage;
        self.rearCardImage  = rearCardImage;
        
        //////////////////////////////////////////////////
        
        NSString *contactGUID = nil;
        
        BOOL manual = NO;
        
        if(cardModel==nil)
        {
            manual = YES;
            
            //////////////////////////////////////////////////
            
            // !! 手動新增時，不會有currentEditingCardModel， 所以要自已建
            WC_CardModel *manualCardModel = [[[WC_CardModel alloc] init] autorelease];
            
            if(manualCardModel!=nil)
            {
                manualCardModel.ID = [NSString GUID];
                
                [manualCardModel setGroupIDArray:[self requestCardModelWithCardModelDefaultGroupIDArray] isInitCard:YES];
                
                //////////////////////////////////////////////////
                
#ifdef PRODUCTLINE_WCE
                // !! WCE 情況下，要塞 CategoryGuid
                if([[manualCardModel groupIDArray] count]>0 &&
                   [manualCardModel respondsToSelector:@selector(setCategoryGuid:)]==YES)
                {
                    [manualCardModel performSelector:@selector(setCategoryGuid:) withObject:[[manualCardModel groupIDArray] firstObject]];
                }
#endif
                
                //////////////////////////////////////////////////
                
                manualCardModel.createdTime = [NSDate date];
                manualCardModel.modifiedTime = [NSDate date];
            }
            
            //////////////////////////////////////////////////
            
            contactAccessFlowController.userInfo = manualCardModel;
            contactGUID = manualCardModel.ID;
        }
        else
        {
            contactAccessFlowController.userInfo = cardModel;
            contactGUID = cardModel.ID;
        }
        
        //////////////////////////////////////////////////
        
        BOOL isForWCTMode = NO;
        
#if defined(PRODUCTLINE_WCT)
        isForWCTMode = YES;
#endif
        //////////////////////////////////////////////////
        
        if(isForWCTMode==YES)
        {
            WCCardModel *tempCardModel = contactAccessFlowController.userInfo;
            
            NSString *selfAccountGuid = [self selfAccountGuidWithContactAccessFlowController:contactAccessFlowController];
            
            tempCardModel.creator = selfAccountGuid?:@"";
            tempCardModel.editor = selfAccountGuid?:@"";
            // TODO: owner應該是被幫忙的人
            tempCardModel.owner = selfAccountGuid?:@"";

            // TODO: 正確應該是什麼?
            tempCardModel.sharedAccountGUIDArray = [self requestDefaultSharedAccountGuidsWithCardID:contactGUID];
        }
        
        //////////////////////////////////////////////////
        
        __block typeof(self) blockself = self;

        if(self.superViewController.presentedViewController==nil)
        {
            [contactAccessFlowController showContactEditFromViewController:self.superViewController
                                                                    cardID:contactGUID
                                                                  delegate:blockself
                                            contacEditViewControllerLayout:WCContactEditViewControllerLayout_HelpScan
                                                                    manual:manual];
        }
        else
        {
            [self.superViewController dismissAnimated:YES completion:^{
                
                [contactAccessFlowController showContactEditFromViewController:blockself.superViewController
                                                                        cardID:contactGUID
                                                                      delegate:blockself
                                                contacEditViewControllerLayout:WCContactEditViewControllerLayout_HelpScan
                                                                        manual:manual];
            }];
        }
        
        //////////////////////////////////////////////////
        
        self.contactAccessFlowController = contactAccessFlowController;
        
        [contactAccessFlowController release];
        
        //////////////////////////////////////////////////
        
        result = YES;
    }
    while (0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCCaptureFlowControllerDatasource Method

//================================================================================
//
//================================================================================
- (NSArray *)recogLanguagesWithCaptureSide:(WCCaptureViewController_CaptureSide)captureSide
{
    if(captureSide==CaptureSide_Front)
    {
        return [self recogLangTitlesWithSelectedTitle:[self recogTitleWithRecogLangCode:[PPSettingsController integerValueWithKey:WCCaptureFlowController_SettingsKey_FrontCardRecogLanguage]]];
    }
    else
    {
        return [self recogLangTitlesWithSelectedTitle:[self recogTitleWithRecogLangCode:[PPSettingsController integerValueWithKey:WCCaptureFlowController_SettingsKey_RearCardRecogLanguage]]];
    }
}


//================================================================================
//
//================================================================================
- (NSInteger)numberOfCard
{
    return 0;
}


//================================================================================
//
//================================================================================
- (NSUInteger)recogLangCodeWithRecogTitle:(NSString *)recogTitle
{
    return [super requestRecogLangCodeWithRecogLangauge:recogTitle];
}


//================================================================================
//
//================================================================================
- (WCRecogSourceModel *)recogSourceModelForImageType:(WC_ImageType)imageType
                                       recogLanguage:(NSString *)recogLanguage
                                   activeCaptureMode:(WCCaptureViewController_CaptureMode)acitveCaptureMode
{
    NSString *cardID = nil;
    
    if(imageType==WC_IT_FrontSide)
    {
        cardID = [NSString GUID];
    }
    else
    {
        //取前一張
        WCRecogSourceModel *recogSourceModel = [self.recogSourceModels lastObject];
        
        cardID = recogSourceModel.cardID;
    }
    
    //////////////////////////////////////////////////

    WCRecogSourceModel *recogSourceModel = [self nextRecogSourceModelWithCardID:cardID imageType:imageType addMode:WCRecogSourceModelAddMode_Camera];
    
    if(recogSourceModel!=nil)
    {
        recogSourceModel.imageEnhance = [PPSettingsController integerValueWithKey:WCCaptureViewControllr_SettingsKey_EnableImageEnhance];
        recogSourceModel.imageSegment = [PPSettingsController integerValueWithKey:WCCaptureViewControllr_SettingsKey_EnableAutoCrop];

        recogSourceModel.recogLang = [self requestRecogLangCodeWithRecogLangauge:recogLanguage];
    }

    return recogSourceModel;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCCaptureFlowControllerDelegate Method

//================================================================================
//
//================================================================================
- (void)captureFlowController:(WCCaptureFlowController *)captureFlowController
     didRecongizeQRCodeString:(NSString *)string
{
    // !!HelpScan只支援拍照，不支援QRCode
}


//================================================================================
//
//================================================================================
- (void)captureFlowController:(WCCaptureFlowController *)captureFlowController
      dockModeDidCaptureImage:(UIImage *)image
                recogLanguage:(NSString *)recogLanguage
                  captureSide:(WCCaptureViewController_CaptureSide)captureSide
             isDoubleSideMode:(BOOL)isDoubleSideMode
{
    // !! 不支援dock
}


//================================================================================
//
//================================================================================
- (void)captureFlowController:(WCCaptureFlowController *)captureFlowController
     fromCaptureViewControler:(WCCaptureViewController *)captureViewController
     manualModeDidSelectImage:(UIImage *)image
             recogSourceModel:(WCRecogSourceModel *)recogSourceModel
                      isFinal:(BOOL)isFinal
{
    //存原始圖
    NSString *path = [self pathForSavingImage:image
                                      imageID:recogSourceModel.cardID
                                    imageType:recogSourceModel.imageType
                                  lightEnable:NO];
    
    //原始圖位置
    recogSourceModel.imageSource = path;
    
    //////////////////////////////////////////////////
    
    //有做影像優化才要存亮化圖
    if(recogSourceModel.imageEnhance==YES)
    {
        //存亮化圖
        path = [self pathForSavingImage:image
                                imageID:recogSourceModel.cardID
                              imageType:recogSourceModel.imageType
                            lightEnable:YES];
        
        //亮化圖位置
        recogSourceModel.lightImageSource = path;
    }
    
    //////////////////////////////////////////////////
    
    //中文名片輸出設定
    recogSourceModel.outputTranslate = [PPSettingsController integerValueWithKey:WCNewCardFlowController_SettingsKey_ChineseCardOutput];
    
    //////////////////////////////////////////////////
    
    if(recogSourceModel.imageType==WC_IT_BackSide)
    {
        [PPSettingsController setIntegerValue:recogSourceModel.recogLang
                                      withKey:WCNewCardFlowController_SettingsKey_RearCardRecogLanguage];
    }
    else if(recogSourceModel.imageType==WC_IT_FrontSide)
    {
        [PPSettingsController setIntegerValue:recogSourceModel.recogLang
                                      withKey:WCNewCardFlowController_SettingsKey_FrontCardRecogLanguage];
    }
    
    //////////////////////////////////////////////////
    
    PPLogFunction(@" %s, recogSourceModel.CardID:%@, recogSourceModel.imageType:%td",__func__,recogSourceModel.cardID,recogSourceModel.imageType);
    
    [self.recogSourceModels addObject:recogSourceModel];
  
    //////////////////////////////////////////////////

    if(isFinal==YES)
    {
        // TODO: 進單張編輯頁面
        if([self numberOfWholeCard]==1)
        {
            [self prepareRecogsourceModelsToRecognitionProgressWithAddCardMode:WCNewCardFlowControllerAddCardMode_Single
                                                            fromViewController:captureViewController];
            
        }
        else
        {
            [self prepareRecogsourceModelsToRecognitionProgressWithAddCardMode:WCNewCardFlowControllerAddCardMode_Multi
                                                            fromViewController:captureViewController];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)captureFlowControllerDidClickCancel:(WCCaptureFlowController *)captureFlowController fromCaptureViewController:(WCCaptureViewController *)captureViewController
{
    if(self.recogSourceModels.count<=0)
    {
        [captureViewController dismissAnimated:YES completion:^{
        }];
    }
    else
    {
        [self showAgainRecogtionAlert];
    }
}


//================================================================================
//
//================================================================================
- (void)captureFlowControllerDidClickDone:(WCCaptureFlowController *)captureFlowController
                fromCaptureViewController:(WCCaptureViewController *)captureViewController
{
    if(captureViewController.captureCount==1)
    {
        [self prepareRecogsourceModelsToRecognitionProgressWithAddCardMode:WCNewCardFlowControllerAddCardMode_Single
                                                        fromViewController:captureViewController];
    }
    else
    {
        [self prepareRecogsourceModelsToRecognitionProgressWithAddCardMode:WCNewCardFlowControllerAddCardMode_Multi
                                                        fromViewController:captureViewController];
    }
}


//================================================================================
//
//================================================================================
- (void)captureFlowControllerDidFinish:(WCCaptureFlowController *)captureFlowController
{
    [self updateNewCardFlowSettingKeyWithCapture];
    
    //////////////////////////////////////////////////
    
    self.captureFlowController = nil;
    
}


//================================================================================
//
//================================================================================
- (BOOL)captureFlowRequestShowError:(NSError *)error
{
    return YES;
}


//================================================================================
//
//================================================================================
- (NSString *)captureFlowRequestTitleWithError:(NSError *)error
{
    NSString *customTitle = nil;
    
    if(error.code==WCCaptureFlowControllerErrorCode_ReachMaximumCount)
    {
        customTitle = WCNCFC_MLS_FailedToNewCard;
    }
    
    return customTitle;
}


//================================================================================
//
//================================================================================
- (NSString *)captureFlowRequestMessageWithError:(NSError *)error
{
    NSString *customMessage = nil;
    
    customMessage = [self requestMessageWithError:error];
    
    if (customMessage==nil)
    {
        if(error.code==WCCaptureFlowControllerErrorCode_ReachMaximumCount)
        {
            customMessage = WCNCFC_MLS_ReachMaxNewCardCount;
        }
    }
    return customMessage;
}


//================================================================================
//
//================================================================================
- (void)captureFlowControllerShowDockPromotion:(WCCaptureFlowController *)captureFlowController
                     fromCaptureViewController:(WCCaptureViewController *)captureViewController
{
    // !! 不支援dock
}

@end
