//
//  AlbumPathController.h
//
//  Created by Mike on 2011/6/3.
//  Copyright 2011年 Penpower. All rights reserved.
//

////////////////////////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
#import "PPPathController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, AlbumPathControllerImageStyle)
{
    AlbumPathControllerImageStyle_Back,
    AlbumPathControllerImageStyle_Front,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, AlbumPathControllerImageSize)
{
    AlbumPathControllerImageSize_Small,
	AlbumPathControllerImageSize_Medium,
	AlbumPathControllerImageSize_Large,
    AlbumPathControllerImageSize_Original,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface AlbumPathController : PPPathController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

//  Documents/Dump
+ (NSString *)dumpDirectory;

//  Documents/Data
+ (NSString *)documentDataDirectory;

+ (NSString *)documentDataDirectoryWithCheck:(BOOL)check;

+ (NSString *)documentDirectoryPathWithAlbumPathControllerImageSize:(AlbumPathControllerImageSize)imageSize
                                                            imageID:(NSInteger)imageID
                                      albumPathControllerImageStyle:(AlbumPathControllerImageStyle)style;

+ (NSString *)tmpDirectoryPathWithAlbumPathControllerImageSize:(AlbumPathControllerImageSize)imageSize
                                                       imageID:(NSInteger)imageID
                                 albumPathControllerImageStyle:(AlbumPathControllerImageStyle)style;

//  tmp/Data
+ (NSString *)tempDataDirectory;
//  tmp/Data/Original
+ (NSString *)tempDataOriginalDirectory;
//  tmp/Data/Small
+ (NSString *)tempDataSmallDirectory;
//  tmp/Data/Medium
+ (NSString *)tempDataMediumDirectory;
//  tmp/Data/Large
+ (NSString *)tempDataLargeDirectory;

+ (NSString *)tempDataDirectoryWithCheck:(BOOL)check;

//  tmp/Data/Small/"imageName"
+ (NSString *)tempDataSmallDirectoryPathWithImageName:(NSString *)imageName;
//  tmp/Data/Medium/"imageName"
+ (NSString *)tempDataMediumDirectoryPathWithImageName:(NSString *)imageName;
//  tmp/Data/Large/"imageName"
+ (NSString *)tempDataLargeDirectoryPathWithImageName:(NSString *)imageName;
//  tmp/Data/Original/"imageName"
+ (NSString *)tempDataOriginalDirectoryPathWithImageName:(NSString *)imageName;


+ (void)clearTempDirectory;

+ (void)removeDocumentDirectory;
+ (void)removeDumpDirectory;
+ (void)removeItemPath:(NSString *)itemPath;

@end