//
//  WCMapPinAnnotationView.m
//  
//
//  Created by Howard on 2015/12/30.
//
//

#import "WCMapPinAnnotationView.h"

// Define
#import "WCMapViewController+ResourceDefine.h"

// View
#import "WCMapAnnotationPopoverShapeView.h"

// Model
#import "WCMapAnnotation.h"

// Category
#import "UIBezierPath+PopoverStyle.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Global Parameter Setting

static NSOperationQueue *g_fetchImageOperationQueue = nil;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Interface WCMapPinAnnotationView

@interface WCMapPinAnnotationView()

@property (nonatomic,retain) WCMapAnnotationPopoverShapeView *mapAnnotationPopoverShapeView;
@property (nonatomic,retain) CAShapeLayer *borderLayer;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation WCMapPinAnnotationView

@implementation WCMapPinAnnotationView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Life Cycle Method

//================================================================================
//
//================================================================================
- (id)initWithAnnotation:(id <MKAnnotation>)annotation reuseIdentifier:(NSString *)reuseIdentifier
{
    if(self=[super initWithAnnotation:annotation reuseIdentifier:reuseIdentifier])
    {
        if(g_fetchImageOperationQueue==nil)
        {
            g_fetchImageOperationQueue = [[NSOperationQueue alloc] init];
            
            if(g_fetchImageOperationQueue!=nil)
            {
                [g_fetchImageOperationQueue setMaxConcurrentOperationCount:1];
            }

        }
        //////////////////////////////////////////////////

        self.canShowCallout = NO;

        //////////////////////////////////////////////////

        _mapAnnotationPopoverShapeView = [[WCMapAnnotationPopoverShapeView alloc] init];
        
        if(_mapAnnotationPopoverShapeView!=nil)
        {
            _mapAnnotationPopoverShapeView.hidden = YES;
            
            [self addSubview:_mapAnnotationPopoverShapeView];
        }
        
        //////////////////////////////////////////////////

        _borderLayer = [[CAShapeLayer layer] retain];
        
        if(_borderLayer!=nil)
        {
            _borderLayer.strokeColor = WCMapViewControllerAnnotationViewBorderColor.CGColor;
            _borderLayer.fillColor = nil;
            _borderLayer.lineWidth = WCMapViewControllerAnnotationViewBorderWidth;
        }
        //////////////////////////////////////////////////

        self.alpha = WCMapViewControllerAnnotationViewAlpha;
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    
    [_mapAnnotationPopoverShapeView removeFromSuperview];
    [_mapAnnotationPopoverShapeView release];
    _mapAnnotationPopoverShapeView = nil;
    
    [_borderLayer removeFromSuperlayer];
    [_borderLayer release];
    _borderLayer = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout of Subview

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////

    if(self.mapAnnotationPopoverShapeView.hidden==NO)
    {
        [self.mapAnnotationPopoverShapeView.nameLabel sizeToFit];
        
        self.mapAnnotationPopoverShapeView.frame = CGRectMake(-(self.mapAnnotationPopoverShapeView.nameLabel.frame.size.width+WCMapAnnotationPopoverShapeViewContentInset.left*2+WCMapAnnotationPopoverShapeViewContentInset.right*2)/2-self.bounds.size.width/2+WCMapViewController_DefaultAnnotationViewOrigin.x,
                                                              WCMapViewController_DefaultAnnotationViewOrigin.y,
                                                              self.mapAnnotationPopoverShapeView.nameLabel.frame.size.width+WCMapAnnotationPopoverShapeViewContentInset.left*2+WCMapAnnotationPopoverShapeViewContentInset.right*2+WCMapAnnotationPopoverShapeView_HeadImageViewSize.width+WCMapAnnotationPopoverShapeView_NavigaionButtonSize.width,
                                                              WCMapAnnotationPopoverShapeViewSizeHeight);
        
        //////////////////////////////////////////////////
        
        UIBezierPath *rectPath = [UIBezierPath upPopoverStyleBezierPathFromMainRect:CGRectMake(0,
                                                                                               0,
                                                                                               self.mapAnnotationPopoverShapeView.nameLabel.frame.size.width+WCMapAnnotationPopoverShapeViewContentInset.left*2+WCMapAnnotationPopoverShapeViewContentInset.right*2+WCMapAnnotationPopoverShapeView_HeadImageViewSize.width+WCMapAnnotationPopoverShapeView_NavigaionButtonSize.width,
                                                                                               WCMapAnnotationPopoverShapeViewSizeHeight-WCMapAnnotationPopoverShapeView_TriangleHeight)
                                                                      triangleWidth:WCMapAnnotationPopoverShapeView_TriangleEdgeLength
                                                                     triangleHeight:WCMapAnnotationPopoverShapeView_TriangleHeight
                                                                             radius:WCMapAnnotationPopoverShapeView_Radius];
        
        
        //////////////////////////////////////////////////
        
        //外觀
        CAShapeLayer *maskLayer = [CAShapeLayer layer];
        
        if(maskLayer!=nil)
        {
            [maskLayer setPath:rectPath.CGPath];
            self.mapAnnotationPopoverShapeView.layer.mask = maskLayer;
        }
        
        //////////////////////////////////////////////////
        
        //邊界
        self.borderLayer.path = rectPath.CGPath;
        self.borderLayer.frame = self.mapAnnotationPopoverShapeView.bounds;
        
        if(self.borderLayer.superlayer==nil)
        {
            [self.mapAnnotationPopoverShapeView.layer addSublayer:self.borderLayer];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)fetchDataWithProtocol:(id<WCMapPinAnnotationViewDatasource>)protocol
{
    do
    {
        if(self.mapAnnotationPopoverShapeView.hidden==YES)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if(protocol==nil ||
           [protocol respondsToSelector:@selector(thumbnailHeadImageWithMapPinAnnotationView:)]==NO)
        {
            break;
        }

        //////////////////////////////////////////////////

        if([self.annotation respondsToSelector:@selector(cardModels)]==YES)
        {
            NSArray *cardModels = [self.annotation performSelector:@selector(cardModels)];
            
            if(cardModels.count>1)
            {
                [self.mapAnnotationPopoverShapeView.navigationButton setImage:nil];
                [self.mapAnnotationPopoverShapeView.navigationButton setTitle:[NSString stringWithFormat:@"%td",cardModels.count] maxWidth:0];
            }
            else
            {
                [self.mapAnnotationPopoverShapeView.navigationButton setImageWithName:ImageNameForWCMapViewControllerTableViewCellDisclosureIndicator];
            }
        }
        
        //////////////////////////////////////////////////

        if(self.mapAnnotationPopoverShapeView.nameLabel.text!=nil &&
           [self.mapAnnotationPopoverShapeView.nameLabel.text compare:[self.annotation title]]==NSOrderedSame)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        __block typeof(self) blockself = self;
        
        __block NSBlockOperation *blockOperation = [NSBlockOperation blockOperationWithBlock:^{

            if(blockOperation.isCancelled==NO)
            {
                UIImage *headImage = [protocol thumbnailHeadImageWithMapPinAnnotationView:blockself];
                
                [blockOperation retain];
                
                //////////////////////////////////////////////////

                dispatch_sync(dispatch_get_main_queue(), ^{
                    
                     if(blockOperation.isCancelled==NO)
                     {
                         blockself.mapAnnotationPopoverShapeView.nameLabel.text = [blockself.annotation title];
                         
                         //////////////////////////////////////////////////
                         
                         [blockself.mapAnnotationPopoverShapeView.nameLabel sizeToFit];
                         
                         blockself.mapAnnotationPopoverShapeView.frame = CGRectMake(-(blockself.mapAnnotationPopoverShapeView.nameLabel.frame.size.width+WCMapAnnotationPopoverShapeViewContentInset.left*2+WCMapAnnotationPopoverShapeViewContentInset.right*2)/2-blockself.bounds.size.width/2+WCMapViewController_DefaultAnnotationViewOrigin.x,
                                                                                    WCMapViewController_DefaultAnnotationViewOrigin.y,
                                                                                    blockself.mapAnnotationPopoverShapeView.nameLabel.frame.size.width+WCMapAnnotationPopoverShapeViewContentInset.left*2+WCMapAnnotationPopoverShapeViewContentInset.right*2+WCMapAnnotationPopoverShapeView_HeadImageViewSize.width+WCMapAnnotationPopoverShapeView_NavigaionButtonSize.width,
                                                                                    WCMapAnnotationPopoverShapeViewSizeHeight);
                         
                         //////////////////////////////////////////////////
                         
                         [blockself.mapAnnotationPopoverShapeView setHeadImage:headImage];

                     }
                    
                    //////////////////////////////////////////////////

                    [blockOperation release];
                });
            }

            //////////////////////////////////////////////////
            
            //operation end
        }];
        
        //////////////////////////////////////////////////

        if(blockOperation!=nil)
        {
            [g_fetchImageOperationQueue addOperation:blockOperation];
        }
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (BOOL)tapViewWithPoint:(CGPoint)point
{
    return CGRectContainsPoint(self.mapAnnotationPopoverShapeView.frame, point);
}


//================================================================================
//
//================================================================================
- (void)setActive:(BOOL)active
{
    if(active==YES)
    {
        self.mapAnnotationPopoverShapeView.hidden = NO;
        
        [self.mapAnnotationPopoverShapeView.navigationButton setHighlighted:YES];
    }
    else
    {
        self.mapAnnotationPopoverShapeView.hidden = YES;
        
        [self.mapAnnotationPopoverShapeView.navigationButton setHighlighted:NO]; 
    }
}


//================================================================================
//
//================================================================================
- (void)reuseForAnnotationView
{
    [self.mapAnnotationPopoverShapeView recycle];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (void)stopFetchData
{
    
    [g_fetchImageOperationQueue cancelAllOperations];
    [g_fetchImageOperationQueue waitUntilAllOperationsAreFinished];
}

@end
