//
//  RenewAnnotationWhenMapDidZoomOperation.m
//
//
//  Created by Howard on 2016/1/11.
//
//

#import "RenewAnnotationWhenMapDidZoomOperation.h"

// Define
#import "WCMapViewController+ParameterDefine.h"

// Controller
#import "PPLocationController.h"

// Model
#import "WCCardModel.h"
#import "WCMapAnnotation.h"

@implementation RenewAnnotationWhenMapDidZoomOperation

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creainting, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        _cardModels = [[NSMutableArray alloc] init];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_cardModels release];
    _cardModels = nil;
    
    _protocol = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (double)beweenDistanceFromPoint1:(CGPoint)point1 point2:(CGPoint)point2
{
    return sqrtf((point1.x-point2.x)*(point1.x-point2.x)+(point1.y-point2.y)*(point1.y-point2.y));
}


//================================================================================
//
//================================================================================
- (void)clusterForCardModel:(WCCardModel *)cardModel
                annotations:(NSMutableDictionary *)annotations
{
    NSInteger index = NSNotFound;

    do
    {
        if([self.protocol respondsToSelector:@selector(pointFromCoordinate:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if(cardModel==nil ||
           annotations==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        CLLocation *location = [[PPLocationController copyLocationFromString:cardModel.displayGPS] autorelease];
        
        if(location==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        CGPoint point1 = [self.protocol pointFromCoordinate:location.coordinate];
        
        for(id key in annotations.allKeys)
        {
            WCMapAnnotation *mapAnnotation = [annotations objectForKey:key];
            
            CGPoint point2 = [self.protocol pointFromCoordinate:mapAnnotation.centerLocation.coordinate];
            
            //加快速度，直接小於距離找到就離開
            if([self beweenDistanceFromPoint1:point1 point2:point2]<=self.cluseterMaximumPixel)
            {
                CLLocationCoordinate2D coordinate = CLLocationCoordinate2DMake((mapAnnotation.centerLocation.coordinate.latitude+location.coordinate.latitude)/2, (mapAnnotation.centerLocation.coordinate.longitude+location.coordinate.longitude)/2);
                
                mapAnnotation.centerLocation = [[[CLLocation alloc] initWithLatitude:coordinate.latitude
                                                                           longitude:coordinate.longitude] autorelease];
                
                [mapAnnotation.cardModels addObject:cardModel];
                
                index = [annotations.allKeys indexOfObject:key];
                
                break;
            }
        }
        
        
        if(index!=NSNotFound)
        {
            break;
        }

        //////////////////////////////////////////////////
        
        WCMapAnnotation *mapAnnotation = [[WCMapAnnotation alloc] init];
        
        if(mapAnnotation!=nil)
        {
            [mapAnnotation.cardModels addObject:cardModel];
            mapAnnotation.centerLocation = location;
            
            NSString *key = [PPLocationController stringForLocation:mapAnnotation.centerLocation];
            
            if(key!=nil)
            {
                [annotations setObject:mapAnnotation forKey:[PPLocationController stringForLocation:mapAnnotation.centerLocation]];
            }
        }
        
        [mapAnnotation release];
        
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)main
{
    do
    {
        if(self.cardModels.count<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        NSMutableDictionary *annotations =[NSMutableDictionary dictionary];
        
        if(annotations==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(WCCardModel *cardModel in self.cardModels)
        {
            @autoreleasepool
            {
                [self clusterForCardModel:cardModel
                              annotations:annotations];
            }
        }
        
        //////////////////////////////////////////////////

        [[NSNotificationCenter defaultCenter] postNotificationName:WCMapViewControllerRenewAnnotationsNotification
                                                            object:self
                                                          userInfo:@{WCMapViewControllerUserInfoKey_Annotations:annotations}];
    }
    while (0);
}

@end
