//
//  WCMFileCollectController.m
//  WorldCardMobile
//
//  Created by PPUser on 7/4/13.
//
//

#import "WCMFileCollectController.h"


#define WCMErrorStepDirName  @"WCM/ConvertStep"
#define WCMErrorStepFileName  @"ConvertStepFile"
#define WCMErrorStepDateTimeFormat     @"yyyy-MM-dd HH:mm:ss"


@interface WCMFileCollectController(private)
-(NSString *)copyStringOfFileStruct;

@end


@implementation WCMFileCollectController



#pragma mark - init , dealloc
-(id)init
{
    self=[super init];
    
    if(self)
    {
        
    }
    
    return self;
}


-(void)dealloc
{
    [super dealloc];
}


#pragma mark - private mathod


-(NSString *)copyStringOfFileStruct
{
    NSMutableString *resultString=nil;
    NSArray	*paths = NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES);
	NSString *libaryStorePath = [NSString stringWithFormat:@"%@/WCM/",[paths objectAtIndex:0]];
    NSArray *dirArray=nil;
    NSError *error = nil;
    
    
    resultString=[[NSMutableString alloc] init];
    dirArray = [[NSFileManager defaultManager]contentsOfDirectoryAtPath:libaryStorePath error:&error];

    for(NSString *fileName in dirArray)
    {
        NSDictionary* fileAttributes = [[NSFileManager defaultManager] attributesOfItemAtPath:[libaryStorePath stringByAppendingPathComponent:fileName] error:&error];

        if([fileAttributes objectForKey:NSFileType]==NSFileTypeDirectory)
        {
            [resultString appendString:fileName];
            NSString *databasePath=[NSString stringWithFormat:@"%@%@/%@",libaryStorePath,fileName,@"card.db"];
            
            NSDictionary* databaseFileAttributes = [[NSFileManager defaultManager] attributesOfItemAtPath:databasePath error:&error];
            
            if(databaseFileAttributes!=nil)
            {
                [resultString appendString:@"/n"];
                NSNumber *fileSizeString=[databaseFileAttributes objectForKey:NSFileSize];
                [resultString appendFormat:@"%@_card.db",fileName];
                [resultString appendString:@"("];
                [resultString appendFormat:@"%@",fileSizeString];
                [resultString appendString:@")"];
            }
            
            [resultString appendString:@"/n"];

        }
    }
    

    return resultString;

}





- (void)addConvertLogWithKey:(NSString *)key note:(NSString *)note
{
    NSString *filePath = [self filePathWithName:WCMErrorStepFileName];
    NSString *writeString = nil;
    
    
    if(![[NSFileManager defaultManager] fileExistsAtPath:filePath])
        [[NSFileManager defaultManager] createFileAtPath:filePath contents:nil attributes:nil];
    
    if([note length])
        writeString = [NSString stringWithFormat:@"%@ @ %@ (%@)\r\n", [self stringFromDate:[NSDate date]], key, note];
    else writeString = [NSString stringWithFormat:@"%@ @ %@\r\n", [self stringFromDate:[NSDate date]], key];

#if DEBUG
    NSLog(@"%@", writeString);
#endif
    
    NSFileHandle *fileHandle = [NSFileHandle fileHandleForWritingAtPath:filePath];
    
    [fileHandle seekToEndOfFile];
    [fileHandle writeData:[writeString dataUsingEncoding:NSUTF8StringEncoding]];
    [fileHandle closeFile];
}


//===============================================================================
//
//===============================================================================
- (NSString *)filePathWithName:(NSString *)name
{
    NSArray	*paths = NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES);
	NSString *dirPath = [NSString stringWithFormat:@"%@/%@", [paths objectAtIndex:0],WCMErrorStepDirName];
    
    if(![[NSFileManager defaultManager] fileExistsAtPath:dirPath])
    {
        [[NSFileManager defaultManager] createDirectoryAtPath:dirPath
                                  withIntermediateDirectories:YES
                                                   attributes:nil
                                                        error:nil];
    }
    
    return [NSString stringWithFormat:@"%@/%@", dirPath, name];
}




//===============================================================================
//
//===============================================================================
- (NSString *)stringFromDate:(NSDate *)date
{
    // !!統一使用標準時間
    NSDateFormatter* dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:WCMErrorStepDateTimeFormat];
    [dateFormatter setTimeZone:[NSTimeZone timeZoneWithAbbreviation:@"GMT"]];
    NSString *dateString = [dateFormatter stringFromDate:date];
    [dateFormatter release];
    
    return dateString;
}



//===============================================================================
//
//===============================================================================
-(NSString *)convertStepFilePath
{
    NSString *filePath = [self filePathWithName:WCMErrorStepFileName];
    
    if(![[NSFileManager defaultManager] fileExistsAtPath:filePath])
    {
        return nil;
    }
    else
    {
        return filePath;
    }

}


#pragma mark - class mathod


+(NSString *)copyStringOfFileStruct
{
    WCMFileCollectController *collectController=[[WCMFileCollectController alloc] init];
    NSString *fileStructString=nil;
    
    fileStructString=[collectController copyStringOfFileStruct];
    
    [collectController release];
    
    return fileStructString;
}



+(void)addConvertLogWithKey:(NSString *)key note:(NSString *)note
{
    WCMFileCollectController *collectController=[[WCMFileCollectController alloc] init];
    [collectController addConvertLogWithKey:key note:note];
    [collectController release];
}


+(NSString *)convertStepFilePath
{
    WCMFileCollectController *collectController=[[WCMFileCollectController alloc] init];
    NSString* convertPath=[collectController convertStepFilePath];
    [collectController release];
    return convertPath;
}
@end


