//
//  WCImportFlowControllerDelegate.h
//  
//
//  Created by Howard on 2015/8/6.
//
//

#import <Foundation/Foundation.h>
#import "WCGroupDefine.h"
#import "PPStorageSpaceSelectViewController+PublicParameterDefine.h"

@class WCImportFlowController;
@class WCABCardModel;
@class WCCardModel;

@protocol WCImportFlowControllerDelegate <NSObject>

/**
 *  詢問上層是否顯示此訊息
 *
 *  @param error 錯誤
 *
 *  @return YES, Show
 */
- (BOOL)importFlowRequestShowError:(NSError *)error;


/**
 *  詢問上層有無錯誤的解釋
 *
 *  @param error 錯誤
 *
 *  @return 解釋
 */
- (NSString *)importFlowRequestMessageWithError:(NSError *)error;


/**
 *  告知目前匯入的數量
 *  處理方式: 單張可能會直接進編輯元件，多張就不進
 *
 *  @param index      目前索引
 *  @param totalCount 總共數量
 */
- (void)importFlowImportTaskAtIndex:(NSUInteger)index
                         totalCount:(NSUInteger)totalCount;

/**
 * 回傳PPStorageSpaceSelectControllerSpaceType_Specific的顯示字串
 * @param importFlowController 委託者
 * @return NSString 有指定cell時，顯示的字串，nil時會顯示MLS_StorageSpecificTitle
 */
- (NSString *)specificStringWithimportFlowController:(WCImportFlowController*)importFlowController;

/**
 *  取得 GroupID
 *
 *  @param groupName 群組名稱
 *  @param error 回傳錯誤
 *
 *  @return GroupID
 */
- (WC_GroupID)importFlowRequestGroupIDWithGroupName:(NSString *)groupName
                                              error:(NSError **)error;


/**
 * 儲存資料 (synchronized)
 * 處理方式: 將名片與圖片存到資料庫或檔案中
 *
 * @param cardModel - WCCardModel that need to be saved
 * @param idPhotoImage - UIImage of ID photo
 * @param frontSideImage - UIImage of card front side
 * @param backSideImage - UIImage of card back side
 * @param error - return error
 * @return - YES if saved success
 */
- (BOOL)importFlowRequestImportWithWCCardModel:(WCCardModel *)cardModel
                                  idPhotoImage:(UIImage *)idPhotoImage
                                frontSideImage:(UIImage *)frontSideImage
                                 backSideImage:(UIImage *)backSideImage
                                         error:(NSError **)error;


/**
 * 儲存從系統聯絡人轉換過來的資料 (synchronized)
 * 處理方式: 將名片與圖片存到資料庫或檔案中
 *
 * @param cardModel - 用來記錄AddressBook的資料及關聯性
 * @param error - return error
 * @return YES if saved success
 */
- (BOOL)importFlowRequestImportWithWCABCardModel:(WCABCardModel *)cardModel
                                           error:(NSError **)error;


/**
 *  匯入流程結束
 *
 *  @param lastError 錯誤
 */
- (void)importFlowDidFinishWithError:(NSError *)lastError;



@optional

/**
 *  通知空間選擇結果
 *
 *  @param storageSpaceSelectControllerSpaceType 空間型態
 */
- (void)importFlowRequestDidSelectStorageSpaceSelectControllerSpaceType:(PPStorageSpaceSelectControllerSpaceType)storageSpaceSelectControllerSpaceType;


@end
