//
//  WCGroupView.h
//  ADAL
//
//  Created by sanhue on 2018/2/13.
//

#import <UIKit/UIKit.h>
#import "RATreeView.h"
#import "WCGroupViewDataSource.h"
#import "WCGroupViewDelegate.h"
#import "WCGroupModel.h"
#import "WCGroupTableViewCell.h"


typedef NS_ENUM(NSInteger, WCGroupViewStyle)
{
    WCGroupViewStyle_Name = 0,                ///< name+expandButton
    WCGroupViewStyle_NameWithPin,             ///< PinMark+name+expandButton
    WCGroupViewStyle_NameWithCount,           ///< name+cardCount+expandButton
    WCGroupViewStyle_NameWithCountAndPin,     ///< PinMark+name+cardCount+expandButton
    WCGroupViewStyle_NameWithCheckBox,        ///< checkBox+name+expandButton
};

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCGroupView : UIView

@property (nonatomic, assign) id<WCGroupViewDataSource> dataSource;
@property (nonatomic, assign) id<WCGroupViewDelegate> delegate;

@property (nonatomic, retain, readonly) RATreeView *treeView;


#pragma mark display style setting API

@property (nonatomic, assign) WCGroupViewStyle style;

// 是否進入編輯
@property (nonatomic, assign) BOOL editing;

/// 是否可多選, default YES
@property (nonatomic, assign) BOOL allowMultiSelection;

/// 不顯示展開按鈕時，是否保留按鈕空間，預設NO，表示不保留
@property (nonatomic, assign) BOOL reserveSpaceWhenExpandButtonHidden;

/// 在下方保留空間，預設nil
@property (nonatomic, retain) id<UILayoutSupport> bottomLayoutGuide;

/// 設定section header
- (void)setSectionHeaderHeight:(CGFloat)sectionHeaderHeight;

#pragma mark cell control API

/// 沒有結束時的顯示字串, default nil;
@property (nonatomic, retain) NSString *noResultString;

///enable long press cell when style is WCGroupViewStyle_NameWithCountAndPin, default NO,
@property (nonatomic, assign) BOOL enableLongPressCell;

/// 展開時是否要focus cell, default NO, 單選時才可用
@property (nonatomic, assign) BOOL activeWhenExpandCell;

/// other group 是否與一般類別互斥，default YES
@property (nonatomic, assign) BOOL exclusiveWithOther;

/// 是否允許在介面上操作釘選，default YES;
@property (nonatomic, assign) BOOL enablePinButton;

/// active某個cell
- (void)activeCellForItem:(id)item;

/// style==WCGroupViewStyle_NameWithCheckBox時，勾選cell
- (void)checkCellWithItem:(id)item;

/// 關閉scroll功能
- (void)setSrollEnabled:(BOOL)scrollEnabled;

#pragma mark data control API

/// 重load介面
-(void)reloadData;

/// 取得目前勾選項目
- (NSArray *)copySelectedItems;

- (WCGroupTableViewCell *)cellForItem:(id)item;

#pragma mark expand/collape control API
- (void)expendAllWithAnimated:(BOOL)animated;
- (void)expendRootWithAnimated:(BOOL)animated;
- (void)expendItem:(WCGroupModel*)item withAnimated:(BOOL)animated;

@end
