//
//  WCGroupFlowController.m
//  ADAL
//
//  Created by sanhue on 2018/3/5.
//

#import "WCGroupAccessFlowController.h"

// define
#import "WCTFieldLengthDefine.h"
#import "WCGroupAccessFlowController+ResourceDefine.h"
#import "WCGroupDefine.h"

// view controller
#import "WCSingleLayerGroupViewController.h"
#import "WCMultiLayerGroupEditViewController.h"
#import "WCAddOrEditGroupViewController.h"
#import "WCMultiLayerGroupPickerViewController.h"

//controller
#import "PPNavigationController.h"
#import "WCToastController.h"



////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCGroupAccessFlowController() <WCSingleLayerGroupViewControllerDelegate, WCGroupTreeViewControllerDelegate>

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCGroupAccessFlowController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.delegate = nil;
    self.userInfo = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - private






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - public 
#pragma  mark for WCM


//==============================================================================
//
//==============================================================================
- (void)showWCMGroupEditViewControllerFromViewController:(UIViewController *)viewController
{
    WCSingleLayerGroupViewController *groupViewController = [[WCSingleLayerGroupViewController alloc] init];
    if (groupViewController)
    {
        [groupViewController setDelegate:self];
        groupViewController.style = WCSingleLayerGroupViewControllerStyle_Edit;
        groupViewController.maxGroupLength = WCT_FML_Group;
        groupViewController.titleString = WCGAFC_MLS_EditGroup;
        groupViewController.showSortButton = YES;
        
        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:groupViewController];
        [viewController presentViewController:navigationController animated:YES completion:nil];
        [navigationController release];
    }
    [groupViewController release];
}


//==============================================================================
/// 顯示變更類別
//==============================================================================
- (void)showWCMChangeGroupViewControllerFromViewController:(UIViewController *)viewController
{
    WCSingleLayerGroupViewController *groupViewController = [[WCSingleLayerGroupViewController alloc] init];
    if (groupViewController)
    {
        [groupViewController setDelegate:self];
        groupViewController.style = WCSingleLayerGroupViewControllerStyle_ChangeGroup;
        groupViewController.maxGroupLength = WCT_FML_Group;
        groupViewController.titleString = WCGAFC_MLS_ChangeGroup;
        groupViewController.showSortButton = YES;
        
        if (viewController.navigationController==nil)
        {
            PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:groupViewController];
            [viewController presentViewController:navigationController animated:YES completion:nil];
            [navigationController release];
        }
        else
        {
            [viewController.navigationController pushViewController:groupViewController animated:YES];
        }
//        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:groupViewController];
//        [viewController presentViewController:navigationController animated:YES completion:nil];
//        [navigationController release];
    }
    [groupViewController release];
}


#pragma  mark for WCT


//==============================================================================
//
//==============================================================================
- (void)showPinnedGroupEditViewControllerFromViewController:(UIViewController *)viewController
{
    WCSingleLayerGroupViewController *groupViewController = [[WCSingleLayerGroupViewController alloc] init];
    if (groupViewController)
    {
        [groupViewController setDelegate:self];
        groupViewController.style = WCSingleLayerGroupViewControllerStyle_Edit;
        groupViewController.maxGroupLength = WCT_FML_Group;
#if defined (PRODUCTLINE_WCT)
        groupViewController.titleString = WCGAFC_MLS_EditPinnedGroup;
        groupViewController.noResultString = Common_MLS_NoPinnedCategory;
        groupViewController.clickCellToEdit = NO;
        groupViewController.showSortButton = NO;
        groupViewController.forWCTMode = YES;
#else
        groupViewController.titleString = WCGAFC_MLS_EditGroup;
        groupViewController.showSortButton = YES;
#endif
        
        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:groupViewController];
        [viewController presentViewController:navigationController animated:YES completion:nil];
        [navigationController release];
    }
    [groupViewController release];
}


//==============================================================================
//
//==============================================================================
- (void)showMultiLayerGroupEditViewControllerFromViewController:(UIViewController *)viewController
{
    WCMultiLayerGroupEditViewController *groupViewController = [[WCMultiLayerGroupEditViewController alloc] init];
    if (groupViewController)
    {
        [groupViewController setDelegate:self];
        groupViewController.titleString = WCGAFC_MLS_EditGroup;
        [groupViewController setActiveWhenExpandCell:YES];

        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:groupViewController];
        [viewController presentViewController:navigationController animated:YES completion:nil];
        [navigationController release];
    }
    [groupViewController release];
}


//==============================================================================
//
//==============================================================================
- (void)showChangeGroupViewControllerFromViewController:(UIViewController *)viewController
{
    [self showMultiSelectGroupViewControllerFromViewController:viewController titleString:WCGAFC_MLS_ChangeGroup forcePresent:NO];
}


//==============================================================================
//
//==============================================================================
- (void)showMultiSelectGroupViewControllerFromViewController:(UIViewController *)viewController titleString:(NSString *)titleString forcePresent:(BOOL)forcePresent
{
    [WCMultiLayerGroupPickerViewController showMultiLayerGroupPickerViewConrollerFromViewController:viewController
                                                                                        titleString:titleString
                                                                                     multiSelection:YES
                                                                                      showPinButton:NO
                                                                                          enablePin:NO
                                                                              checkWhileNoSelection:YES
                                                                                 exclusiveWithOther:YES
                                                                                       forcePresent:forcePresent
                                                                          requestSourceGroupHandler:^NSArray *(NSError **error) {

                                                                              if ([self.delegate respondsToSelector:@selector(sourceGroupArrayForGroupAccessFlowController:error:)])
                                                                              {
                                                                                  return [self.delegate sourceGroupArrayForGroupAccessFlowController:self error:error];
                                                                              }
                                                                              
                                                                              return nil;
                                                                          } requestSelectedGroupHandler:^NSArray *(NSError **error) {
                                                                              
                                                                              if ([self.delegate respondsToSelector:@selector(selectedGroupArrayForGroupAccessFlowController:error:)])
                                                                              {
                                                                                  return [self.delegate selectedGroupArrayForGroupAccessFlowController:self error:error];
                                                                              }
                                                                              
                                                                              return nil;
                                                                          } requestErrorMessageHandler:^NSString *(NSError *error) {
                                                                              
                                                                              if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:requestErrorMessageForError:)])
                                                                              {
                                                                                  return [self.delegate groupAccessFlowController:self requestErrorMessageForError:error];
                                                                              }
                                                                              return nil;
                                                                          } selectionHandler:^(NSArray *selectedGroups) {
                                                                              
                                                                              if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:groupsDidSelected:)])
                                                                              {
                                                                                  [self.delegate groupAccessFlowController:self groupsDidSelected:selectedGroups];
                                                                              }
                                                                          } finishHandler:^(WCMultiLayerGroupPickerViewController *viewController) {
                                                                              
                                                                              if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:didFinishViewController:)])
                                                                              {
                                                                                  [self.delegate groupAccessFlowController:self didFinishViewController:viewController];
                                                                              }
                                                                              self.userInfo = nil;
                                                                          }];
}



//==============================================================================
//
//==============================================================================
- (void)showSingleSelectGroupSelectViewControllerFromViewController:(UIViewController *)viewController titleString:(NSString *)titleString forcePresent:(BOOL)forcePresent;
{
    [WCMultiLayerGroupPickerViewController showMultiLayerGroupPickerViewConrollerFromViewController:viewController
                                                                                        titleString:titleString
                                                                                     multiSelection:NO
                                                                                      showPinButton:NO
                                                                                          enablePin:NO
                                                                              checkWhileNoSelection:YES
                                                                                 exclusiveWithOther:YES
                                                                                       forcePresent:forcePresent
                                                                          requestSourceGroupHandler:^NSArray *(NSError **error){
                                                                              
                                                                              if ([self.delegate respondsToSelector:@selector(sourceGroupArrayForGroupAccessFlowController:error:)])
                                                                              {
                                                                                  return [self.delegate sourceGroupArrayForGroupAccessFlowController:self error:error];
                                                                              }
                                                                              
                                                                              return nil;
                                                                          } requestSelectedGroupHandler:^NSArray *(NSError **error){
                                                                              
                                                                              if ([self.delegate respondsToSelector:@selector(selectedGroupArrayForGroupAccessFlowController:error:)])
                                                                              {
                                                                                  return [self.delegate selectedGroupArrayForGroupAccessFlowController:self error:error];
                                                                              }
                                                                              
                                                                              return nil;
                                                                          } requestErrorMessageHandler:^NSString *(NSError *error) {
                                                                              
                                                                              if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:requestErrorMessageForError:)])
                                                                              {
                                                                                  return [self.delegate groupAccessFlowController:self requestErrorMessageForError:error];
                                                                              }
                                                                              return nil;
                                                                          } selectionHandler:^(NSArray *selectedGroups) {
                                                                              
                                                                              if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:groupsDidSelected:)])
                                                                              {
                                                                                  [self.delegate groupAccessFlowController:self groupsDidSelected:selectedGroups];
                                                                              }
                                                                          } finishHandler:^(WCMultiLayerGroupPickerViewController *viewController) {
                                                                              
                                                                              if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:didFinishViewController:)])
                                                                              {
                                                                                  [self.delegate groupAccessFlowController:self didFinishViewController:viewController];
                                                                              }
                                                                              self.userInfo = nil;
                                                                          }];
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCSingleLayerGroupViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)sourceGroupArrayForGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController
{
#if defined (PRODUCTLINE_WCT)
    if ([self.delegate respondsToSelector:@selector(pinnedSourceGroupArrayForGroupAccessFlowController:)])
    {
        return [self.delegate pinnedSourceGroupArrayForGroupAccessFlowController:self];
    }
#else
    if ([self.delegate respondsToSelector:@selector(sourceGroupArrayForGroupAccessFlowController:error:)])
    {
        return [self.delegate sourceGroupArrayForGroupAccessFlowController:self error:nil];
    }
    
#endif
    return nil;
}

#pragma mark - for group add


//==============================================================================
//
//==============================================================================
- (BOOL)singleLayerGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController isExistGroupNamed:(NSString*)groupNamed
{
    if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:requestIsExistGroupNamed:)])
    {
        return [self.delegate groupAccessFlowController:self requestIsExistGroupNamed:groupNamed];
    }
    
    return YES;
}


//==============================================================================
//
//==============================================================================
- (WCGroupModel *)singleLayerGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController groupModelByNewGroupName:(NSString *)groupName
{
    if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:requestGroupModelByNewGroupName:superGroupGuid:error:)])
    {
        return [self.delegate groupAccessFlowController:self requestGroupModelByNewGroupName:groupName superGroupGuid:nil error:nil];
    }
    
    return nil;
}


#pragma mark - for group edit style

#if defined (PRODUCTLINE_WCT)

//==============================================================================
//
//==============================================================================
- (BOOL)singleLayerGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController didOrderChangedWithNewGroupArray:(NSArray *)groupArray
{
    if([self.delegate respondsToSelector:@selector(groupAccessFlowController:singleLayerGroupViewController:didOrderChangedWithNewGroupArray:)])
    {
        return [self.delegate groupAccessFlowController:self singleLayerGroupViewController:singleLayerGroupViewController didOrderChangedWithNewGroupArray:groupArray];
    }
    
    return YES;
}


#endif

//==============================================================================
//
//==============================================================================
- (void)didClickNewGroupWithViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController
{
#if defined (PRODUCTLINE_WCT)
    __block typeof(self) blockSelf = self;
    
    [WCMultiLayerGroupPickerViewController showMultiLayerGroupPickerViewConrollerFromViewController:singleLayerGroupViewController
                                                                                        titleString:WCGAFC_MLS_AddPinnedGroup
                                                                                     multiSelection:NO
                                                                                      showPinButton:YES
                                                                                          enablePin:NO
                                                                              checkWhileNoSelection:NO
                                                                                 exclusiveWithOther:YES
                                                                                       forcePresent:NO
                                                                          requestSourceGroupHandler:^NSArray *(NSError **error){
                                                                              
                                                                              if ([self.delegate respondsToSelector:@selector(sourceGroupArrayForGroupAccessFlowController:error:)])
                                                                              {
                                                                                  return [self.delegate sourceGroupArrayForGroupAccessFlowController:self error:error];
                                                                              }
                                                                              
                                                                              return nil;
                                                                          } requestSelectedGroupHandler:^NSArray *(NSError **error){
                                                                              
                                                                              return nil;
                                                                          } requestErrorMessageHandler:^NSString *(NSError *error) {
                                                                              
                                                                              if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:requestErrorMessageForError:)])
                                                                              {
                                                                                  return [self.delegate groupAccessFlowController:self requestErrorMessageForError:error];
                                                                              }
                                                                              return nil;
                                                                          } selectionHandler:^(NSArray *selectedGroups) {
                                                                              
                                                                              if ([blockSelf.delegate respondsToSelector:@selector(groupAccessFlowController:requestGroupModels:pinned:)])
                                                                              {
                                                                                  __block typeof(self) blockSelf = self;
                                                                                  
                                                                                  dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                                                                                      NSError *error = [blockSelf.delegate groupAccessFlowController:blockSelf requestGroupModels:selectedGroups pinned:YES];
                                                                                      
                                                                                      //////////////////////////////////////////////////
                                                                                      dispatch_async(dispatch_get_main_queue(), ^{
                                                                                          
                                                                                          if (error)
                                                                                          {
                                                                                              NSString *errorMessage = nil;
                                                                                              if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:requestErrorMessageForError:)])
                                                                                              {
                                                                                                  errorMessage = [self.delegate groupAccessFlowController:self requestErrorMessageForError:error];
                                                                                              }
                                                                                              
                                                                                              if ([errorMessage length])
                                                                                              {
                                                                                                  [WCToastController showMessageToastFromSuperView:singleLayerGroupViewController.view
                                                                                                                                       withMessage:errorMessage
                                                                                                                                          position:PPToastPositionCenter];
                                                                                              }
                                                                                          }
                                                                                          else
                                                                                          {
                                                                                              [singleLayerGroupViewController clearAndLoadGroupData];
                                                                                          }
                                                                                      });
                                                                                  });
                                                                                  
                                                                                  
                                                                              }
                                                                          } finishHandler:nil];
#else
    [singleLayerGroupViewController showNewGroupUI];
#endif
}


//==============================================================================
//
//==============================================================================
- (NSMutableArray*)singleLayerGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController sortedGroupWithCurrentGroups:(NSArray *)currentGroups
{
    if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:sortedGroupWithCurrentGroups:)])
    {
        return [self.delegate groupAccessFlowController:self sortedGroupWithCurrentGroups:currentGroups];
    }
    
    return nil;
}


//==============================================================================
//
//==============================================================================
- (void)singleLayerGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController updateGroupModel:(WCGroupModel *)groupModel
{
    if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:updateGroupModel:)])
    {
        [self.delegate groupAccessFlowController:self updateGroupModel:groupModel];
    }
}


//==============================================================================
//
//==============================================================================
- (void)singleLayerGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController deleteGroupModel:(WCGroupModel *)groupModel
{
#if defined (PRODUCTLINE_WCT)
    if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:requestGroupModels:pinned:)])
    {
        if (groupModel==nil)
        {
            return ;
        }
        __block typeof(self) blockSelf = self;
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            NSError *error = [blockSelf.delegate groupAccessFlowController:blockSelf requestGroupModels:@[groupModel] pinned:NO];
            
            //////////////////////////////////////////////////
            dispatch_async(dispatch_get_main_queue(), ^{
                
                if (error)
                {
                    NSString *errorMessage = nil;
                    if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:requestErrorMessageForError:)])
                    {
                        errorMessage = [self.delegate groupAccessFlowController:self requestErrorMessageForError:error];
                    }
                    
                    if ([errorMessage length])
                    {
                        [WCToastController showMessageToastFromSuperView:singleLayerGroupViewController.view
                                                             withMessage:errorMessage
                                                                position:PPToastPositionCenter];
                    }
                }

                [singleLayerGroupViewController clearAndLoadGroupData];
            });
        });
        
        
    }
#else
    if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:deleteGroupModel:)])
    {
        [self.delegate groupAccessFlowController:self deleteGroupModel:groupModel];
    }
#endif
}





//==============================================================================
//
//==============================================================================
- (void)singleLayerGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController didEditFinishWithGroupArray:(NSArray *)groupModelArray
{
    if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:didEditFinishWithGroupArray:)])
    {
        [self.delegate groupAccessFlowController:self didEditFinishWithGroupArray:groupModelArray];
    }
}


#pragma mark - for group change style


//==============================================================================
//
//==============================================================================
- (NSArray *)selectedGroupArrayForGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController;
{
    if ([self.delegate respondsToSelector:@selector(selectedGroupArrayForGroupAccessFlowController:error:)])
    {
        return [self.delegate selectedGroupArrayForGroupAccessFlowController:self error:nil];
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (void)singleLayerGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController groupsDidSelected:(NSArray *)groupArray
{
    if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:groupsDidSelected:)])
    {
        [self.delegate groupAccessFlowController:self groupsDidSelected:groupArray];
    }
    
    [singleLayerGroupViewController goBackAnimated:YES];
}


//==============================================================================
//
//==============================================================================
- (void)didFinishSingleGroupGroupViewController:(WCSingleLayerGroupViewController *)singleLayerGroupViewController
{
    if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:didFinishViewController:)])
    {
        [self.delegate groupAccessFlowController:self didFinishViewController:singleLayerGroupViewController];
    }
    self.userInfo = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCGroupTreeViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (NSString *)groupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController requestErrorMessageForError:(NSError *)error
{
    if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:requestErrorMessageForError:)])
    {
        return [self.delegate groupAccessFlowController:self requestErrorMessageForError:error];
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSArray *)groupsWithWCGroupTreeViewController:(WCGroupTreeViewController *)groupViewController error:(NSError **)error
{
    if ([self.delegate respondsToSelector:@selector(sourceGroupArrayForGroupAccessFlowController:error:)])
    {
        NSMutableArray *sourceGroup = [self.delegate sourceGroupArrayForGroupAccessFlowController:self error:error];
        
        for (WCGroupModel *groupModel in [[sourceGroup firstObject] subGroups])
        {
            if(groupModel.ID==WC_GID_Unfiled)
            {
                [[[sourceGroup firstObject] subGroups] removeObject:groupModel];
                break;
            }
        }
        return sourceGroup;
    }
    
    return nil;
}

#pragma mark - for groupTreeViewController add


//==============================================================================
//
//==============================================================================
- (BOOL)groupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController isExistGroupNamed:(NSString*)groupNamed
{
    if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:requestIsExistGroupNamed:)])
    {
        return [self.delegate groupAccessFlowController:self requestIsExistGroupNamed:groupNamed];
    }
    
    return YES;
}


//==============================================================================
//
//==============================================================================
- (WCGroupModel *)groupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController groupModelByNewGroupName:(NSString *)groupName superGroupGuid:(NSString *)superGroupGuid error:(NSError **)error
{
    if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:requestGroupModelByNewGroupName:superGroupGuid:error:)])
    {
        return [self.delegate groupAccessFlowController:self requestGroupModelByNewGroupName:groupName superGroupGuid:superGroupGuid error:error];
    }
    
    return nil;
}


#pragma mark - for groupTreeViewController edit style


//==============================================================================
//
//==============================================================================
- (NSError *)groupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController updateGroupModel:(WCGroupModel *)groupModel;
{
    if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:updateGroupModel:)])
    {
        return [self.delegate groupAccessFlowController:self updateGroupModel:groupModel];
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSError *)groupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController deleteGroupModel:(WCGroupModel *)groupModel
{
    if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:deleteGroupModel:)])
    {
        return [self.delegate groupAccessFlowController:self deleteGroupModel:groupModel];
    }
    return nil;
}

#pragma mark - for groupTreeViewController move

//==============================================================================
//
//==============================================================================
- (NSArray *)validParentsForMoveGroupModel:(WCGroupModel *)groupModel withGroupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController error:(NSError **)error
{
    if ([self.delegate respondsToSelector:@selector(validParentsForMoveGroupModel:withGroupAccessFlowController:error:)])
    {
        return [self.delegate validParentsForMoveGroupModel:groupModel withGroupAccessFlowController:self error:error];
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSError *)groupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController moveGroupModel:(WCGroupModel *)groupModel toParentGuid:(NSString *)parentGuid
{
    if ([self.delegate respondsToSelector:@selector(groupAccessFlowController:moveGroupModel:toParentGuid:)])
    {
        return [self.delegate groupAccessFlowController:self moveGroupModel:groupModel toParentGuid:parentGuid];
    }
    return nil;
}








////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - class methods


//==============================================================================
//
//==============================================================================
+ (instancetype)sharedInstance
{
    static WCGroupAccessFlowController *staticGroupFlowController = nil;
    
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        staticGroupFlowController = [[WCGroupAccessFlowController alloc] init];
    });
    
    return staticGroupFlowController;
}

@end
