//
//  WCMultiLayerGroupPickerViewController.m
//  ADAL
//
//  Created by sanhue on 2018/3/8.
//

#import "WCMultiLayerGroupPickerViewController.h"

// define
#import "WCAppearanceDefine.h"

//category
#import "PPButton+Factory.h"
#import "UIViewController+Additions.h"
#import "NSObject+PPBusyView.h"


// view
#import "PPNavigationBarView.h"

// controller
#import "PPNavigationController.h"



////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSInteger, WCMLGPVC_ButtonTag)
{
    WCMLGPVC_ButtonTag_Back = 0,
    WCMLGPVC_ButtonTag_Done,
};


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCMultiLayerGroupPickerViewController () <PPButtonDelegate, WCGroupTreeViewControllerDelegate>

@property (nonatomic, copy) WCMLGroupPickerRequestSourceHandler requestSourceGroupHandler;
@property (nonatomic, copy) WCMLGroupPickerRequestSourceHandler requestSelectedGroupHandler;
@property (nonatomic, copy) WCMLGroupPickerRequestErrorMessageHandler requestErrorMessageHandler;
@property (nonatomic, copy) WCMLGroupPickerSelectionHandler selectionHandler;
@property (nonatomic, copy) WCMLGroupPickerFinishHandler finishHandler;

@property (nonatomic, retain) PPNavigationBarView *navigationBarView;
@property (nonatomic, retain) PPButton *ppButtonBack;
@property (nonatomic, retain) PPButton *ppButtonDone;

@property (nonatomic, retain) NSArray *inputDatas;
@property (nonatomic, assign) BOOL multiSelection;
@property (nonatomic, assign) BOOL showPinButton;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCMultiLayerGroupPickerViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.delegate = self;
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.requestSourceGroupHandler = nil;
    self.requestSelectedGroupHandler = nil;
    self.requestErrorMessageHandler = nil;
    self.selectionHandler = nil;
    self.finishHandler = nil;

    self.inputDatas = nil;
    
    
    [self removeMainUI];

    //////////////////////////////////////////////////
    [super dealloc];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    [self prepareMainUI];
    
    // setting groupView
    [self.groupView setStyle:self.multiSelection?WCGroupViewStyle_NameWithCheckBox:(self.showPinButton?WCGroupViewStyle_NameWithPin:WCGroupViewStyle_Name)];

}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    if (_navigationBarView==nil)
    {
        _navigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    }
    
    if (self.navigationBarView!=nil)
    {
        self.navigationBarView.style = PPBarViewStyle_CenteredAbsolute;
        self.navigationBarView.titleLabel.text = self.titleString;
        
        self.ppButtonBack = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                            tag:WCMLGPVC_ButtonTag_Back
                                                       delegate:self
                                          normalBackgroundColor:nil
                                     highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
        if(self.ppButtonBack!=nil)
        {
            //////////////////////////////////////////////////
            
            [self.navigationBarView setViews:@[self.ppButtonBack] forBlockType:PPBarViewBlockType_Left];
        }
        
        NSMutableArray *rightButtons = [NSMutableArray array];
        
        //////////////////////////////////////////////////
        self.ppButtonDone = [PPButton ppButtonWithIconImageName:@"GroupDone"
                                                           tag:WCMLGPVC_ButtonTag_Done
                                                      delegate:self
                                         normalBackgroundColor:nil
                                    highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                               imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
        //        self.ppButtonAdd.ppGuideIndex = WCGroupViewControllerGuideIndex_Add;
        [rightButtons addObject:self.ppButtonDone];
        
        if([rightButtons count]>0)
        {
            [self.navigationBarView setViews:rightButtons forBlockType:PPBarViewBlockType_Right];
        }
        
        self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.navigationBarView] autorelease];
    }
    
}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    
    self.ppButtonBack.delegate = nil;
    self.ppButtonBack = nil;
    
    self.ppButtonDone.delegate = nil;
    self.ppButtonDone = nil;
    
    self.navigationBarView = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - override


//==============================================================================
//
//==============================================================================
-(void)setDelegate:(id<WCGroupTreeViewControllerDelegate>)delegate
{
    [super setDelegate:self];
}


//==============================================================================
//
//==============================================================================
- (void)setBusy:(NSNumber *)busy
{
    [super setBusy:busy];
    
    [self.busyView setStyle:PPBusyViewStyle_Border];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCMLGPVC_ButtonTag_Done:
        {
            __block typeof(self) blockSelf = self;
            [blockSelf setBusy:@(YES)];

            dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                
                NSArray *selectedItems = nil;
                selectedItems = [blockSelf.groupView copySelectedItems];

                if (self.selectionHandler)
                {
                    self.selectionHandler(selectedItems);
                }
                [selectedItems release];
                //////////////////////////////////////////////////
                dispatch_async(dispatch_get_main_queue(), ^{
                    [blockSelf setBusy:@(NO)];

                    if (blockSelf.finishHandler)
                    {
                        blockSelf.finishHandler(blockSelf);
                    }
                    else
                    {
                        [blockSelf goBackAnimated:YES];
                    }
                });
            });

            break;
        }
        case WCMLGPVC_ButtonTag_Back:
        default:
        {
            [self goBackAnimated:YES];
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCGroupTreeViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (NSString *)groupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController requestErrorMessageForError:(NSError *)error
{
    if (self.requestErrorMessageHandler)
    {
        return self.requestErrorMessageHandler(error);
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSArray *)groupsWithWCGroupTreeViewController:(WCGroupTreeViewController *)groupViewController error:(NSError **)error
{
    if (self.requestSourceGroupHandler)
    {
        return self.requestSourceGroupHandler(error);
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSArray *)selectedGroupsWithWCGroupTreeViewController:(WCGroupTreeViewController *)groupTreeViewController error:(NSError **)error
{
    if (self.requestSelectedGroupHandler)
    {
        return self.requestSelectedGroupHandler(error);
    }
    return nil;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - class methods


//==============================================================================
//
//==============================================================================
+ (void)showMultiLayerGroupPickerViewConrollerFromViewController:(UIViewController *)viewController
                                                     titleString:(NSString *)titleString
                                                  multiSelection:(BOOL)multiSelection
                                              exclusiveWithOther:(BOOL)exclusiveWithOther
                                                    forcePresent:(BOOL)forcePresent
                                       requestSourceGroupHandler:(WCMLGroupPickerRequestSourceHandler)requestSourceGroupHandler
                                     requestSelectedGroupHandler:(WCMLGroupPickerRequestSourceHandler)requestSelectedGroupHandler
                                                selectionHandler:(WCMLGroupPickerSelectionHandler)selectionHandler;
{
    [[self class] showMultiLayerGroupPickerViewConrollerFromViewController:viewController
                                                               titleString:titleString
                                                            multiSelection:multiSelection
                                                             showPinButton:YES
                                                                 enablePin:YES
                                                     checkWhileNoSelection:YES
                                                        exclusiveWithOther:exclusiveWithOther
                                                              forcePresent:forcePresent
                                                 requestSourceGroupHandler:requestSourceGroupHandler
                                               requestSelectedGroupHandler:requestSelectedGroupHandler
                                                requestErrorMessageHandler:nil
                                                          selectionHandler:selectionHandler
                                                             finishHandler:nil];
}
//==============================================================================
//
//==============================================================================
+ (void)showMultiLayerGroupPickerViewConrollerFromViewController:(UIViewController *)viewController
                                                     titleString:(NSString *)titleString
                                                  multiSelection:(BOOL)multiSelection
                                           checkWhileNoSelection:(BOOL)checkWhileNoSelection
                                              exclusiveWithOther:(BOOL)exclusiveWithOther
                                                    forcePresent:(BOOL)forcePresent
                                       requestSourceGroupHandler:(WCMLGroupPickerRequestSourceHandler)requestSourceGroupHandler
                                     requestSelectedGroupHandler:(WCMLGroupPickerRequestSourceHandler)requestSelectedGroupHandler
                                                selectionHandler:(WCMLGroupPickerSelectionHandler)selectionHandler;
{
    [[self class] showMultiLayerGroupPickerViewConrollerFromViewController:viewController
                                                               titleString:titleString
                                                            multiSelection:multiSelection
                                                             showPinButton:YES
                                                                 enablePin:YES
                                                     checkWhileNoSelection:checkWhileNoSelection
                                                        exclusiveWithOther:exclusiveWithOther
                                                              forcePresent:forcePresent
                                                 requestSourceGroupHandler:requestSourceGroupHandler
                                               requestSelectedGroupHandler:requestSelectedGroupHandler
                                                requestErrorMessageHandler:nil
                                                          selectionHandler:selectionHandler
                                                             finishHandler:nil];
}


//==============================================================================
//
//==============================================================================
+ (void)showMultiLayerGroupPickerViewConrollerFromViewController:(UIViewController *)viewController
                                                     titleString:(NSString *)titleString
                                                  multiSelection:(BOOL)multiSelection
                                                   showPinButton:(BOOL)showPinButton
                                                       enablePin:(BOOL)enablePin
                                           checkWhileNoSelection:(BOOL)checkWhileNoSelection
                                              exclusiveWithOther:(BOOL)exclusiveWithOther
                                                    forcePresent:(BOOL)forcePresent
                                       requestSourceGroupHandler:(WCMLGroupPickerRequestSourceHandler)requestSourceGroupHandler
                                     requestSelectedGroupHandler:(WCMLGroupPickerRequestSourceHandler)requestSelectedGroupHandler
                                      requestErrorMessageHandler:(WCMLGroupPickerRequestErrorMessageHandler)requestErrorMessageHandler
                                                selectionHandler:(WCMLGroupPickerSelectionHandler)selectionHandler
                                                   finishHandler:(WCMLGroupPickerFinishHandler)finishHandler;
{
    WCMultiLayerGroupPickerViewController *addGroupViewController = [[WCMultiLayerGroupPickerViewController alloc] init];
    addGroupViewController.requestSourceGroupHandler = requestSourceGroupHandler;
    addGroupViewController.requestSelectedGroupHandler = requestSelectedGroupHandler;
    addGroupViewController.requestErrorMessageHandler = requestErrorMessageHandler;
    addGroupViewController.selectionHandler = selectionHandler;
    addGroupViewController.finishHandler = finishHandler;
    addGroupViewController.multiSelection = multiSelection;
    addGroupViewController.titleString = titleString;
    addGroupViewController.checkWhileNoSelection = checkWhileNoSelection;
    addGroupViewController.exclusiveWithOther = exclusiveWithOther;
    addGroupViewController.showPinButton = showPinButton;
    addGroupViewController.enablePin = enablePin;
    
    // 單選時預設選取一個
    addGroupViewController.activeCellByDefault = (multiSelection==NO);
    
    if (forcePresent||viewController.navigationController==nil)
    {
        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:addGroupViewController];
        [viewController presentViewController:navigationController animated:YES completion:nil];
        [navigationController release];
    }
    else
    {
        [viewController.navigationController pushViewController:addGroupViewController animated:YES];
    }
    [addGroupViewController release];
}


@end
