//
//  WCFieldTypeConverter.m
//
//
//  Created by sanhue on 2014/10/16.
//
//

#import "WCFieldTypeConverter.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCFieldTypeConverter

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - type from PPContactViewController

//==============================================================================
// 轉換為WC_FieldSource
//==============================================================================
+ (WC_FieldSource)fieldSourceFromPPContactFieldSource:(PPContactFieldSource)fieldSource
{
    switch (fieldSource)
    {
        case PPContactFieldSource_FrontSide:
            return WC_FS_FrontRecog;
        case PPContactFieldSource_BackSide:
            return WC_FS_BackRecog;
        case PPContactFieldSource_UserCreate:
        case PPContactFieldSource_None:
        default:
            return WC_FS_UserCreate;
    }
}


//===============================================================================
// 轉換為WC_FieldType
//===============================================================================
+ (WC_FieldType)fieldTypeFromPPContactMainType:(PPContactMainType)type
{
    WC_FieldType resultType=WC_FT_None;
    
    switch (type) {
        case PPContactMainType_Name:
        {
            resultType=WC_FT_Name;
            break;
        }
        case PPContactMainType_Company:
        {
            resultType=WC_FT_Company;
            break;
        }
        case PPContactMainType_Address:
        {
            resultType=WC_FT_Address;
            break;
        }
        case PPContactMainType_Phone:
        {
            resultType=WC_FT_Phone;
            break;
        }
        case PPContactMainType_Email:
        {
            resultType=WC_FT_Email;
            break;
        }
        case PPContactMainType_URL:
        {
            resultType=WC_FT_URL;
            break;
        }
        case PPContactMainType_InstantMessage:
        {
            resultType=WC_FT_InstantMessage;
            break;
        }
        case PPContactMainType_SocialNetwork:
        {
            resultType=WC_FT_SocialNetwork;
            break;
        }
        case PPContactMainType_Date:
        {
            resultType=WC_FT_Date;
            break;
        }
        case PPContactMainType_UnifiedBusinessNumber:
        {
            resultType=WC_FT_UnifiedBusinessNo;
            break;
        }
        case PPContactMainType_BirthDay:
        {
            resultType=WC_FT_Date;
            break;
        }
        case PPContactMainType_NickName:
        {
            resultType=WC_FT_Nickname;
            break;
        }
        case PPContactMainType_Note:
        {
            resultType=WC_FT_Note;
            break;
        }
        case PPContactMainType_Group:
        {
            resultType=EditCustomGroupType;
            break;
        }
        case PPContactMainType_UserDefine:
        {
            resultType=WC_FT_UserDefine;
            break;
        }
        case PPContactMainType_Status:
        {
            resultType=WC_FT_SalesforceData;
            break;
        }
        case PPContactMainType_PublicNote:
        default:
            break;
    }
    return resultType;
}


//==============================================================================
// 轉換 WC_FieldSubType1
//==============================================================================
+ (WC_FieldSubType1)fieldSubType1FromPPContactLabelType:(PPContactLabelType)type
{
    switch (type)
    {
        case PPContactLabelType_Address_Work:
        {
            return WC_FST1_Address_Work;
        }
        case PPContactLabelType_Address_Home:
        {
            return WC_FST1_Address_Home;
        }
        case PPContactLabelType_Address_Other:
        {
            return WC_FST1_Address_Other;
        }
            
            
        case PPContactLabelType_Phone_Work:
        {
            return WC_FST1_Phone_Work;
        }
        case PPContactLabelType_Phone_Home:
        {
            return WC_FST1_Phone_Home;
        }
        case PPContactLabelType_Phone_Mobile:
        {
            return WC_FST1_Phone_Mobile;
        }
        case PPContactLabelType_Phone_Main:
        {
            return WC_FST1_Phone_Mobile;
        }
        case PPContactLabelType_Phone_iPhone:
        {
            return WC_FST1_Phone_iPhone;
        }
        case PPContactLabelType_Phone_WorkFax:
        {
            return WC_FST1_Phone_WorkFax;
        }
        case PPContactLabelType_Phone_HomeFax:
        {
            return WC_FST1_Phone_HomeFax;
        }
        case PPContactLabelType_Phone_Pager:
        {
            return WC_FST1_Phone_Pager;
        }
        case PPContactLabelType_Phone_GoogleVoice:
        {
            return WC_FST1_Phone_GoogleVoice;
        }
        case PPContactLabelType_Phone_Other:
        {
            return WC_FST1_Phone_Other;
        }
            
            
        case PPContactLabelType_Email_Work:
        {
            return WC_FST1_Email_Work;
        }
        case PPContactLabelType_Email_Home:
        {
            return WC_FST1_Email_Home;
        }
        case PPContactLabelType_Email_Other:
        {
            return WC_FST1_Email_Other;
        }
            
            
        case PPContactLabelType_URL_HomePage:
        {
            return WC_FST1_URL_HomePage;
        }
        case PPContactLabelType_URL_Work:
        {
            return WC_FST1_URL_Work;
        }
        case PPContactLabelType_URL_Home:
        {
            return WC_FST1_URL_Home;
        }
        case PPContactLabelType_URL_Profile:
        {
            return WC_FST1_URL_Profile;
        }
        case PPContactLabelType_URL_Blog:
        {
            return WC_FST1_URL_Blog;
        }
        case PPContactLabelType_URL_Other:
        {
            return WC_FST1_URL_Other;
        }
            
            
        case PPContactLabelType_InstantMessage_MSN:
        {
            return WC_FST1_IM_MSN;
        }
        case PPContactLabelType_InstantMessage_Skype:
        {
            return WC_FST1_IM_Skype;
        }
        case PPContactLabelType_InstantMessage_QQ:
        {
            return WC_FST1_IM_QQ;
        }
        case PPContactLabelType_InstantMessage_Yahoo:
        {
            return WC_FST1_IM_Yahoo;
        }
        case PPContactLabelType_InstantMessage_ICQ:
        {
            return WC_FST1_IM_ICQ;
        }
        case PPContactLabelType_InstantMessage_GoogleTalk:
        {
            return WC_FST1_IM_GoogleTalk;
        }
        case PPContactLabelType_InstantMessage_Jabber:
        {
            return WC_FST1_IM_Jabber;
        }
        case PPContactLabelType_InstantMessage_AIM:
        {
            return WC_FST1_IM_AIM;
        }
        case PPContactLabelType_InstantMessage_Other:
        {
            return WC_FST1_IM_Other;
        }
        case PPContactLabelType_InstantMessage_GaduGadu:
        {
            return WC_FST1_IM_GaduGadu;
        }
            
            
        case PPContactLabelType_Date_Anniversary:
        {
            return WC_FST1_Date_Anniversary;
        }
        case PPContactLabelType_Date_Other:
        {
            return WC_FST1_Date_Other;
        }
            
        case PPContactLabelType_SN_Twitter:
        {
            return WC_FST1_SN_Twitter;
        }
        case PPContactLabelType_SN_Facebook:
        {
            return WC_FST1_SN_Facebook;
        }
        case PPContactLabelType_SN_Flicker:
        {
            return WC_FST1_SN_Flicker;
        }
        case PPContactLabelType_SN_LinkedIn:
        {
            return WC_FST1_SN_LinkedIn;
        }
        case PPContactLabelType_SN_MySpace:
        {
            return WC_FST1_SN_MySpace;
        }
        case PPContactLabelType_SN_SinaWebo:
        {
            return WC_FST1_SN_SinaWebo;
        }
        case PPContactLabelType_SN_Other:
        {
            return WC_FST1_SN_Other;
        }

            
        case PPContactLabelType_Status_Status:
        {
            return WC_FST1_SFData_Status;
        }
        case PPContactLabelType_Status_LeadSource:
        {
            return WC_FST1_SFData_LeadSource;
        }
        case PPContactLabelType_Status_Industry:
        {
            return WC_FST1_SFData_Industry;
        }
        case PPContactLabelType_Status_Rating:
        {
            return WC_FST1_SFData_Rating;
        }

        default:
            return WC_FST1_None;
    }
}


//===============================================================================
// 轉換 WC_FieldSubType1
//===============================================================================
+ (WC_FieldSubType1)fieldSubType1WithPPContactLabelTextString:(NSString *)subTypeString mainType:(PPContactMainType)type
{
    WC_FieldSubType1 result = WC_FST1_None;
    
    switch (type)
    {
        case PPContactMainType_Address:
        {
            if([subTypeString isEqualToString:PPContactLabelText_Address_Home])
            {
                result = WC_FST1_Address_Home;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_Address_Work])
            {
                result = WC_FST1_Address_Work;
            }
            else
            {
                result = WC_FST1_Address_Other;
            }
            
            break;
        }
        case PPContactMainType_Phone:
        {
            if([subTypeString isEqualToString:PPContactLabelText_Phone_Work])
            {
                result = WC_FST1_Phone_Work;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_Phone_Home])
            {
                result = WC_FST1_Phone_Home;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_Phone_Mobile])
            {
                result = WC_FST1_Phone_Mobile;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_Phone_WorkFax])
            {
                result = WC_FST1_Phone_WorkFax;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_Phone_HomeFax])
            {
                result = WC_FST1_Phone_HomeFax;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_Phone_Pager])
            {
                result = WC_FST1_Phone_Pager;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_Phone_GoogleVoice])
            {
                result = WC_FST1_Phone_GoogleVoice;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_Phone_iPhone])
            {
                result = WC_FST1_Phone_iPhone;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_Phone_Main])
            {
                result = WC_FST1_Phone_Main;
            }
            else
            {
                result = WC_FST1_Phone_Other;
            }
            
            break;
        }
        case PPContactMainType_Email:
        {
            if([subTypeString isEqualToString:PPContactLabelText_Email_Work])
            {
                result = WC_FST1_Email_Work;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_Email_Home])
            {
                result = WC_FST1_Email_Home;
            }
            else
            {
                result = WC_FST1_Email_Other;
            }
            
            break;
        }
        case PPContactMainType_URL:
        {
            if([subTypeString isEqualToString:PPContactLabelText_URL_HomePage])
            {
                result = WC_FST1_URL_HomePage;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_URL_Home])
            {
                result = WC_FST1_URL_Home;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_URL_Work])
            {
                result = WC_FST1_URL_Work;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_URL_Profile])
            {
                result = WC_FST1_URL_Profile;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_URL_Blog])
            {
                result = WC_FST1_URL_Blog;
            }
            else
            {
                result = WC_FST1_URL_Other;
            }
            
            
            break;
        }
        case PPContactMainType_InstantMessage:
        {
            
            if([subTypeString isEqualToString:PPContactLabelText_InstantMessage_MSN])
            {
                result = WC_FST1_IM_MSN;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_InstantMessage_Skype])
            {
                result = WC_FST1_IM_Skype;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_InstantMessage_QQ])
            {
                result = WC_FST1_IM_QQ;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_InstantMessage_Yahoo])
            {
                result = WC_FST1_IM_Yahoo;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_InstantMessage_ICQ])
            {
                result = WC_FST1_IM_ICQ;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_InstantMessage_GoogleTalk])
            {
                result = WC_FST1_IM_GoogleTalk;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_InstantMessage_Jabber])
            {
                result = WC_FST1_IM_Jabber;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_InstantMessage_AIM])
            {
                result = WC_FST1_IM_AIM;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_InstantMessage_GaduGadu])
            {
                result = WC_FST1_IM_GaduGadu;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_InstantMessage_Other])
            {
                result = WC_FST1_IM_Other;
            }
            else
            {
                result = WC_FST1_IM_MSN;
            }
            
            break;
        }
        case PPContactMainType_SocialNetwork:
        {
            if([subTypeString isEqualToString:PPContactLabelText_SN_Facebook])
            {
                result = WC_FST1_SN_Facebook;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_SN_Twitter])
            {
                result = WC_FST1_SN_Twitter;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_SN_LinkedIn])
            {
                result = WC_FST1_SN_LinkedIn;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_SN_Flicker])
            {
                result = WC_FST1_SN_Flicker;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_SN_MySpace])
            {
                result = WC_FST1_SN_MySpace;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_SN_SinaWebo])
            {
                result = WC_FST1_SN_SinaWebo;
            }
            else
            {
                result = WC_FST1_SN_Other;
            }
            
            break;
        }
        case PPContactMainType_Date:
        {
            if([subTypeString isEqualToString:PPContactLabelText_Date_Anniversary])
            {
                result = WC_FST1_Date_Anniversary;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_BirthDay])
            {
                result = WC_FST1_Date_Birthday;
            }
            else
            {
                result = WC_FST1_Date_Other;
            }
            
            break;
        }
        case PPContactMainType_BirthDay:
        {
            if([subTypeString isEqualToString:PPContactLabelText_BirthDay])
            {
                result = WC_FST1_Date_Birthday;
            }
            else
            {
                result = WC_FST1_Date_Other;
            }
            
            break;
        }
        case PPContactMainType_Status:
        {
            if([subTypeString isEqualToString:PPContactLabelText_LeadSource])
            {
                result = WC_FST1_SFData_LeadSource;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_Industry])
            {
                result = WC_FST1_SFData_Industry;
            }
            else if([subTypeString isEqualToString:PPContactLabelText_Rating])
            {
                result = WC_FST1_SFData_Rating;
            }
            else
            {
                result = WC_FST1_SFData_Status;
            }
        }
        default:
            break;
    }
    
    return result;
}


//==============================================================================
// 轉化為WC_FieldSubType2
//==============================================================================
+ (WC_FieldSubType2)fieldSubType2FromPPContactSubType:(PPContactSubType)subType
{
    WC_FieldSubType2 wcFieldSubType = WC_FST2_None;
    switch (subType)
    {
            //////////////////////////////////////////////////
            // name subtype
        case PPContactSubType_Name_FirstName:
        {
            wcFieldSubType=WC_FST2_Name_First;
            break;
        }
        case PPContactSubType_Name_FirstNamePhonetic:
        {
            wcFieldSubType=WC_FST2_Name_FirstPhonetic;
            break;
        }
        case PPContactSubType_Name_MiddleName:
        {
            wcFieldSubType=WC_FST2_Name_Middle;
            break;
        }
        case PPContactSubType_Name_LastName:
        {
            wcFieldSubType=WC_FST2_Name_Last;
            break;
        }
        case PPContactSubType_Name_LastNamePhonetic:
        {
            wcFieldSubType=WC_FST2_Name_LastPhonetic;
            break;
        }
        case PPContactSubType_Name_Prefix:
        {
            wcFieldSubType=WC_FST2_Name_Prefix;
            break;
        }
        case PPContactSubType_Name_Surffix:
        {
            wcFieldSubType=WC_FST2_Name_Suffix;
            break;
        }
            //////////////////////////////////////////////////
            // company subtype
        case PPContactSubType_Company_Name:
        {
            wcFieldSubType=WC_FST2_Company_Name;
            break;
        }
        case PPContactSubType_Company_NamePhonetic:
        {
            wcFieldSubType=WC_FST2_Company_Phonetic;
            break;
        }
        case PPContactSubType_Company_Department:
        {
            wcFieldSubType=WC_FST2_Company_Department;
            break;
        }
        case PPContactSubType_Company_JobTitle:
        {
            wcFieldSubType=WC_FST2_Company_JobTitle;
            break;
        }
            
            //////////////////////////////////////////////////
            // address subtype
        case PPContactSubType_Address_Street:
        {
            wcFieldSubType=WC_FST2_Address_Street;
            break;
        }
        case PPContactSubType_Address_City:
        {
            wcFieldSubType=WC_FST2_Address_City;
            break;
        }
        case PPContactSubType_Address_State:
        {
            wcFieldSubType=WC_FST2_Address_State;
            break;
        }
        case PPContactSubType_Address_Zip:
        {
            wcFieldSubType=WC_FST2_Address_ZIP;
            break;
        }
        case PPContactSubType_Address_Country:
        {
            wcFieldSubType=WC_FST2_Address_Country;
            break;
        }
        case PPContactSubType_Address_CountryCode:
        {
            wcFieldSubType=WC_FST2_Address_CountryCode;
            break;
        }
        case PPContactSubType_Address_GPS:
        {
            wcFieldSubType=WC_FST2_Address_Location;
            break;
        }
        default:
        {
            break;
        }
    }
    return wcFieldSubType;
}



//==============================================================================
//
//==============================================================================
+ (WC_ImageType)imageTypeFromPPContactMainType:(PPContactMainType)type
{
    WC_ImageType imageType = WC_IT_None;
    switch (type)
    {
        case PPContactMainType_HeadImage:
        {
            imageType = WC_IT_IDPhoto;
            break;
        }
        case PPContactMainType_FrontCardImage:
        {
            imageType = WC_IT_FrontSide;
            break;
        }
        case PPContactMainType_BackCardImage:
        {
            imageType = WC_IT_BackSide;
           break;
        }
        default:
        {
            break;
        }
    }
    
    return imageType;
}


//==============================================================================
//
//==============================================================================
+ (WC_FieldSubType2)fieldSubType2FromPPContactLabelType:(PPContactLabelType)type
{
    WC_FieldSubType2 subType2 = WC_FST2_None;
    switch (type)
    {
        case PPContactLabelType_Company_Name:
        {
            subType2 = WC_FST2_Company_Name;
            break;
        }
        case PPContactLabelType_Company_Department:
        {
            subType2 = WC_FST2_Company_Department;
            break;
        }
        case PPContactLabelType_Company_JobTitle:
        {
            subType2 = WC_FST2_Company_JobTitle;
            break;
        }
        default:
            break;
    }
    
    return subType2;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark -  PPContactViewController type from WCFieldType


//==============================================================================
//
//==============================================================================
+ (PPContactFieldSource)contactFieldSourceFromFieldSource:(WC_FieldSource)fieldSource
{
    PPContactFieldSource contactFieldSource = PPContactFieldSource_UserCreate;
    switch (fieldSource)
    {
        case WC_FS_FrontRecog:
        {
            contactFieldSource = PPContactFieldSource_FrontSide;
            break;
        }
        case WC_FS_BackRecog:
        {
            contactFieldSource = PPContactFieldSource_BackSide;
            break;
        }
        case WC_FS_UserCreate:
        default:
        {
            // 不認得的都當成user create
            break;
        }
    }
    return contactFieldSource;
}


//==============================================================================
//
//==============================================================================
+ (PPContactMainType)contactMainTypeFromFieldType:(WC_FieldType)fieldType dateAsBirthday:(BOOL)dateAsBirthday
{
    PPContactMainType mainType = PPContactMainType_None;
    switch (fieldType)
    {
        case WC_FT_Name:
        {
            mainType = PPContactMainType_Name;
            break;
        }
        case WC_FT_Company:
        {
            mainType = PPContactMainType_Company;
            break;
        }
        case WC_FT_Address:
        {
            mainType = PPContactMainType_Address;
            break;
        }
        case WC_FT_Phone:
        {
            mainType = PPContactMainType_Phone;
            break;
        }
        case WC_FT_Email:
        {
            mainType = PPContactMainType_Email;
            break;
        }
        case WC_FT_URL:
        {
            mainType = PPContactMainType_URL;
            break;
        }
        case WC_FT_InstantMessage:
        {
            mainType = PPContactMainType_InstantMessage;
            break;
        }
        case WC_FT_Date:
        {
            if (dateAsBirthday)
            {
                mainType = PPContactMainType_BirthDay;
            }
            else
            {
                mainType = PPContactMainType_Date;
            }
            break;
        }
        case WC_FT_Note:
        {
            mainType = PPContactMainType_Note;
            break;
        }
        case WC_FT_Nickname:
        {
            mainType = PPContactMainType_NickName;
            break;
        }
        case WC_FT_UnifiedBusinessNo:
        {
            mainType = PPContactMainType_UnifiedBusinessNumber;
            break;
        }
        default:
            break;
    }
    return mainType;
}


//==============================================================================
//
//==============================================================================
+ (PPContactLabelType)contactLabelTypeFromFieldSubType1:(WC_FieldSubType1)fieldSubType1
{
    PPContactLabelType contactLabelType = PPContactLabelType_None;
    switch (fieldSubType1)
    {
        //////////////////////////////////////////////////
        // address
        case WC_FST1_Address_Work:
        {
            contactLabelType = PPContactLabelType_Address_Work;
            break;
        }
        case WC_FST1_Address_Home:
        {
            contactLabelType = PPContactLabelType_Address_Home;
            break;
        }
        case WC_FST1_Address_Other:
        {
            contactLabelType = PPContactLabelType_Address_Other;
            break;
        }
        //////////////////////////////////////////////////
        // phone
        case WC_FST1_Phone_Work:
        {
            contactLabelType = PPContactLabelType_Phone_Work;
            break;
        }
        case WC_FST1_Phone_Home:
        {
            contactLabelType = PPContactLabelType_Phone_Home;
            break;
        }
        case WC_FST1_Phone_Mobile:
        {
            contactLabelType = PPContactLabelType_Phone_Mobile;
            break;
        }
        case WC_FST1_Phone_Main:
        {
            contactLabelType = PPContactLabelType_Phone_Main;
            break;
        }
        case WC_FST1_Phone_WorkFax:
        {
            contactLabelType = PPContactLabelType_Phone_WorkFax;
            break;
        }
        case WC_FST1_Phone_HomeFax:
        {
            contactLabelType = PPContactLabelType_Phone_HomeFax;
            break;
        }
        case WC_FST1_Phone_Pager:
        {
            contactLabelType = PPContactLabelType_Phone_Pager;
            break;
        }
        case WC_FST1_Phone_GoogleVoice:
        {
            contactLabelType = PPContactLabelType_Phone_GoogleVoice;
            break;
        }
        case WC_FST1_Phone_iPhone:
        {
            contactLabelType = PPContactLabelType_Phone_iPhone;
            break;
        }
        case WC_FST1_Phone_Other:
        {
            contactLabelType = PPContactLabelType_Phone_Other;
            break;
        }
        //////////////////////////////////////////////////
        // email
        case WC_FST1_Email_Work:
        {
            contactLabelType = PPContactLabelType_Email_Work;
            break;
        }
        case WC_FST1_Email_Home:
        {
            contactLabelType = PPContactLabelType_Email_Home;
            break;
        }
        case WC_FST1_Email_Other:
        {
            contactLabelType = PPContactLabelType_Email_Other;
            break;
        }
            
        //////////////////////////////////////////////////
        // url
        case WC_FST1_URL_HomePage:
        {
            contactLabelType = PPContactLabelType_URL_HomePage;
            break;
        }
        case WC_FST1_URL_Work:
        {
            contactLabelType = PPContactLabelType_URL_Work;
            break;
        }
        case WC_FST1_URL_Home:
        {
            contactLabelType = PPContactLabelType_URL_Home;
            break;
        }
        case WC_FST1_URL_Profile:
        {
            contactLabelType = PPContactLabelType_URL_Profile;
            break;
        }
        case WC_FST1_URL_Blog:
        {
            contactLabelType = PPContactLabelType_URL_Blog;
            break;
        }
        case WC_FST1_URL_Other:
        {
            contactLabelType = PPContactLabelType_URL_Other;
            break;
        }
        //////////////////////////////////////////////////
        // im
        case WC_FST1_IM_MSN:
        {
            contactLabelType = PPContactLabelType_InstantMessage_MSN;
            break;
        }
        case WC_FST1_IM_Skype:
        {
            contactLabelType = PPContactLabelType_InstantMessage_Skype;
            break;
        }
        case WC_FST1_IM_QQ:
        {
            contactLabelType = PPContactLabelType_InstantMessage_QQ;
            break;
        }
        case WC_FST1_IM_Yahoo:
        {
            contactLabelType = PPContactLabelType_InstantMessage_Yahoo;
            break;
        }
        case WC_FST1_IM_ICQ:
        {
            contactLabelType = PPContactLabelType_InstantMessage_ICQ;
            break;
        }
        case WC_FST1_IM_GoogleTalk:
        {
            contactLabelType = PPContactLabelType_InstantMessage_GoogleTalk;
            break;
        }
        case WC_FST1_IM_Jabber:
        {
            contactLabelType = PPContactLabelType_InstantMessage_Jabber;
            break;
        }
        case WC_FST1_IM_AIM:
        {
            contactLabelType = PPContactLabelType_InstantMessage_AIM;
            break;
        }
        case WC_FST1_IM_Other:
        {
            contactLabelType = PPContactLabelType_InstantMessage_Other;
            break;
        }
        //////////////////////////////////////////////////
        // Social network
        case WC_FST1_SN_Facebook:
        {
            contactLabelType = PPContactLabelType_SN_Facebook;
            break;
        }
        case WC_FST1_SN_Flicker:
        {
            contactLabelType = PPContactLabelType_SN_Flicker;
            break;
        }
        case WC_FST1_SN_LinkedIn:
        {
            contactLabelType = PPContactLabelType_SN_LinkedIn;
            break;
        }
        case WC_FST1_SN_MySpace:
        {
            contactLabelType = PPContactLabelType_SN_MySpace;
            break;
        }
        case WC_FST1_SN_Twitter:
        {
            contactLabelType = PPContactLabelType_SN_Twitter;
            break;
        }
        case WC_FST1_SN_SinaWebo:
        {
            contactLabelType = PPContactLabelType_SN_SinaWebo;
            break;
        }
        case WC_FST1_SN_Other:
        {
            contactLabelType = PPContactLabelType_SN_Other;
            break;
        }
        //////////////////////////////////////////////////
        // date
        case WC_FST1_Date_Birthday:
        {
            contactLabelType = PPContactLabelType_Date_Anniversary;
            break;
        }
        case WC_FST1_Date_Anniversary:
        {
            contactLabelType = PPContactLabelType_Date_Anniversary;
            break;
        }
        case WC_FST1_Date_Other:
        {
            contactLabelType = PPContactLabelType_Date_Other;
            break;
        }

        //////////////////////////////////////////////////
        case WC_FST1_SFData_Status:
        {
            contactLabelType = PPContactLabelType_Status_Status;
            break;
        }
        case WC_FST1_SFData_Rating:
        {
            contactLabelType = PPContactLabelType_Status_Rating;
            break;
        }
        case WC_FST1_SFData_Industry:
        {
            contactLabelType = PPContactLabelType_Status_Industry;
            break;
        }
        case WC_FST1_SFData_LeadSource:
        {
            contactLabelType = PPContactLabelType_Status_LeadSource;
            break;
        }

        case WC_FST1_None:
        default:
            break;
    }
    return contactLabelType;
}


//==============================================================================
//
//==============================================================================
+ (PPContactSubType)contactSubTypeFromFieldSubType2:(WC_FieldSubType2)fieldSubType2
{
    PPContactSubType contactSubType = PPContactSubType_None;
    switch (fieldSubType2)
    {
        case WC_FST2_Name_First:
        {
            contactSubType = PPContactSubType_Name_FirstName;
            break;
        }
        case WC_FST2_Name_FirstPhonetic:
        {
            contactSubType = PPContactSubType_Name_FirstNamePhonetic;
            break;
        }
        case WC_FST2_Name_Last:
        {
            contactSubType = PPContactSubType_Name_LastName;
            break;
        }
        case WC_FST2_Name_LastPhonetic:
        {
            contactSubType = PPContactSubType_Name_LastNamePhonetic;
            break;
        }
        case WC_FST2_Name_Middle:
        {
            contactSubType = PPContactSubType_Name_MiddleName;
            break;
        }
        case WC_FST2_Name_Prefix:
        {
            contactSubType = PPContactSubType_Name_Prefix;
            break;
        }
        case WC_FST2_Name_Suffix:
        {
            contactSubType = PPContactSubType_Name_Surffix;
            break;
        }
            
        case WC_FST2_Company_Name:
        {
            contactSubType = PPContactSubType_Company_Name;
            break;
        }
        case WC_FST2_Company_Phonetic:
        {
            contactSubType = PPContactSubType_Company_NamePhonetic;
            break;
        }
        case WC_FST2_Company_Department:
        {
            contactSubType = PPContactSubType_Company_Department;
            break;
        }
        case WC_FST2_Company_JobTitle:
        {
            contactSubType = PPContactSubType_Company_JobTitle;
            break;
        }
            
        case WC_FST2_Address_Street:
        {
            contactSubType = PPContactSubType_Address_Street;
            break;
        }
        case WC_FST2_Address_City:
        {
            contactSubType = PPContactSubType_Address_City;
            break;
        }
        case WC_FST2_Address_State:
        {
            contactSubType = PPContactSubType_Address_State;
            break;
        }
        case WC_FST2_Address_ZIP:
        {
            contactSubType = PPContactSubType_Address_Zip;
            break;
        }
        case WC_FST2_Address_Country:
        {
            contactSubType = PPContactSubType_Address_Country;
            break;
        }
        case WC_FST2_Address_CountryCode:
        {
            contactSubType = PPContactSubType_Address_CountryCode;
            break;
        }
        case WC_FST2_Address_Format:
        {
            contactSubType = PPContactSubType_Address_Format;
            break;
        }
        case WC_FST2_Address_Location:
        {
            contactSubType = PPContactSubType_Address_GPS;
            break;
        }
            
        default:
            break;
    }
    return contactSubType;
}


//===============================================================================
// 取得subtype label text
//===============================================================================
+ (NSString *)subTypeStringWithFieldType:(WC_FieldType)type associateType:(WC_FieldSubType1)associateType
{
    NSString *result = nil;
    
    switch (type) {
        case WC_FT_Name:
        {
            result = PPContactLabelText_Name;
            break;
        }
        case WC_FT_Company:
        {
            result = PPContactLabelText_Company;
            break;
        }
        case WC_FT_Address:
        {
            if (associateType==WC_FST1_Address_Home)
            {
                result = PPContactLabelText_Address_Home;
            }
            else if(associateType==WC_FST1_Address_Work)
            {
                result = PPContactLabelText_Address_Work;
            }
            else
            {
                result = PPContactLabelText_Address_Other;
            }
            break;
        }
        case WC_FT_Phone:
        {
            if (associateType==WC_FST1_Phone_Work)
            {
                result = PPContactLabelText_Phone_Work;
            }
            else if(associateType==WC_FST1_Phone_Home)
            {
                result = PPContactLabelText_Phone_Home;
            }
            else if(associateType==WC_FST1_Phone_Mobile)
            {
                result = PPContactLabelText_Phone_Mobile;
            }
            else if(associateType==WC_FST1_Phone_WorkFax)
            {
                result = PPContactLabelText_Phone_WorkFax;
            }
            else if(associateType==WC_FST1_Phone_HomeFax)
            {
                result = PPContactLabelText_Phone_HomeFax;
            }
            else if(associateType==WC_FST1_Phone_Pager)
            {
                result = PPContactLabelText_Phone_Pager;
            }
            else if(associateType==WC_FST1_Phone_GoogleVoice)
            {
                result = PPContactLabelText_Phone_GoogleVoice;
            }
            else if(associateType==WC_FST1_Phone_iPhone)
            {
                result = PPContactLabelText_Phone_iPhone;
            }
            else if(associateType==WC_FST1_Phone_Main)
            {
                result = PPContactLabelText_Phone_Main;
            }
            else
            {
                result = PPContactLabelText_Phone_Other;
            }
            break;
        }
        case WC_FT_Email:
        {
            if (associateType==WC_FST1_Email_Work)
            {
                result = PPContactLabelText_Email_Work;
            }
            else if(associateType==WC_FST1_Email_Home)
            {
                result = PPContactLabelText_Email_Home;
            }
            else
            {
                result = PPContactLabelText_Email_Other;
            }
            
            break;
        }
        case WC_FT_URL:
        {
            if (associateType==WC_FST1_URL_HomePage)
            {
                result = PPContactLabelText_URL_HomePage;
            }
            else if(associateType==WC_FST1_URL_Home)
            {
                result = PPContactLabelText_URL_Home;
            }
            else if(associateType==WC_FST1_URL_Work)
            {
                result = PPContactLabelText_URL_Work;
            }
            else if(associateType==WC_FST1_URL_Profile)
            {
                result = PPContactLabelText_URL_Profile;
            }
            else if(associateType==WC_FST1_URL_Blog)
            {
                result = PPContactLabelText_URL_Blog;
            }
            else
            {
                result = PPContactLabelText_URL_Other;
            }
            
            break;
        }
        case WC_FT_InstantMessage:
        {
            if (associateType==WC_FST1_IM_MSN)
            {
                result = PPContactLabelText_InstantMessage_MSN;
            }
            else if(associateType==WC_FST1_IM_Skype)
            {
                result = PPContactLabelText_InstantMessage_Skype;
            }
            else if(associateType==WC_FST1_IM_QQ)
            {
                result = PPContactLabelText_InstantMessage_QQ;
            }
            else if(associateType==WC_FST1_IM_Yahoo)
            {
                result = PPContactLabelText_InstantMessage_Yahoo;
            }
            else if(associateType==WC_FST1_IM_ICQ)
            {
                result = PPContactLabelText_InstantMessage_ICQ;
            }
            else if(associateType==WC_FST1_IM_GoogleTalk)
            {
                result = PPContactLabelText_InstantMessage_GoogleTalk;
            }
            else if(associateType==WC_FST1_IM_Jabber)
            {
                result = PPContactLabelText_InstantMessage_Jabber;
            }
            else if(associateType==WC_FST1_IM_AIM)
            {
                result = PPContactLabelText_InstantMessage_AIM;
            }
            else if(associateType==WC_FST1_IM_Other)
            {
                result = PPContactLabelText_InstantMessage_Other;
            }
            else if(associateType==WC_FST1_IM_GaduGadu)
            {
                result = PPContactLabelText_InstantMessage_GaduGadu;
            }
            else
            {
                result = PPContactLabelText_InstantMessage_MSN;
            }
            
            break;
        }
        case WC_FT_SocialNetwork:
        {
            if (associateType==WC_FST1_SN_Facebook)
            {
                result = PPContactLabelText_SN_Facebook;
            }
            else if(associateType==WC_FST1_SN_Flicker)
            {
                result = PPContactLabelText_SN_Flicker;
            }
            else if(associateType==WC_FST1_SN_LinkedIn)
            {
                result = PPContactLabelText_SN_LinkedIn;
            }
            else if(associateType==WC_FST1_SN_MySpace)
            {
                result = PPContactLabelText_SN_MySpace;
            }
            else if(associateType==WC_FST1_SN_Twitter)
            {
                result = PPContactLabelText_SN_Twitter;
            }
            else if(associateType==WC_FST1_SN_SinaWebo)
            {
                result = PPContactLabelText_SN_SinaWebo;
            }
            else
            {
                result = PPContactLabelText_SN_Other;
            }
            
            break;
        }
        case WC_FT_Date:
        {
            if (associateType==WC_FST1_Date_Anniversary)
            {
                result = PPContactLabelText_Date_Anniversary;
            }
            else if(associateType==WC_FST1_Date_Birthday)
            {
                result = PPContactLabelText_BirthDay;
            }
            else
            {
                result = PPContactLabelText_Date_Other;
            }
            
            break;
        }
        case WC_FT_Note:
        {
            result = PPContactLabelText_Note;
            break;
        }
        case WC_FT_Nickname:
        {
            result = PPContactLabelText_Other_NickName;
            break;
        }
        case WC_FT_UnifiedBusinessNo:
        {
            result = PPContactLabelText_Other_UnifiedBuinessNumber;
            break;
        }
        case WC_FT_SalesforceData:
        {
            if (associateType==WC_FST1_SFData_Rating)
            {
                result = PPContactLabelText_Rating;
            }
            else if(associateType==WC_FST1_SFData_LeadSource)
            {
                result = PPContactLabelText_LeadSource;
            }
            else if(associateType==WC_FST1_SFData_Industry)
            {
                result = PPContactLabelText_Industry;
            }
            else
            {
                result = PPContactLabelText_Status;
            }
            break;
        }
        default:
            break;
    }
    
    return result;
}

//==============================================================================
//
//==============================================================================
+ (PPContactLabelType)contactLabelTypeFromFieldSubType2:(WC_FieldSubType2)fieldSubType2
{
    PPContactLabelType labelType = PPContactLabelType_None;
    switch (fieldSubType2)
    {
        case WC_FST2_Company_Name:
        {
            labelType = PPContactLabelType_Company_Name;
            break;
        }
        case WC_FST2_Company_Department:
        {
            labelType = PPContactLabelType_Company_Department;
            break;
        }
        case WC_FST2_Company_JobTitle:
        {
            labelType = PPContactLabelType_Company_JobTitle;
            break;
        }
        default:
            break;
    }
    return labelType;
}


//==============================================================================
//
//==============================================================================
+ (NSString *)subTypeStringWithFieldSubType2:(WC_FieldSubType2)fieldSubType2
{
    NSString *labelText = nil;
    switch (fieldSubType2)
    {
        case WC_FST2_Company_Name:
        {
            labelText = PPContactLabelText_Company_Name;
            break;
        }
        case WC_FST2_Company_Department:
        {
            labelText = PPContactLabelText_Company_Department;
            break;
        }
        case WC_FST2_Company_JobTitle:
        {
            labelText = PPContactLabelText_Company_JobTitle;
            break;
        }
        default:
            break;
    }

    return labelText;
}


@end
