//
//  EFCExportViewController.m
//  Pods
//
//  Created by Andrew on 2015/8/3.
//
//

#import "UIViewController+ShareApplication.h"
#import "EFCExportViewController.h"

// Define
#import "UIColor+HexString.h"
#import "WCAppearanceDefine.h"

// View
#import "PPButton+Factory.h"

// Controller
#import "EFCPreferenceController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, EFCExportViewController_ButtonAction)
{
    EFCExportViewController_ButtonAction_None  = 0,
    EFCExportViewController_ButtonAction_Back,
    EFCExportViewController_ButtonAction_Export
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - EFCExportViewController

@interface EFCExportViewController () <PPButtonDelegate, WCFileTypeSelectViewDelegate>

@property (nonatomic, retain) PPButton                 *ppButtonBack;
@property (nonatomic, retain) PPButton                 *ppButtonExport;
@property (nonatomic, retain) PPNavigationBarView      *ppNavigationBarView;
@property (nonatomic, retain) WCFileTypeSelectView     *fileTypeSelectView;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - EFCExportViewController Implementation

@implementation EFCExportViewController





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    
    [_fileTypeOrderSource release];
    _fileTypeOrderSource = nil;
    
    [_fileTypeSelectView removeFromSuperview];
    [_fileTypeSelectView release];
    _fileTypeSelectView = nil;
    
    
    [self.ppButtonBack removeFromSuperview];
    self.ppButtonBack.delegate = nil;
    self.ppButtonBack = nil;
    
    [self.ppNavigationBarView removeFromSuperview];
    self.ppNavigationBarView = nil;
    
    [self.ppButtonExport removeFromSuperview];
    self.ppButtonExport.delegate = nil;
    self.ppButtonExport = nil;
    
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding To View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    WCFileTypeSelectView_ContactFileType initFileType = [[self.fileTypeOrderSource firstObject] integerValue];
    
    [EFCPreferenceController setDefaultContactFileExportFormat:initFileType];
    
    //////////////////////////////////////////////////
    
    _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    if (self.ppNavigationBarView!=nil)
    {
        self.ppNavigationBarView.style = PPBarViewStyle_CenteredAbsolute;
        self.ppNavigationBarView.backgroundImageView.image = nil; //因為navigationBar在init時會塞入預設圖
        self.ppNavigationBarView.backgroundColor = [UIColor colorWithHexString:@"#3F79CF"];
        
        self.ppNavigationBarView.titleLabel.text      = WCEFC_MLS_Export;
        self.ppNavigationBarView.titleLabel.textColor = [UIColor whiteColor];
        
        _ppButtonBack = [[PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                         tag:EFCExportViewController_ButtonAction_Back
                                                    delegate:self
                                       normalBackgroundColor:nil
                                  highlightedBackgroundColor:[UIColor colorWithHexString:@"#2c538f"]
                                             imageEdgeInsets:WCExportFlowControllerNavigationBarButtonImageEdgeInsets] retain];
        if (self.ppButtonBack!=nil)
        {
            [self.ppButtonBack addControlEvents:UIControlEventTouchUpInside];
            
            //////////////////////////////////////////////////
            
            PPBarViewItemModel *itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
            if(itemModel!=nil)
            {
                itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                
                [self.ppNavigationBarView setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
            }
        }
        
        //////////////////////////////////////////////////
        
        _ppButtonExport = [[PPButton ppButtonWithIconImageName:ImageNameWCExportFlowControllerButtonExport
                                                           tag:EFCExportViewController_ButtonAction_Export
                                                      delegate:self
                                         normalBackgroundColor:nil
                                    highlightedBackgroundColor:[UIColor colorWithHexString:@"#2c538f"]
                                               imageEdgeInsets:WCExportFlowControllerNavigationBarButtonImageEdgeInsets] retain];
        if (self.ppButtonExport!=nil)
        {
            [self.ppButtonExport addControlEvents:UIControlEventTouchUpInside];
            
            //////////////////////////////////////////////////
            
            PPBarViewItemModel *itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonExport];
            if(itemModel!=nil)
            {
                itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                
                [self.ppNavigationBarView setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Right];
            }
        }
        
        self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
    }
    
    //////////////////////////////////////////////////
    
    
    _fileTypeSelectView = [[WCFileTypeSelectView alloc] initWithFrame:CGRectZero];
    if (self.fileTypeSelectView!=nil)
    {
        self.fileTypeSelectView.delegate                = self;
        self.fileTypeSelectView.supportFileTypes        = self.fileTypeOrderSource;
        self.fileTypeSelectView.contactFileTypeSelected = [EFCPreferenceController contactFileExportFormat];
        
        self.fileTypeSelectView.fileTypeSelectorTitle   = WCEFC_MLS_ExportToFileContent;
        self.fileTypeSelectView.tableSectionColor       = WCAppearanceDefine_SectionHeaderBGColor;
        
        //!! 因為設定footerView後，下方才不會顯示持續顯示Cell的Separator
        UIView *footerView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, self.view.bounds.size.width, 0)];
        if (footerView!=nil)
        {
            footerView.backgroundColor = [UIColor whiteColor];
            self.fileTypeSelectView.selectFooterView = footerView;
            
            [self.view addSubview:self.fileTypeSelectView];
            [footerView release];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self.fileTypeSelectView removeFromSuperview];
    self.fileTypeSelectView.delegate = nil;
    self.fileTypeSelectView = nil;
    
    [self.ppButtonBack removeFromSuperview];
    self.ppButtonBack.delegate = nil;
    self.ppButtonBack = nil;
    
    [self.ppNavigationBarView removeFromSuperview];
    self.ppNavigationBarView = nil;
    
    [self.ppButtonExport removeFromSuperview];
    self.ppButtonExport.delegate = nil;
    self.ppButtonExport = nil;
    
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    CGRect viewRegion = [self layoutFrame];
    
    //////////////////////////////////////////////////
    
    CGRect selectViewFrame = viewRegion;
    self.fileTypeSelectView.frame = selectViewFrame;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    [EFCPreferenceController setContactFileExportFormat:self.fileTypeSelectView.contactFileTypeSelected];
    
    switch (ppButton.tag)
    {
        case EFCExportViewController_ButtonAction_Back:
        {
            [self goBackAnimated:YES];
            break;
        }
        case EFCExportViewController_ButtonAction_Export:
        {
            if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(exportViewController:didSelectContactFileType:fileTypeTextInfoSelected:)]==YES)
            {
                [self.delegate exportViewController:self
                           didSelectContactFileType:self.fileTypeSelectView.contactFileTypeSelected
                           fileTypeTextInfoSelected:self.fileTypeSelectView.fileTypeTextInfoSelected];
            }
            
            break;
        }
        default:
            break;
    }
}

@end
