//
//  WCUserDefinedFieldValueModel.m
//

#import "WCUserDefinedFieldValueModel.h"

NSString * const Separator = @"<|>";


@implementation WCUserDefinedFieldValueModel

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Override methods

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.label = nil;
    self.value = nil;
    
    [super dealloc];
}


//===============================================================================
//
//===============================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"<Label:%@, Value:%@>\r\n", self.label, self.value];
}


//===============================================================================
//
//===============================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCUserDefinedFieldValueModel *model = [[[self class] allocWithZone:zone] init];
    
    if(model != nil)
    {
        model.label = self.label;
        model.value = self.value;
    }
    
    return model;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods

//================================================================================
//
//================================================================================
- (NSString *)combinedString
{
    return [NSString stringWithFormat:@"%@%@%@", self.label, Separator, self.value];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods

//================================================================================
//
//================================================================================
+ (WCUserDefinedFieldValueModel *)modelWithCombinedString:(NSString *)combinedString
{
    NSArray *elements = [combinedString componentsSeparatedByString:Separator];
    
    if([elements count] == 2)
    {
        WCUserDefinedFieldValueModel *model = [[WCUserDefinedFieldValueModel alloc] init];
        
        if(model != nil)
        {
            model.label = elements[0];
            model.value = elements[1];
            
            return [model autorelease];
        }
    }
    
    return nil;
}

@end
