//
//  WCRecogSourceModel.h
//  WorldCardMobile
//
//  Created by  Eddie on 12/6/15.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "WCImageDefine.h"

typedef NS_ENUM(NSUInteger,WCRecogSourceModelAddMode)
{
    WCRecogSourceModelAddMode_Album,
    WCRecogSourceModelAddMode_Camera,
    WCRecogSourceModelAddMode_EmailSignature,
    WCRecogSourceModelAddMode_HandClip,
    WCRecogSourceModelAddMode_QRCode
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCRecogSourceModel : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

// 新增的模式
@property (nonatomic, assign) WCRecogSourceModelAddMode addMode;

/// 辨識影像來源，可能是ALAssetURL/FilePath/Image (必要)
@property (nonatomic, retain) id                     imageSource;

/// 亮化影像來源，可能是ALAssetURL/FilePath/Image 
@property (nonatomic, retain) id                     lightImageSource;

/// 是否是dock模式
@property (nonatomic, assign) BOOL                   dockMode;

/// 是否要做影像優化
@property (nonatomic, assign) BOOL                   imageEnhance;

/// 是否要做影像裁切
@property (nonatomic,assign)  BOOL                   imageSegment;

/// 有沒有辨識範圍 (必要)
@property (nonatomic, assign) BOOL                   hasRecogRect;

/// 是否已校正
@property (nonatomic, assign) BOOL                   isVerified;

/// 辨識語系 (必要)
@property (nonatomic, assign) NSInteger              recogLang;

/// 旋轉角度
@property (nonatomic, assign) NSInteger              rotateDegree;

/// 繁中名片輸出設定
@property (nonatomic, assign) NSInteger              outputTranslate;

/// cardID
@property (nonatomic, retain) NSString               *cardID;

/// 要辨識的影像是正面或反面
@property (nonatomic, assign) WC_ImageType           imageType;

/// cardModel's gruop 的群組 [@(WC_GroupID)], 因為cardModel的群組會隨著預設群組的不同而改變，無法在cardModel產生時決定群組
@property (nonatomic, retain) NSArray                *groupIDArray;

#pragma mark 手刮

/// 手刮辨識欄位 (必要)
@property (nonatomic, assign) NSInteger              handClipRecogType;

/// 手刮辨識範圍 (必要)
@property (nonatomic, assign) CGRect                 handClipRect;

@end
