//
//  WCRecentCardModel.m
//  Pods
//
//  Created by sanhue on 2015/9/11.
//
//

#import "WCRecentCardModel.h"

@implementation WCRecentCardModel





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.content = nil;
    self.actionTime = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - class methods


//==============================================================================
//
//==============================================================================
+ (WCRecentCardModel *)recentCardModelFromCardModel:(WCCardModel *)cardModel
{
    WCRecentCardModel *abCardModel = [[WCRecentCardModel alloc] init];
    
    abCardModel.ID = cardModel.ID;
    abCardModel.sourceID = cardModel.sourceID;
    [abCardModel setGroupIDArray:cardModel.groupIDArray isInitCard:YES];
    
    abCardModel.displayName = cardModel.displayName;
    abCardModel.displayCompany = cardModel.displayCompany;
    abCardModel.displayPhone = cardModel.displayPhone;
    abCardModel.displayAddress = cardModel.displayAddress;
    abCardModel.displayGPS = cardModel.displayGPS;
    abCardModel.sectionTitle = cardModel.sectionTitle;
    abCardModel.createdTime = cardModel.createdTime;
    abCardModel.modifiedTime = cardModel.modifiedTime;
    abCardModel.frontRecogLang = cardModel.frontRecogLang;
    abCardModel.backRecogLang = cardModel.backRecogLang;
    abCardModel.tagMask = cardModel.tagMask;
    
    NSArray *allKeys = [cardModel.fieldArrayDict allKeys];
    
    for(NSString *key in allKeys)
    {
        NSMutableArray *array = [cardModel.fieldArrayDict objectForKey:key];
        
        for(WCFieldModel *fieldModel in array)
        {
            WCFieldModel *newFieldModel = [fieldModel copy];
            [abCardModel addField:newFieldModel];
            [newFieldModel release];
        }
    }
    
    return [abCardModel autorelease];
}


@end
