//
//  WCKernelRecogLangModel.m
//  WorldCardMobile
//
//  Created by  Eddie on 12/6/14.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "WCKernelRecogLangModel.h"
#import "namecard_define.h"

@implementation WCKernelRecogLangModel
@synthesize langCode = langCode_;
@synthesize localizedString = localizedString_;
@synthesize key = key_;


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.localizedString = nil;
    self.key = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}


//===============================================================================
// 
//===============================================================================
+ (WCKernelRecogLangModel *)modelWithLangCode:(NSInteger)langCode
{
    WCKernelRecogLangModel *model = nil;
    NSString *stringID            = nil;
    NSString *key                 = nil;
    
    switch (langCode) 
    {
        case B5_LANG: stringID = @"MLS_TraditionalChinese"; key = @"B5"; break;
        case GB_LANG: stringID = @"MLS_SimplifiedChinese"; key = @"GB"; break;
        case HK_LANG: stringID = @"MLS_HongKong"; key = @"HK"; break;
        case EN_LANG: stringID = @"MLS_English"; key = @"EN"; break;
        case GE_LANG: stringID = @"MLS_German"; key = @"GE"; break;
        case FR_LANG: stringID = @"MLS_French"; key = @"FR"; break;
        case IT_LANG: stringID = @"MLS_Italian"; key = @"IT"; break;
        case ES_LANG: stringID = @"MLS_Spanish"; key = @"ES"; break;
        case NO_LANG: stringID = @"MLS_Norwegian"; key = @"NO"; break;
        case HU_LANG: stringID = @"MLS_Hungarian"; key = @"HU"; break;
        case PL_LANG: stringID = @"MLS_Polish"; key = @"PL"; break;
        case SE_LANG: stringID = @"MLS_Swedish"; key = @"SE"; break;
        case NL_LANG: stringID = @"MLS_Dutch"; key = @"NL"; break;
        case TR_LANG: stringID = @"MLS_Turkish"; key = @"TR"; break;
        case RU_LANG: stringID = @"MLS_Russian"; key = @"RU"; break;
        case JP_LANG: stringID = @"MLS_Japanese"; key = @"JP"; break;
        case KS_LANG: stringID = @"MLS_Korean"; key = @"KS"; break;
        case DK_LANG: stringID = @"MLS_Danish"; key = @"DK"; break;
        case FI_LANG: stringID = @"MLS_Finnish"; key = @"FI"; break;
        case PT_LANG: stringID = @"MLS_Portuguese"; key = @"PT"; break;
        case GR_LANG: stringID = @"MLS_Greek"; key = @"GR"; break;
        case BR_LANG: stringID = @"MLS_Portuguese_Brazil"; key = @"BR"; break;
        case MX_LANG: stringID = @"MLS_Spanish_Mexican"; key = @"MX"; break;
        case CZ_LANG: stringID = @"MLS_Czech"; key = @"CZ"; break;
        case SK_LANG: stringID = @"MLS_Slovak"; key = @"SK"; break;
        case AR_LANG: stringID = @"MLS_Arabic"; key = @"AR"; break;
        case TH_LANG: stringID = @"MLS_Thai"; key = @"TH"; break;

        default:
            break;
    }
    
    if (stringID!=nil && key!=nil)
    {
        model = [[[WCKernelRecogLangModel alloc] init] autorelease];
        model.langCode = langCode;
        model.localizedString = NSLocalizedStringFromTable(stringID,@"WCRecognitionController",nil);
        model.key = key;

    }
    
    return model;
}

@end
