//
//  WCGroupModel+Tree.m
//

#import "WCGroupModel+Tree.h"
#import "WCGroupDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCGroupModel (Tree)

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods

//================================================================================
//
//================================================================================
- (WCGroupModel *)groupInTreeWithGuid:(NSString *)guid
{
    if([guid length] == 0)
    {
        return nil;
    }
    
    //////////////////////////////////////////////////
    
    if([self.guid isEqualToString:guid] == YES)
    {
        return self;
    }
    else
    {
        for(WCGroupModel *subGroup in self.subGroups)
        {
            WCGroupModel *result = [subGroup groupInTreeWithGuid:guid];
            
            if(result != nil)
            {
                return result;
            }
        }
        
        return nil;
    }
}


//================================================================================
//
//================================================================================
- (WCGroupModel *)groupInTreeWithID:(NSInteger)groupID sourceID:(NSInteger)sourceID
{
    if(self.ID==groupID && self.sourceID==sourceID)
    {
        return self;
    }
    else
    {
        for(WCGroupModel *subGroup in self.subGroups)
        {
            WCGroupModel *result = [subGroup groupInTreeWithID:groupID sourceID:sourceID];
            
            if(result!=nil)
            {
                return result;
            }
        }
        
        return nil;
    }
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)superGroupNamesInTreeWithID:(NSInteger)groupID
{
    WCGroupModel *groupModel = [self groupInTreeWithID:groupID sourceID:self.sourceID];
    
    if(groupModel == nil)
    {
        return nil;
    }
    
    NSMutableArray *groupNames = [NSMutableArray array];
    
    [groupNames insertObject:groupModel.name atIndex:0];
    
    WCGroupModel *superGroupModel = [self groupInTreeWithGuid:groupModel.superGroupGuid];
    
    while(superGroupModel != nil)
    {
        [groupNames insertObject:superGroupModel.name atIndex:0];
        superGroupModel = [self groupInTreeWithGuid:superGroupModel.superGroupGuid];
    }
    
    return groupNames;
}



//================================================================================
//
//================================================================================
- (NSMutableArray *)superGroupNamesInTreeWithGuid:(NSString *)groupGuid
{
    WCGroupModel *groupModel = [self groupInTreeWithGuid:groupGuid];
    
    if(groupModel == nil)
    {
        return nil;
    }
    
    NSMutableArray *groupNames = [NSMutableArray array];
    
    [groupNames insertObject:groupModel.name atIndex:0];
    
    WCGroupModel *superGroupModel = [self groupInTreeWithGuid:groupModel.superGroupGuid];
    
    while(superGroupModel != nil)
    {
        [groupNames insertObject:superGroupModel.name atIndex:0];
        superGroupModel = [self groupInTreeWithGuid:superGroupModel.superGroupGuid];
    }
    
    return groupNames;
}

//================================================================================
//
//================================================================================
- (NSMutableArray *)layerGroupsInTreeWithID:(NSInteger)groupID
{
    WCGroupModel *groupModel = [self groupInTreeWithID:groupID sourceID:self.sourceID];
    
    if(groupModel == nil)
    {
        return nil;
    }
    
    NSMutableArray *superGroups = [NSMutableArray array];
    
    [superGroups insertObject:groupModel atIndex:0];
    
    WCGroupModel *superGroupModel = [self groupInTreeWithGuid:groupModel.superGroupGuid];
    
    while(superGroupModel != nil)
    {
        [superGroups insertObject:superGroupModel atIndex:0];
        superGroupModel = [self groupInTreeWithGuid:superGroupModel.superGroupGuid];
    }
    
    return superGroups;
}


//================================================================================
//
//================================================================================
- (void)expandSuperGroupInTreeWithGroupGuid:(NSString *)groupGuid
{
    WCGroupModel *groupModel = [self groupInTreeWithGuid:groupGuid];
    
    if(groupModel == nil)
    {
        return;
    }
    
    WCGroupModel *superGroupModel = [self groupInTreeWithGuid:groupModel.superGroupGuid];
    
    while(superGroupModel != nil)
    {
        superGroupModel.isExpanded = YES;
        superGroupModel = [self groupInTreeWithGuid:superGroupModel.superGroupGuid];
    }
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)expandedGroupGuidsInTree
{
    NSMutableArray *guids = [NSMutableArray array];
    
    @autoreleasepool
    {
        if(self.isExpanded == YES)
        {
            [guids addObject:self.guid];
        }
        
        for(WCGroupModel *subGroup in self.subGroups)
        {
            NSMutableArray *subGuids = [subGroup expandedGroupGuidsInTree];
            
            if([subGuids count] > 0)
            {
                [guids addObjectsFromArray:subGuids];
            }
        }
    }
    
    return guids;
}


//================================================================================
//
//================================================================================
- (void)setExpandedGroupInTreeWithGuids:(NSMutableArray *)guids
{
    if([guids containsObject:self.guid] == YES)
    {
        self.isExpanded = YES;
        [guids removeObject:self.guid];
    }
    else
    {
        self.isExpanded = NO;
    }
    
    for(WCGroupModel *subGroup in self.subGroups)
    {
        [subGroup setExpandedGroupInTreeWithGuids:guids];
    }
}


//================================================================================
//
//================================================================================
- (void)setOwnerOfTreeWithGuid:(NSString *)ownerGuid
{
    self.owner = ownerGuid;
    
    for(WCGroupModel *subGroup in self.subGroups)
    {
        [subGroup setOwnerOfTreeWithGuid:ownerGuid];
    }
}


//================================================================================
//
//================================================================================
- (NSInteger)subGroupLayerCount
{
    if(self.subGroups.count==0 || self.subGroups==nil)
    {
        return 0;
    }
    else
    {
        NSInteger maxLayerCount = 0;
        for(WCGroupModel *subGroup in self.subGroups)
        {
            NSInteger layerCount = 1 + [subGroup subGroupLayerCount];
            if(layerCount>maxLayerCount)
            {
                maxLayerCount = layerCount;
            }
        }
        
        return maxLayerCount;
    }
}


//==============================================================================
//
//==============================================================================
- (NSString *)displayGroupStringWithGroupIDArray:(NSArray *)groupIDArray isGroupMissing:(BOOL *)isGroupMissing
{
    NSMutableString *groupNames = [NSMutableString string];
    
    for (NSString *groupID in groupIDArray)
    {
        NSMutableArray *ancestralGroupNames = [self superGroupNamesInTreeWithID:[groupID integerValue]];
        
        // 如果找不到，表示這個類別已不存在，要顯示!
        if (ancestralGroupNames==nil)
        {
            if(isGroupMissing!=NULL)
            {
                *isGroupMissing = YES;
            }
            break;
        }
        
        //////////////////////////////////////////////////
        // 有兩層以上時，去掉root
        if ([ancestralGroupNames count]>1)
        {
            [ancestralGroupNames removeObjectAtIndex:0];
        }
        
        NSString *multiLayerGroupName = [ancestralGroupNames componentsJoinedByString:@"/"];
        
        if ([groupNames length]>0)
        {
            [groupNames appendString:@"; "];
        }
        
        [groupNames appendString:multiLayerGroupName];
    }
    
    return groupNames;
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods

//================================================================================
//
//================================================================================
+ (WCGroupModel *)groupTreeWithGroups:(NSArray *)groups
{
    if([groups count] < 1)
    {
        return nil;
    }
    
    //////////////////////////////////////////////////
    
    NSMutableArray *groupNodes = [NSMutableArray arrayWithArray:groups];
    WCGroupModel *rootGroup = nil;
    
    //////////////////////////////////////////////////
    // 先找出"All"群組當作root
    
    for(WCGroupModel *groupModel in groupNodes)
    {
        if(groupModel.ID == WC_GID_All)
        {
            rootGroup = [groupModel retain];
            [groupNodes removeObject:groupModel];
            break;
        }
    }
    
    //////////////////////////////////////////////////
    // 歸類剩下的群組
    
    if(rootGroup != nil)
    {
        while([groupNodes count] > 0)
        {
            for(WCGroupModel *groupModel in groupNodes)
            {
                WCGroupModel *superGroup = [rootGroup groupInTreeWithGuid:groupModel.superGroupGuid];
                
                if(superGroup != nil)
                {
                    [superGroup.subGroups addObject:groupModel];
                    [groupNodes removeObject:groupModel];
                    break;
                }
                else
                {
                    // 踢除沒有parent存在的group
                    BOOL hasSuperGroupGuid = NO;
                    
                    for(WCGroupModel *superGroup in groups)
                    {
                        if([superGroup.guid isEqualToString:groupModel.superGroupGuid] == YES)
                        {
                            hasSuperGroupGuid = YES;
                            break;
                        }
                    }
                    
                    if(hasSuperGroupGuid == NO)
                    {
                        [groupNodes removeObject:groupModel];
                        break;
                    }
                }
            }
        }
    }
    
    return [rootGroup autorelease];
}


@end
