//
//  WCGroupModel+Sort.m
//

#import "WCGroupModel+Sort.h"
#import "NSString+Additions.h"
#import "PPSystemInfoController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCGroupModel (Sort)

#pragma mark private


//==============================================================================
// 排序判斷是否為亞洲語系的方法，hamming說不用那邊準確，所以另外處理
//==============================================================================
+ (BOOL)isCJKString:(NSString *)string
{
    BOOL isCJK = NO;
    
    NSUInteger length = [string length];
    for(NSUInteger index=0; index<length; index++)
    {
        unichar character = [string characterAtIndex:index];
        if(character>=0x3000)
        {
            isCJK = YES;
            break;
        }
    }
    
    return isCJK;
}

//================================================================================
//
//================================================================================
+ (NSMutableArray *)sortTreeWithRootGroups:(NSArray *)rootGroups
{
    BOOL forEnglish = YES;
    
    switch([PPSystemInfoController language])
    {
        case PPSystemInfoLanguage_ChineseTraditional:
        case PPSystemInfoLanguage_ChineseSimplified:
        case PPSystemInfoLanguage_Korean:
        case PPSystemInfoLanguage_Japanese:
            forEnglish = NO;
            break;
            
        default:
            break;
    }

    NSMutableArray *sortedGroups = [WCGroupModel defaultSortedGroupsWithCurrentGroups:rootGroups
                                                                           forEnglish:forEnglish
                                                                  onlySortSystemGroup:NO];
    
    for(WCGroupModel *groupModel in sortedGroups)
    {
        groupModel.subGroups = [self sortTreeWithRootGroups:groupModel.subGroups];
    }
    
    return sortedGroups;
}


//==============================================================================
//
//==============================================================================
+ (NSMutableArray *)defaultSortedGroupsWithCurrentGroups:(NSArray*)currentGroups forEnglish:(BOOL)forEnglish onlySortSystemGroup:(BOOL)onlySortSystemGroup
{
    if ([currentGroups count]==0)
    {
        return nil;
    }
    
    NSMutableArray *sourceGroups = [NSMutableArray arrayWithArray:currentGroups];
    NSMutableArray *sortedGroups = [NSMutableArray array];
    NSMutableDictionary *englishUserDefineGroupDictionary = [NSMutableDictionary dictionary];
    NSMutableArray *englishUserDefineGroups = [NSMutableArray array];
    NSMutableArray *nonEnglishUserDefineGroups = [NSMutableArray array];
    NSMutableArray *helpScanGroups = [NSMutableArray array];

    // 預設類別排序 (全部連絡人,我的聯絡人 (Gmail),Starred in Android,同事 (Gmail),朋友 (Gmail),家人 (Gmail),其他聯絡人,未下載)
    NSArray *systemGroupOrder = @[@"MLS_All", @"MLS_MyContacts", @"Starred in Android", @"MLS_Coworkers", @"MLS_Friends", @"MLS_Family", @"MLS_Unfiled", @"MLS_Undownload"];
    
    // 先處理預設類別
    for (NSString *defualtGroupName in systemGroupOrder)
    {
        for (WCGroupModel *groupModel in sourceGroups)
        {
            if (groupModel.editable==NO &&
                [groupModel.name isEqualToString:[defualtGroupName localized]] == YES)
            {
                [sortedGroups addObject:groupModel];
                [sourceGroups removeObject:groupModel];
                break;
            }
        }
    }
    
    //////////////////////////////////////////////////
    // 再處理剩下的類別
    if (onlySortSystemGroup == YES)
    {
        // 剩下的以原本的順序回傳
        [sortedGroups addObjectsFromArray:sourceGroups];
    }
    else
    {
        // 使用者自訂的類別加到userDefineGroups，以便後續處理
        for (WCGroupModel *groupModel in sourceGroups)
        {
            // 同事幫忙掃描的類別要放一起
            if ([groupModel.helper length]>0)
            {
                [helpScanGroups addObject:groupModel];
            }
            else if ([groupModel.name length]>0)
            {
                // !! hamming說用 0x3000比就好
                if ([self isCJKString:groupModel.name])
//                if ([groupModel.name isCJK])
                {
                    [nonEnglishUserDefineGroups addObject:groupModel];
                }
                else
                {
                    // 英文先加到dictionary
                    unichar firstChar = [groupModel.name characterAtIndex:0];
                    NSString *key = [[NSString stringWithCharacters:&firstChar length:1] lowercaseString];
                    NSMutableArray *arrayForKey = [englishUserDefineGroupDictionary objectForKey:key];
                    if (arrayForKey==nil)
                    {
                        arrayForKey = [NSMutableArray array];
                    }
                    
                    [arrayForKey addObject:groupModel];
                    [englishUserDefineGroupDictionary setObject:arrayForKey forKey:key];
                }
            }
        }
        
        
        //////////////////////////////////////////////////
        // 處理自訂類別
        // MARK: 幫同事掃描
        [helpScanGroups sortUsingComparator:^NSComparisonResult(WCGroupModel *obj1, WCGroupModel *obj2) {
            return [obj1.name unicodeCompare:obj2.name];
        }];
        
        //////////////////////////////////////////////////
        // MARK: 非中日韓排序
        // 先將dictionary中的array依key排序
        NSArray *sortedAllKeys = [[englishUserDefineGroupDictionary allKeys] sortedArrayUsingComparator:^NSComparisonResult(NSString * obj1, NSString *obj2) {
            return [obj1 unicodeCompare:obj2];
        }];
        
        // 再將key中的array排序
        
        // 輸出排序後的資料到 nonEnglishUserDefineGroups
        for (NSString *key in sortedAllKeys)
        {
            NSMutableArray *tempArray = [englishUserDefineGroupDictionary objectForKey:key];
            
            // 直接排序
            if ([tempArray count]>0)
            {
                [tempArray sortUsingComparator:^NSComparisonResult(WCGroupModel *groupModel1, WCGroupModel *groupModel2) {
                    
                    if ([groupModel1.name length]==0)
                    {
                        // 沒有長度的排前面
                        return NSOrderedAscending;
                    }
                    else if ([groupModel2.name length]==0)
                    {
                        // 沒有長度的排前面
                        return NSOrderedDescending;
                    }
                    else
                    {
                        int index = 0;
                        while (true)
                        {
                            if (index <[groupModel1.name length] && index < [groupModel2.name length])
                            {
                                NSComparisonResult result = [[groupModel1.name substringWithRange:NSMakeRange(index, 1)] caseInsensitiveCompare:[groupModel2.name substringWithRange:NSMakeRange(index, 1)]];
                                
                                if (result == NSOrderedSame)
                                {
                                    if ([groupModel1.name length] < [groupModel2.name length])
                                    {
                                        // 比較短的排前面
                                        return NSOrderedAscending;
                                    }
                                    else if ([groupModel2.name length] <[groupModel1.name length])
                                    {
                                        // 比較短的排前面
                                        return NSOrderedDescending;
                                    }
                                    else
                                    {
                                        result = [[groupModel1.name substringWithRange:NSMakeRange(index, 1)] unicodeCompare:[groupModel2.name substringWithRange:NSMakeRange(index, 1)]];
                                        if (result == NSOrderedSame)
                                        {
                                            index++;
                                        }
                                        else
                                        {
                                            return result;
                                        }
                                    }
                                }
                                else
                                {
                                    return result;
                                }
                            }
                            else
                            {
                                return NSOrderedSame;
                            }
                        }
                    }
                }];
                
                [englishUserDefineGroups addObjectsFromArray:tempArray];
            }
        }
        
        
        //////////////////////////////////////////////////
        // MARK 中日韓排序
        
        [nonEnglishUserDefineGroups sortUsingComparator:^NSComparisonResult(WCGroupModel *groupModel1, WCGroupModel *groupModel2) {
               return [groupModel1.name unicodeCompare:groupModel2.name];
        }];

        //////////////////////////////////////////////////
        // 先加入同事幫忙掃描的類別
        if ([helpScanGroups count]>0)
        {
            [sortedGroups addObjectsFromArray:helpScanGroups];
        }

        //////////////////////////////////////////////////
        // !! 英文，先加englishUserDefineGroups，再加nonEnglishUserDefineGroups
        // !! 非英文，先加nonEnglishUserDefineGroups，再加englishUserDefineGroups
        
        if (forEnglish)
        {
            if ([englishUserDefineGroups count]>0)
            {
                [sortedGroups addObjectsFromArray:englishUserDefineGroups];
            }
            
            if ([nonEnglishUserDefineGroups count]>0)
            {
                [sortedGroups addObjectsFromArray:nonEnglishUserDefineGroups];
            }
        }
        else
        {
            if ([nonEnglishUserDefineGroups count]>0)
            {
                [sortedGroups addObjectsFromArray:nonEnglishUserDefineGroups];
            }
            
            if ([englishUserDefineGroups count]>0)
            {
                [sortedGroups addObjectsFromArray:englishUserDefineGroups];
            }
        }
    }
    
    return sortedGroups;
}


@end
