//
//  WCCardModel+SalesforceAccessHelper.m
//  WCDataModel
//
//  Created by sanhue on 2019/2/1.
//

#import "WCCardModel+SalesforceAccessHelper.h"
#import "WCFieldModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCCardModel (SalesforceAccessHelper)





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - private


//==============================================================================
//
//==============================================================================
- (void)addOrUpdateSalesforceDataWithSubType1:(WC_FieldSubType1)subtype1 value:(id)value
{
    // value為空就要刪除
    if (value==nil)
    {
        NSMutableArray *fieldModels = [self fieldArrayWithType:WC_FT_SalesforceData];
        
        for (WCFieldModel *fieldModel in fieldModels)
        {
            if (fieldModel.subType1==subtype1)
            {
                [fieldModels removeObject:fieldModel];
                return;
            }
        }
        return;
    }
    
    // 存在就更新
    NSArray *fieldModels = [self fieldArrayWithType:WC_FT_SalesforceData];
    
    for (WCFieldModel *fieldModel in fieldModels)
    {
        if (fieldModel.subType1==subtype1)
        {
            fieldModel.value = value;
            return;
        }
    }
    
    // 不存在就新增
    WCFieldModel *fieldModel = [WCFieldModel newFieldModel];
    
    fieldModel.type = WC_FT_SalesforceData;
    fieldModel.subType1 = subtype1;
    fieldModel.value = value;
    
    [self addField:fieldModel];
    [fieldModel release];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Salesforce field Access


//==============================================================================
//
//==============================================================================
- (void)setSaveAs:(WC_SF_SaveAs)saveAs
{
    [self addOrUpdateSalesforceDataWithSubType1:WC_FST1_SFData_SaveAs value:@(saveAs)];
}


//==============================================================================
//
//==============================================================================
- (WC_SF_SaveAs)saveAs
{
    NSArray *fieldModels = [self fieldArrayWithType:WC_FT_SalesforceData];
    
    for (WCFieldModel *fieldModel in fieldModels)
    {
        if (fieldModel.subType1==WC_FST1_SFData_SaveAs)
        {
            return [fieldModel.value integerValue];
        }
    }
    return WC_SF_SaveAs_None;
}


//==============================================================================
//
//==============================================================================
- (void)setContactID:(NSString *)contactID
{
    [self addOrUpdateSalesforceDataWithSubType1:WC_FST1_SFData_ContactID value:contactID];
}


//==============================================================================
//
//==============================================================================
- (NSString *)contactID
{
    NSArray *fieldModels = [self fieldArrayWithType:WC_FT_SalesforceData];
    
    for (WCFieldModel *fieldModel in fieldModels)
    {
        if (fieldModel.subType1==WC_FST1_SFData_ContactID)
        {
            return fieldModel.value;
        }
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (void)setLeadSource:(NSString *)leadSource
{
    [self addOrUpdateSalesforceDataWithSubType1:WC_FST1_SFData_LeadSource value:leadSource];
}


//==============================================================================
//
//==============================================================================
- (NSString *)leadSource
{
    NSArray *fieldModels = [self fieldArrayWithType:WC_FT_SalesforceData];
    
    for (WCFieldModel *fieldModel in fieldModels)
    {
        if (fieldModel.subType1==WC_FST1_SFData_LeadSource)
        {
            return fieldModel.value;
        }
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (void)setIndustry:(NSString *)industry
{
    [self addOrUpdateSalesforceDataWithSubType1:WC_FST1_SFData_Industry value:industry];
}


//==============================================================================
//
//==============================================================================
- (NSString *)industry
{
    NSArray *fieldModels = [self fieldArrayWithType:WC_FT_SalesforceData];
    
    for (WCFieldModel *fieldModel in fieldModels)
    {
        if (fieldModel.subType1==WC_FST1_SFData_Industry)
        {
            return fieldModel.value;
        }
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (void)setStatus:(NSString *)status
{
    [self addOrUpdateSalesforceDataWithSubType1:WC_FST1_SFData_Status value:status];
}


//==============================================================================
//
//==============================================================================
- (NSString *)status
{
    NSArray *fieldModels = [self fieldArrayWithType:WC_FT_SalesforceData];
    
    for (WCFieldModel *fieldModel in fieldModels)
    {
        if (fieldModel.subType1==WC_FST1_SFData_Status)
        {
            return fieldModel.value;
        }
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (void)setRating:(NSString *)rating;
{
    [self addOrUpdateSalesforceDataWithSubType1:WC_FST1_SFData_Rating value:rating];
}


//==============================================================================
//
//==============================================================================
- (NSString *)rating
{
    NSArray *fieldModels = [self fieldArrayWithType:WC_FT_SalesforceData];
    
    for (WCFieldModel *fieldModel in fieldModels)
    {
        if (fieldModel.subType1==WC_FST1_SFData_Rating)
        {
            return fieldModel.value;
        }
    }
    return nil;
}


@end
