//
//  WCCardModel+Office365AccessHelper.m
//  
//
//  Created by Howard on 2019/5/29.
//

#import "WCCardModel+Office365AccessHelper.h"

// Model
#import "WCFieldModel.h"

@implementation WCCardModel (Office365AccessHelper)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//==============================================================================
//
//==============================================================================
- (void)addOrUpdateOffice365DataWithSubType1:(WC_FieldSubType1)subtype1 value:(id)value
{
    do
    {
        // value為空就要刪除
        if (value==nil)
        {
            NSMutableArray *fieldModels = [self fieldArrayWithType:WC_FT_Office365Data];
            
            for (WCFieldModel *fieldModel in fieldModels)
            {
                if (fieldModel.subType1==subtype1)
                {
                    [fieldModels removeObject:fieldModel];
                    
                    break;
                }
            }
            
            break;
        }
        
        //////////////////////////////////////////////////

        // 存在就更新
        BOOL fieldExist = NO;
        
        NSArray *fieldModels = [self fieldArrayWithType:WC_FT_Office365Data];
        
        for (WCFieldModel *fieldModel in fieldModels)
        {
            if (fieldModel.subType1==subtype1)
            {
                fieldModel.value = value;
                fieldExist = YES;
                break;
            }
        }

        //////////////////////////////////////////////////

        if(fieldExist==YES)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        // 不存在就新增
        WCFieldModel *fieldModel = [WCFieldModel newFieldModel];
        
        if(fieldModel==nil)
        {
            break;
        }
        
        fieldModel.type = WC_FT_Office365Data;
        fieldModel.subType1 = subtype1;
        fieldModel.value = value;
        
        [self addField:fieldModel];
        [fieldModel release];
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Field Method

//==============================================================================
//
//==============================================================================
- (void)setOffice365ContactID:(NSString *)contactID
{
    [self addOrUpdateOffice365DataWithSubType1:WC_FST1_Office365Data_ContactID value:contactID];
}


//==============================================================================
//
//==============================================================================
- (NSString *)office365ContactID
{
    NSString *contactID = nil;
    
    NSArray *fieldModels = [self fieldArrayWithType:WC_FT_Office365Data];
    
    for (WCFieldModel *fieldModel in fieldModels)
    {
        if (fieldModel.subType1==WC_FST1_Office365Data_ContactID)
        {
            contactID = fieldModel.value;
            
            break;
        }
    }
    
    return contactID;
}


@end
