//
//  WCAdvancedSearchModel.m
//  Extension
//
//  Created by sanhue on 2018/10/22.
//

#import "WCAdvancedSearchModel.h"

@interface WCAdvancedSearchModel()

@property (nonatomic, retain, readwrite, nullable) NSMutableArray *contactInfoConditions;
@property (nonatomic, retain, readwrite, nullable) NSMutableArray *categoryConditions;
@property (nonatomic, retain, readwrite, nullable) NSMutableArray *dateConditions;
@end



////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCAdvancedSearchModel





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.contactInfoConditions = [NSMutableArray array];
        self.categoryConditions = [NSMutableArray array];
        self.dateConditions = [NSMutableArray array];
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.contactInfoConditions = nil;
    self.categoryConditions = nil;
    self.dateConditions = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (NSString *)description
{
    NSMutableString *msg = [[NSMutableString alloc] initWithFormat:@"\r\n\r\n#################### %@ (%p) ####################\r\n",[self class], self];
    
    if(self.contactInfoConditions.count>0)
    {
        [msg appendFormat:@"\r\n ❗️❗️❗️contactInfoConditions:%@", self.contactInfoConditions];
    }
    
    if(self.categoryConditions.count>0)
    {
        [msg appendFormat:@"\r\n ❗️❗️❗️categoryConditions:%@", self.categoryConditions];
    }
    
    if(self.dateConditions.count>0)
    {
        [msg appendFormat:@"\r\n ❗️❗️❗️dateConditions:%@", self.dateConditions];
    }
    [msg appendString:@"\r\n"];
    
    //////////////////////////////////////////////////
    
    return [msg autorelease];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - NSCopying


//==============================================================================
//
//==============================================================================
- (id)copyWithZone:(nullable NSZone *)zone
{
    id searchModel = [[[self class] alloc] init];
    
    ((WCAdvancedSearchModel *)searchModel).contactInfoConditions = [[self.contactInfoConditions mutableCopyWithZone:zone] autorelease];
    ((WCAdvancedSearchModel *)searchModel).categoryConditions = [[self.categoryConditions mutableCopyWithZone:zone] autorelease];
    ((WCAdvancedSearchModel *)searchModel).dateConditions = [[self.dateConditions mutableCopyWithZone:zone] autorelease];

    return searchModel;
}

@end
