//
//  WCAppearanceDefine.h
//
//  App介面顯示相關的定義值
//

#ifndef WCAppearanceDefine_h
#define WCAppearanceDefine_h

#import <UIKit/UIKit.h>
#import "UIColor+HexString.h"

/// Guide時 rect Fucus mode 的 infoAreaGap
#define WCAppearanceDefine_RectFocusModeInfoAreaGap 50


/// Button中image的內縮範圍
#define WCAppearanceDefine_ButtonImageEdgeInset UIEdgeInsetsMake(10, 10, 10, 10)

/// 圓角大小
#define WCAppearanceDefine_CornerRadius 5.0

/// 深藍色
#define WCAppearanceDefine_DarkBlueColor [UIColor colorWithHexString:@"#2c538f"]

/// 淺藍色
#define WCAppearanceDefine_LightBlueColor [UIColor colorWithHexString:@"#5fdfff"]

/// 橘色
#define WCAppearanceDefine_OrangeColor [UIColor colorWithHexString:@"#f6ae4e"]


////////////////////////////////////////////////////////////////////////////////////////////////////
// navigation bar style
#define WCAppearanceDefine_NavigationBarColor [UIColor colorWithHexString:@"#3f79cf"]
#define WCAppearanceDefine_ButtonBackgroundColor WCAppearanceDefine_DarkBlueColor

/// table view style
#define WCAppearanceDefine_SectionIndexTitleColor [UIColor colorWithHexString:@"#75a7f0"]
#define WCAppearanceDefine_SectionIndexTitleHighlightColor [UIColor colorWithHexString:@"#ffffff"]
#define WCAppearanceDefine_SectionIndexHighlightColor [UIColor colorWithHexString:@"#75a6f0"]

#define WCAppearanceDefine_SectionHeaderBGColor [UIColor colorWithHexString:@"#dae3f2"]
#define WCAppearanceDefine_SectionHeaderTitleColor [UIColor colorWithHexString:@"#75a6f0"]
#define WCAppearanceDefine_SectionHeaderFontSize 15
#define WCAppearanceDefine_SectionHeaderHeight 48

#define WCAppearanceDefine_CellTitleColor [UIColor colorWithHexString:@"#4c4c4c"]
#define WCAppearanceDefine_CellHighlightedBGColor [UIColor colorWithHexString:@"#e7f0ff"]
#define WCAppearanceDefine_SeparatorColor [UIColor colorWithHexString:@"#9cbff3"]
#define WCAppearanceDefine_CellHeight 48

// section index toast
#define WCAppearanceDefine_SectionIndexToastBGColor WCAppearanceDefine_SectionIndexHighlightColor
#define WCAppearanceDefine_SectionIndexToastTitleColor WCAppearanceDefine_SectionIndexTitleHighlightColor
#define WCAppearanceDefine_SectionIndexToastTitleFontSize 36

/// scroll tab style
#define WCAppearanceDefine_ScrollTabButtonTitleColor [UIColor colorWithHexString:@"#85a7da"]
#define WCAppearanceDefine_ScrollTabButtonTitleSelectedColor [UIColor colorWithHexString:@"#ffb76a"]

// alert toast
#define WCAppearanceDefine_AlertToastBGColor [[UIColor colorWithHexString:@"#031c43"] colorWithAlphaComponent:0.85]
#define WCAppearanceDefine_AlertToastTitleColor [UIColor colorWithHexString:@"#ffffff"]
#define WCAppearanceDefine_AlertToastTitleFontSize 16

#endif
