//
//  WCCoverFlowActionBar.m
//  Pods
//
//  Created by sanhue on 2016/7/1.
//
//

#import "WCCoverFlowActionBar.h"

#import "PPButton.h"
#import "PPButton+Factory.h"
#import "UIColor+HexString.h"

static NSString *WCCoverFlowBarTel = @"WCCoverFlowBarTel";
static NSString *WCCoverFlowBarMail = @"WCCoverFlowBarMail";
static NSString *WCCoverFlowBarAddress = @"WCCoverFlowBarAddress";
static NSString *WCCoverFlowBarGo = @"WCCoverFlowBarGo";
static NSString *WCCoverFlowBarNext = @"WCCoverFlowBarNext";
static NSString *WCCoverFlowBarPrev = @"WCCoverFlowBarPrev";

static CGFloat WCCoverFlowBar_ContentBarRighMargin = 0;

static CGFloat WCCoverFlowBar_LeftSpace = 4;
static CGFloat WCCoverFlowBar_DefaultFontSize = 20;
static CGFloat WCCoverFlowBar_MultiLineFontSize = 16;

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSInteger, WCCoverFlowActionBarContentBarAction)
{
    WCCoverFlowActionBarContentBarAction_None = 10,
    WCCoverFlowActionBarContentBarAction_Prev,
    WCCoverFlowActionBarContentBarAction_Next,
    WCCoverFlowActionBarContentBarAction_Go,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCCoverFlowActionBar () <PPButtonDelegate>
@property (nonatomic ,retain) PPButton *ppButtonTel;
@property (nonatomic ,retain) PPButton *ppButtonMail;
@property (nonatomic ,retain) PPButton *ppButtonMap;

@property (nonatomic ,retain) UIView *contentBar;
@property (nonatomic ,retain) UILabel *contentLabel;
@property (nonatomic ,retain) PPButton *ppButtonContent;
@property (nonatomic ,retain) PPButton *ppButtonPrev;
@property (nonatomic ,retain) PPButton *ppButtonNext;
@property (nonatomic ,retain) PPButton *ppButtonGo;

@property (nonatomic ,retain) PPButton *currentActiveButton;

#pragma mark Data
@property (nonatomic, retain) NSArray *layoutConstraints;

@property (nonatomic, assign) WCCoverFlowBarAction action;
@property (nonatomic, assign) NSInteger contentIndex;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCCoverFlowActionBar





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self)
    {
        self.contentBarBackgroundColor = [UIColor whiteColor];
        
        self.contentBarButtonEdgeInsets = UIEdgeInsetsZero;
        self.actionBarButtonEdgeInsets = UIEdgeInsetsZero;
        
        self.maxTitleFontSize = WCCoverFlowBar_DefaultFontSize;
        self.minTitleFontSize = WCCoverFlowBar_MultiLineFontSize;
        //////////////////////////////////////////////////
        [self prepareToolBar];
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.delegate = nil;
    [self removeToolBar];
    
    self.contentBarBackgroundColor = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare UI


//==============================================================================
//
//==============================================================================
- (void)prepareToolBar
{
    self.ppButtonTel = [PPButton ppButtonWithIconImageName:WCCoverFlowBarTel
                                                       tag:WCCoverFlowBarAction_Tel
                                                  delegate:self
                                     normalBackgroundColor:[UIColor clearColor]
                                highlightedBackgroundColor:[UIColor whiteColor]
                                           imageEdgeInsets:self.actionBarButtonEdgeInsets];
    
    //////////////////////////////////////////////////
    self.ppButtonMail = [PPButton ppButtonWithIconImageName:WCCoverFlowBarMail
                                                        tag:WCCoverFlowBarAction_Mail
                                                   delegate:self
                                      normalBackgroundColor:[UIColor clearColor]
                                 highlightedBackgroundColor:[UIColor whiteColor]
                                            imageEdgeInsets:self.actionBarButtonEdgeInsets];
    
    //////////////////////////////////////////////////
    self.ppButtonMap = [PPButton ppButtonWithIconImageName:WCCoverFlowBarAddress
                                                       tag:WCCoverFlowBarAction_Map
                                                  delegate:self
                                     normalBackgroundColor:[UIColor clearColor]
                                highlightedBackgroundColor:[UIColor whiteColor]
                                           imageEdgeInsets:self.actionBarButtonEdgeInsets];
    
    //////////////////////////////////////////////////
    [self setTranslatesAutoresizingMaskIntoConstraints:NO];
    [self setStyle:PPBarViewStyle_Average];
    
    NSMutableArray *views = [NSMutableArray array];
    
    if (self.ppButtonTel)
    {
        [views addObject:self.ppButtonTel];
    }
    
    if (self.ppButtonMail)
    {
        [views addObject:self.ppButtonMail];
    }
    
    if (self.ppButtonMap)
    {
        [views addObject:self.ppButtonMap];
    }
    
    [self setViews:views forBlockType:PPBarViewBlockType_Center];
    //////////////////////////////////////////////////
//    [self.ppButtonTel setBackgroundColor:[UIColor blueColor]];
//    [self.ppButtonMap setBackgroundColor:[UIColor redColor]];
//    [self.ppButtonMail setBackgroundColor:[UIColor greenColor]];

}


//==============================================================================
//
//==============================================================================
- (void)removeToolBar
{
    [self removeContentBar];

    self.ppButtonTel = nil;
    self.ppButtonMap = nil;
    self.ppButtonMail = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare contentBar UI

//==============================================================================
//
//==============================================================================
- (void)prepareContentBarWithRect:(CGRect)rect
{
    [self removeContentBar];
    //////////////////////////////////////////////////
    self.contentLabel = [[[UILabel alloc] initWithFrame:CGRectZero] autorelease];
    [self.contentLabel setTranslatesAutoresizingMaskIntoConstraints:NO];
    [self.contentLabel setTextColor:[UIColor whiteColor]];
    [self.contentLabel setTextAlignment:NSTextAlignmentLeft];
    [self.contentLabel setFont:[UIFont systemFontOfSize:WCCoverFlowBar_DefaultFontSize]];
    [self.contentLabel setNumberOfLines:2];
    [self.contentLabel setLineBreakMode:NSLineBreakByWordWrapping];
    //////////////////////////////////////////////////
//    self.ppButtonContent = [PPButton ppButtonWithFrame:CGRectMake(0, 0, self.superview.bounds.size.width-44*3-(UIButtonAdditions_DefaultMinWidth+20)*3,	UIButtonAdditions_DefaultMinHeight)
//                                         IconImageName:nil
//                                   backgroundImageName:nil
//                                       backgroundColor:nil
//                                           borderColor:nil
//                                              delegate:self
//                                                   tag:0
//                                                 title:nil];
//    [self.ppButtonContent setTranslatesAutoresizingMaskIntoConstraints:NO];
//    
//    [self.ppButtonContent.titleLabel setFont:[UIFont systemFontOfSize:20]];
//    [self.ppButtonContent.titleLabel setTextAlignment:NSTextAlignmentLeft];
//    [self.ppButtonContent setTitleColor:[UIColor blackColor]];
//    
    //////////////////////////////////////////////////
    self.ppButtonPrev = [PPButton ppButtonWithIconImageName:WCCoverFlowBarPrev
                                                        tag:WCCoverFlowActionBarContentBarAction_Prev
                                                   delegate:self
                                      normalBackgroundColor:[UIColor clearColor]
                                 highlightedBackgroundColor:self.contentBarBackgroundColor
                                            imageEdgeInsets:self.contentBarButtonEdgeInsets];
    
    [self.ppButtonPrev setTranslatesAutoresizingMaskIntoConstraints:NO];
    
    //////////////////////////////////////////////////
    self.ppButtonNext = [PPButton ppButtonWithIconImageName:WCCoverFlowBarNext
                                                        tag:WCCoverFlowActionBarContentBarAction_Next
                                                   delegate:self
                                      normalBackgroundColor:[UIColor clearColor]
                                 highlightedBackgroundColor:self.contentBarBackgroundColor
                                            imageEdgeInsets:self.contentBarButtonEdgeInsets];
    
    [self.ppButtonNext setTranslatesAutoresizingMaskIntoConstraints:NO];
    
    //////////////////////////////////////////////////
    self.ppButtonGo = [PPButton ppButtonWithIconImageName:WCCoverFlowBarGo
                                                      tag:WCCoverFlowActionBarContentBarAction_Go
                                                 delegate:self
                                    normalBackgroundColor:[UIColor clearColor]
                               highlightedBackgroundColor:self.contentBarBackgroundColor
                                          imageEdgeInsets:self.contentBarButtonEdgeInsets];

    [self.ppButtonGo setTranslatesAutoresizingMaskIntoConstraints:NO];
    
    //////////////////////////////////////////////////
    _contentBar = [[UIView alloc] initWithFrame:rect];
    [self.contentBar setBackgroundColor:self.contentBarBackgroundColor];
    
    if (self.contentLabel)
    {
        [self.contentBar addSubview:self.contentLabel];
    }
    
    if (self.ppButtonContent)
    {
        [self.contentBar addSubview:self.ppButtonContent];
    }
    
    if (self.ppButtonPrev)
    {
        [self.contentBar addSubview:self.ppButtonPrev];
    }
    
    if (self.ppButtonNext)
    {
        [self.contentBar addSubview:self.ppButtonNext];
    }
    
    if (self.ppButtonGo)
    {
        [self.contentBar addSubview:self.ppButtonGo];
    }
    
    [self.superview addSubview:self.contentBar];
    [self.superview bringSubviewToFront:self];
    
    [self.contentBar setAlpha:0.0];
    [self resetContentBarLayoutConstraints];
    
    //////////////////////////////////////////////////
    // 取得要顯示的content
    [self updateContentStringByAction:self.action];
    
    //////////////////////////////////////////////////
    // debug
    
//    [self.contentLabel setBackgroundColor:[UIColor blueColor]];
//    [self.ppButtonPrev setBackgroundColor:[UIColor redColor]];
//    [self.ppButtonNext setBackgroundColor:[UIColor greenColor]];
//    [self.ppButtonGo setBackgroundColor:[UIColor purpleColor]];
}


//==============================================================================
//
//==============================================================================
- (void)removeContentBar
{
    [self removeContentBarLayoutConstraints];
    
    [self.contentBar removeFromSuperview];
    self.contentBar = nil;
    
    self.contentLabel = nil;
    self.ppButtonContent = nil;
    self.ppButtonPrev = nil;
    self.ppButtonNext = nil;
    self.ppButtonGo  = nil;
    
    self.currentActiveButton = nil;
}


//==============================================================================
//
//==============================================================================
- (UILabel *)currentContentLabel
{
    return self.contentLabel;
}


//==============================================================================
//
//==============================================================================
- (void)resetState
{
    self.currentActiveButton.selected = NO;
    self.currentActiveButton = nil;
    
    self.action = WCCoverFlowBarAction_None;
    self.contentIndex = 0;
}



//==============================================================================
//
//==============================================================================
- (void)showContentBar:(BOOL)show fromButton:(UIButton *)fromButton animated:(BOOL)animated
{
    CGRect buttonRectAtSreen =  [self convertRect:fromButton.frame toView:self.superview];
    
    if (show)
    {
        [self prepareContentBarWithRect:buttonRectAtSreen];
    }
    
    [UIView animateWithDuration:animated?0.3:0.0 animations:^{
        
        if(show)
        {
            self.contentBar.frame = CGRectMake(0, buttonRectAtSreen.origin.y, self.superview.bounds.size.width, self.bounds.size.height);
            self.contentBar.alpha = 1.0;
            self.contentBar.backgroundColor = [UIColor colorWithHexString:@"#1b437f"];
            self.backgroundColor = [UIColor colorWithHexString:@"#000d21"];
        }
        else
        {
            self.contentBar.frame = buttonRectAtSreen;
            self.contentBar.alpha = 0.2;
            self.contentBar.backgroundColor = [UIColor clearColor];
            self.backgroundColor = [UIColor clearColor];
        }
        [self.contentBar layoutIfNeeded];
    } completion:^(BOOL finished) {
        
        if(!show)
        {
            [self resetState];
            [self removeContentBar];
        }
    }];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - contentBar layout constraints


//==============================================================================
//
//==============================================================================
- (void)resetContentBarLayoutConstraints
{
    [self removeContentBarLayoutConstraints];
    //////////////////////////////////////////////////
    // 按鈕寬與toolbar的高度一樣
    CGFloat buttonWidth = self.contentBarButtonWidth;
    if (self.contentBarButtonWidth==0)
    {
        buttonWidth = self.bounds.size.height;
    }
    CGFloat buttonHeight = self.bounds.size.height;
    CGFloat rightMargin = self.bounds.size.width+WCCoverFlowBar_ContentBarRighMargin;
    
    NSDictionary *views   = @{@"contentBar":self.contentBar,
                              @"contentLabel":[self currentContentLabel],
//                              @"ppButtonContent":self.ppButtonContent,
                              @"ppButtonPrev":self.ppButtonPrev,
                              @"ppButtonNext":self.ppButtonNext,
                              @"ppButtonGo":self.ppButtonGo};
    
    
    NSDictionary *metrics = @{@"buttonWidth":@(buttonWidth),
                              @"buttonHeight":@(buttonHeight),
                              @"rightMargin":@(rightMargin),
                              @"leftSpace":@(WCCoverFlowBar_LeftSpace)};
    
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[contentLabel]|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:nil
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[ppButtonPrev]|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:nil
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[ppButtonNext]|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:nil
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[ppButtonGo]|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:nil
                                                                                     views:views]];
    
    // 加@750是為了讓ppButtonGo的動畫不會被這個寬度卡住
    // 加@749是為了讓按鈕不會看起來是在leftMargin變0之後才開始做動畫
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|-(leftSpace)-[ppButtonPrev(==buttonWidth)][contentLabel][ppButtonNext(==buttonWidth)][ppButtonGo(==buttonWidth)]-(rightMargin@750)-|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    // 設定最小值，並以最小值優先，讓縮小時的畫動可以更順暢
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|-(leftSpace)-[ppButtonPrev(==buttonWidth)][contentLabel(>=0@748)][ppButtonNext(==buttonWidth)][ppButtonGo(==buttonWidth)]-(>=50@750)-|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.contentBar addConstraints:self.layoutConstraints];
        [self.contentBar layoutIfNeeded];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeContentBarLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.contentBar removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - override property


//==============================================================================
//
//==============================================================================
- (void)setContentBarBackgroundColor:(UIColor *)contentBarBackgroundColor
{
    [contentBarBackgroundColor retain];
    [_contentBarBackgroundColor release];
    _contentBarBackgroundColor = contentBarBackgroundColor;
    //////////////////////////////////////////////////
    UIImage *backgroundImage = [UIImage imageWithColor:self.contentBarBackgroundColor];
    [self.ppButtonTel setBackgroundImage:backgroundImage forState:UIControlStateHighlighted];
    [self.ppButtonMail setBackgroundImage:backgroundImage forState:UIControlStateHighlighted];
    [self.ppButtonMap setBackgroundImage:backgroundImage forState:UIControlStateHighlighted];
}


//==============================================================================
//
//==============================================================================
- (void)setContentBarButtonEdgeInsets:(UIEdgeInsets)contentBarButtonEdgeInsets
{
    _contentBarButtonEdgeInsets = contentBarButtonEdgeInsets;
    //////////////////////////////////////////////////
    [self.ppButtonPrev setImageEdgeInsets:self.contentBarButtonEdgeInsets];
    [self.ppButtonNext setImageEdgeInsets:self.contentBarButtonEdgeInsets];
    [self.ppButtonGo setImageEdgeInsets:self.contentBarButtonEdgeInsets];
}


//==============================================================================
//
//==============================================================================
- (void)setActionBarButtonEdgeInsets:(UIEdgeInsets)actionBarButtonEdgeInsets
{
    _actionBarButtonEdgeInsets = actionBarButtonEdgeInsets;
    //////////////////////////////////////////////////
    [self.ppButtonTel setImageEdgeInsets:self.actionBarButtonEdgeInsets];
    [self.ppButtonMail setImageEdgeInsets:self.actionBarButtonEdgeInsets];
    [self.ppButtonMap setImageEdgeInsets:self.actionBarButtonEdgeInsets];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - maintain data


//==============================================================================
//
//==============================================================================
- (BOOL)hasNext
{
    BOOL hasNext = YES;
    if ([self.delegate respondsToSelector:@selector(hasNextWithAction:index:)])
    {
        hasNext = [self.delegate hasNextWithAction:self.action index:self.contentIndex];
    }
    return hasNext;
}



//==============================================================================
//
//==============================================================================
- (BOOL)hasPrev
{
    BOOL hasPrev = YES;
    if ([self.delegate respondsToSelector:@selector(hasPrevWithAction:index:)])
    {
        hasPrev = [self.delegate hasPrevWithAction:self.action index:self.contentIndex];
    }
    return hasPrev;
}


//==============================================================================
//
//==============================================================================
- (void)updatePrevNextButtons
{
    [self.ppButtonPrev setHidden:![self hasPrev]];
    [self.ppButtonNext setHidden:![self hasNext]];
}


//==============================================================================
//
//==============================================================================
- (void)updateContentStringByAction:(NSInteger)action
{
    if (self.action!=WCCoverFlowBarAction_None &&
        [self.delegate respondsToSelector:@selector(contentStringAtIndex:withAction:)])
    {
        __block typeof(self) blockSelf = self;
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
            NSString *contentString = [blockSelf.delegate contentStringAtIndex:blockSelf.contentIndex withAction:blockSelf.action];

            dispatch_async(dispatch_get_main_queue(), ^{
                UILabel *currentLabel = [blockSelf currentContentLabel];
                if (currentLabel)
                {
                    [currentLabel setText:contentString];
                    
                    //////////////////////////////////////////////////
                    // 調整字型，如果單行放得下，使用 WCCoverFlowBar_DefaultFontSize
                    // 多行使用 WCCoverFlowBar_MultiLineFontSize
                    CGFloat fontSize = blockSelf.maxTitleFontSize;
                    CGSize predictLabelSize = [contentString sizeWithAttributes:@{NSFontAttributeName:[UIFont systemFontOfSize:fontSize]}];
                    
                    if(predictLabelSize.width>currentLabel.bounds.size.width)
                    {
                        fontSize = blockSelf.minTitleFontSize;
                    }
                    
                    [currentLabel setFont:[UIFont systemFontOfSize:fontSize]];
                    
                }
                
                [blockSelf updatePrevNextButtons];
                
            });
        });
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - public methods


//==============================================================================
//
//==============================================================================
- (void)hideContentBar
{
    if (self.contentBar)
    {
        [self showContentBar:NO fromButton:self.currentActiveButton animated:YES];
    }
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent;
{
    if(ppButton.tag<WCCoverFlowActionBarContentBarAction_None)
    {
        // 如果是按同一個，關閉
        if (self.currentActiveButton==ppButton)
        {
            [self showContentBar:NO fromButton:self.currentActiveButton animated:YES];
            [self resetState];
            return;
        }
        
        // 詢問是否可以開啟選單
        BOOL shouldAct = YES;
        if ([self.delegate respondsToSelector:@selector(shouldOpenContentBarWithAction:)])
        {
            shouldAct = [self.delegate shouldOpenContentBarWithAction:ppButton.tag];
        }
        
        if (shouldAct==NO)
        {
            return;
        }
        
        // 如果可以開啟選單，才要切換設定
        self.currentActiveButton.selected = NO;
        ppButton.selected = YES;
        self.action = ppButton.tag;
        // 重新從第一筆開始顯示
        self.contentIndex=0;
    
        // 已顯示，就不再顯示，但要通知更新內容
        if(self.currentActiveButton==nil)
        {
            [self showContentBar:YES fromButton:ppButton animated:YES];
        }
        else
        {

            [self updateContentStringByAction:self.action];
        }
        
        self.currentActiveButton = ppButton;
        
    }
    else
    {
        switch (ppButton.tag)
        {
            case WCCoverFlowActionBarContentBarAction_Prev:
            {
                BOOL hasPrev = [self hasPrev];
                if (hasPrev)
                {
                    self.contentIndex--;
                    if(self.contentIndex<0)
                    {
                        self.contentIndex = 0;
                    }
                    
                    [self updateContentStringByAction:self.action];
                }
                
                //////////////////////////////////////////////////
                // 調整前後按鈕
                [self updatePrevNextButtons];
                break;
            }
            case WCCoverFlowActionBarContentBarAction_Next:
            {
                BOOL hasNext = [self hasNext];
                if (hasNext)
                {
                    self.contentIndex++;
                    [self updateContentStringByAction:self.action];
                }
                //////////////////////////////////////////////////
                // 調整前後按鈕
                [self updatePrevNextButtons];
                break;
            }
            case WCCoverFlowActionBarContentBarAction_Go:
            {
                if ([self.delegate respondsToSelector:@selector(actionBar:didClickAction:withContent:index:)])
                {
                    NSString *contentStringCopy = [[[self currentContentLabel] text] copy];
                    [self.delegate actionBar:self didClickAction:self.action withContent:contentStringCopy index:self.contentIndex];
                    [contentStringCopy release];
                }
                break;
            }
            default:
                break;
        }
    }
}



@end
