//
//  WCCoverFlowControllerDelegate.h
//  Pods
//
//  Created by sanhue on 2016/6/20.
//
//

#ifndef WCCoverFlowControllerDelegate_h
#define WCCoverFlowControllerDelegate_h

typedef NS_ENUM(NSInteger, WCCoverFlowControllerAction)
{
    WCCoverFlowControllerAction_None = 0,
    WCCoverFlowControllerAction_Tel,
    WCCoverFlowControllerAction_EMail,
    WCCoverFlowControllerAction_Map,
};


//////////////////////////////////////////////////
@class WCCoverFlowController;

@protocol WCCoverFlowControllerDelegate <NSObject>

@optional


/**
 * 點選名片圖
 * @param coverFlowController instance of flow controller
 * @param cardID 點選到的ID
 */
- (void)coverFlowController:(WCCoverFlowController *)coverFlowController didClickCardImageWithCardID:(NSString *)cardID;


/**
 * 送出執行動作後的通知
 * @param coverFlowController instance of flow controller
 * @param action 目前動作的ID
 * @param content 目前動作的內容
 * @param cardID 要修改的名片ID
 */
- (void)coverFlowController:(WCCoverFlowController *)coverFlowController
               recentAction:(NSInteger)action
                    content:(NSString *)content
                     cardID:(NSString *)cardID;
@end

#endif /* WCCoverFlowControllerDelegate_h */
