//
//  WCCoverFlowController.m
//  Pods
//
//  Created by sanhue on 2016/6/20.
//
//

#import "WCCoverFlowController.h"

// define
#import "WCCoverFlowController+ResourceDefine.h"

//Category

//view controllers
#import "WCCoverFlowViewController.h"

// controllers
#import "PPLogControllerExtension.h"

#import "PPURLController+iOS.h"
#import "PPNetworkReachabilityController.h"
#import "WCToastController.h"
#import "PPWebViewController.h"
#import "PPNavigationController.h"
#import "PPMailComposeViewController.h"


#if defined (PRODUCTLINE_WCT)
    #import "WCTMatomoController.h"
#elif defined (PRODUCTLINE_WCSF)
    #import "WCSFMatomoController.h"
#endif
////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCCoverFlowController ()
<
WCCoverFlowViewControllerDataSource,
WCCoverFlowViewControllerDelegate
>


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - property
@property (nonatomic, assign) id<WCCoverFlowControllerDataSource> dataSource;
@property (nonatomic, assign) id<WCCoverFlowControllerDelegate> delegate;

@property (nonatomic, retain, readwrite) WCCoverFlowViewController *coverFlowViewController;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - data


@end


////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCCoverFlowController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)initWithDelegate:(id)delegate;
{
    self = [super init];
    if (self)
    {
        self.delegate = delegate;
        self.dataSource = delegate;
        
        self.coverFlowViewController = [[[WCCoverFlowViewController alloc] initWithMode:WCCoverFlowViewControllerMode_CardHolder] autorelease];

    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.delegate = nil;
    self.dataSource = nil;
    
    self.coverFlowViewController = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare horizontal view controller


//==============================================================================
//
//==============================================================================
- (void)addCoverFlowViewControllerWithMode:(WCCoverFlowViewControllerMode)mode
                          onViewController:(UIViewController *)viewController
{
    self.coverFlowViewController.delegate = self;
    self.coverFlowViewController.dataSource = self;
    
    [self.coverFlowViewController addOnViewController:viewController
                                             withMode:mode];
}


//==============================================================================
//
//==============================================================================
- (void)removeCoverFlowController
{
    [self.coverFlowViewController removeFromParent];
}


//==============================================================================
//
//==============================================================================
- (void)setStringForNoContact:(NSString *)noContact noName:(NSString *)noName
{
    [self.coverFlowViewController setNoCardString:noContact];
    [self.coverFlowViewController setNoNameString:noName];
}



//==============================================================================
//
//==============================================================================
- (WCCoverFlowViewControllerMode)mode
{
    return self.coverFlowViewController.mode;
}


//==============================================================================
//
//==============================================================================
- (void)setCategoryName:(NSString *)categoryName
{
    [self.coverFlowViewController setCategoryName:categoryName];
}



//==============================================================================
//
//==============================================================================
- (void)reloadData
{
    [self.coverFlowViewController reloadData];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (Private) recent contact action


//==============================================================================
//
//==============================================================================
- (void)reportRecentAction:(NSInteger)action content:(NSString *)content cardID:(NSString *)cardID
{
    if ([self.delegate respondsToSelector:@selector(coverFlowController:recentAction:content:cardID:)])
    {
        [self.delegate coverFlowController:self recentAction:action content:content cardID:cardID];
    }
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCCoverFlowViewControllerDataSource


//==============================================================================
//
//==============================================================================
- (NSArray *)cardSectionArrayWithCoverFlowViewController:(WCCoverFlowViewController *)coverFlowViewController
{
    if([self.dataSource respondsToSelector:@selector(cardSectionArrayWithCoverFlowController:)])
    {
        return [self.dataSource cardSectionArrayWithCoverFlowController:self];
    }

    return nil;
}


//==============================================================================
//
//==============================================================================
- (WCCardModel *)coverFlowViewController:(WCCoverFlowViewController *)coverFlowViewController requestFullCardModelWithCardID:(NSString *)cardID;
{
    if([self.dataSource respondsToSelector:@selector(coverFlowController:requestFullCardModelWithCardID:)])
    {
        return [self.dataSource coverFlowController:self requestFullCardModelWithCardID:cardID];
    }
    
    return nil;
}


//==============================================================================
//
//==============================================================================
- (UIImage *)coverFlowViewController:(WCCoverFlowViewController *)coverFlowViewController cardImageWithCardID:(NSString *)cardID
{
    if([self.dataSource respondsToSelector:@selector(coverFlowController:cardImageWithCardID:imageType:imageSubType:)])
    {
        return [self.dataSource coverFlowController:self cardImageWithCardID:cardID imageType:WC_IT_FrontSide imageSubType:WC_IST_Browse];
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (UIImage *)coverFlowViewController:(WCCoverFlowViewController *)coverFlowViewController thumbnailCardImageWithCardID:(NSString *)cardID;
{
    if([self.dataSource respondsToSelector:@selector(coverFlowController:cardImageWithCardID:imageType:imageSubType:)])
    {
        return [self.dataSource coverFlowController:self cardImageWithCardID:cardID imageType:WC_IT_FrontSide imageSubType:WC_IST_Thumbnail];
    }
    return nil;
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCCoverFlowViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (void)coverFlowViewController:(WCCoverFlowViewController *)coverFlowViewController didSelectCardWithCardID:(NSString *)cardID
{
    if([self.delegate respondsToSelector:@selector(coverFlowController:didClickCardImageWithCardID:)])
    {
        [self.delegate coverFlowController:self didClickCardImageWithCardID:cardID];
    }
}


//==============================================================================
//
//==============================================================================
- (void)coverFlowViewController:(WCCoverFlowViewController *)coverFlowViewController
                     actionType:(PPURLControllerType)actionType
              withActionContent:(NSString *)actionContent
                  displayString:(NSString *)displayString
                         cardID:(NSString *)cardID

{
//    NSLog(@"%s - %ld, %@", __PRETTY_FUNCTION__, (long)actionType, content);
    // 使用PPURLController執行動作
    BOOL recordAction = YES;
    BOOL needCheckNetwork = NO;
    ContactActionType contactActionType = ContactActionType_Tel;
    NSString *tempActionContent = actionContent;
    
    switch (actionType)
    {
        case PPURLControllerType_Tel:
        {
            //////////////////////////////////////////////////
            NSMutableString *phone = [NSMutableString stringWithString:tempActionContent];
            [phone replaceOccurrencesOfString:@"#"
                                   withString:@","
                                      options:NSLiteralSearch
                                        range:NSMakeRange(0, [phone length])];
            [phone replaceOccurrencesOfString:@","
                                   withString:@","
                                      options:NSLiteralSearch
                                        range:NSMakeRange(0, [phone length])];
            [phone replaceOccurrencesOfString:@"*"
                                   withString:@","
                                      options:NSLiteralSearch
                                        range:NSMakeRange(0, [phone length])];
            tempActionContent = [NSString stringWithString:phone];
            break;
        }
        case PPURLControllerType_Email:
        {
            contactActionType = ContactActionType_EMail;
            needCheckNetwork = YES;
            
            // 如果是寄信要檢查是否可以寄送
            if([PPMailComposeViewController canSendMail]==NO)
            {
                [WCToastController showMessageToastFromSuperView:coverFlowViewController.view
                                                     withMessage:WCCFC_NotSettingEmail
                                                        position:PPToastPositionCenter];
                return ;
            }
            break;
        }
        case PPURLControllerType_GoogleMap:
        case PPURLControllerType_BaiduMap:
        case PPURLControllerType_NaviCon:
        {
            contactActionType = ContactActionType_Map;
            needCheckNetwork = YES;
            
            //////////////////////////////////////////////////
            // navicon 參數不同
            if (actionType==PPURLControllerType_NaviCon)
            {
                tempActionContent = [PPURLController parameterForNaviConWithAddress:tempActionContent
                                                                            appName:@"UX0pU2eo"
                                                                              title:tempActionContent
                                                                               text:nil];
            }
            
            break;
        }
        default:
            return ;
    }

    if (needCheckNetwork)
    {
        if ([PPNetworkReachabilityController checkForInternetConnection]==NO)
        {
            [WCToastController showMessageToastFromSuperView:coverFlowViewController.view
                                                 withMessage:WCCFC_PleaseConnectNetwork
                                                    position:PPToastPositionCenter];
            return ;
        }
    }
    
    //////////////////////////////////////////////////
    // !! 執行動作
    [PPURLController showFromViewController:coverFlowViewController
                                withURLType:actionType
                                  parameter:tempActionContent];
    
    //////////////////////////////////////////////////
#if defined (PRODUCTLINE_WCSF)
    // MARK: Matomo log (phone, sms, email)
    WCSFMatomoController_ContactAction action = WCSFMatomoController_ContactAction_None;
    switch (actionType)
    {
        case PPURLControllerType_Tel:
        {
            action = WCSFMatomoController_ContactAction_Phone;
            break;
        }
        case PPURLControllerType_SMS:
        {
            action = WCSFMatomoController_ContactAction_Message;
            break;
        }
        case PPURLControllerType_Email:
        {
            action = WCSFMatomoController_ContactAction_Email;
            break;
        }
        default:
            break;
    }
    
    if(action!=WCSFMatomoController_ContactAction_None)
    {
        [WCSFMatomoController sendContactActionLogWithAction:action];
    }
    
#endif
    //////////////////////////////////////////////////
    // 記錄動作
    if (recordAction)
    {
#if defined (PRODUCTLINE_WCT)
        // MARK: !! matomo log (email, map, skype)
        WCTMatomoController_Feature feature = WCTMatomoController_Feature_None;
        switch (contactActionType)
        {
            case ContactActionType_EMail:
            {
                feature = WCTMatomoController_Feature_Email;
                break;
            }
            case ContactActionType_Map:
            {
                feature = WCTMatomoController_Feature_Map;
                break;
            }
            case ContactActionType_Skype:
            {
                feature = WCTMatomoController_Feature_Skype;
                break;
            }
            default:
                break;
        }
        
        if(feature!=WCTMatomoController_Feature_None)
        {
            [WCTMatomoController sendLogWithFeature:feature];
        }
#endif
        
        [self reportRecentAction:contactActionType content:tempActionContent cardID:cardID];
    }
}



@end
