//
//  ContactViewController.m
//
//  Created by Howard.Lin on 13/10/29.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "WCContactViewController.h"
#import "PPMakeVirtualCardController.h"
#import "UIImage+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCContactViewController ()

@property (nonatomic,retain) UIImage *defaultCardImage;
@property (nonatomic,retain) UIImage *displayFrontCardImage;
@property (nonatomic,retain) UIImage *displayBackCardImage;
@property (nonatomic,retain) UIImage *displayHeadImage;
@property (nonatomic,retain) UIImage *originalHeadImage;
@property (atomic,retain)    UIImage *originalBackCardImage;
@property (atomic,retain)    UIImage *originalFrontCardImage;
@property (nonatomic,retain) NSMutableDictionary *imageStateDictionary;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCContactViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        _showFrontCard = YES;

        //////////////////////////////////////////////////
        
        PPMakeVirtualCardController *makeVirtualCardController = [[PPMakeVirtualCardController alloc] init];
        
        _defaultCardImage = [[makeVirtualCardController virtualCardImage] retain];
        
        [makeVirtualCardController release];
        
        //////////////////////////////////////////////////
        
        _imageStateDictionary = [[NSMutableDictionary alloc] init];
        
        [self resetImageStateDictionary];
        
        //////////////////////////////////////////////////
        
        //預設支持Portrait direction
        self.ppInterfaceOrientationController.mask = PPInterfaceOrientationControllerMask_Portrait;
        
        //////////////////////////////////////////////////
        
        _backCardRecognitionLanguage  = defaultCardRecognitionLanguage; //預設為-1，代表抓系統語系當成辨識語系
        _frontCardRecognitionLanguage = defaultCardRecognitionLanguage;
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _contactDataExchangeProtocol = nil;
    _contactImageProtocol = nil;
    
    [_userInfoObject release];
    _userInfoObject = nil;

    [_ppBusyView removeFromSuperview];
    [_ppBusyView release];
    _ppBusyView = nil;
    
    [_topButtonsActionSheet setDelegate:nil];
    [_topButtonsActionSheet removeFromSuperview];
    [_topButtonsActionSheet release];
    _topButtonsActionSheet = nil;
    
    [_defaultCardImage release];
    _defaultCardImage = nil;
    
    [_originalHeadImage release];
    _originalHeadImage = nil;
    
    [_displayBackCardImage release];
    _displayBackCardImage = nil;
    
    [_displayFrontCardImage release];
    _displayFrontCardImage = nil;
    
    [_displayHeadImage release];
    _displayHeadImage = nil;

    [_imageStateDictionary removeAllObjects];
    [_imageStateDictionary release];
    _imageStateDictionary = nil;

    self.originalFrontCardImage = nil;
    self.originalBackCardImage = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)setDefaultCardImage:(UIImage *)defaultCardImage
{
    if (defaultCardImage==nil)
    {
        PPMakeVirtualCardController *makeVirtualCardController = [[PPMakeVirtualCardController alloc] init];
        defaultCardImage = [makeVirtualCardController virtualCardImage];
        [makeVirtualCardController release];
    }
    
    UIImage *tempImage = [defaultCardImage retain];
    [_defaultCardImage release];
    _defaultCardImage = tempImage;
    
    if(self.defaultCardImage!=nil)
    {
        [self.contactImageProtocol setContactFrontCardImage:self.defaultCardImage];
    }
}


//================================================================================
//
//================================================================================
- (void)setBackCardImage:(UIImage *)backCardImage
{
    self.displayBackCardImage = backCardImage;
    
    if(self.displayBackCardImage!=nil)
    {
        [self.contactImageProtocol setContactRearCardImage:self.displayBackCardImage];
    }
}


//================================================================================
//
//================================================================================
- (void)setFrontCardImage:(UIImage *)frontCardImage
{
    self.displayFrontCardImage = frontCardImage;
    
    if(self.displayFrontCardImage!=nil && self.showFrontCard==YES)
    {
        [self.contactImageProtocol setContactFrontCardImage:self.displayFrontCardImage];
    }
}


//================================================================================
//
//================================================================================
- (void)resetImageStateDictionary
{
    if(_imageStateDictionary!=nil)
    {
        [self setContactViewControllerImageState:WCContactViewControllerImageState_None forPPContactSubType:PPContactSubType_HeadImage_Original];
        [self setContactViewControllerImageState:WCContactViewControllerImageState_None forPPContactSubType:PPContactSubType_HeadImage_Medium];
        [self setContactViewControllerImageState:WCContactViewControllerImageState_None forPPContactSubType:PPContactSubType_HeadImage_Thumbnail];
        
        //////////////////////////////////////////////////
        
        [self setContactViewControllerImageState:WCContactViewControllerImageState_None forPPContactSubType:PPContactSubType_FrontCardImage_Medium];
        [self setContactViewControllerImageState:WCContactViewControllerImageState_None forPPContactSubType:PPContactSubType_FrontCardImage_Original];
        [self setContactViewControllerImageState:WCContactViewControllerImageState_None forPPContactSubType:PPContactSubType_FrontCardImage_Thumbnail];

        //////////////////////////////////////////////////
        
        [self setContactViewControllerImageState:WCContactViewControllerImageState_None forPPContactSubType:PPContactSubType_BackCardImage_Medium];
        [self setContactViewControllerImageState:WCContactViewControllerImageState_None forPPContactSubType:PPContactSubType_BackCardImage_Original];
        [self setContactViewControllerImageState:WCContactViewControllerImageState_None forPPContactSubType:PPContactSubType_BackCardImage_Thumbnail];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method For Inheriting


//================================================================================
//
//================================================================================
- (void)fetchContactCardImagesData
{
    
}


//================================================================================
//
//================================================================================
- (void)fetchContactHeadImagesData
{
    
}


//================================================================================
//
//================================================================================
- (void)setContactHeadImage:(UIImage *)contactHeadImage
{
    self.displayHeadImage = contactHeadImage;
}


//================================================================================
//
//================================================================================
- (void)setContactCardImage:(UIImage *)contactCardImage
{
    
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)clearImageForPPContactMainType:(PPContactMainType)contactMainType ppContactSubType:(PPContactSubType)contactSubType
{
    switch (contactMainType)
    {
        case PPContactMainType_HeadImage:
        {
            if(contactSubType==PPContactSubType_HeadImage_Thumbnail)
            {
                self.displayHeadImage = nil;
            }
            else if(contactSubType==PPContactSubType_HeadImage_Original)
            {
                self.originalHeadImage = nil;
            }
            
            break;
        }
        case PPContactMainType_FrontCardImage:
        {
            if(contactSubType==PPContactSubType_FrontCardImage_Thumbnail)
            {
                self.displayFrontCardImage = nil;
            }
            else if(contactSubType==PPContactSubType_FrontCardImage_Original)
            {
                self.originalFrontCardImage = nil;
            }
            
            break;
        }
        case PPContactMainType_BackCardImage:
        {
            if(contactSubType==PPContactSubType_BackCardImage_Thumbnail)
            {
                self.displayBackCardImage = nil;
            }
            else if(contactSubType==PPContactSubType_BackCardImage_Original)
            {
                self.originalBackCardImage = nil;
            }
            
            break;
        }
        default:
        {
            break;
        }
    }
}


//================================================================================
//
//================================================================================
- (BOOL)setImage:(UIImage *)image forPPContactMainType:(PPContactMainType)contactMainType ppContactSubType:(PPContactSubType)contactSubType
{
    BOOL result = NO;
    
    do
    {
        switch (contactMainType)
        {
            case PPContactMainType_HeadImage:
            {
                [self setContactHeadImage:image];
                
                //////////////////////////////////////////////////
                
                if(contactSubType==PPContactSubType_HeadImage_Original &&
                   self.originalHeadImage!=image)
                {
                    self.originalHeadImage = image;
                    
                    //////////////////////////////////////////////////

                    [self updateImageStateWithImage:image contactSubType:contactSubType];
                }
                
                //////////////////////////////////////////////////
                
                result = YES;

                break;
            }
            case PPContactMainType_FrontCardImage:
            {
                //設定預設圖
                if(contactSubType==PPContactSubType_FrontCardImage_Default)
                {
                    [self setDefaultCardImage:image];
                }
                else
                {
                    if(contactSubType==PPContactSubType_FrontCardImage_Original)
                    {
                        if(self.originalFrontCardImage!=image)
                        {
                            if(image.imageOrientation!=UIImageOrientationUp)
                            {
                                self.originalFrontCardImage = [image imageRotatedByDegrees:0];
                            }
                            else
                            {
                                self.originalFrontCardImage = image;
                            }
                            
                            //////////////////////////////////////////////////
                            
                            [self updateImageStateWithImage:image contactSubType:contactSubType];
                        }
                    
                        //////////////////////////////////////////////////
                        
                        if(image!=nil)
                        {
                            [self setFrontCardImage:image];
                        }
                    }
                    else
                    {
                        [self setFrontCardImage:image];
                    }
                    
                    //////////////////////////////////////////////////
                    
                    result = YES;
                }
                
                break;
            }
            case PPContactMainType_BackCardImage:
            {
                if(contactSubType==PPContactSubType_BackCardImage_Original)
                {
                    if(self.originalBackCardImage!=image)
                    {
                        if(image.imageOrientation!=UIImageOrientationUp)
                        {
                            self.originalBackCardImage = [image imageRotatedByDegrees:0];
                        }
                        else
                        {
                            self.originalBackCardImage = image;
                        }

                        //////////////////////////////////////////////////
                        
                        [self updateImageStateWithImage:image contactSubType:contactSubType];
                    }
                    
                    //////////////////////////////////////////////////
                    
                    //顯示小圖不存在，設定顯示名片圖為大圖
                    if(image!=nil)
                    {
                        [self setBackCardImage:image];
                    }
                }
                else
                {
                    [self setBackCardImage:image];
                }
                
                //////////////////////////////////////////////////
                
                result = YES;
                
                break;
            }
            default:
            {
                break;
            }
        }
        
    } while (0);
    
    //////////////////////////////////////////////////
    
    return result;
}


//================================================================================
//
//================================================================================
- (UIImage *)imageForPPContactMainType:(PPContactMainType)contactMainType ppContactSubType:(PPContactSubType)contactSubType
{
    UIImage *image = nil;
    
    switch (contactMainType)
    {
        case PPContactMainType_HeadImage:
        {
            if(contactSubType==PPContactSubType_HeadImage_Thumbnail)
            {
                image = self.displayHeadImage;
            }
            else if(contactSubType==PPContactSubType_HeadImage_Original)
            {
                image = self.originalHeadImage;
            }
            
            break;
        }
        case PPContactMainType_FrontCardImage:
        {
            if(contactSubType==PPContactSubType_FrontCardImage_Thumbnail)
            {
                image = self.displayFrontCardImage;
            }
            else if(contactSubType==PPContactSubType_FrontCardImage_Original)
            {
                image = self.originalFrontCardImage;
            }
            else if(contactSubType==PPContactSubType_FrontCardImage_Default)
            {
                image = self.defaultCardImage;
            }
            
            break;
        }
        case PPContactMainType_BackCardImage:
        {
            if(contactSubType==PPContactSubType_BackCardImage_Thumbnail)
            {
                image = self.displayBackCardImage;
            }
            else if(contactSubType==PPContactSubType_BackCardImage_Original)
            {
                image = self.originalBackCardImage;
            }
            break;
        }
        default:
        {
            break;
        }
    }
    
    //////////////////////////////////////////////////
    
    return image;
}


//================================================================================
//
//================================================================================
- (void)deleteHeadImage
{
    [self setImage:nil forPPContactMainType:PPContactMainType_HeadImage ppContactSubType:PPContactSubType_HeadImage_Original];
    
    [self setImage:nil forPPContactMainType:PPContactMainType_HeadImage ppContactSubType:PPContactSubType_HeadImage_Thumbnail];
}


//===============================================================================
//
//===============================================================================
- (void)showBusyView:(BOOL)show withSuperView:(UIView *)superView
{
    if(show==YES)
    {
        if(self.ppBusyView==nil)
        {
            _ppBusyView = [[PPBusyView alloc] initWithSuperView:superView];
        }
    }
    else
    {
        [self.ppBusyView removeFromSuperview];
        self.ppBusyView = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instace ImageState Method

//================================================================================
//
//================================================================================
- (void)setContactViewControllerImageState:(WCContactViewControllerImageState)contactViewControllerImageState
                       forPPContactSubType:(PPContactSubType)contactSubType
{
    if(_imageStateDictionary!=nil)
    {
        [_imageStateDictionary setObject:[NSNumber numberWithUnsignedInteger:contactViewControllerImageState]
                                  forKey:[NSNumber numberWithUnsignedInteger:contactSubType]];
    }
}


//================================================================================
//
//================================================================================
- (WCContactViewControllerImageState)contactViewControllerImageStateForPPContactSubType:(PPContactSubType)contactSubType
{
    WCContactViewControllerImageState contactViewControllerImageState = WCContactViewControllerImageState_None;
    
    if(_imageStateDictionary!=nil && _imageStateDictionary.count>0)
    {
        contactViewControllerImageState = [[_imageStateDictionary objectForKey:[NSNumber numberWithUnsignedInteger:contactSubType]] unsignedIntegerValue];
    }
    
    return contactViewControllerImageState;
}


//================================================================================
//
//================================================================================
- (void)updateImageStateWithImage:(UIImage *)image contactSubType:(PPContactSubType)contactSubType
{
    if(contactSubType!=PPContactSubType_FrontCardImage_Default)
    {
        WCContactViewControllerImageState existImageState = [[self.imageStateDictionary objectForKey:[NSNumber numberWithUnsignedInteger:contactSubType]] unsignedIntegerValue];
        
        if(image!=nil)
        {
            //第一次設定圖
            if(existImageState==WCContactViewControllerImageState_None)
            {
                [self setContactViewControllerImageState:WCContactViewControllerImageState_Exist
                                     forPPContactSubType:contactSubType];
            }
            //沒圖設定成有圖  or 有圖設定成有圖
            else
            {
                [self setContactViewControllerImageState:WCContactViewControllerImageState_Changed
                                     forPPContactSubType:contactSubType];
            }
            
        }
        else
        {
            //第一次設定圖
            if(existImageState==WCContactViewControllerImageState_None)
            {
                [self setContactViewControllerImageState:WCContactViewControllerImageState_NoneExist
                                     forPPContactSubType:contactSubType];
            }
            //有圖設定成沒圖
            else if(existImageState==WCContactViewControllerImageState_Exist)
            {
                [self setContactViewControllerImageState:WCContactViewControllerImageState_Changed
                                     forPPContactSubType:contactSubType];
            }
            //沒圖設定成沒圖
            else
            {
                
            }
        }
    }
}
@end
