//
//  ContactViewController.h
//
//  Created by Howard.Lin on 13/10/29.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>

// Define
#import "PPContactMainTypeDefine.h"
#import "PPContactSubTypeDefine.h"
#import "ContactImageProtocol.h"

// Model
#import "ContactDataExchangeModel.h"

// View
#import "PPBusyView.h"
#import "PPTopButtonsActionSheet.h"
#import "PPImageScrollView.h"

// Controller
#import "PPViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static CGFloat const cardImageScrollViewHeight = 50;

////////////////////////////////////////////////////////////////////////////////////////////////////

// EN_LANG see namecard.h
static NSInteger const defaultCardRecognitionLanguage = 3;

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCContactViewControllerImageState)
{
    WCContactViewControllerImageState_None,
    WCContactViewControllerImageState_NoneExist,
    WCContactViewControllerImageState_Exist,
    WCContactViewControllerImageState_Changed,
};

typedef NS_ENUM(NSUInteger, WCContactViewControllerDataState)
{
    WCContactViewControllerDataState_None,
    WCContactViewControllerDataState_NotExist,
    WCContactViewControllerDataState_Exist,
    WCContactViewControllerDataState_EmptyData
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCContactViewController : PPViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign)   id<ContactDataExchangeProtocol>      contactDataExchangeProtocol;
@property (nonatomic,assign)   id<ContactImageProtocol>             contactImageProtocol;
@property (nonatomic,retain)   id                                   userInfoObject;
@property (nonatomic,retain)   PPBusyView                           *ppBusyView;
@property (nonatomic,retain)   PPTopButtonsActionSheet              *topButtonsActionSheet;
@property (nonatomic,assign)   BOOL                                 showBottomCardImage;
@property (nonatomic,assign)   BOOL                                 showFrontCard;
@property (nonatomic,assign)   BOOL                                 phoneAutoFormat;
@property (nonatomic,assign)   BOOL                                 phoneAppendCountryCode;
@property (nonatomic,assign)   NSInteger                            backCardRecognitionLanguage;
@property (nonatomic,assign)   NSInteger                            frontCardRecognitionLanguage;

@property (atomic, assign)     WCContactViewControllerDataState     dataState;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method For Inheriting


/**
 *  To fetch contact Card image data from contactDataExchangeProtocol
 */
- (void)fetchContactCardImagesData;

/**
 *  To fetch contact Head image data from contactDataExchangeProtocol
 */
- (void)fetchContactHeadImagesData;

/**
 * To set headImage
 *
 * @param contactHeadImage The headImage you want to set
 */
- (void)setContactHeadImage:(UIImage *)contactHeadImage;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 * To CLEAR image for PPContactMainType and PPContactSubType
 * @param contactMainType The contactMainType you want to select
 * @param contactSubType The contactSubType you want to select
 */
- (void)clearImageForPPContactMainType:(PPContactMainType)contactMainType ppContactSubType:(PPContactSubType)contactSubType;


/**
 * To set image for PPContactMainType and PPContactSubType
 * @param image The image you want to set
 * @param contactMainType The contactMainType you want to select
 * @param contactSubType The contactSubType you want to select
 * @return: If return Yes, set image successful
 */
- (BOOL)setImage:(UIImage *)image forPPContactMainType:(PPContactMainType)contactMainType ppContactSubType:(PPContactSubType)contactSubType;


/**
 * To get image for PPContactMainType and PPContactSubType
 * @param contactMainType The contactMainType you want to select
 * @param contactSubType The contactSubType you want to select
 * @return: If return Yes, the image for PPContactMainType and PPContactSubType
 */
- (UIImage *)imageForPPContactMainType:(PPContactMainType)contactMainType ppContactSubType:(PPContactSubType)contactSubType;


/**
 * To delete head Image
 */
- (void)deleteHeadImage;


/**
 * To show ppBusyView or no
 * @param show The parameter you have to set to show ppBusyView or no
 * @param superView The superView in which ppBusyView locates. If you set a nil superview, we assume that superView is a rootView.
 */
- (void)showBusyView:(BOOL)show withSuperView:(UIView *)superView;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance ImageState Method

- (void)setContactViewControllerImageState:(WCContactViewControllerImageState)contactViewControllerImageState
                       forPPContactSubType:(PPContactSubType)contactSubType;


- (WCContactViewControllerImageState)contactViewControllerImageStateForPPContactSubType:(PPContactSubType)contactSubType;

- (void)updateImageStateWithImage:(UIImage *)image
                   contactSubType:(PPContactSubType)contactSubType;

@end
