//
//  ContactDataExchangeModel.m
//
//  Created by Howard.Lin on 13/10/17.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "ContactDataExchangeModel.h"

@implementation ContactDataExchangeModel


////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self = [super init])
    {
        _imageRectDictionary = [[NSMutableDictionary alloc] init];
        _propertyDictionary  = [[NSMutableDictionary alloc] init];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_imageRectDictionary removeAllObjects];
    [_imageRectDictionary release];
    _imageRectDictionary = nil;
    
    [_propertyDictionary removeAllObjects];
    [_propertyDictionary release];
    _propertyDictionary = nil;
    
    [_labelText release];
    _labelText = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (ContactDataExchangeModel *)contactDataExchangeModelCopyFromContactDataExchangeModel:(ContactDataExchangeModel *)contactDataExchangeModel
{
    ContactDataExchangeModel *newContactDataExchangeModel = [[ContactDataExchangeModel alloc] init];
    
    for(id key in contactDataExchangeModel.imageRectDictionary.allKeys)
    {
        [newContactDataExchangeModel.imageRectDictionary setObject:[contactDataExchangeModel.imageRectDictionary objectForKey:key] forKey:key];
    }
    
    for(id key in contactDataExchangeModel.propertyDictionary.allKeys)
    {
        [newContactDataExchangeModel.propertyDictionary setObject:[contactDataExchangeModel.propertyDictionary objectForKey:key] forKey:key];
    }
    
    newContactDataExchangeModel.contactFieldSource = contactDataExchangeModel.contactFieldSource;
    newContactDataExchangeModel.labelType = contactDataExchangeModel.labelType;
    newContactDataExchangeModel.labelText = contactDataExchangeModel.labelText;

    return [newContactDataExchangeModel autorelease];
}
@end
