//
//  ContactLabelTableViewCell.m
//
//  Created by Howard.Lin on 13/11/14.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "ContactLabelTableViewCell.h"
#import "ContactApperanceDefine.h"
#import "UIColor+Contact.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define ContactLabelTableViewCell_ImageViewTableViewCellTopMargin 12
#define ContactLabelTableViewCell_ImageViewTableViewCellLeftMargin 15
#define ContactLabelTableViewCell_DetailLabelHeight 20

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ContactLabelTableViewCell()
{
    @private
     BOOL showValueTextLabel_;
}
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ContactLabelTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize showValueTextLabel = showValueTextLabel_;




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if((self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        if(valueTextLabel_!=nil)
        {
            valueTextLabel_.dataSource = self;
            valueTextLabel_.userInteractionEnabled = YES;
        }
        
        //////////////////////////////////////////////////
        
        showValueTextLabel_ = YES;
    }
    
    return self;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout Of View

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];

    //////////////////////////////////////////////////

    if(self.showValueTextLabel==YES)
    {
        CGRect textLabelFrame = self.textLabel.frame;
        
        textLabelFrame.size.width = ContactTableViewCellLabelWidth;
        
        self.textLabel.frame = textLabelFrame;

        //////////////////////////////////////////////////
        
        CGRect valueTextLabelFrame = self.valueTextLabel.frame;

        if (self.style==UITableViewCellStyleDefault)
        {
            if (self.imageView.image!=nil)
            {
                if (self.frame.size.height<=ContactLabelTableViewCellImageViewSize.height+ContactLabelTableViewCellDetailHeight)
                {
                    CGPoint imageViewCenter = self.imageView.center;
                    CGRect imageViewFrame = self.imageView.frame;
                    imageViewFrame.origin.y = imageViewCenter.y-ContactLabelTableViewCellImageViewSize.height/2;
                    imageViewFrame.size.width = ContactLabelTableViewCellImageViewSize.width;
                    imageViewFrame.size.height = ContactLabelTableViewCellImageViewSize.height;
                    self.imageView.frame = imageViewFrame;
                }
                else
                {
                    CGRect imageViewFrame = self.imageView.frame;
                    imageViewFrame.origin.y = imageViewFrame.origin.y+ContactLabelTableViewCell_ImageViewTableViewCellTopMargin;
                    imageViewFrame.size.width = ContactLabelTableViewCellImageViewSize.width;
                    imageViewFrame.size.height = ContactLabelTableViewCellImageViewSize.height;
                    self.imageView.frame = imageViewFrame;
                }
            }
            
            valueTextLabelFrame.origin.x   = self.imageView.frame.origin.x+self.imageView.frame.size.width+ContactLabelTableViewCell_ImageViewTableViewCellLeftMargin;
            valueTextLabelFrame.size.width -=(self.imageView.frame.size.width+ContactLabelTableViewCell_ImageViewTableViewCellLeftMargin);
        }
        else if(self.style==UITableViewCellStyleSubtitle)
        {
            if (self.imageView.image!=nil)
            {
                CGRect imageViewFrame = self.imageView.frame;
                imageViewFrame.origin.y = imageViewFrame.origin.y+ContactLabelTableViewCell_ImageViewTableViewCellTopMargin;
                imageViewFrame.size.width = ContactLabelTableViewCellImageViewSize.width;
                imageViewFrame.size.height = ContactLabelTableViewCellImageViewSize.height;
                self.imageView.frame = imageViewFrame;
            }
            
            valueTextLabelFrame.origin.x   = self.imageView.frame.origin.x+self.imageView.frame.size.width+ContactLabelTableViewCell_ImageViewTableViewCellLeftMargin;
            valueTextLabelFrame.size.width -=(self.imageView.frame.size.width+ContactLabelTableViewCell_ImageViewTableViewCellLeftMargin*2);
            
            CGRect detetailLabelFrame = self.detailTextLabel.frame;
            detetailLabelFrame.origin.x  = valueTextLabelFrame.origin.x;
            detetailLabelFrame.size.width = valueTextLabelFrame.size.width;

            //////////////////////////////////////////////////
            
            if(self.contentView.bounds.size.height>2*ContactLabelTableViewCellDetailHeight)
            {
                valueTextLabelFrame.size.height = self.contentView.bounds.size.height-ContactLabelTableViewCell_DetailLabelHeight;
            }
            
            if(self.contentView.bounds.size.height>2*ContactLabelTableViewCellDetailHeight)
            {
                detetailLabelFrame.size.height = ContactLabelTableViewCell_DetailLabelHeight;
                detetailLabelFrame.origin.y    = self.contentView.bounds.size.height-detetailLabelFrame.size.height;
            }
            
            self.detailTextLabel.frame = detetailLabelFrame;
        }
        else
        {
            valueTextLabelFrame.origin.x   = textLabelFrame.origin.x + textLabelFrame.size.width +ContactTableViewCellContentEdgeInset.left*2;
            
            valueTextLabelFrame.size.width = self.contentView.bounds.size.width - ContactTableViewCellContentEdgeInset.right - valueTextLabelFrame.origin.x;
        }
        
        self.valueTextLabel.frame = valueTextLabelFrame;
    }
    else
    {
        self.textLabel.frame = CGRectMake(self.textLabel.frame.origin.x, self.textLabel.frame.origin.y, self.contentView.bounds.size.width-self.textLabel.frame.origin.x*2,self.textLabel.frame.size.height);
        
        //////////////////////////////////////////////////
        
        self.valueTextLabel.frame = CGRectZero;
    }
  
}

@end
