//
//  TranslateNavigationBarButton.m
//  Pods
//
//  Created by AndrewLai on 2015/10/7.
//
//

#import "TranslateNavigationBarButton.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define TranslateNavigationBarButton_ImageViewRect CGRectMake(0, 0, 16, 16)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - TranslateNavigationBarButton Extension

@interface TranslateNavigationBarButton ()
@property (nonatomic, retain) UIImageView *moreLanguageImageView;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - TranslateNavigationBarButton Implementation

@implementation TranslateNavigationBarButton

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame buttonImageName:(NSString *)imageName languageText:(NSString *)languageText
{
    if (self=[super initWithFrame:frame])
    {        
        [self setTitleEdgeInsets:UIEdgeInsetsMake(0, 0, 0, TranslateNavigationBarButton_ImageViewRect.size.width)];
        [self setTitle:languageText maxWidth:0];

        //////////////////////////////////////////////////
        
        _moreLanguageImageView = [[UIImageView alloc] initWithFrame:TranslateNavigationBarButton_ImageViewRect];
        if (self.moreLanguageImageView!=nil)
        {
            self.moreLanguageImageView.image = [UIImage imageWithName:imageName forState:UIControlStateNormal];
            self.moreLanguageImageView.highlightedImage = [UIImage imageWithName:imageName forState:UIControlStateHighlighted];
            
            [self addSubview:self.moreLanguageImageView];
        }
        
        //////////////////////////////////////////////////
        // Button Events
        
        [self addTarget:self action:@selector(onButtonClick:) forControlEvents:UIControlEventTouchUpInside];
        [self addTarget:self action:@selector(onButtonTouchDown:) forControlEvents:UIControlEventTouchDown];
        [self addTarget:self action:@selector(onButtonTouchDragEnter:) forControlEvents:UIControlEventTouchDragEnter];
        [self addTarget:self action:@selector(onButtonTouchDragExit:) forControlEvents:UIControlEventTouchDragExit];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_moreLanguageImageView removeFromSuperview];
    [_moreLanguageImageView release];
    _moreLanguageImageView = nil;
    
    [_languageTextColorHighlighted release];
    _languageTextColorHighlighted = nil;
    
    [_languageTextColorNormal release];
    _languageTextColorNormal = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}


//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    self.moreLanguageImageView.center = CGPointMake(self.bounds.size.width/2, self.bounds.size.height/2);
    
    CGRect imageFrame = self.moreLanguageImageView.frame;
    imageFrame.origin.x = self.bounds.size.width-imageFrame.size.width;
    self.moreLanguageImageView.frame = imageFrame;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overrid Method

//================================================================================
//
//================================================================================
- (void)setLanguageTextColorHighlighted:(UIColor *)languageTextColorHighlighted
{
    [_languageTextColorHighlighted release];
    _languageTextColorHighlighted = [languageTextColorHighlighted retain];
    
    //////////////////////////////////////////////////
    
    self.titleLabel.highlightedTextColor = languageTextColorHighlighted;
}


//================================================================================
//
//================================================================================
- (void)setLanguageTextColorNormal:(UIColor *)languageTextColorNormal
{
    [_languageTextColorNormal release];
    _languageTextColorNormal = [languageTextColorNormal retain];
    
    //////////////////////////////////////////////////
    
    self.titleLabel.textColor = languageTextColorNormal;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Button Event

//================================================================================
//
//================================================================================
- (void)onButtonClick:(id)sender
{
    self.titleLabel.highlighted = NO;
    self.moreLanguageImageView.highlighted = NO;
}


//================================================================================
//
//================================================================================
- (void)onButtonTouchDown:(id)sender
{
    self.titleLabel.highlighted = YES;
    self.moreLanguageImageView.highlighted = YES;
}


//================================================================================
//
//================================================================================
- (void)onButtonTouchDragEnter:(id)sender
{
    self.titleLabel.highlighted = YES;
    self.moreLanguageImageView.highlighted = YES;
}


//================================================================================
//
//================================================================================
- (void)onButtonTouchDragExit:(id)sender
{
    self.titleLabel.highlighted = NO;
    self.moreLanguageImageView.highlighted = NO;
}

@end
