//
//  ContactTranslateNavigationBarView.m
//
//  Created by Howard.Lin on 13/12/24.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "ContactTranslateNavigationBarView.h"
#import "NSString+Additions.h"
#import "UIColor+HexString.h"

// Define
#import "WCAppearanceDefine.h"
#import "WCContactViewController+ResourceDefine.h"
#import "WCContactInfoViewController+ResouceDefine.h"

// UIView Extension
#import "PPButton+Factory.h"
#import "TranslateNavigationBarButton.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ContactTranslateNavigationBarView ()
@property (nonatomic, retain) PPButton *backButton;
@property (nonatomic, retain) TranslateNavigationBarButton *sourceLanguageButton;
@property (nonatomic, retain) PPButton *assignButton;
@property (nonatomic, retain) TranslateNavigationBarButton *destinationLanguageButton;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ContactTranslateNavigationBarView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    
    if (self)
    {
        // Initialization code
        self.backgroundColor    = [UIColor clearColor];
        self.style              = PPBarViewStyle_CenteredAbsolute;
        
        NSMutableArray *viewItemArray = [NSMutableArray array];
        
        //////////////////////////////////////////////////
        // 左側按鈕區塊
        
        _backButton = [[PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                       tag:ContactTranslateNavigationBarViewButtonTag_Back
                                                  delegate:self
                                     normalBackgroundColor:nil
                                highlightedBackgroundColor:[UIColor colorWithHexString:@"#2c538f"]
                                           imageEdgeInsets:UIEdgeInsetsMake(10, 10, 10, 10)] retain];
        if (self.backButton!=nil)
        {
            [self.backButton addControlEvents:UIControlEventTouchUpInside];
            
            //////////////////////////////////////////////////
            
            PPBarViewItemModel *backItemModel  = [PPBarViewItemModel ppBarViewItemModelWithView:self.backButton];
            if (backItemModel!=nil)
            {
                backItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                [viewItemArray addObject:backItemModel];
            }
            
            self.titleLabel.textAlignment = NSTextAlignmentLeft;
            
            PPBarViewItemModel *titleItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.titleLabel];
            if(titleItemModel!=nil)
            {
                titleItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                [viewItemArray addObject:titleItemModel];
            }
            
            [self setItemModels:viewItemArray forBlockType:PPBarViewBlockType_Left];
        }
        
        //////////////////////////////////////////////////
        // 創建右側翻譯頁面
        
        NSMutableArray *rightCapabilitys = [NSMutableArray array];
        if (rightCapabilitys!=nil)
        {
            _sourceLanguageButton = [[TranslateNavigationBarButton alloc] initWithFrame:CGRectZero buttonImageName:@"WCContactInfoViewControllerButtonMoreLanguage" languageText:@"繁體中文"];
            if(self.sourceLanguageButton!=nil)
            {
                self.sourceLanguageButton.delegate = self;
                self.sourceLanguageButton.tag      = ContactTranslateNavigationBarViewButtonTag_SourceLanguage;
                
                [self.sourceLanguageButton addControlEvents:UIControlEventTouchUpInside];
                
                //////////////////////////////////////////////////
                
                PPBarViewItemModel *sourceItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.sourceLanguageButton];
                if(sourceItemModel!=nil)
                {
                    sourceItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                    [rightCapabilitys addObject:sourceItemModel];
                }
            }
            
            //////////////////////////////////////////////////
            
            _assignButton = [[PPButton ppButtonWithIconImageName:ImageNameWCContactInfoViewControllerNavigationBarButtonLanguageArrow
                                                             tag:ContactTranslateNavigationBarViewButtonTag_Assign
                                                        delegate:self
                                           normalBackgroundColor:nil
                                      highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                 imageEdgeInsets:WCContactViewControllerNavigationBarButtonImageEdgeInsets] retain];
            if(self.assignButton!=nil)
            {
                self.assignButton.enabled  = NO;
                
                [self.assignButton addControlEvents:UIControlEventTouchUpInside];
                
                //////////////////////////////////////////////////
                
                PPBarViewItemModel *assignItemModel  = [PPBarViewItemModel ppBarViewItemModelWithView:self.assignButton];
                if (assignItemModel!=nil)
                {
                    assignItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                    [rightCapabilitys addObject:assignItemModel];
                }
            }
            
            //////////////////////////////////////////////////
            
            _destinationLanguageButton = [[TranslateNavigationBarButton alloc] initWithFrame:CGRectZero buttonImageName:@"WCContactInfoViewControllerButtonMoreLanguage" languageText:@"繁體中文"];
            if(self.destinationLanguageButton!=nil)
            {
                self.destinationLanguageButton.delegate = self;
                self.destinationLanguageButton.tag      = ContactTranslateNavigationBarViewButtonTag_DestinationLanguage;
                
                [self.destinationLanguageButton addControlEvents:UIControlEventTouchUpInside];
                
                //////////////////////////////////////////////////
                
                PPBarViewItemModel *destinationItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.destinationLanguageButton];
                if(destinationItemModel!=nil)
                {
                    destinationItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                    [rightCapabilitys addObject:destinationItemModel];
                }
            }
            
            [self setItemModels:rightCapabilitys forBlockType:PPBarViewBlockType_Right];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.delegate = nil;
    
    [self.backButton removeFromSuperview];
    self.backButton.delegate = nil;
    self.backButton = nil;
    
    [self.sourceLanguageButton removeFromSuperview];
    self.sourceLanguageButton.delegate = nil;
    self.sourceLanguageButton = nil;
    
    [self.assignButton removeFromSuperview];
    self.assignButton.delegate = nil;
    self.assignButton = nil;
    
    [self.destinationLanguageButton removeFromSuperview];
    self.destinationLanguageButton.delegate = nil;
    self.destinationLanguageButton = nil;
    
    //////////////////////////////////////////////////
    
    [_sourceLanguageString release];
    _sourceLanguageString = nil;
    
    [_destinationLanguageString release];
    _destinationLanguageString = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}


//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    CGFloat assignButtonCenter = self.backButton.frame.origin.x+self.backButton.frame.size.width+(self.bounds.size.width-self.backButton.frame.size.width)/2;
    self.assignButton.center   = CGPointMake(assignButtonCenter, self.assignButton.center.y);
    
    CGFloat languageWidth = (self.bounds.size.width-self.backButton.frame.size.width-self.assignButton.frame.size.width)/2;
    
    CGRect destinationButtonFrame     = self.destinationLanguageButton.frame;
    destinationButtonFrame.origin.x   = self.assignButton.frame.origin.x+self.assignButton.frame.size.width;
    destinationButtonFrame.size.width = languageWidth;
    self.destinationLanguageButton.frame = destinationButtonFrame;
    
    CGRect sourceButtonFrame     = self.sourceLanguageButton.frame;
    sourceButtonFrame.size.width = languageWidth;
    sourceButtonFrame.origin.x   = self.assignButton.frame.origin.x-sourceButtonFrame.size.width;
    self.sourceLanguageButton.frame = sourceButtonFrame;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)setSourceLanguageString:(NSString *)sourceLanguageString
{
    [_sourceLanguageString release];
    _sourceLanguageString = [sourceLanguageString retain];
    
    //////////////////////////////////////////////////
    
    [self.sourceLanguageButton setTitle:[sourceLanguageString localized] maxWidth:0.0];
}


//================================================================================
//
//================================================================================
- (void)setDestinationLanguageString:(NSString *)destinationLanguageString
{
    [_destinationLanguageString release];
    _destinationLanguageString = [destinationLanguageString retain];
    
    //////////////////////////////////////////////////
    
    [self.destinationLanguageButton setTitle:[destinationLanguageString localized] maxWidth:0.0];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)showTranslateToolBar:(BOOL)isShow
{
    self.assignButton.hidden              = !(isShow);
    self.sourceLanguageButton.hidden      = !(isShow);
    self.destinationLanguageButton.hidden = !(isShow);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if([self.delegate respondsToSelector:@selector(contactTranslateNavigationBarView:ppButton:withControlEvent:)]==YES)
    {
        [self.delegate contactTranslateNavigationBarView:self ppButton:ppButton withControlEvent:controlEvent];
    }
}


@end
