//
//  ContactInfoNavigationBarView.m
//
//  Created by Howard.Lin on 13/12/24.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "ContactInfoNavigationBarView.h"

// Define
#import "WCAppearanceDefine.h"
#import "WCContactViewController+PrivateParameterDefine.h"
#import "WCContactViewController+ResourceDefine.h"
#import "WCContactInfoViewController+ResouceDefine.h"
#import "UIView+PPGuideController.h"

// Category
#import "NSString+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSUInteger ContactInfoNavigationBarView_TitleLabelLeftGapForBackButtomDismissed = 10;
CGFloat ContactInfoNavigationBarView_ContactNameShortPressDuration = 0.5;

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ContactInfoNavigationBarView ()
@property (nonatomic, assign) BOOL      isBackButtonShowed;
@property (nonatomic, retain) PPButton *backButton;
@property (nonatomic, retain) PPButton *favoriteButton;
@property (nonatomic, retain) PPButton *noteButton;
@property (nonatomic, retain) PPButton *otherButton;
@property (nonatomic, assign) ContactInfoNavigationBarViewMode mode;

@property (nonatomic, retain) UILongPressGestureRecognizer *shortPressGestureRecognizer;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ContactInfoNavigationBarView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame navigationBarMode:(ContactInfoNavigationBarViewMode)mode isBackButtonShowed:(BOOL)isBackShowed
{
    self = [super initWithFrame:frame];
    
    if (self)
    {
        // Initialization code
        self.backgroundColor    = [UIColor clearColor];
        self.style              = PPBarViewStyle_CenteredAbsolute;
        self.mode               = mode;
        self.isBackButtonShowed = isBackShowed;
        
        NSMutableArray *viewItemArray = [NSMutableArray array];
        
        //////////////////////////////////////////////////
        // 左側按鈕區塊
        
        if (self.isBackButtonShowed==YES)
        {
            _backButton = [[PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                           tag:ContactInfoNavigationBarViewButtonTag_Back
                                                      delegate:self
                                         normalBackgroundColor:nil
                                    highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                               imageEdgeInsets:WCContactViewControllerNavigationBarButtonImageEdgeInsets] retain];
            if(self.backButton!=nil)
            {
                [self.backButton addControlEvents:UIControlEventTouchUpInside];
                
                PPBarViewItemModel *backItemModel  = [PPBarViewItemModel ppBarViewItemModelWithView:self.backButton];
                if (backItemModel!=nil)
                {
                    backItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                    [viewItemArray addObject:backItemModel];
                }
            }
        }
        
        //////////////////////////////////////////////////
        //!! 必須adjustsFontSizeToFitWidth設定為NO，否則font.pointSize無法抓到正確大小
        
        [self addShortPressGestureRecognizer];
        self.titleLabel.userInteractionEnabled = YES;
        self.titleLabel.adjustsFontSizeToFitWidth = NO;
        self.titleLabel.textAlignment = NSTextAlignmentLeft;
        
        PPBarViewItemModel *titleItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.titleLabel];
        if(titleItemModel!=nil)
        {
            titleItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            [viewItemArray addObject:titleItemModel];
        }
        
        [self setItemModels:viewItemArray forBlockType:PPBarViewBlockType_Left];

        //////////////////////////////////////////////////
        // 右側按鈕區塊
        
        [viewItemArray removeAllObjects];
        
        // 我的最愛: 公司聯絡人，salesforce沒有
        if (self.mode!=ContactInfoNavigationBarViewMode_Company&&
            self.mode!=ContactInfoNavigationBarViewMode_Salesforce)
        {
            _favoriteButton = [[PPButton ppButtonWithIconImageName:ImageNameWCContactViewControllerNavigationBarButtonFavorite
                                                               tag:ContactInfoNavigationBarViewButtonTag_Favorite
                                                          delegate:self
                                             normalBackgroundColor:nil
                                        highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                   imageEdgeInsets:WCContactViewControllerNavigationBarButtonImageEdgeInsets] retain];
            if (self.favoriteButton!=nil)
            {
                self.favoriteButton.ppGuideIndex = PPGuideDataModel_GuideIndex_InfoFavoriteButton;
                [self.favoriteButton addControlEvents:UIControlEventTouchUpInside];
                
                PPBarViewItemModel *favoriteItemModel  = [PPBarViewItemModel ppBarViewItemModelWithView:self.favoriteButton];
                if (favoriteItemModel!=nil)
                {
                    favoriteItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                    [viewItemArray addObject:favoriteItemModel];
                }
            }
        }

        
        //////////////////////////////////////////////////
        //!! 我的最愛是否可按下        
        if (self.mode==ContactInfoNavigationBarViewMode_Duplicate)
        {
            self.favoriteButton.userInteractionEnabled = NO;
        }
        else
        {
            self.favoriteButton.userInteractionEnabled = YES;
        }
        
        //////////////////////////////////////////////////
        // 加入note按鈕
        _noteButton = [[PPButton ppButtonWithIconImageName:ImageNameWCContactInfoViewControllerNavigationBarButtonNote
                                                       tag:ContactInfoNavigationBarViewButtonTag_Note
                                                  delegate:self
                                     normalBackgroundColor:nil
                                highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                           imageEdgeInsets:WCContactViewControllerNavigationBarButtonImageEdgeInsets] retain];
        if (self.noteButton!=nil)
        {
            self.noteButton.ppGuideIndex = PPGuideDataModel_GuideIndex_InfoNoteButton;
            [self.noteButton addControlEvents:UIControlEventTouchUpInside];
            
            PPBarViewItemModel *noteItemModel  = [PPBarViewItemModel ppBarViewItemModelWithView:self.noteButton];
            if (noteItemModel!=nil)
            {
                noteItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                [viewItemArray addObject:noteItemModel];
            }
        }
        
        //////////////////////////////////////////////////
        // 其他功能，只有normal, salesforce有
        if (self.mode==ContactInfoNavigationBarViewMode_Normal||
            self.mode==ContactInfoNavigationBarViewMode_Salesforce)
        {

            //////////////////////////////////////////////////
            
            _otherButton = [[PPButton ppButtonWithIconImageName:ImageNameWCContactViewControllerNavigationBarButtonMore
                                                            tag:ContactInfoNavigationBarViewButtonTag_Other
                                                       delegate:self
                                          normalBackgroundColor:nil
                                     highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                imageEdgeInsets:WCContactViewControllerNavigationBarButtonImageEdgeInsets] retain];
            if (self.otherButton!=nil)
            {
                [self.otherButton addControlEvents:UIControlEventTouchUpInside];
                
                PPBarViewItemModel *otherItemModel  = [PPBarViewItemModel ppBarViewItemModelWithView:self.otherButton];
                if (otherItemModel!=nil)
                {
                    otherItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                    [viewItemArray addObject:otherItemModel];
                }
            }
        }

        //////////////////////////////////////////////////

        if([viewItemArray count]>0)
        {
            [self setItemModels:viewItemArray forBlockType:PPBarViewBlockType_Right];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [self removeShortPressGestureRecognizer];
    
    if (self.isBackButtonShowed==YES)
    {
        [self.backButton removeFromSuperview];
        self.backButton.delegate = nil;
        self.backButton = nil;
    }
    
    [self.favoriteButton removeFromSuperview];
    self.favoriteButton.delegate = nil;
    self.favoriteButton = nil;
    
    [self.noteButton removeFromSuperview];
    self.noteButton.delegate = nil;
    self.noteButton = nil;
    
    [self.otherButton removeFromSuperview];
    self.otherButton.delegate = nil;
    self.otherButton = nil;
    
    [self.backButton removeFromSuperview];
    self.backButton.delegate = nil;
    self.backButton = nil;
    
    self.delegate = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
// 避免字串過長，導致按鈕與文字重疊(TitleBar內會autoresize)
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    // Back可能無需呈現
    
    do
    {
        CGRect labelFrame = self.titleLabel.frame;
        
        if (self.isBackButtonShowed==YES)
        {
            if (self.backButton==nil)
            {
                break;
            }
        }
        else
        {
            labelFrame.origin.x = ContactInfoNavigationBarView_TitleLabelLeftGapForBackButtomDismissed;
        }
        
        //////////////////////////////////////////////////
        // !! titleLabel是autoresizeLabel, 所以長度會超過，這邊要重設大小
        if (self.mode==ContactInfoNavigationBarViewMode_Normal)
        {
            if (self.favoriteButton!=nil && self.noteButton!=nil && self.otherButton!=nil)
            {
                labelFrame.size.width = self.favoriteButton.frame.origin.x-labelFrame.origin.x;
                self.titleLabel.frame = labelFrame;
            }
        }
        else
        {
            if (self.favoriteButton!=nil)
            {
                labelFrame.size.width = self.favoriteButton.frame.origin.x-labelFrame.origin.x;
                self.titleLabel.frame = labelFrame;
            }
            else if (self.noteButton!=nil)
            {
                labelFrame.size.width = self.noteButton.frame.origin.x-labelFrame.origin.x;
                self.titleLabel.frame = labelFrame;
            }
        }
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)addShortPressGestureRecognizer
{
    if(self.shortPressGestureRecognizer==nil)
    {
        _shortPressGestureRecognizer = [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(handleShortPress:)];
        
        if(self.shortPressGestureRecognizer!=nil)
        {
            self.shortPressGestureRecognizer.minimumPressDuration = ContactInfoNavigationBarView_ContactNameShortPressDuration; //seconds
            [self.titleLabel addGestureRecognizer:self.shortPressGestureRecognizer];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)handleShortPress:(UILongPressGestureRecognizer *)sender
{
    if(sender.state==UIGestureRecognizerStateBegan)
    {        
        if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(contactInfoNavigationBarViewDidShortPressContactName:)]==YES)
        {
            [self.delegate contactInfoNavigationBarViewDidShortPressContactName:self];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)removeShortPressGestureRecognizer
{
    [self removeGestureRecognizer:self.shortPressGestureRecognizer];
    self.shortPressGestureRecognizer = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)setContactFavorite:(BOOL)isFavorite
{
    self.favoriteButton.selected = isFavorite;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case ContactInfoNavigationBarViewButtonTag_Favorite:
        {
            ppButton.selected = !ppButton.selected;
            break;
        }
        default:
            break;
    }
    
    //////////////////////////////////////////////////
    
    if([self.delegate respondsToSelector:@selector(contactInfoNavigationBarView:ppButton:withControlEvent:)]==YES)
    {
        [self.delegate contactInfoNavigationBarView:self ppButton:ppButton withControlEvent:controlEvent];
    }
}


@end
