//
//  ContactInfoDataModel.m
//
//  Created by Howard.Lin on 13/10/16.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "ContactInfoDataModel.h"

#import "WCContactViewController+PublicParameterDefine.h"

//controller
#import "PPWorldcardAddressController.h"
#import "WCDisplayNameController.h"

//model
#import "ContactDataExchangeModel.h"
#import "PPContactRowObject.h"

//tool
#import "ContactTool.h"
#import "PPCountryCodeConvert.h"

//extension
#import "NSString+Additions.h"
#import "PPRowModel+Contact.h"
#import "PPRowModel+DisplayPhoneSort.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ContactInfoDataModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Class Method

//================================================================================
//
//================================================================================
+ (BOOL)validUserDefineContactExchangeDataModel:(ContactDataExchangeModel *)dataExchangeModel
{
    BOOL result = NO;
    
    do
    {
        NSArray *allkeys = [dataExchangeModel.propertyDictionary allKeys];
        
        //////////////////////////////////////////////////

        NSArray *subTypes = @[@(PPContactSubType_UserDefine_Text),
                              @(PPContactSubType_UserDefine_Email),
                              @(PPContactSubType_UserDefine_URL),
                              @(PPContactSubType_UserDefine_Float),
                              @(PPContactSubType_UserDefine_Integer),
                              @(PPContactSubType_UserDefine_ListValue),
                              @(PPContactSubType_UserDefine_Date),
                              @(PPContactSubType_UserDefine_DateAndTime)];
        
        //////////////////////////////////////////////////

        for(NSNumber *subType in subTypes)
        {
            if([allkeys indexOfObject:subType]!=NSNotFound &&
               [[dataExchangeModel.propertyDictionary objectForKey:subType] length]>0)
            {
                result = YES;
                
                break;
            }
        }
    }
    while (0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForParsingAddressContactDataExchangeModels:(NSArray *)contactDataExchangeModels
                                                           frontCardBCRRecognitionLanguage:(NSUInteger)frontCardBCRRecognitionLanguage
                                                            backCardBCRRecognitionLanguage:(NSUInteger)backCardBCRRecognitionLanguage;
{
    PPContactSectionModel *newSectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:PPContactMainType_Address];

    @autoreleasepool
    {
        do
        {
            if(newSectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(ContactDataExchangeModel *contactDataExchangeModel in contactDataExchangeModels)
            {
                NSString *street = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Street]];
                
                if(street==nil)
                {
                    street = @"";
                }
                
                //////////////////////////////////////////////////
                
                NSString *state	= [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_State]];
                
                if(state==nil)
                {
                    state = @"";
                }
                
                //////////////////////////////////////////////////
                
                NSString *city	= [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_City]];
                
                if(city==nil)
                {
                    city = @"";
                }
                
                //////////////////////////////////////////////////
                
                NSString *zip	= [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Zip]];
 
                if(zip==nil)
                {
                    zip = @"";
                }
                
                //////////////////////////////////////////////////
                
                NSNumber *languageCode = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_RecognitionLanguageCode]];
                
                NSString *countryCode  = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_CountryCode]];
                
                
                NSString *country = nil;
                
                if(countryCode==nil || countryCode.length<=0)
                {
                    country = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Country]];
                }
                else if(languageCode==nil || [languageCode integerValue]==-1)
                {
                    country = [PPCountryCodeConvert localizeStringFromCountryCode:countryCode];
                }
                else
                {
                    country  = [PPCountryCodeConvert localizeStringFromCountryCode:countryCode
                                                                  withLanguageCode:[PPCountryCodeConvert languageCodeWithRecogLang:[languageCode unsignedIntegerValue]]];
                }

    
                if(country==nil)
                {
                    country = @"";
                }
                
                //////////////////////////////////////////////////
                
                PPContactAddressFormat addressFormat = [[contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_Format]] unsignedIntegerValue];
                
                if(addressFormat==PPContactAddressFormat_None)
                {
                    NSString *countryCode = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Address_CountryCode]];
                    
                    if(countryCode==nil)
                    {
                        countryCode = [PPCountryCodeConvert defaultCountryCode];
                    }
                    
                    //////////////////////////////////////////////////
                    
                    NSUInteger BCRRecognitionLanguage = frontCardBCRRecognitionLanguage;
                    
                    if(contactDataExchangeModel.contactFieldSource==PPContactFieldSource_BackSide)
                    {
                        BCRRecognitionLanguage = backCardBCRRecognitionLanguage;
                    }
                    else if(contactDataExchangeModel.contactFieldSource==PPContactFieldSource_UserCreate)
                    {
                        BCRRecognitionLanguage = [ContactTool defaultSysmtemLanguage]; //!!預設英文
                    }
                    
                    addressFormat = [PPWorldcardAddressController formatFromStreet:street
                                                                              city:city
                                                                          province:state
                                                                        postalCode:zip
                                                                       countryName:[NSMutableString stringWithString:country]
                                                                            format:-1
                                                                       countryCode:[NSMutableString stringWithString:countryCode]
                                                                       bcrLanguage:BCRRecognitionLanguage
                                                                    systemLanguage:[PPWorldcardAddressController addressSystemLanguage]];
                    
                }
                
                //////////////////////////////////////////////////
                
                NSString *addressString = [PPWorldcardAddressController addressFromStreet:street
                                                                                     city:city
                                                                                 province:state
                                                                               postalCode:zip
                                                                              countryName:country
                                                                                   format:addressFormat];
            
                //////////////////////////////////////////////////
                
                PPContactRowObject *newContactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:PPContactMainType_Address
                                                                                                    ppContactLabelType:contactDataExchangeModel.labelType
                                                                                            tableViewCellEditingStyle:UITableViewCellEditingStyleNone
                                                                                          ppContactTableViewCellStyle:PPContactTableViewCellStyle_Label
                                                                                                             selected:NO];
                
                
                if(newContactRowObject==nil)
                {
                    break;
                }
           
                //////////////////////////////////////////////////

                [newContactRowObject.inputValueDictionary setObject:addressString forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_None]];

                //////////////////////////////////////////////////

                if(city!=nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:city forKey:@(PPContactSubType_Address_City)];
                }
                
                if(street!=nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:street forKey:@(PPContactSubType_Address_Street)];
                }
                
                if(state!=nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:state forKey:@(PPContactSubType_Address_State)];
                }
                
                if(zip!=nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:zip forKey:@(PPContactSubType_Address_Zip)];
                }
                
                if(country!=nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:country forKey:@(PPContactSubType_Address_Country)];
                }
                
                if(languageCode!=nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:languageCode forKey:@(PPContactSubType_Address_RecognitionLanguageCode)];
                }
                
                if(countryCode!=nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:countryCode forKey:@(PPContactSubType_Address_CountryCode)];
                }
                
                //////////////////////////////////////////////////
                
                if(addressString.length)
                {
                    NSString *labelText = contactDataExchangeModel.labelText;
                    
                    if(labelText==nil || labelText.length<=0)
                    {
                        labelText = [PPContactRowObject labelTextFromPPContactLabelType:contactDataExchangeModel.labelType ppContactMainType:PPContactMainType_Address];
                    }
                    
                    
                    PPRowModel *newRowModel = [PPRowModel rowModelWithRow:newSectionModel.rowModels.count
                                                                     text:addressString
                                                               detailText:labelText
                                                                   object:newContactRowObject];
                    
                    [newRowModel setPPContactFieldSource:contactDataExchangeModel.contactFieldSource];
                    
                    if(newRowModel!=nil)
                    {
                        [newSectionModel.rowModels addObject:newRowModel];
                    }
                    
                }
                
            }
            
        } while (0);
    }
    
    return newSectionModel;
}


//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForParsingCompanyContactDataExchangeModels:(NSArray *)contactDataExchangeModels
                                                                              showPhonetic:(BOOL)showPhonetic
{
    PPContactSectionModel *newSectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:PPContactMainType_Company];
    
    @autoreleasepool
    {
        do
        {
            if(newSectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(ContactDataExchangeModel *contactDataExchangeModel in contactDataExchangeModels)
            {
                if(showPhonetic==NO)
                {
                    [contactDataExchangeModel.propertyDictionary removeObjectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Company_NamePhonetic]];
                }
                
                //////////////////////////////////////////////////
                
                NSString *totalText = @"";
                
                NSString *companyString = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Company_Name]];
                
                if(companyString!=nil && companyString.length>0)
                {
                    totalText = [totalText stringByAppendingFormat:@"%@",companyString];
                }
                
                //////////////////////////////////////////////////
                
                NSString *companyStringPhonetic = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Company_NamePhonetic]];
                
                if(companyStringPhonetic!=nil && companyStringPhonetic.length>0)
                {
                    if(totalText.length>0)
                    {
                        totalText = [totalText stringByAppendingFormat:@"\n"];
                    }

                    totalText = [totalText stringByAppendingFormat:@"%@",companyStringPhonetic];
                }
                
                //////////////////////////////////////////////////
                
                NSString *departmentString = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Company_Department]];
                
                if(departmentString!=nil && departmentString.length>0)
                {
                    if(totalText.length>0)
                    {
                        totalText = [totalText stringByAppendingFormat:@"\n"];
                    }
                    
                    totalText = [totalText stringByAppendingFormat:@"%@",departmentString];
                }
                
                //////////////////////////////////////////////////
                
                NSString *positionString = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Company_JobTitle]];

                
                if(positionString!=nil && positionString.length>0)
                {
                    if(totalText.length>0)
                    {
                        totalText = [totalText stringByAppendingFormat:@"\n"];
                    }
                    
                    totalText = [totalText stringByAppendingString:positionString];
                }
                
                //////////////////////////////////////////////////
                
                PPContactRowObject *newContactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:PPContactMainType_Company
                                                                                                   ppContactLabelType:contactDataExchangeModel.labelType
                                                                                            tableViewCellEditingStyle:UITableViewCellEditingStyleNone
                                                                                          ppContactTableViewCellStyle:PPContactTableViewCellStyle_Label
                                                                                                             selected:NO];
                
                [newContactRowObject.inputValueDictionary setObject:totalText forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_None]];
                
                if(totalText.length)
                {
                    PPRowModel *newRowModel = [PPRowModel rowModelWithRow:newSectionModel.rowModels.count
                                                                     text:totalText
                                                               detailText:nil
                                                                   object:newContactRowObject];
                    
                    [newRowModel setPPContactFieldSource:contactDataExchangeModel.contactFieldSource];
                    
                    if(newRowModel!=nil)
                    {
                        [newSectionModel.rowModels addObject:newRowModel];
                    }
                }
            }
        } while (0);
    }
    
    return newSectionModel;

}


//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForParsingGroupContactDataExchangeModels:(NSArray *)contactDataExchangeModels
{
    PPContactSectionModel *newSectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:PPContactMainType_Group];

    @autoreleasepool
    {
        do
        {
            if(newSectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(ContactDataExchangeModel *contactDataExchangeModel in contactDataExchangeModels)
            {
                PPContactRowObject *newContactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:PPContactMainType_Group
                                                                                                   ppContactLabelType:contactDataExchangeModel.labelType
                                                                                            tableViewCellEditingStyle:UITableViewCellEditingStyleNone
                                                                                          ppContactTableViewCellStyle:PPContactTableViewCellStyle_Default
                                                           selected:NO];
                
                //////////////////////////////////////////////////
                
                NSString *detailText = nil;
                
                if(contactDataExchangeModel.labelType==PPContactLabelType_Group_Info)
                {
                    detailText = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Group]];
                }
                else
                {
                    detailText = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_SystemGroup]];
                }
                
                if(detailText==nil)
                {
                    detailText = @"";
                
                    if(contactDataExchangeModel.labelType==PPContactLabelType_Group_Info)
                    {
                        [contactDataExchangeModel.propertyDictionary setObject:detailText forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Group]];
                    }
                    else
                    {
                        [contactDataExchangeModel.propertyDictionary setObject:detailText forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_SystemGroup]];
                    }
                    
                }
                
                //////////////////////////////////////////////////
                
                PPRowModel *groupRowModel = [PPRowModel rowModelWithRow:newSectionModel.rowModels.count
                                                                   text:contactDataExchangeModel.labelText
                                                             detailText:detailText
                                                                 object:newContactRowObject];
                
                if(groupRowModel!=nil)
                {
                    [newSectionModel.rowModels addObject:groupRowModel];
                }
            }
            
            
        } while (0);
    }
    
    return newSectionModel;
}

//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForParsingNameContactDataExchangeModels:(NSArray *)contactDataExchangeModels
                                                                             salutation:(NSString*)salutation
                                                                        easterNameOrder:(PPContactNameOrder)easterNameOrder
                                                                       westernNameOrder:(PPContactNameOrder)westernNameOrder
                                                                           showPhonetic:(BOOL)showPhonetic
{
    PPContactSectionModel *newSectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:PPContactMainType_Name];
    
    @autoreleasepool
    {
        do
        {
            if(newSectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(ContactDataExchangeModel *contactDataExchangeModel in contactDataExchangeModels)
            {
                if(showPhonetic==NO)
                {
                    [contactDataExchangeModel.propertyDictionary removeObjectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_FirstNamePhonetic]];
                    
                    [contactDataExchangeModel.propertyDictionary removeObjectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_LastNamePhonetic]];
                }

                //////////////////////////////////////////////////

                NSString *prefixNameString = [salutation length]?salutation:[contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_Prefix]];
                
                NSString *surffixNameString = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_Surffix]];
                
                NSString *lastNameString = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_LastName]];

                NSString *firstNameString = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_FirstName]];
                
                NSString *middleNameString = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_MiddleName]];
                
                NSString *lastNamePhoneticString = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_LastNamePhonetic]];

                NSString *firstNamePhoneticString = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_Name_FirstNamePhonetic]];
                
                PPContactNameOrder nameOrder;
                
                //中日韓字串
                if([lastNameString isCJK]==YES | [firstNameString isCJK]==YES | [middleNameString isCJK]==YES | [lastNamePhoneticString isCJK]==YES | [firstNamePhoneticString isCJK]==YES | [prefixNameString isCJK]==YES | [surffixNameString isCJK]==YES)
                {
                    if(easterNameOrder==PPContactNameOrder_None)
                    {
                        nameOrder = PPContactNameOrder_LastFirst;
                    }
                    else
                    {
                        nameOrder = easterNameOrder;
                    }
                    
                }
                else
                {
                    if(westernNameOrder==PPContactNameOrder_None)
                    {
                        nameOrder = PPContactNameOrder_FirstLast;
                    }
                    else
                    {
                        nameOrder = westernNameOrder;
                    }
                }
                
                //////////////////////////////////////////////////
                
                NSMutableString *totalDetailText = [NSMutableString stringWithString:@""];
                
                NSString *totalText = [WCDisplayNameController displayNameWithFirstName:firstNameString
                                                                               lastName:lastNameString
                                                                             middleName:middleNameString
                                                                                 prefix:prefixNameString
                                                                                 suffix:surffixNameString
                                                                              eastOrder:(WCDisplayNameOrder)easterNameOrder
                                                                              westOrder:(WCDisplayNameOrder)westernNameOrder];
                switch (nameOrder)
                {
                    case PPContactNameOrder_FirstLast:
                    {
                        if(lastNamePhoneticString!=nil && lastNamePhoneticString.length>0 && firstNamePhoneticString!=nil && firstNamePhoneticString.length>0)
                        {
                            totalDetailText = [NSMutableString stringWithFormat:@"%@ %@",firstNamePhoneticString,lastNamePhoneticString];
                        }
                        else if(lastNamePhoneticString!=nil && lastNamePhoneticString.length>0)
                        {
                            totalDetailText = [NSMutableString stringWithFormat:@"%@",lastNamePhoneticString];
                        }
                        else if(firstNamePhoneticString!=nil && firstNamePhoneticString.length>0)
                        {
                            totalDetailText = [NSMutableString stringWithFormat:@"%@",firstNamePhoneticString];
                        }
                        
                        break;
                    }
                    case PPContactNameOrder_LastFirst:
                    default:
                    {
                        if(lastNamePhoneticString!=nil && lastNamePhoneticString.length>0 && firstNamePhoneticString!=nil && firstNamePhoneticString.length>0)
                        {
                            totalDetailText = [NSMutableString stringWithFormat:@"%@ %@",lastNamePhoneticString,firstNamePhoneticString];
                        }
                        else if(lastNamePhoneticString!=nil && lastNamePhoneticString.length>0)
                        {
                            totalDetailText = [NSMutableString stringWithFormat:@"%@",lastNamePhoneticString];
                        }
                        else if(firstNamePhoneticString!=nil && firstNamePhoneticString.length>0)
                        {
                            totalDetailText = [NSMutableString stringWithFormat:@"%@",firstNamePhoneticString];
                        }

                        break;
                    }
                }
                
                //////////////////////////////////////////////////
                
                if(totalText.length>0 || totalDetailText.length>0)
                {
                    PPContactRowObject *newContactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:PPContactMainType_Name
                                                                                                       ppContactLabelType:contactDataExchangeModel.labelType
                                                                                                tableViewCellEditingStyle:UITableViewCellEditingStyleNone
                                                                                              ppContactTableViewCellStyle:PPContactTableViewCellStyle_Default
                                                                                                                 selected:NO];
                    
                    newContactRowObject.tableViewCellStyle = PPContactTableViewCellStyle_Label;
                    
                    PPRowModel *newRowModel = [PPRowModel rowModelWithRow:newSectionModel.rowModels.count
                                                                     text:totalText
                                                               detailText:totalDetailText
                                                                   object:newContactRowObject];
                    
                    [newRowModel setPPContactFieldSource:contactDataExchangeModel.contactFieldSource];
                    
                    if(newRowModel!=nil)
                    {
                        [newSectionModel.rowModels addObject:newRowModel];
                    }
                }
            }
            
        } while (0);
    }
    
    return newSectionModel;
}


//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForParsingNormalContactDataExchangeModels:(NSArray *)contactDataExchangeModels
                                                                        ppContactMainType:(PPContactMainType)contactMainType
{
    PPContactSectionModel *newSectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:contactMainType];
    
    //////////////////////////////////////////////////
    
    @autoreleasepool
    {
        do
        {
            if(newSectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(ContactDataExchangeModel *contactDataExchangeModel in contactDataExchangeModels)
            {
                if(contactDataExchangeModel.propertyDictionary.count<=0)
                {
                    break;
                }
                
                //////////////////////////////////////////////////

                if(contactMainType==PPContactMainType_UserDefine &&
                   [self validUserDefineContactExchangeDataModel:contactDataExchangeModel]==NO)
                {
                    continue;
                }
                
                //////////////////////////////////////////////////
                
                PPContactTableViewCellStyle tableViewCellStyle = PPContactTableViewCellStyle_Label;
                
                if(contactMainType==PPContactMainType_Note || contactMainType==PPContactMainType_PublicNote)
                {
                    tableViewCellStyle = PPContactTableViewCellStyle_TextView;
                }
                
                PPContactRowObject *newContactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:contactMainType
                                                                                                   ppContactLabelType:contactDataExchangeModel.labelType
                                                                                            tableViewCellEditingStyle:UITableViewCellEditingStyleNone
                                                                                          ppContactTableViewCellStyle:tableViewCellStyle
                                                                                                             selected:NO];
                
                if(newContactRowObject==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                NSString *rowModelText = nil;
                
                
                for (id key in contactDataExchangeModel.propertyDictionary.allKeys)
                {
                    id object = [contactDataExchangeModel.propertyDictionary objectForKey:key];
                
                    if(object!=nil)
                    {
                       [newContactRowObject.inputValueDictionary setObject:object forKey:key];
                    }
                    
                    //////////////////////////////////////////////////
                    // 自訂欄位設值
                    if([object isKindOfClass:[NSString class]]==YES &&
                       [key integerValue]!=PPContactSubType_UserDefine_ID &&
                       [key integerValue]!=PPContactSubType_UserDefine_UserInfo &&
                       [key integerValue]!=PPContactSubType_UserDefine_ItemMenu)
                    {
                        rowModelText = object;
                    }
                }
               
                
                //////////////////////////////////////////////////
                
                for (id key in contactDataExchangeModel.imageRectDictionary.allKeys)
                {
                    [newContactRowObject.imageRectDictionary setObject:[contactDataExchangeModel.propertyDictionary objectForKey:key] forKey:key];
                }
                
                //////////////////////////////////////////////////
                
                if(newContactRowObject.inputValueDictionary.count>0)
                {
                    NSString *labelText = contactDataExchangeModel.labelText;
                    
                    if(labelText==nil || labelText.length<=0)
                    {
                        labelText = [PPContactRowObject labelTextFromPPContactLabelType:contactDataExchangeModel.labelType ppContactMainType:contactMainType];
                    }
                    
                    //////////////////////////////////////////////////
                    
                    PPRowModel *newRowModel = [PPRowModel rowModelWithRow:newSectionModel.rowModels.count
                                                                     text:rowModelText
                                                               detailText:labelText
                                                                   object:newContactRowObject];
                    
                    if(newRowModel!=nil)
                    {
                        [newSectionModel.rowModels addObject:newRowModel];
                    }
                }
            }
            
            //////////////////////////////////////////////////
            // office 365的other要排序
            if (contactMainType==PPContactMainType_Other)
            {
                NSArray *sortRowModes = [newSectionModel.rowModels sortedArrayUsingSelector:@selector(labelTypeCompare:)];
                
                if(sortRowModes!=nil)
                {
                    [newSectionModel.rowModels removeAllObjects];
                    [newSectionModel.rowModels addObjectsFromArray:sortRowModes];
                }
            }
            //////////////////////////////////////////////////
            // !! 電話接下來免排序
//            //電話欄位排序
//            if(contactMainType==PPContactMainType_Phone)
//            {
//                NSArray *phonesRowModel = [newSectionModel.rowModels sortedArrayUsingSelector:@selector(displayPhoneSortWithPPRowModel:)];
//                
//                [newSectionModel.rowModels removeAllObjects];
//                
//                for(PPRowModel *sortedRowModel in phonesRowModel)
//                {
//                    sortedRowModel.row = [phonesRowModel indexOfObject:sortedRowModel];
//                    
//                    [newSectionModel.rowModels addObject:sortedRowModel];
//                }
//               
//            }
            
        } while (0);
    }
    
    return newSectionModel;
}


//==============================================================================
//
//==============================================================================
+ (PPContactSectionModel *)ppContactSectionModelForParsingVisibleAccountContactDataExchangeModels:(NSArray *)contactDataExchangeModels
{
    PPContactSectionModel *newSectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:PPContactMaintype_VisibleAccount];
    
    @autoreleasepool
    {
        do
        {
            if(newSectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(ContactDataExchangeModel *contactDataExchangeModel in contactDataExchangeModels)
            {
                PPContactRowObject *newContactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:PPContactMaintype_VisibleAccount
                                                                                                   ppContactLabelType:contactDataExchangeModel.labelType
                                                                                            tableViewCellEditingStyle:UITableViewCellEditingStyleNone
                                                                                          ppContactTableViewCellStyle:PPContactTableViewCellStyle_Default
                                                                                                             selected:NO];
                
                //////////////////////////////////////////////////
                
                NSString *detailText = nil;
                
                if(contactDataExchangeModel.labelType==PPContactLabelType_VisibleAccount_Info)
                {
                    detailText = [contactDataExchangeModel.propertyDictionary objectForKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_VisibleAccount]];
                }
                
                if(detailText==nil)
                {
                    detailText = @"";
                    
                    if(contactDataExchangeModel.labelType==PPContactLabelType_VisibleAccount_Info)
                    {
                        [contactDataExchangeModel.propertyDictionary setObject:detailText forKey:[NSNumber numberWithUnsignedInteger:PPContactSubType_VisibleAccount]];
                    }
                }
                
                //////////////////////////////////////////////////
                
                PPRowModel *groupRowModel = [PPRowModel rowModelWithRow:newSectionModel.rowModels.count
                                                                   text:contactDataExchangeModel.labelText
                                                             detailText:detailText
                                                                 object:newContactRowObject];
                
                if(groupRowModel!=nil)
                {
                    [newSectionModel.rowModels addObject:groupRowModel];
                }
            }
            
            
        } while (0);
    }
    
    return newSectionModel;
}



//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForParsingSalesforceCompanyDataExchangeModels:(NSArray *)contactDataExchangeModels
{
    PPContactSectionModel *newSectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:PPContactMainType_Company];
    
    @autoreleasepool
    {
        do
        {
            if(newSectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            // !! salesforce第一組公司，部門，職稱放在一起
            // 如果有第二組，再另外建
            NSMutableArray *companyDicts = [NSMutableArray array];
            for(ContactDataExchangeModel *contactDataExchangeModel in contactDataExchangeModels)
            {
                @autoreleasepool
                {
                    // !! 先找到第一個沒有塞滿的companyDict
                    NSMutableDictionary *companyDict = nil;
                    for (NSMutableDictionary *tempCompanyDict in companyDicts)
                    {
                        if([[companyDict allKeys] count]<3)
                        {
                            companyDict = tempCompanyDict;
                            break;
                        }
                    }
                    
                    // 如果沒有可用的，建立一個新的
                    if(companyDict==nil)
                    {
                        companyDict = [NSMutableDictionary dictionary];
                        [companyDicts addObject:companyDict];
                    }
                    //////////////////////////////////////////////////
                    NSString *value = [contactDataExchangeModel.propertyDictionary objectForKey:@(PPContactSubType_None)];
                    if ([value length]>0)
                    {
                        [companyDict setObject:value forKey:@([contactDataExchangeModel labelType])];
                    }
                }
            }
            
            
            //////////////////////////////////////////////////
            // 把companyDicts轉為rowModel
            
            NSString *totalText = @"";
            NSArray *companyOrder = @[@(PPContactLabelType_Company_Name),
                                      @(PPContactLabelType_Company_Department),
                                      @(PPContactLabelType_Company_JobTitle)];
            for (NSMutableDictionary *companyDict in companyDicts)
            {
                for (NSNumber *subType in companyOrder)
                {
                    NSString *value = [companyDict objectForKey:subType];
                    
                    if ([value length]>0)
                    {
                        if ([totalText length]>0)
                        {
                            totalText = [totalText stringByAppendingString:@"\n"];
                        }

                        totalText = [totalText stringByAppendingString:value];
                    }
                }
                //////////////////////////////////////////////////
                if(totalText.length)
                {
                    PPContactRowObject *newContactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:PPContactMainType_Company
                                                                                                       ppContactLabelType:PPContactLabelType_None
                                                                                                tableViewCellEditingStyle:UITableViewCellEditingStyleNone
                                                                                              ppContactTableViewCellStyle:PPContactTableViewCellStyle_Label
                                                                                                                 selected:NO];
                    
                    [newContactRowObject.inputValueDictionary setObject:totalText forKey:@(PPContactSubType_None)];
                    

                    PPRowModel *newRowModel = [PPRowModel rowModelWithRow:newSectionModel.rowModels.count
                                                                     text:totalText
                                                               detailText:nil
                                                                   object:newContactRowObject];
                    
                    [newRowModel setPPContactFieldSource:PPContactFieldSource_UserCreate];
                    
                    if(newRowModel!=nil)
                    {
                        [newSectionModel.rowModels addObject:newRowModel];
                    }
                }
            }

        } while (0);
    }
    
    return newSectionModel;
    
}

//================================================================================
//
//================================================================================
+ (PPContactSectionModel *)ppContactSectionModelForParsingSalesforceStatusDataExchangeModels:(NSArray *)contactDataExchangeModels
{
    PPContactSectionModel *newSectionModel = [PPContactSectionModel ppContactSectionModelForPPContactMainType:PPContactMainType_Status];
    
    //////////////////////////////////////////////////
    
    @autoreleasepool
    {
        do
        {
            if(newSectionModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(ContactDataExchangeModel *contactDataExchangeModel in contactDataExchangeModels)
            {
                if(contactDataExchangeModel.propertyDictionary.count<=0)
                {
                    continue;
                }
                //////////////////////////////////////////////////
                // salesforce沒有值，不用顯示
                NSString *rowModelText = nil;
                
                rowModelText = [contactDataExchangeModel.propertyDictionary objectForKey:@(PPContactSubType_ListValue)];

                if ([rowModelText length]==0 ||
                    [rowModelText isEqualToString:WCVC_EditViewControllerSelectEmptyValue]==YES ||
                    [rowModelText isEqualToString:WCVC_EditViewControllerSelectDisableValue]==YES)
                {
                    continue;
                }
                //////////////////////////////////////////////////
                
                PPContactTableViewCellStyle tableViewCellStyle = PPContactTableViewCellStyle_Label;
                
                PPContactRowObject *newContactRowObject = [PPContactRowObject ppContactRowObjectWithPPContactMainType:PPContactMainType_Status
                                                                                                   ppContactLabelType:contactDataExchangeModel.labelType
                                                                                            tableViewCellEditingStyle:UITableViewCellEditingStyleNone
                                                                                          ppContactTableViewCellStyle:tableViewCellStyle
                                                                                                             selected:NO];
                
                if(newContactRowObject==nil)
                {
                    continue;
                }
                
                //////////////////////////////////////////////////
                
                
                if(rowModelText!=nil)
                {
                    [newContactRowObject.inputValueDictionary setObject:rowModelText forKey:@(PPContactSubType_ListValue)];
                }

                //////////////////////////////////////////////////
                
                if(newContactRowObject.inputValueDictionary.count>0)
                {
                    NSString *labelText = contactDataExchangeModel.labelText;
                    
                    if(labelText==nil || labelText.length<=0)
                    {
                        labelText = [PPContactRowObject labelTextFromPPContactLabelType:contactDataExchangeModel.labelType
                                                                      ppContactMainType:PPContactMainType_Status];
                    }
                    
                    //////////////////////////////////////////////////
                    
                    PPRowModel *newRowModel = [PPRowModel rowModelWithRow:newSectionModel.rowModels.count
                                                                     text:rowModelText
                                                               detailText:labelText
                                                                   object:newContactRowObject];
                    
                    [newRowModel setPPContactFieldSource:contactDataExchangeModel.contactFieldSource];
                    
                    if(newRowModel!=nil)
                    {
                        [newSectionModel.rowModels addObject:newRowModel];
                    }
                }
            }
        } while (0);
    }
    
    return newSectionModel;
}


@end
