//
//  PPContactInfoSectionController.h
//
//  Created by Howard.Lin on 13/10/16.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPSectionController.h"

#import "ContactInfoDataModel.h"
#import "ContactDataExchangeProtocol.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPContactInfoSectionController : PPSectionController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,retain) ContactInfoDataModel   *dataModel;
@property (nonatomic,retain) NSDictionary           *currentFieldDictionary;
@property (nonatomic,assign) PPContactNameOrder     easterNameOrder;
@property (nonatomic,assign) PPContactNameOrder     westernNameOrder;
@property (nonatomic,assign) BOOL                   showPhonetic;




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (BOOL)validPhone;

- (NSMutableArray *)fetchFieldDictionary:(NSDictionary *)fieldDictionary toSectionModelsForSearching:(BOOL)searching frontCardBCRRecognitionLanguage:(NSUInteger)frontCardBCRRecognitionLanguage backCardBCRRecognitionLanguage:(NSUInteger)backCardBCRRecognitionLanguage orders:(NSArray *)orders;

- (NSString *)fetchSaveAsStringFromFieldDictionary:(NSDictionary *)fieldDictionary ;
@end
