//
//  WCContactEditViewController+WCT.m
//  Pods
//
//  Created by sanhue on 2019/8/28.
//

#import "WCContactEditViewController+WCT.h"

// define
#import "WCContactEditViewController+SettingKey.h"

//view
#import "ContactEditNavigationBarView.h"

// Controller
#import "WCContactEditViewController.h"

#import "PPGuideController.h"
#import "PPSettingsController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCContactEditViewController (WCT)





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Guide Related Method

//================================================================================
//
//================================================================================
- (BOOL)addWCTGuidesData
{
    BOOL result = NO;
    
    [PPGuideController setDelegate:self];
    
    //////////////////////////////////////////////////
    // prepare guide data
    
    [PPGuideController clearAllGuideScripts];
    
    @autoreleasepool
    {
        NSMutableArray *guideDataModels = [NSMutableArray array];
        
        //////////////////////////////////////////////////
        
        if(guideDataModels!=nil)
        {
            if (self.contactEditViewControllerLayout==WCContactEditViewControllerLayout_MyCard)
            {
                // TODO: 看是否要有Tip
            }
            else if (self.contactEditViewControllerLayout==WCContactEditViewControllerLayout_HelpScan)
            {
                //////////////////////////////////////////////////
                
                if([PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_GuideSendToColleague]==1)
                {
                    [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_GuideSendToColleague];
                    
                    //////////////////////////////////////////////////
                    
                    [guideDataModels addObject:[PPGuideDataModel modelWithTargetClassName:NSStringFromClass([self class])
                                                                               guideIndex:ContactEditNavigationBarViewButtonGuideIndex_Done
                                                                                    title:@""
                                                                                  message:WCCV_MLS_GuideSendToColleagueMessage
                                                                          layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
                }

                //////////////////////////////////////////////////
                
                if([PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_GuideSaveAndAddNext]==1)
                {
                    [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_GuideSaveAndAddNext];
                    
                    //////////////////////////////////////////////////
                    
                    [guideDataModels addObject:[PPGuideDataModel modelWithTargetClassName:NSStringFromClass([self class])
                                                                               guideIndex:ContactEditNavigationBarViewButtonGuideIndex_Next
                                                                                    title:@""
                                                                                  message:WCCV_MLS_GuideSaveAndAddNextMessage
                                                                          layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
                }
            }
            else
            {
                if([self existFrontCardImage]==YES &&
                   [self existRearCardImage]==YES &&
                   [PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_GuideFlipCard]==1)
                {
                    [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_GuideFlipCard];
                    
                    //////////////////////////////////////////////////
                    
                    [guideDataModels addObject:[PPGuideDataModel modelWithTargetClassName:NSStringFromClass([self class])
                                                                               guideIndex:PPHeadImageNameTabelViewCellGuideIndex_Flip
                                                                                    title:WCCV_MLS_GuideFlipTitle
                                                                                  message:WCCV_MLS_GuideFlipMessage
                                                                          layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
                }
                else if([self existFrontCardImage]==NO &&
                        [PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_GuideAddFrontCard]==1)
                {
                    [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_GuideAddFrontCard];
                    
                    //////////////////////////////////////////////////
                    
                    [guideDataModels addObject:[PPGuideDataModel modelWithTargetClassName:NSStringFromClass([self class])
                                                                               guideIndex:PPHeadImageNameTabelViewCellGuideIndex_AddFrontCard
                                                                                    title:WCCV_MLS_GuideAddFrontCardTitle
                                                                                  message:WCCV_MLS_GuideAddFrontCardMessage
                                                                          layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
                }
                else if([self existFrontCardImage]==YES &&
                        [self existRearCardImage]==NO &&
                        [PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_GuideAddRearCard]==1)
                {
                    [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_GuideAddRearCard];
                    
                    //////////////////////////////////////////////////
                    
                    [guideDataModels addObject:[PPGuideDataModel modelWithTargetClassName:NSStringFromClass([self class])
                                                                               guideIndex:PPHeadImageNameTabelViewCellGuideIndex_AddBackCard
                                                                                    title:WCCV_MLS_GuideAddBackCardTitle
                                                                                  message:WCCV_MLS_GuideAddBackCardMessage
                                                                          layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
                }
                
                //////////////////////////////////////////////////
                
                if([PPSettingsController integerValueWithKey:WCContactViewController_SettingsKey_GuideMore]==1)
                {
                    [PPSettingsController setIntegerValue:0 withKey:WCContactViewController_SettingsKey_GuideMore];
                    
                    //////////////////////////////////////////////////
                    
                    [guideDataModels addObject:[PPGuideDataModel modelWithTargetClassName:NSStringFromClass([self class])
                                                                               guideIndex:ContactEditNavigationBarViewButtonGuideIndex_More
                                                                                    title:WCCV_MLS_GuideMoreTitle
                                                                                  message:WCCV_MLS_GuideMoreMessage
                                                                          layoutDirection:PPGuideDataModel_LayoutDirection_Vert]];
                }
            }
            
            //////////////////////////////////////////////////
            
            if(guideDataModels.count>0)
            {
                [PPGuideController addGuideScriptWithName:NSStringFromClass([self class]) guideDataModels:guideDataModels];
                
                result = YES;
            }
        }
    }
    
    return result;
}

@end
