//
//  ContactEditView.m
//
//  Created by Howard.Lin on 13/9/27.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

////////////////////////////////////////////////////////////////////////////////////////////////////

#import "ContactEditView.h"

// Define
#import "WCAppearanceDefine.h"
#import "WCContactViewController+ResourceDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ContactEditView()
{
    @private
     id<ContactEditViewDataSource> dataSource_;
     id<ContactEditViewDelegate>   delegate_;
     PPTableView                   *contactEditTableView_;
    
     NSIndexPath                   *shouldEditIndexPath_;
}

@property (nonatomic,readwrite,retain) PPTableView *contactEditTableView;
@property (nonatomic,retain)           NSIndexPath *shouldEditIndexPath;


@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation ContactEditView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
 dataSource           = dataSource_,
 delegate             = delegate_,
 contactEditTableView = contactEditTableView_,
 shouldEditIndexPath  = shouldEditIndexPath_;






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    
    if (self)
    {
        // Initialization code
     
        _sectionHeaders = [[NSMutableDictionary alloc] init];
        
        contactEditTableView_ = [[PPTableView alloc] initWithFrame:frame style:UITableViewStylePlain];

        if(contactEditTableView_!=nil)
        {
            contactEditTableView_.allowsSelectionDuringEditing = YES;
 
            contactEditTableView_.editing    = YES;
            contactEditTableView_.dataSource = self;
            contactEditTableView_.delegate   = self;
            contactEditTableView_.separatorColor = WCAppearanceDefine_SeparatorColor;
            
            if([contactEditTableView_ respondsToSelector:@selector(setEstimatedRowHeight:)]==YES)
            {
                contactEditTableView_.rowHeight = UITableViewAutomaticDimension;
                [contactEditTableView_ setEstimatedRowHeight:PPTableViewDefaultRowHeight];
            }
            
            
            [self addSubview:contactEditTableView_];
        }
    }
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    dataSource_ = nil;
    delegate_   = nil;

    [_sectionHeaders release];
    _sectionHeaders = nil;
    
    contactEditTableView_.dataSource = nil;
    contactEditTableView_.delegate   = nil;
    [contactEditTableView_ removeFromSuperview];
    [contactEditTableView_ release];
    contactEditTableView_ = nil;
    
    [shouldEditIndexPath_ release];
    shouldEditIndexPath_ = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    self.contactEditTableView.frame = self.bounds;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Hit Testing in a View

//================================================================================
//
//================================================================================
- (UIView *)hitTest:(CGPoint)point withEvent:(UIEvent *)event
{
    UIView *hitView= [super hitTest:point withEvent:event];
 
    do
    {
        if([self.delegate respondsToSelector:@selector(contactEditViewDidTouch:)]==NO)
        {
            break;
        }
        
        // MARK: Howard  ios 8.0，有機會點鍵盤時，事件會傳給鍵盤下面的view，造成打字時鍵盤退開的問題。
        else if([[[UIDevice currentDevice] systemVersion] floatValue]<8.0)
        {
            if([hitView isKindOfClass:[UITextField class]]==YES ||
               [hitView isKindOfClass:[UITextView class]]==YES ||
               [hitView isKindOfClass:[UIButton class]]==YES ||
               [NSStringFromClass(hitView.class) isEqualToString:@"UITableViewCellEditControl"]==YES ||
               [NSStringFromClass(hitView.class) isEqualToString:@"UITableViewCellReorderControl"]==YES)
            {
                break;
            }
            
            [self.delegate contactEditViewDidTouch:self];
        }
        
    } while (0);

    return hitView;
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactKeyboardToolBarViewDelegate Method

//================================================================================
//
//================================================================================
- (void)contactEditKeyboardToolBarView:(ContactKeyboardToolBarView *)contactEditKeyboardToolBarView
                              ppButton:(PPButton *)ppButton
                          controlEvent:(UIControlEvents)controlEvent
{
    do
    {
        if(self.delegate==nil ||
           [self.delegate respondsToSelector:@selector(contactEditView:contactEditKeyboardToolBarView:ppButton:controlEvent:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        [self.delegate contactEditView:self
        contactEditKeyboardToolBarView:contactEditKeyboardToolBarView
                              ppButton:ppButton
                          controlEvent:controlEvent];
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPMultipleTextFieldButtonTableViewCellDelegate Method

//================================================================================
//
//================================================================================
- (BOOL)ppMultipleTextFieldButtonTableViewCellShouldBeginEditing:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldButtonTableViewCell textFieldTag:(NSUInteger)tag
{
    BOOL result = YES;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(contactEditView:ppMultipleTextFieldButtonTableViewCellShouldBeginEditing:textFieldTag:atIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.shouldEditIndexPath =[NSIndexPath indexPathForRow:[self.contactEditTableView indexPathForCell:multipleTextFieldButtonTableViewCell].row inSection:[self.contactEditTableView  indexPathForCell:multipleTextFieldButtonTableViewCell].section];
        
        //////////////////////////////////////////////////
        
        result = [self.delegate contactEditView:self ppMultipleTextFieldButtonTableViewCellShouldBeginEditing:multipleTextFieldButtonTableViewCell textFieldTag:tag atIndexPath:self.shouldEditIndexPath];
    
        
    } while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)ppMultipleTextFieldButtonTableViewCellDidBeginEditing:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldButtonTableViewCell
                                                 textFieldTag:(NSUInteger)tag
{
    if([self.delegate respondsToSelector:@selector(contactEditView:ppMultipleTextFieldButtonTableViewCellDidBeginEditing:textFieldTag:atIndexPath:)]==YES)
    {
        [self.delegate contactEditView:self ppMultipleTextFieldButtonTableViewCellDidBeginEditing:multipleTextFieldButtonTableViewCell textFieldTag:tag atIndexPath:self.shouldEditIndexPath];
    }
}


//================================================================================
//
//================================================================================
- (BOOL)ppMultipleTextFieldButtonTableViewCellShouldReturn:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldTableViewCell
{
    BOOL result = YES;
    
    if([self.delegate respondsToSelector:@selector(contactEditViewTableViewCellShowReturn)]==YES)
    {
        result = [self.delegate contactEditViewTableViewCellShowReturn];
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)ppMultipleTextFieldButtonTableViewCellDidChanged:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldButtonTableViewCell
                                      textFieldTag:(NSUInteger)tag
{
    if([self.delegate respondsToSelector:@selector(contactEditView:ppMultipleTextFieldButtonTableViewCellDidChanged:textFieldTag:atIndexPath:)]==YES)
    {
        [self.delegate contactEditView:self ppMultipleTextFieldButtonTableViewCellDidChanged:multipleTextFieldButtonTableViewCell textFieldTag:tag atIndexPath:self.shouldEditIndexPath];
    }
}


//================================================================================
//
//================================================================================
- (void)ppMultipleTextFieldButtonTableViewCellTouchDetail:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldButtonTableViewCell
                                             textFieldTag:(NSUInteger)tag
{
    do
    {
        if(self.delegate==nil ||
           [self.delegate respondsToSelector:@selector(contactEditView:ppMultipleTextFieldButtonTableViewCellShouldBeginEditing:textFieldTag:atIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [self.delegate contactEditView:self ppMultipleTextFieldButtonTableViewCellTouchDetail:multipleTextFieldButtonTableViewCell textFieldTag:tag atIndexPath:[NSIndexPath indexPathForRow:[self.contactEditTableView indexPathForCell:multipleTextFieldButtonTableViewCell].row inSection:[self.contactEditTableView  indexPathForCell:multipleTextFieldButtonTableViewCell].section]];
        
    } while (0);
}


//================================================================================
//
//================================================================================
- (void)ppMultipleTextFieldButtonTableViewCellDidEndEditing:(PPMultipleTextFieldButtonTableViewCell *)multipleTextFieldButtonTableViewCell textFieldTag:(NSUInteger)tag
{
    do
    {
        if([self.delegate respondsToSelector:@selector(contactEditView:ppMultipleTextFieldButtonTableViewCellDidEndEditing:textFieldTag:atIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSIndexPath *indexPath = [NSIndexPath indexPathForRow:[self.contactEditTableView indexPathForCell:multipleTextFieldButtonTableViewCell].row inSection:[self.contactEditTableView  indexPathForCell:multipleTextFieldButtonTableViewCell].section];
        
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [self.delegate contactEditView:self ppMultipleTextFieldButtonTableViewCellDidEndEditing:multipleTextFieldButtonTableViewCell textFieldTag:tag atIndexPath:indexPath];
        
    }
    while (0);
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPPhoneTextFieldTableViewCellDelegate Method

//================================================================================
//
//================================================================================
- (BOOL)ppPhoneTextFieldTableViewCellShouldBeginEditing:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell
{
    BOOL result = YES;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(contactEditView:ppPhoneTextFieldTableViewCellShouldBeginEditing:atIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.shouldEditIndexPath = [NSIndexPath indexPathForRow:[self.contactEditTableView indexPathForCell:phoneTextFieldTableViewCell].row inSection:[self.contactEditTableView  indexPathForCell:phoneTextFieldTableViewCell].section];
        
        //////////////////////////////////////////////////
        
        result = [self.delegate contactEditView:self ppPhoneTextFieldTableViewCellShouldBeginEditing:phoneTextFieldTableViewCell atIndexPath:self.shouldEditIndexPath];
        
    } while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)ppPhoneTextFieldTableViewCellDidBeginEditing:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell
{
    if([self.delegate respondsToSelector:@selector(contactEditView:ppPhoneTextFieldTableViewCellDidBeginEditing:atIndexPath:)]==YES)
    {
        [self.delegate contactEditView:self ppPhoneTextFieldTableViewCellDidBeginEditing:phoneTextFieldTableViewCell atIndexPath:self.shouldEditIndexPath];
    }

}


//================================================================================
//
//================================================================================
- (void)ppPhoneTextFieldTableViewCellDidChanged:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell
{
    if([self.delegate respondsToSelector:@selector(contactEditView:ppPhoneTextFieldTableViewCellDidChanged:atIndexPath:)]==YES)
    {
        [self.delegate contactEditView:self ppPhoneTextFieldTableViewCellDidChanged:phoneTextFieldTableViewCell atIndexPath:self.shouldEditIndexPath];
    }
}


//================================================================================
//
//================================================================================
- (void)ppPhoneTextFieldTableViewCellDidEndEditing:(PPPhoneTextFieldTableViewCell *)phoneTextFieldTableViewCell
{
    do
    {
        if([self.delegate respondsToSelector:@selector(contactEditView:ppPhoneTextFieldTableViewCellDidEndEditing:atIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSIndexPath *indexPath = [NSIndexPath indexPathForRow:[self.contactEditTableView indexPathForCell:phoneTextFieldTableViewCell].row
                                                    inSection:[self.contactEditTableView  indexPathForCell:phoneTextFieldTableViewCell].section];
        
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        [self.delegate contactEditView:self ppPhoneTextFieldTableViewCellDidEndEditing:phoneTextFieldTableViewCell atIndexPath:indexPath];
        
    }
    while (0);
}



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPTextFieldTableViewCellDelegate Method

//================================================================================
//
//================================================================================
- (BOOL)ppTextFieldTableViewCellShouldBeginEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell
{
    BOOL result = YES;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(contactEditView:ppTextFieldTableViewCellShouldBeginEditing:atIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.shouldEditIndexPath = [NSIndexPath indexPathForRow:[self.contactEditTableView indexPathForCell:textFieldTableViewCell].row
                                                        inSection:[self.contactEditTableView  indexPathForCell:textFieldTableViewCell].section];
  
        //////////////////////////////////////////////////
        
        result = [self.delegate contactEditView:self ppTextFieldTableViewCellShouldBeginEditing:textFieldTableViewCell atIndexPath:self.shouldEditIndexPath];
    
        
    } while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)ppTextFieldTableViewCellDidBeginEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell
{
   
    
    if([self.delegate respondsToSelector:@selector(contactEditView:ppTextFieldTableViewCellDidBeginEditing:atIndexPath:)]==YES)
    {
        [self.delegate contactEditView:self ppTextFieldTableViewCellDidBeginEditing:textFieldTableViewCell atIndexPath:self.shouldEditIndexPath];
    }
   
}


//================================================================================
//
//================================================================================
- (void)ppTextFieldTableViewCellDidChanged:(PPTextFieldTableViewCell *)textFieldTableViewCell
{
    if([self.delegate respondsToSelector:@selector(contactEditView:ppTextFieldTableViewCellDidChanged:atIndexPath:)]==YES)
    {
        [self.delegate contactEditView:self ppTextFieldTableViewCellDidChanged:textFieldTableViewCell atIndexPath:self.shouldEditIndexPath];
    }
}


//================================================================================
//
//================================================================================
- (BOOL)ppTextFieldTableViewCellShouldReturn:(PPTextFieldTableViewCell *)textFieldTableViewCell
{
    BOOL result = YES;
    
    if([self.delegate respondsToSelector:@selector(contactEditViewTableViewCellShowReturn)]==YES)
    {
        result = [self.delegate contactEditViewTableViewCellShowReturn];
    }
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)ppTextFieldTableViewCellDidEndEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell
{
    do
    {
        if([self.delegate respondsToSelector:@selector(contactEditView:ppTextFieldTableViewCellDidEndEditing:atIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSIndexPath *indexPath = [NSIndexPath indexPathForRow:[self.contactEditTableView indexPathForCell:textFieldTableViewCell].row
                                                    inSection:[self.contactEditTableView  indexPathForCell:textFieldTableViewCell].section];
        
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        [self.delegate contactEditView:self
 ppTextFieldTableViewCellDidEndEditing:textFieldTableViewCell
                           atIndexPath:indexPath];
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPTextViewTableViewCellDelegate Method

//================================================================================
//
//================================================================================
- (BOOL)ppTextViewTableViewCellShouldBeginEditing:(PPTextViewTableViewCell *)textViewTableViewCell
{
    BOOL result = YES;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(contactEditView:ppTextViewTableViewCellShouldBeginEditing:atIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.shouldEditIndexPath =[NSIndexPath indexPathForRow:[self.contactEditTableView indexPathForCell:textViewTableViewCell].row
                                                     inSection:[self.contactEditTableView  indexPathForCell:textViewTableViewCell].section];
        
        //////////////////////////////////////////////////
        
        result = [self.delegate contactEditView:self ppTextViewTableViewCellShouldBeginEditing:textViewTableViewCell
                                    atIndexPath:self.shouldEditIndexPath];
    
    } while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)ppTextViewTableViewCellDidBeginEditing:(PPTextViewTableViewCell *)textViewTableViewCell
{
    
    if([self.delegate respondsToSelector:@selector(contactEditView:ppTextViewTableViewCellDidBeginEditing:atIndexPath:)]==YES)
    {
        [self.delegate contactEditView:self
ppTextViewTableViewCellDidBeginEditing:textViewTableViewCell
                           atIndexPath:self.shouldEditIndexPath];
    }

}


//================================================================================
//
//================================================================================
- (void)ppTextViewTableViewCellDidChange:(PPTextViewTableViewCell *)textViewTableViewCell
{
    if([self.delegate respondsToSelector:@selector(contactEditView:ppTextViewTableViewCellDidChange:atIndexPath:)]==YES)
    {
        [self.delegate contactEditView:self
      ppTextViewTableViewCellDidChange:textViewTableViewCell
                           atIndexPath:self.shouldEditIndexPath];

    }
}


//================================================================================
//
//================================================================================
- (void)ppTextViewTableViewCellDidEndEditing:(PPTextViewTableViewCell *)textViewTableViewCell
{
    do
    {
        if([self.delegate respondsToSelector:@selector(contactEditView:ppTextViewTableViewCellDidEndEditing:atIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSIndexPath *indexPath = [NSIndexPath indexPathForRow:[self.contactEditTableView indexPathForCell:textViewTableViewCell].row
                                                     inSection:[self.contactEditTableView  indexPathForCell:textViewTableViewCell].section];
        
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        [self.delegate contactEditView:self
  ppTextViewTableViewCellDidEndEditing:textViewTableViewCell
                           atIndexPath:indexPath];
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPHeadImageNameTableViewCell Method

//================================================================================
//
//================================================================================
- (void)ppHeadImageNameTableViewCellDidBeginEditing:(PPHeadImageNameTabelViewCell *)headImageNameTabelViewCell
                                       textFieldTag:(NSUInteger)tag
{
    if([self.delegate respondsToSelector:@selector(contactEditView:ppHeadImageNameTableViewCellDidBeginEditing:textFieldTag:atIndexPath:)]==YES)
    {
        [self.delegate contactEditView:self ppHeadImageNameTableViewCellDidBeginEditing:headImageNameTabelViewCell textFieldTag:tag atIndexPath:self.shouldEditIndexPath];
    }
}


//================================================================================
//
//================================================================================
- (BOOL)ppHeadImageNameTableViewCellShouldBeginEditing:(PPHeadImageNameTabelViewCell *)headImageNameTabelViewCell textFieldTag:(NSUInteger)tag
{
    BOOL result = YES;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(contactEditView:ppHeadImageNameTableViewCellShouldBeginEditing:textFieldTag:atIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.shouldEditIndexPath =[NSIndexPath indexPathForRow:[self.contactEditTableView indexPathForCell:headImageNameTabelViewCell].row inSection:[self.contactEditTableView  indexPathForCell:headImageNameTabelViewCell].section];
        
        //////////////////////////////////////////////////
        
        result = [self.delegate contactEditView:self
 ppHeadImageNameTableViewCellShouldBeginEditing:headImageNameTabelViewCell
                                   textFieldTag:tag
                                    atIndexPath:self.shouldEditIndexPath];
        
        
    } while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)ppHeadImageNameTableViewCellDidChanged:(PPHeadImageNameTabelViewCell *)headImageNameTabelViewCell
                                  textFieldTag:(NSUInteger)tag
{
    if([self.delegate respondsToSelector:@selector(contactEditView:ppHeadImageNameTableViewCellDidChanged:textFieldTag:atIndexPath:)]==YES)
    {
        [self.delegate contactEditView:self ppHeadImageNameTableViewCellDidChanged:headImageNameTabelViewCell textFieldTag:tag atIndexPath:self.shouldEditIndexPath];
    }
}


//================================================================================
//
//================================================================================
- (void)ppHeadImageNameTableViewCellTouchDetail:(PPHeadImageNameTabelViewCell *)headImageNameTabelViewCell
                                   textFieldTag:(NSUInteger)tag
{
    if([self.delegate respondsToSelector:@selector(contactEditView:ppHeadImageNameTableViewCellTouchDetail:textFieldTag:atIndexPath:)]==YES)
    {
        [self.delegate contactEditView:self ppHeadImageNameTableViewCellTouchDetail:headImageNameTabelViewCell textFieldTag:tag atIndexPath:self.shouldEditIndexPath];
    }
}


//================================================================================
//
//================================================================================
- (void)ppHeadImageNameTableViewCell:(PPHeadImageNameTabelViewCell *)headImageNameTabelViewCell
                            ppButton:(PPButton *)ppButton
                        controlEvent:(UIControlEvents)controlEvent
{
    if([self.delegate respondsToSelector:@selector(contactEditView:ppHeadImageNameTableViewCell:ppButton:controlEvent:)]==YES)
    {
        [self.delegate contactEditView:self ppHeadImageNameTableViewCell:headImageNameTabelViewCell ppButton:ppButton controlEvent:controlEvent];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDataSource Method

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    NSInteger number = 0;
    
    do
    {
        if([self.dataSource respondsToSelector:@selector(numberOfSectionsInContactEditView:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        number = [self.dataSource numberOfSectionsInContactEditView:self];
        
    } while (0);
    
    
    return number;
}


//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger number = 0;
    
    do
    {
        if([self.dataSource respondsToSelector:@selector(contactEditView:numberOfRowsInSection:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        number = [self.dataSource contactEditView:self
                            numberOfRowsInSection:section];
        
    } while (0);
    
    
    return number;
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = nil;
    
    do
    {
        if([self.dataSource respondsToSelector:@selector(contactEditView:cellForRowAtIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        cell = [self.dataSource contactEditView:self cellForRowAtIndexPath:indexPath];
        
        //////////////////////////////////////////////////

    } while (0);
    
    //////////////////////////////////////////////////
    
    if(cell==nil)
    {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:NSStringFromClass([UITableViewCell class])] autorelease];
    }
    
    return cell;
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath
{
    if([self.dataSource respondsToSelector:@selector(contactEditView:commitEditingStyle:forRowAtIndexPath:)]==YES)
    {
        [self.dataSource contactEditView:self
                      commitEditingStyle:editingStyle
                       forRowAtIndexPath:indexPath];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDelegate Method

//================================================================================
//
//================================================================================
- (void)scrollViewDidScroll:(UIScrollView *)scrollView
{
    if([self.delegate respondsToSelector:@selector(contactEditViewDidScroll:)]==YES)
    {
        [self.delegate contactEditViewDidScroll:self];
    }
}


//==============================================================================
//
//==============================================================================
//- (nullable NSIndexPath *)tableView:(UITableView *)tableView willSelectRowAtIndexPath:(NSIndexPath *)indexPath
//{
//    return nil;
//}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if([self.delegate respondsToSelector:@selector(contactEditView:didSelectRowAtIndexPath:)]==YES)
    {
        [self.delegate contactEditView:self
               didSelectRowAtIndexPath:indexPath];
    }
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didDeselectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if([self.delegate respondsToSelector:@selector(contactEditView:didDeselectRowAtIndexPath:)]==YES)
    {
        [self.delegate contactEditView:self
             didDeselectRowAtIndexPath:indexPath];
    }
}


//================================================================================
//
//================================================================================
- (UITableViewCellEditingStyle)tableView:(UITableView *)tableView editingStyleForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCellEditingStyle style = UITableViewCellEditingStyleNone;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(contactEditView:editingStyleForRowAtIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        style = [self.delegate contactEditView:self editingStyleForRowAtIndexPath:indexPath];
        
    } while (0);
    
    return style;
}


//===============================================================================
//
//===============================================================================
- (CGFloat)tableView:(UITableView *)tableView estimatedHeightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CGFloat rowHeight = UITableViewAutomaticDimension;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(contactEditView:estimatedHeightForRowAtIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        rowHeight = [self.delegate contactEditView:self estimatedHeightForRowAtIndexPath:indexPath];
        
    } while (0);
    
    return rowHeight;
}


//===============================================================================
//
//===============================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CGFloat rowHeight = tableView.rowHeight;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(contactEditView:heightForRowAtIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        rowHeight = [self.delegate contactEditView:self heightForRowAtIndexPath:indexPath];
        
    } while (0);
    
    return rowHeight;
}


//===============================================================================
//
//===============================================================================
- (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath
{
    BOOL result = NO;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(contactEditView:canMoveRowAtIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        result = [self.delegate contactEditView:self canMoveRowAtIndexPath:indexPath];
        
    } while (0);
    
    return result;
}


//===============================================================================
//
//===============================================================================
- (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)sourceIndexPath toIndexPath:(NSIndexPath *)destinationIndexPath
{
    do
    {
        if([self.delegate respondsToSelector:@selector(contactEditView:moveRowAtIndexPath:toIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [self.delegate contactEditView:self moveRowAtIndexPath:sourceIndexPath toIndexPath:destinationIndexPath];
        
    } while (0);
}


//===============================================================================
//
//===============================================================================
- (NSIndexPath *)tableView:(UITableView *)tableView targetIndexPathForMoveFromRowAtIndexPath:(NSIndexPath *)sourceIndexPath toProposedIndexPath:(NSIndexPath *)proposedDestinationIndexPath
{
    NSIndexPath *indexPath = [NSIndexPath indexPathForRow:sourceIndexPath.row inSection:sourceIndexPath.section];
    
    do
    {
        if([self.delegate respondsToSelector:@selector(contactEditView:targetIndexPathForMoveFromRowAtIndexPath:toProposedIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        indexPath = [self.delegate contactEditView:self targetIndexPathForMoveFromRowAtIndexPath:sourceIndexPath toProposedIndexPath:proposedDestinationIndexPath];
        
    } while (0);
    
    return indexPath;
}


//================================================================================
//
//================================================================================
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    UIView *view = self.sectionHeaders[@(section)];
    
    do
    {
        if (view==nil)
        {
            if([self.delegate respondsToSelector:@selector(contactEditView:viewForHeaderInSection:)]==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            view = [self.delegate contactEditView:self
                           viewForHeaderInSection:section];
            
            if (view)
            {
                [self.sectionHeaders setObject:view forKey:@(section)];
            }
        }
        
    }
    while (0);
    
    return view;
}



//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    CGFloat heightForHeaderInSection = 0;
    
    do
    {
        do
        {
            if([self.delegate respondsToSelector:@selector(contactEditView:heightForHeaderInSection:)]==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            heightForHeaderInSection = [self.delegate contactEditView:self
                                             heightForHeaderInSection:section];
            
        } while (0);
    }
    while (0);
    
    return heightForHeaderInSection;
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView willDisplayCell:(UITableViewCell *)cell forRowAtIndexPath:(NSIndexPath *)indexPath
{
    do
    {
        if([self.delegate respondsToSelector:@selector(contactEditView:willDisplayCell:forRowAtIndexPath:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        [self.delegate contactEditView:self
                       willDisplayCell:cell
                     forRowAtIndexPath:indexPath];
    }
    while (0);
}
@end
