//
//  WCReRecognitionFlowController.h
//  Pods
//
//  Created by sanhue on 2015/9/6.
//
//

#import <Foundation/Foundation.h>
#import "WCRecogSourceModel.h"
#import "WCCardModel.h"

typedef NS_ENUM(NSInteger, WCReRecognitionFlowControllerErrorCode)
{
    WCReRecognitionFlowControllerErrorCode_None = 0,
    WCReRecognitionFlowControllerErrorCode_Cancel,
};

typedef void (^ReRecognitionFinish)(WCCardModel *resultModel, NSError *error);

// sourceModel, imageSource, outputTranslate要自已塞
typedef WCCardModel* (^ReRecognitionAction)(WCRecogSourceModel *sourceModel,BOOL isBackSide, NSError **error);

////////////////////////////////////////////////////////////////////////////////////////////////////
// 再辨識流程
// 先看是否有正反面名片，並設定要辨識正反辨識語系，
// 辨識部份需delegate出來給外部做，
// 辨識後的回傳辨識結果

@interface WCReRecognitionFlowController : NSObject

+ (void)startFromViewController:(UIViewController *)viewController
                 recogLanguages:(NSArray *)recogLanguages
               defaultFrontLang:(NSInteger)defaultFrontLang
                defaultBackLang:(NSInteger)defaultBackLang
                 frontCardImage:(UIImage *)frontCardImage
                  backCardImage:(UIImage *)backCardImage
            showRecogSideOnCell:(BOOL)showRecogSideOnCell
                originCardModel:(WCCardModel *)originCardModel
              recognitionAction:(ReRecognitionAction)recognitionAction
                     completion:(ReRecognitionFinish)completion;
    
+ (void)startFromViewController:(UIViewController *)viewController
                 recogLanguages:(NSArray *)recogLanguages
               defaultFrontLang:(NSInteger)defaultFrontLang
                defaultBackLang:(NSInteger)defaultBackLang
                 frontCardImage:(UIImage *)frontCardImage
                  backCardImage:(UIImage *)backCardImage
                originCardModel:(WCCardModel *)originCardModel
              recognitionAction:(ReRecognitionAction)recognitionAction
                     completion:(ReRecognitionFinish)completion;


+ (void)endOfReRecognitionFlowController;

@end
