//
//  WCContactAccessToolController.m
//  Pods
//
//  Created by sanhue on 2015/8/7.
//
//

#import "AVCaptureDevice+RequestAuthorization.h"
#import "PPAlertView.h"
#import "PPViewController.h"
#import "UIImage+Additions.h"
#import "PHAsset+Image.h"
#import "WCCaptureFlowController.h"
#import "WCContactAccessFlowResourceDefine.h"
#import "WCImagePickerController.h"
#import "WCAlbumFlowController.h"
#import <UIKit/UIImagePickerController.h>
#import "WCKernelRecogLangModel.h"



static WCImagePickerController *staticPickerController = nil;
static NSInteger WCImagePickerController_ImageMaxLength  = 1600;
////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCImagePickerController ()
<
UINavigationControllerDelegate,
UIImagePickerControllerDelegate,
WCAlbumFlowControllerDatasource,
WCAlbumFlowControllerDelegate,
WCCaptureFlowControllerDelegate
>

@property (nonatomic, copy) WCImagePickerCompletion completion;
@property (nonatomic, copy) WCImagePickerCompletionWithRecognitionTitle completionWithRecognitionTitle;
@property (nonatomic, retain) WCCaptureFlowController *captureFlowController;
@property (nonatomic, retain) WCAlbumFlowController *albumFlowController;

@property (nonatomic, assign) BOOL isMyCardFlow;
@property (nonatomic, assign) NSUInteger currentLanguageCode;
@property (nonatomic, retain) NSArray *recogLanguageModels;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCImagePickerController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.isMyCardFlow = NO;
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.albumFlowController = nil;
    self.captureFlowController = nil;
    self.completion = nil;
    self.completionWithRecognitionTitle = nil;
    self.recogLanguageModels = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark -


//==============================================================================
//
//==============================================================================
- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary<NSString *,id> *)info
{
    if (self.completion!=nil)
    {
        UIImage *image = [info objectForKey:UIImagePickerControllerOriginalImage];
        UIImage *tempImage = [[image imageByAdjustOrientationWithMaxLength:WCImagePickerController_ImageMaxLength] copy];
        self.completion(tempImage);
        [tempImage release];
    }
    
    
    //////////////////////////////////////////////////
    
    [picker dismissAnimated:NO completion:^{
        [staticPickerController release];
        staticPickerController = nil;
    }];

}

//==============================================================================
//
//==============================================================================
- (void)imagePickerControllerDidCancel:(UIImagePickerController *)picker
{
    
    //////////////////////////////////////////////////
    
    [picker dismissAnimated:NO completion:^{
        [staticPickerController release];
        staticPickerController = nil;
    }];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCCaptureFlowController

#pragma mark for showMyCardCamaraFromViewController:
//==============================================================================
//
//==============================================================================
- (NSUInteger)recogLangCodeWithRecogTitle:(NSString *)recogTitle
{
    return [self recogIDWithLocalizedString:recogTitle];
}


//================================================================================
//
//================================================================================
- (NSArray *)recogLanguagesWithCaptureSide:(WCCaptureViewController_CaptureSide)captureSide
{
    return [self recogLangTitlesWithSelectedTitle:nil];
}


//================================================================================
//
//================================================================================
- (void)captureFlowControllerDidClickCancel:(WCCaptureFlowController *)captureFlowController
                  fromCaptureViewController:(WCCaptureViewController *)captureViewController
{
    [captureViewController dismissAnimated:YES completion:nil];
}


//==============================================================================
//
//==============================================================================
- (void)captureFlowController:(WCCaptureFlowController *)captureFlowController
     fromCaptureViewControler:(WCCaptureViewController *)captureViewController
     manualModeDidSelectImage:(UIImage *)image
             recogSourceModel:(WCRecogSourceModel *)recogSourceModel
                      isFinal:(BOOL)isFinal
{
    if (self.completionWithRecognitionTitle)
    {
        self.completionWithRecognitionTitle(image, recogSourceModel.recogLang);
    }
    
    [captureViewController.presentingViewController dismissAnimated:YES completion:^{
        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.3 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
            [captureViewController dismissAnimated:NO completion:nil];
        });
    }];
}


#pragma mark for showCamaraFromViewController:

//==============================================================================
//
//==============================================================================
- (void)captureFlowController:(WCCaptureFlowController *)captureFlowController
      singleManualSelectImage:(UIImage *)image
{
    if (self.completion!=nil)
    {
        UIImage *tempImage = [[image imageByAdjustOrientationWithMaxLength:WCImagePickerController_ImageMaxLength] copy];
        self.completion(tempImage);
        [tempImage release];
    }
}


//==============================================================================
//
//==============================================================================
- (void)captureFlowControllerDidFinish:(WCCaptureFlowController *)captureFlowController
{
    
    //////////////////////////////////////////////////
    if (self.isMyCardFlow==NO)
    {
        dispatch_async(dispatch_get_main_queue(), ^{
            [staticPickerController release];
            staticPickerController = nil;
        });
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCAlbumFlowControllerDelegate


//==============================================================================
//
//==============================================================================
- (void)albumFlowController:(WCAlbumFlowController *)albumFlowController didFinishAssetImageDictionary:(NSMutableDictionary *)assetImageDictionary recogLanguageTitle:(NSString *)recogLanguageTitle fromViewContrller:(UIViewController *)viewContrller
{
    // !!TODO: MyCard的flow 會需要
    if(assetImageDictionary.count>0)
    {
        // !!MyCard只會有一張
        PHAsset *asset = [assetImageDictionary objectForKey:[[assetImageDictionary allKeys] firstObject]];
        [asset fetchImageWithTargetSize:CGSizeMake(asset.pixelWidth, asset.pixelHeight) completeHandler:^(UIImage *result) {
            
            UIImage *tempImage = [[result imageByAdjustOrientationWithMaxLength:WCImagePickerController_ImageMaxLength] copy];
            if (self.completionWithRecognitionTitle!=nil)
            {
                self.completionWithRecognitionTitle(tempImage, [self recogIDWithLocalizedString:recogLanguageTitle]);
            }
            [tempImage release];
            
            //////////////////////////////////////////////////
            dispatch_async(dispatch_get_main_queue(), ^{
                [viewContrller dismissAnimated:YES completion:^{
                    [staticPickerController release];
                    staticPickerController = nil;
                }];
            });
        }];
    }

}


//==============================================================================
//
//==============================================================================
- (void)albumFlowController:(WCAlbumFlowController *)albumFlowController didFinishSelectImage:(UIImage *)image
{
    if (self.completion!=nil)
    {
        UIImage *tempImage = [[image imageByAdjustOrientationWithMaxLength:WCImagePickerController_ImageMaxLength] copy];
        self.completion(tempImage);
        [tempImage release];
    }
}



//==============================================================================
//
//==============================================================================
- (void)albumFlowControllerDidFinish:(WCAlbumFlowController *)albumFlowController
{
    //////////////////////////////////////////////////
    // !! myCard的退出不在這邊處理
    if(self.isMyCardFlow==YES)
    {
        return ;
    }
    dispatch_async(dispatch_get_main_queue(), ^{
        [staticPickerController release];
        staticPickerController = nil;
    });
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCAlbumFlowController Datasource Method

//================================================================================
//
//================================================================================
- (NSString *)frontCardRecognitionTitle
{
    return [self recogTitleWithRecogLangCode:self.currentLanguageCode];
}


//================================================================================
//
//================================================================================
- (NSArray *)recognitionLanguageTitleArrayWithCurRecognitionLanguageTitle:(NSString *)curRecognitionLanguageTitle
{
    return [self recogLangTitlesWithSelectedTitle:curRecognitionLanguageTitle];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private recognition methods


//================================================================================
//
//================================================================================
- (NSString *)recogTitleWithRecogLangCode:(NSUInteger)recogLangCode
{
    NSString *recogTitle = nil;
    
    //////////////////////////////////////////////////
    
    //辨識語系
    for(WCKernelRecogLangModel *kernelRecoLangModel in self.recogLanguageModels)
    {
        recogTitle = kernelRecoLangModel.localizedString;
        
        //////////////////////////////////////////////////
        
        //找到目前語系
        if(kernelRecoLangModel.langCode==recogLangCode)
        {
            break;
        }
    }
    
    return recogTitle;
}


//================================================================================
//
//================================================================================
- (NSArray *)recogLangTitlesWithSelectedTitle:(NSString *)selectedTitle
{
    NSMutableArray *kernelRecogLangModes = nil;
    
    do
    {
        kernelRecogLangModes = [NSMutableArray array];
        
        if(kernelRecogLangModes==nil)
        {
            break;
        }

        //////////////////////////////////////////////////
        
        for(WCKernelRecogLangModel *kernelRecoLangModel in self.recogLanguageModels)
        {
            if([kernelRecoLangModel.localizedString compare:selectedTitle]==NSOrderedSame)
            {
                [kernelRecogLangModes insertObject:kernelRecoLangModel.localizedString atIndex:0];
            }
            else
            {
                [kernelRecogLangModes addObject:kernelRecoLangModel.localizedString];
            }
        }
    }
    while (0);
    
    return kernelRecogLangModes;
}


//==============================================================================
//
//==============================================================================
- (NSInteger)recogIDWithLocalizedString:(NSString *)localizedString
{
    for (WCKernelRecogLangModel *langModel in self.recogLanguageModels)
    {
        if ([langModel.localizedString isEqualToString:localizedString])
        {
            return langModel.langCode;
        }
    }
    
    return -1;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - private  methods


//==============================================================================
//
//==============================================================================
- (void)showMyCardSelectImageFromViewController:(UIViewController *)viewController
                              recogLanguageCode:(NSUInteger)recogLanguageCode
                            recogLanguageModels:(NSArray*)recogLanguageModels
{
    self.albumFlowController = [[[WCAlbumFlowController alloc] init] autorelease];
    if (self.albumFlowController!=nil)
    {
        self.currentLanguageCode = recogLanguageCode;
        self.recogLanguageModels = recogLanguageModels;
        [self.albumFlowController presentMyCardSelectImageViewControllerFromSuperViewController:viewController
                                                                  albumFlowControllerDatasource:self
                                                                    albumFlowControllerDelegate:self];
    }
}


//==============================================================================
//
//==============================================================================
- (void)showMyCardCameraFromViewController:(UIViewController *)viewController
                         recogLanguageCode:(NSUInteger)recogLanguageCode
                       recogLanguageModels:(NSArray*)recogLanguageModels
{
    if ([UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera])
    {
        [AVCaptureDevice requestAccessCameraWithSuccessHandler:^{
            self.captureFlowController = [[[WCCaptureFlowController alloc] init] autorelease];
            if (self.captureFlowController!=nil)
            {
                self.captureFlowController.captureFlowDelegate = self;
                self.captureFlowController.captureFlowDatasource = self;
                
                self.currentLanguageCode = recogLanguageCode;
                self.recogLanguageModels = recogLanguageModels;

                [self.captureFlowController presentMultiModeFromViewController:viewController
                                                                   captureSide:CaptureSide_None
                                                                  captureCount:0
                                                           supportCaptureModes:@[@(CaptureMode_Manual)]
                                                             activeCaptureMode:CaptureMode_Manual
                                                             presentCompletion:nil];
//                [self.captureFlowController presentSingleManualModeFromViewController:viewController
//                                                                          captureSide:CaptureSide_None
//                                                                    presentCompletion:nil];
            }
        } failedHandler:^{
            [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                 title:@""
                               message:WCCardImageFlowControllerString_CameraPolicyFailed
                     cancelButtonTitle:WCCAFC_Ok
                     otherButtonTitles:nil];
        }];
    }
    else
    {
        [PPAlertView showWithStyle:UIAlertViewStyleDefault
                             title:@""
                           message:WCCardImageFlowControllerString_NotSupportCamera
                 cancelButtonTitle:WCCAFC_Ok
                 otherButtonTitles:nil];
    }
}

//==============================================================================
//
//==============================================================================
- (void)showAlbumFromViewController:(UIViewController *)viewController
{
    self.albumFlowController = [[[WCAlbumFlowController alloc] init] autorelease];
    if (self.albumFlowController!=nil)
    {
        [self.albumFlowController presentSelectImageViewControllerFromSuperViewController:viewController
                                                              albumFlowControllerDelegate:self];
    }
}


//==============================================================================
//
//==============================================================================
- (void)showCameraFromViewController:(UIViewController *)viewController
{
    if ([UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera])
    {
        [AVCaptureDevice requestAccessCameraWithSuccessHandler:^{
            self.captureFlowController = [[[WCCaptureFlowController alloc] init] autorelease];
            if (self.captureFlowController!=nil)
            {
                self.captureFlowController.captureFlowDelegate = self;
                
                [self.captureFlowController presentSingleManualModeFromViewController:viewController captureSide:CaptureSide_None presentCompletion:nil];
            }
        } failedHandler:^{
            [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                 title:@""
                               message:WCCardImageFlowControllerString_CameraPolicyFailed
                     cancelButtonTitle:WCCAFC_Ok
                     otherButtonTitles:nil];
        }];
    }
    else
    {
        [PPAlertView showWithStyle:UIAlertViewStyleDefault
                             title:@""
                           message:WCCardImageFlowControllerString_NotSupportCamera
                 cancelButtonTitle:WCCAFC_Ok
                 otherButtonTitles:nil];
    }
}


//==============================================================================
//
//==============================================================================
- (void)showSystemCameraFromViewController:(UIViewController *)viewController
{
    if ([UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera])
    {
        [AVCaptureDevice requestAccessCameraWithSuccessHandler:^{
            UIImagePickerController *imagePickerController = [[UIImagePickerController alloc] init];
            if (imagePickerController)
            {
                imagePickerController.sourceType = UIImagePickerControllerSourceTypeCamera;
                imagePickerController.delegate = self;
                [viewController presentViewController:imagePickerController animated:NO completion:nil];
            }
            [imagePickerController release];
        } failedHandler:^{
            [PPAlertView showWithStyle:UIAlertViewStyleDefault
                                 title:@""
                               message:WCCardImageFlowControllerString_CameraPolicyFailed
                     cancelButtonTitle:WCCAFC_Ok
                     otherButtonTitles:nil];
        }];
    }
    else
    {
        [PPAlertView showWithStyle:UIAlertViewStyleDefault
                             title:@""
                           message:WCCardImageFlowControllerString_NotSupportCamera
                 cancelButtonTitle:WCCAFC_Ok
                 otherButtonTitles:nil];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - class methods


//==============================================================================
//
//==============================================================================
+ (void)showMyCardSelectImageFromViewController:(UIViewController *)viewController
                               recogLanguageCode:(NSUInteger)recogLanguageCode
                            recogLanguageModels:(NSArray*)recogLanguageModels
                                     completion:(WCImagePickerCompletionWithRecognitionTitle)completion
{
    [staticPickerController release];
    staticPickerController = [[WCImagePickerController alloc] init];
    if (staticPickerController)
    {
        staticPickerController.isMyCardFlow = YES;
        staticPickerController.completionWithRecognitionTitle = completion;
        [staticPickerController showMyCardSelectImageFromViewController:viewController
                                                      recogLanguageCode:recogLanguageCode
                                                    recogLanguageModels:recogLanguageModels];
    }
}


//==============================================================================
//
//==============================================================================
+ (void)showMyCardCameraFromViewController:(UIViewController *)viewController
                         recogLanguageCode:(NSUInteger)recogLanguageCode
                       recogLanguageModels:(NSArray*)recogLanguageModels
                                completion:(WCImagePickerCompletionWithRecognitionTitle)completion
{
    [staticPickerController release];
    staticPickerController = [[WCImagePickerController alloc] init];
    if (staticPickerController)
    {
        staticPickerController.isMyCardFlow = YES;
        staticPickerController.completionWithRecognitionTitle = completion;
        [staticPickerController showMyCardCameraFromViewController:viewController
                                                 recogLanguageCode:recogLanguageCode
                                               recogLanguageModels:recogLanguageModels];
    }
}


//==============================================================================
//
//==============================================================================
+ (void)showAlbumFromViewController:(UIViewController *)viewController completion:(WCImagePickerCompletion)completion
{
    [staticPickerController release];
    staticPickerController = [[WCImagePickerController alloc] init];
    if (staticPickerController)
    {
        staticPickerController.completion = completion;
        [staticPickerController showAlbumFromViewController:viewController];
    }
}


//==============================================================================
//
//==============================================================================
+ (void)showCameraFromViewController:(UIViewController *)viewController completion:(WCImagePickerCompletion)completion
{
    [staticPickerController release];
    staticPickerController = [[WCImagePickerController alloc] init];
    if (staticPickerController)
    {
        staticPickerController.completion = completion;
        [staticPickerController showCameraFromViewController:viewController];
    }
}


//==============================================================================
//
//==============================================================================
+ (void)showSystemCameraFromViewController:(UIViewController *)viewController completion:(WCImagePickerCompletion)completion
{
    [staticPickerController release];
    staticPickerController = [[WCImagePickerController alloc] init];
    if (staticPickerController)
    {
        staticPickerController.completion = completion;
        [staticPickerController showSystemCameraFromViewController:viewController];
    }
}

@end
