//
//  WCContactAccessFlowController+Common.m
//  ADAL
//
//  Created by sanhue on 2019/7/20.
//

#import "WCContactAccessFlowController+Common.h"
#import "WCFieldTypeConverter.h"
#import "WCCustomFieldListItem.h"
#import "WCContactViewController+PublicParameterDefine.h"
#import "NSDate+Format.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCContactAccessFlowController (Common)



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark 處理contactDataExchangeModel轉為fieldModel

//===============================================================================
// 處理姓名，公司，地址等複合欄位的更新
// 也可處理電話，email, url, 等一般欄位
//===============================================================================
+ (void)complexFieldModelWithFieldModel:(WCFieldModel *)fieldModel
                      dataExchangeModel:(ContactDataExchangeModel *)dataModel
                        contactMainType:(PPContactMainType)type
{
    //////////////////////////////////////////////////
    
    BOOL isForWCTMode = NO;
    
#if defined(PRODUCTLINE_WCT)
    isForWCTMode = YES;
#endif
    
    //////////////////////////////////////////////////
    
    NSArray *fieldKeyArray=[dataModel.propertyDictionary allKeys];
    
    fieldModel.source = [WCFieldTypeConverter fieldSourceFromPPContactFieldSource:dataModel.contactFieldSource];
    fieldModel.type = [WCFieldTypeConverter fieldTypeFromPPContactMainType:type];
    fieldModel.subType1 = [WCFieldTypeConverter fieldSubType1WithPPContactLabelTextString:dataModel.labelText mainType:type];
    
    //////////////////////////////////////////////////
    
    for (id fieldKey in fieldKeyArray)
    {
        id value = [dataModel.propertyDictionary objectForKey:fieldKey];
        CGRect recognRect=CGRectZero;
        //////////////////////////////////////////////////
        // 處理subtype2 (複合欄位)
        // 沒有subtype1==WC_FST1_None或是地址才要處理
        if (fieldModel.type==WC_FT_Name||
            fieldModel.type==WC_FT_Company||
            fieldModel.type==WC_FT_Address)
        {
            //////////////////////////////////////////////////
            // 轉換為subtype
            PPContactSubType subType=(PPContactSubType)[fieldKey integerValue];
            WC_FieldSubType2 wcmSubtype = [WCFieldTypeConverter fieldSubType2FromPPContactSubType:subType];
            //////////////////////////////////////////////////
            // 處理子欄位
            if (wcmSubtype!=WC_FST2_None)
            {
                recognRect=CGRectFromString([dataModel.imageRectDictionary objectForKey:fieldKey]);
                
                if ([value length]>0)
                {
                    [fieldModel setSubType2FieldWithValue:value recogRect:recognRect subType2:wcmSubtype];
                }
                else
                {
                    [fieldModel removeFieldWithWithSubType2:wcmSubtype];
                }
            }
        }
        else if(fieldModel.type==WC_FT_UserDefine)
        {
            if(isForWCTMode)
            {
                PPContactSubType subType=(PPContactSubType)[fieldKey integerValue];
                
                if (subType==PPContactSubType_UserDefine_ID)
                {
                    fieldModel.guid = value;
                }
                else if (subType==PPContactSubType_UserDefine_UserInfo)
                {
                    if ([value isKindOfClass:[NSDictionary class]])
                    {
                        NSDictionary *userInfo = (NSDictionary *)value;
                        fieldModel.customFieldContentType = (WCCustomFieldContentType)[[userInfo objectForKey:WCContactAccessFlowControllerCustomFieldKey_ContentType] integerValue];
                        fieldModel.customFieldInfoGuid = [userInfo objectForKey:WCContactAccessFlowControllerCustomFieldKey_FieldInfoGuid];
                    }
                }
                else if (subType==PPContactSubType_UserDefine_Text||
                         subType==PPContactSubType_UserDefine_Integer||
                         subType==PPContactSubType_UserDefine_Float||
                         subType==PPContactSubType_UserDefine_Email||
                         subType==PPContactSubType_UserDefine_URL||
                         subType==PPContactSubType_UserDefine_ListValue||
                         subType==PPContactSubType_UserDefine_Date||
                         subType==PPContactSubType_UserDefine_DateAndTime)
                {
                    if([value length]>0)
                    {
                        NSDictionary *userInfo = [dataModel.propertyDictionary objectForKey:@(PPContactSubType_UserDefine_UserInfo)];
                        WCCustomFieldContentType contentType = (WCCustomFieldContentType)[[userInfo objectForKey:WCContactAccessFlowControllerCustomFieldKey_ContentType] integerValue];
                        
                        if(contentType==WCCustomFieldContentType_Picklist)
                        {
                            // Picklist要把值轉為item guid再存
                            NSArray *picklistItems = [userInfo objectForKey:WCContactAccessFlowControllerCustomFieldKey_ListItems];
                            
                            for (WCCustomFieldListItem *listItem in picklistItems)
                            {
                                if ([listItem.itemText isEqualToString:value])
                                {
                                    fieldModel.value = listItem.guid;
                                    break;
                                }
                            }
                        }
                        else
                        {
                            fieldModel.value = value;
                        }
                    }
                }
            }
        }
        else if(fieldModel.type==WC_FT_SalesforceData)
        {
            PPContactSubType subType=(PPContactSubType)[fieldKey integerValue];
            
            if (subType==PPContactSubType_ListValue)
            {
                if([value length]>0)
                {
                    if([value isEqualToString:WCVC_EditViewControllerSelectDisableValue]==YES)
                    {
                        fieldModel.value = nil;
                    }
                    else
                    {
                        if([value isEqualToString:WCVC_EditViewControllerSelectEmptyValue]==NO)
                        {
                            fieldModel.value = value;
                        }
                        else
                        {
                            fieldModel.value = @"";
                        }
                    }
                }
            }
        }
        else
        {
            recognRect=CGRectFromString([dataModel.imageRectDictionary objectForKey:fieldKey]);
            fieldModel.recogRect=recognRect;
            
            if([value length]>0)
            {
                fieldModel.value=value;
            }
        }
    }
}



//===============================================================================
//
//===============================================================================
+ (void)dateFieldModelWithFieldModel:(WCFieldModel *)fieldModel
                   dataExchangeModel:(ContactDataExchangeModel *)dataModel
                     contactMainType:(PPContactMainType)type
{
    NSArray *fieldKeyArray=[dataModel.propertyDictionary allKeys];
    
    fieldModel.source = [WCFieldTypeConverter fieldSourceFromPPContactFieldSource:dataModel.contactFieldSource];
    fieldModel.type = [WCFieldTypeConverter fieldTypeFromPPContactMainType:type];
    fieldModel.subType1 = [WCFieldTypeConverter fieldSubType1WithPPContactLabelTextString:dataModel.labelText mainType:type];
    
    //////////////////////////////////////////////////
    for (id fieldKey in fieldKeyArray)
    {
        id value=nil;
        CGRect recognRect = CGRectZero;
        value = [dataModel.propertyDictionary objectForKey:fieldKey];
        recognRect = CGRectFromString([dataModel.imageRectDictionary objectForKey:fieldKey]);
        
        if([value length]>0)
        {
            fieldModel.recogRect = recognRect;
            
            NSDateFormatter *formatter_ = [[NSDateFormatter alloc] init];
            // !! 要轉為UTC+0
            [formatter_ setTimeZone:[NSTimeZone timeZoneForSecondsFromGMT:0]];
            [formatter_ setFormatterBehavior:NSDateFormatterBehavior10_4];
            [formatter_ setDateFormat:NSDateFormat_Day];
            fieldModel.value = [formatter_ dateFromString:value];
            [formatter_ release];
        }
    }
}
@end
