//
//  WCClipImageViewController.m
//  Pods
//
//  Created by sanhue on 2015/8/8.
//
//

#import "WCClipImageViewController.h"
#import "PPClipBusinessCardViewController.h"
#import "PPNavigationController.h"
#import "PPSelectController.h"
#import "WCContactAccessFlowResourceDefine.h"
#import "WCKernelRecogLangModel.h"
#import "WCKernelRecogTypeModel.h"
#import "ContactApperanceDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
static WCClipImageViewController *staticClipImageViewController = nil;

typedef NS_ENUM(NSInteger, WCClipImageSelectTag)
{
    WCClipImageSelectTag_None = 0,
    WCClipImageSelectTag_RecogLang,
    WCClipImageSelectTag_RecogField,
};


////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCClipImageViewController () <PPClipBusinessCardViewControllerDelegate, PPSelectControllerDelegate>
@property (nonatomic, retain) PPClipBusinessCardViewController *ppClipBusinessCardViewController;

@property (nonatomic, copy) WCClipImageCompletion completion;

#pragma mark for hand clip recognize
@property (nonatomic, retain) PPSelectController *ppSelectController;
@property (nonatomic, copy) WCClipImageClipRecognizeCompletion recognizeCompletion;

@property (nonatomic, retain) NSArray *supportedRecogLanguages;
@property (nonatomic, retain) NSArray *supportedRecogFields;

@property (nonatomic, assign) NSInteger frontRecogLangID;
@property (nonatomic, assign) NSInteger backRecogLangID;
@end
////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCClipImageViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.completion = nil;
    
    self.ppSelectController = nil;
    self.recognizeCompletion = nil;
    self.supportedRecogLanguages = nil;
    self.supportedRecogFields = nil;

    self.ppClipBusinessCardViewController = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (Private)


//==============================================================================
//
//==============================================================================
- (void)showFromViewController:(UIViewController *)viewController
                frontCardImage:(UIImage *)frontCardImage
                 backCardImage:(UIImage *)backCardImage
          recogLangButtonTitle:(NSString *)recogLangButtonTitle
             showBackCardImage:(BOOL)showBackCardImage
                      handClip:(BOOL)handClip
{
    self.ppClipBusinessCardViewController = [[[PPClipBusinessCardViewController alloc] init] autorelease];
    if (self.ppClipBusinessCardViewController)
    {
        [self.ppClipBusinessCardViewController.view setBackgroundColor:[UIColor whiteColor]];
        self.ppClipBusinessCardViewController.delegate = self;
        if (handClip)
        {
            self.ppClipBusinessCardViewController.ppClipBusinessCardViewControllerStyle = PPClipBusinessCardViewControllerStyle_BusinessCard;
        }
        else
        {
            self.ppClipBusinessCardViewController.ppClipBusinessCardViewControllerStyle = PPClipBusinessCardViewControllerStyle_ContactPhoto;
        }
        
        if (showBackCardImage)
        {
            self.ppClipBusinessCardViewController.clipImageSide = PPClipBusinessCardViewControllerClipImageSide_RearCard;
        }
        else
        {
            self.ppClipBusinessCardViewController.clipImageSide = PPClipBusinessCardViewControllerClipImageSide_FrontCard;
        }
        
        self.ppClipBusinessCardViewController.navigationBarTitle = WCCV_MLS_HandClip;
        self.ppClipBusinessCardViewController.defaultNavigationBarStyle = PPBarViewStyle_CenteredAbsolute;
        
        self.ppClipBusinessCardViewController.frontCardImage = frontCardImage;
        self.ppClipBusinessCardViewController.rearCardImage = backCardImage;
        self.ppClipBusinessCardViewController.recognitionButtonTitle = recogLangButtonTitle;
        
        //  設定配色
        self.ppClipBusinessCardViewController.contentBackgroundColor = WCCAFC_ImageScrollViewColor;
        
        self.ppClipBusinessCardViewController.bottomToolBarButtonBackgroundColorNormal = WCCAFC_ToolBarColor;
        self.ppClipBusinessCardViewController.bottomToolBarButtonBackgroundColorHighlighted = WCCAFC_ButtonBackgroundColor;
        self.ppClipBusinessCardViewController.bottomToolBarLanguageTextColorNormal = WCCAFC_ButtonTitleColor;
        self.ppClipBusinessCardViewController.bottomToolBarLanguageTextColorHighlighted = WCCAFC_ButtonTitleSelectedColor;
        
        self.ppClipBusinessCardViewController.navigationBarButtonBackgroundColorHighlighted = WCCAFC_ButtonBackgroundColor;
        //////////////////////////////////////////////////
        if (viewController.navigationController)
        {
            [viewController.navigationController pushViewController:self.ppClipBusinessCardViewController animated:YES];
        }
        else
        {
            PPNavigationController *navigationContoller = [[PPNavigationController alloc] initWithRootViewController:self.ppClipBusinessCardViewController];
            [viewController presentViewController:navigationContoller animated:YES completion:nil];
            [navigationContoller release];
        }
    }
}


//==============================================================================
//
//==============================================================================
- (void)showSelectControllerFromViewController:(UIViewController *)viewController withArray:(NSArray *)array tag:(NSInteger)tag isBackSide:(BOOL)isBackSide
{
    if (self.ppSelectController==nil)
    {
        self.ppSelectController = [[[PPSelectController alloc] init] autorelease];
    }
    
    self.ppSelectController.sourceItemStringArray = array;
    self.ppSelectController.tag = tag;
    self.ppSelectController.delegate = self;
    self.ppSelectController.userInfo = @(isBackSide);
    [self.ppSelectController showFromViewController:viewController animated:YES];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPClipBusinessCardViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (void)ppClipBusinessCardViewController:(PPClipBusinessCardViewController *)ppClipBusinessCardViewController ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case PPClipBusinessCardViewControllerButtonTag_Back:
        {
            [ppClipBusinessCardViewController goBackAnimated:YES];
            
            //////////////////////////////////////////////////
            dispatch_async(dispatch_get_main_queue(), ^{
                [staticClipImageViewController release];
                staticClipImageViewController = nil;
            });
            break;
        }
        case PPClipBusinessCardViewControllerButtonTag_Done:
        {
            if(ppClipBusinessCardViewController.ppClipBusinessCardViewControllerStyle==PPClipBusinessCardViewControllerStyle_BusinessCard)
            {
                // 手刮辨識流程，顯示辨識欄位
                BOOL isBackSide = (ppClipBusinessCardViewController.clipImageSide==PPClipBusinessCardViewControllerClipImageSide_RearCard?YES:NO);
                NSMutableArray *fields = [[NSMutableArray alloc] init];
                for (WCKernelRecogTypeModel *recogTypeModel in self.supportedRecogFields)
                {
                    [fields addObject:recogTypeModel.localizedString];
                }
                
                if ([fields count]>0)
                {
                    [self showSelectControllerFromViewController:ppClipBusinessCardViewController withArray:fields tag:WCClipImageSelectTag_RecogField isBackSide:isBackSide];
                }
                else
                {
                    
                }
                [fields release];

                // next @selector(ppSelectController:itemSelectedIndex:withString:)
            }
            else
            {
                // 手刮大頭貼流程，回傳手刮結果後結束
                if (self.completion!=nil)
                {
                    self.completion(ppClipBusinessCardViewController.clipImage);
                }
                
                //////////////////////////////////////////////////
                
                [ppClipBusinessCardViewController goBackAnimated:YES];
                
                //////////////////////////////////////////////////
                dispatch_async(dispatch_get_main_queue(), ^{
                    [staticClipImageViewController release];
                    staticClipImageViewController = nil;
                });
            }
            break;
        }
        case PPClipBusinessCardViewControllerButtonTag_RecognitionLanguage:
        {
            
            // 顯示辨識語系
            NSMutableArray *languages = [[NSMutableArray alloc] init];
            
            // 判斷是正面或是反面來決定目前語系
            BOOL isBackSide = (ppClipBusinessCardViewController.clipImageSide==PPClipBusinessCardViewControllerClipImageSide_RearCard?YES:NO);
            self.supportedRecogLanguages =
            [WCClipImageViewController recogLanguagesAdjustedWithRecogLanguages:self.supportedRecogLanguages
                                                              defaultLanguageID:isBackSide?self.backRecogLangID:self.frontRecogLangID];

            for (WCKernelRecogLangModel *recogLangModel in self.supportedRecogLanguages)
            {
                [languages addObject:recogLangModel.localizedString];
            }
            
            if ([languages count]>0)
            {
                [self showSelectControllerFromViewController:ppClipBusinessCardViewController withArray:languages tag:WCClipImageSelectTag_RecogLang isBackSide:isBackSide];
            }
            [languages release];
            // next @selector(ppSelectController:itemSelectedIndex:withString:)
            break;
        }
        case PPClipBusinessCardViewControllerButtonTag_ChangeSide:
        {
            // 判斷是正面或是反面來決定目前語系
            BOOL isBackSide = (ppClipBusinessCardViewController.clipImageSide==PPClipBusinessCardViewControllerClipImageSide_RearCard?YES:NO);
            self.supportedRecogLanguages =
            [WCClipImageViewController recogLanguagesAdjustedWithRecogLanguages:self.supportedRecogLanguages
                                                              defaultLanguageID:isBackSide?self.backRecogLangID:self.frontRecogLangID];
            ppClipBusinessCardViewController.recognitionButtonTitle = [[self.supportedRecogLanguages firstObject] localizedString];
        }
        default:
            break;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPSelectControllerDelegate


//==============================================================================
//
//==============================================================================
- (void)ppSelectController:(PPSelectController *)selectController itemSelectedIndex:(NSInteger)itemIndex withString:(NSString *)itemString
{
    BOOL isBackSide = [selectController.userInfo boolValue];
    if (selectController.tag==WCClipImageSelectTag_RecogLang)
    {
        // 選擇後紀錄下來
        if ([self.supportedRecogLanguages count]>itemIndex)
        {
            WCKernelRecogLangModel *recgoLangModel = [self.supportedRecogLanguages objectAtIndex:itemIndex];
            if (isBackSide)
            {
                self.backRecogLangID = recgoLangModel.langCode;
            }
            else
            {
                self.frontRecogLangID = recgoLangModel.langCode;
            }
            
            // 設定按鈕文字
            self.ppClipBusinessCardViewController.recognitionButtonTitle = recgoLangModel.localizedString;
        }
    }
    else
    {
        // 選擇後，送出completion, 結束流程
        if (self.recognizeCompletion)
        {
            if ([self.supportedRecogFields count]>itemIndex)
            {
                WCKernelRecogTypeModel *recogTypeModel = [self.supportedRecogFields objectAtIndex:itemIndex];
                self.recognizeCompletion (self.ppClipBusinessCardViewController.sourceImageSelectRect,
                                          recogTypeModel.typeCode,
                                          (isBackSide?self.backRecogLangID:self.frontRecogLangID),
                                          isBackSide);
            }
        }
        
        [self.ppClipBusinessCardViewController goBackAnimated:YES];
        
        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{
            [staticClipImageViewController release];
            staticClipImageViewController = nil;
        });

    }
}


//================================================================================
//
//================================================================================
- (void)ppSelectControllerDidDismiss:(PPSelectController *)selectController
{
    self.ppSelectController = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - class methods


//==============================================================================
//
//==============================================================================
+ (void)showClipImageFromViewController:(UIViewController *)viewController
                            sourceImage:(UIImage *)sourceImage
                             completion:(WCClipImageCompletion)completion
{
    [staticClipImageViewController release];
    staticClipImageViewController = [[WCClipImageViewController alloc] init];
    staticClipImageViewController.completion = completion;
    [staticClipImageViewController showFromViewController:viewController
                                           frontCardImage:sourceImage
                                            backCardImage:nil
                                     recogLangButtonTitle:nil
                                        showBackCardImage:NO
                                                 handClip:NO];

}


//==============================================================================
//
//==============================================================================
+ (void)showClipRecognizeFromViewController:(UIViewController *)viewController
                             frontCardImage:(UIImage *)frontCardImage
                              backCardImage:(UIImage *)backCardImage
                           frontRecogLangID:(NSInteger)frontRecogLangID
                            backRecogLangID:(NSInteger)backRecogLangID
                             recogLanguages:(NSArray *)recogLanguages
                                recogFields:(NSArray *)recogFields
                          showBackCardImage:(BOOL)showBackCardImage
                                 completion:(WCClipImageClipRecognizeCompletion)completion;
{
    [staticClipImageViewController release];
    staticClipImageViewController = [[WCClipImageViewController alloc] init];
    staticClipImageViewController.recognizeCompletion = completion;
    staticClipImageViewController.frontRecogLangID = frontRecogLangID;
    staticClipImageViewController.backRecogLangID = backRecogLangID;
    staticClipImageViewController.supportedRecogLanguages =recogLanguages;
    staticClipImageViewController.supportedRecogFields = recogFields;
    
    NSString *defaultRecogLangeTitle = nil;
    
    if (showBackCardImage)
    {
        defaultRecogLangeTitle = [[[self recogLanguagesAdjustedWithRecogLanguages:recogLanguages defaultLanguageID:backRecogLangID] firstObject] localizedString];
    }
    else
    {
        defaultRecogLangeTitle = [[[self recogLanguagesAdjustedWithRecogLanguages:recogLanguages defaultLanguageID:frontRecogLangID] firstObject] localizedString];
    }
    
    [staticClipImageViewController showFromViewController:viewController
                                           frontCardImage:frontCardImage
                                            backCardImage:backCardImage
                                     recogLangButtonTitle:defaultRecogLangeTitle
                                        showBackCardImage:showBackCardImage
                                                 handClip:YES];
}


//==============================================================================
// 把上次選取的語系設為第一個
//==============================================================================
+ (NSArray *)recogLanguagesAdjustedWithRecogLanguages:(NSArray *)recogLanguage defaultLanguageID:(NSInteger)defaultLanguageID
{
    NSArray *adjustedRecogLanguages = nil;
    NSMutableArray *originRecogLanguages = [[NSMutableArray alloc] initWithArray:recogLanguage];
    for (WCKernelRecogLangModel *recogLangModel in originRecogLanguages)
    {
        // 如果有一樣的，移到最前面
        if (recogLangModel.langCode == defaultLanguageID)
        {
            [originRecogLanguages removeObject:recogLangModel];
            [originRecogLanguages insertObject:recogLangModel atIndex:0];
            break;
        }
    }
    
    if ([originRecogLanguages count]>0)
    {
        adjustedRecogLanguages = [[[NSArray alloc] initWithArray:originRecogLanguages] autorelease];
    }
    [originRecogLanguages release];
    return adjustedRecogLanguages;
}
@end
