//
//  WCCardImageFlowController.m
//  WorldCardMobile7
//
//  Created by sanhue on 2015/7/20.
//  Copyright (c) 2015年 penpower. All rights reserved.
//

#import "WCCardImageFlowController.h"

// define
#import "WCContactAccessFlowResourceDefine.h"

//view
#import "PPAlertView.h"

// view controllers
#import "PPCardImageViewController.h"
#import "PPNavigationController.h"
#import "PPImageEnhanceViewController.h"
#import "WCImagePickerController.h"
#import "WCToastController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCCardImageFlowController ()
<
PPCardImageViewControllerDatasource,
PPCardImageViewControllerDelegate,
PPImageEnhanceViewControllerDelegate,
UINavigationControllerDelegate,
UIImagePickerControllerDelegate
>

@property (nonatomic, assign) id<WCCardImageFlowControllerDelegate> delegate;
@property (nonatomic, retain) PPCardImageViewController *cardImageViewController;

@property (nonatomic, retain) NSString *cardID;

@property (nonatomic, assign) BOOL isFirstLoadFrontImage;            // 第一次從資料庫取得
@property (nonatomic, assign) BOOL isFirstLoadBackImage;            // 第一次從資料庫取得

@property (nonatomic, retain) UIImage *frontCardImage;          // 重load或修改後的正面圖
@property (nonatomic, retain) UIImage *backCardImage;           // 重load或修改後的正面圖
@property (nonatomic, assign) BOOL isBackBecomeFront;           // 是否有反面變正面(兩張圖都存在，且刪正面圖)
@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCCardImageFlowController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)initWithDelegate:(id<WCCardImageFlowControllerDelegate>)delegate
{
    self = [super init];
    if (self)
    {
        self.delegate = delegate;
        self.isBackBecomeFront = NO;
//        self.imageState = WCCardImageFlowControllerImageState_None;
        
        //////////////////////////////////////////////////
        [self resetCardImageViewControllerState];
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.delegate = nil;
    self.userInfo = nil;
    self.cardImageViewController = nil;
    self.cardID = nil;
    self.backCardImage = nil;
    self.frontCardImage = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - state control


//==============================================================================
//
//==============================================================================
- (void)resetCardImageViewControllerState
{
    self.isFirstLoadFrontImage = YES;
    self.isFirstLoadBackImage = YES;
    
    self.frontCardImage = nil;
    self.backCardImage = nil;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - private methods


//==============================================================================
//
//==============================================================================
- (void)showAlbum
{
    UIImagePickerController *pickerController = [[UIImagePickerController alloc] init];
    
    if(pickerController!=nil)
    {
        pickerController.sourceType = UIImagePickerControllerSourceTypeSavedPhotosAlbum;
        pickerController.delegate   = self;
        
        [self.cardImageViewController presentViewController:pickerController animated:NO completion:nil];
    }
    
    [pickerController release];
}


//==============================================================================
//
//==============================================================================
- (void)showCamera
{
    if ([UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera])
    {
        UIImagePickerController *pickerController = [[UIImagePickerController alloc] init];
        
        if(pickerController!=nil)
        {
            pickerController.sourceType = UIImagePickerControllerSourceTypeCamera;
            pickerController.delegate   = self;
            
            [self.cardImageViewController presentViewController:pickerController animated:NO completion:nil];
        }
        
        [pickerController release];
    }
    else
    {
        [PPAlertView showWithStyle:UIAlertViewStyleDefault
                             title:@""
                           message:WCCardImageFlowControllerString_NotSupportCamera
                 cancelButtonTitle:WCCAFC_Ok
                 otherButtonTitles:nil];
    }
}


//==============================================================================
//
//==============================================================================
- (void)showImageEnhanceFromViewController:(UIViewController *)viewController sourceImage:(UIImage *)sourceImage
{
    if (viewController==nil)
    {
        return ;
    }
    
    // 不存在就不用進影像優化
    if ([self checkExistAndShowToastIfNeededFromViewController:self.cardImageViewController withCardID:self.cardID]==NO)
    {
        return ;
    }
    
    //////////////////////////////////////////////////
    PPImageEnhanceViewController *imageEnhanceViewController = [[PPImageEnhanceViewController alloc] init];
    
    if(imageEnhanceViewController!=nil)
    {
        [imageEnhanceViewController.ppInterfaceOrientationController setMask:[self interfaceOrientationControllerMask]];
        
        imageEnhanceViewController.delegate    = self;
        imageEnhanceViewController.sourceImage = sourceImage;
        [viewController.navigationController pushViewController:imageEnhanceViewController animated:YES];
    }
    
    [imageEnhanceViewController release];
}


//==============================================================================
//
//==============================================================================
- (PPInterfaceOrientationControllerMask)interfaceOrientationControllerMask
{
    // !! ipad只有橫式
    if (UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
    {
        return PPInterfaceOrientationControllerMask_LandscapeLeft|PPInterfaceOrientationControllerMask_LandscapeRight;
    }
    else
    {
        return PPInterfaceOrientationControllerMask_All;
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Toast method


//==============================================================================
//
//==============================================================================
- (BOOL)checkExistAndShowToastIfNeededFromViewController:(UIViewController *)viewController withCardID:(NSString *)cardID
{
    BOOL isCardExist = NO;
    if ([self.delegate respondsToSelector:@selector(isCardExist:)])
    {
        isCardExist = [self.delegate isCardExist:cardID];
        
        if (isCardExist==NO)
        {
            if(viewController)
            {
                [WCToastController showMessageToastFromSuperView:viewController.view
                                                     withMessage:WCCAFC_FailedToLoadDataWithID
                                                        position:PPToastPositionCenter];
            }
        }
    }
    
    return isCardExist;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - public methods


//==============================================================================
//
//==============================================================================
- (BOOL)showFromViewController:(UIViewController *)viewController
                        cardID:(NSString *)cardID
             showBackCardImage:(BOOL)showBackCardImage
{
    if (viewController==nil)
    {
        return NO;
    }
    
    self.cardID = cardID;

    [self resetCardImageViewControllerState];

    self.cardImageViewController = [[[PPCardImageViewController alloc] init] autorelease];
    
    if(self.cardImageViewController!=nil)
    {
        // 設定可旋轉方向
        [self.cardImageViewController.ppInterfaceOrientationController setMask:[self interfaceOrientationControllerMask]];
        
        // 設定背景色
        self.cardImageViewController.bottomBarBackgroundColor = WCCAFC_ToolBarColor;
        self.cardImageViewController.navigationBarButtonHighlightedBackgroundColor = WCCAFC_ButtonBackgroundColor;
        self.cardImageViewController.buttonImageEdgeInsets = WCAppearanceDefine_ButtonImageEdgeInset;
        
        self.cardImageViewController.delegate = self;
        self.cardImageViewController.datasource = self;
        
        self.cardImageViewController.cardImageViewControllerDisplayMode = PPCardImageViewControllerDisplayMode_EditFrontSide;
        if (showBackCardImage)
        {
            self.cardImageViewController.cardImageViewControllerDisplayMode = PPCardImageViewControllerDisplayMode_EditBackSide;
        }
        //////////////////////////////////////////////////
        
        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:self.cardImageViewController];
        
        if(navigationController!=nil)
        {
            [viewController presentViewController:navigationController
                                         animated:YES
                                       completion:nil];
        }
        
        [navigationController release];
    }
    
    return YES;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - PPCardImageViewControllerDataSource

//================================================================================
//
//================================================================================
- (UIImage *)defaultImageWithCardImageViewController:(PPCardImageViewController *)cardImageViewController
{
    if ([self.delegate respondsToSelector:@selector(copyDefaultCardImageWithCardID:)])
    {
        return [[self.delegate copyDefaultCardImageWithCardID:self.cardID] autorelease];
    }
    return nil;
}

//================================================================================
//
//================================================================================
- (UIImage *)frontImageWithCardImageViewController:(PPCardImageViewController *)cardImageViewController
{
    if (self.isFirstLoadFrontImage)
    {
        self.isFirstLoadFrontImage = NO;
        
        // 第一次load才要重load
        if ([self.delegate respondsToSelector:@selector(copyFrontCardImageWithCardID:)])
        {
            self.frontCardImage =  [[self.delegate copyFrontCardImageWithCardID:self.cardID] autorelease];
        }
    }

    return self.frontCardImage;
}

//================================================================================
//
//================================================================================
- (UIImage *)rearImageWithCardImageViewController:(PPCardImageViewController *)cardImageViewController
{
    if (self.isFirstLoadBackImage)
    {
        self.isFirstLoadBackImage = NO;
        
        if ([self.delegate respondsToSelector:@selector(copyBackCardImageWithCardID:)])
        {
            self.backCardImage =  [[self.delegate copyBackCardImageWithCardID:self.cardID] autorelease];
        }
    }
    
    return self.backCardImage;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCardImageViewController Delegate Method


//==============================================================================
//
//==============================================================================
- (BOOL)shouldActionWithCardImageViewController:(PPCardImageViewController *)cardImageViewController
{
    BOOL hasImage = [cardImageViewController hasImage];
    if (hasImage==NO)
    {
        [WCToastController showMessageToastFromSuperView:cardImageViewController.view
                                             withMessage:WCCardImageFlowControllerString_NoImageExist
                                                position:PPToastPositionCenter];
    }
    
    return hasImage;
}


//================================================================================
//
//================================================================================
- (void)cardImageViewController:(PPCardImageViewController *)cardImageViewController
                         action:(PPCardImageViewControllerAction)action
{
    switch (action)
    {
        case PPCardImageViewControllerAction_Exit:
        {
            if ([self.delegate respondsToSelector:@selector(didFinishWithCardImageFlowController:)])
            {
                [self.delegate didFinishWithCardImageFlowController:self];
            }
            
            [cardImageViewController goBackAnimated:YES];
            break;
        }
        case PPCardImageViewControllerAction_TakePhotoForFrontCard:
        {
            self.frontCardImage = cardImageViewController.frontCardImage;
            self.backCardImage = cardImageViewController.rearCardImage;
            
            [WCImagePickerController showCameraFromViewController:cardImageViewController completion:^(UIImage *pickedImage) {
                self.frontCardImage = pickedImage;
                cardImageViewController.cardImageViewControllerDisplayMode = PPCardImageViewControllerDisplayMode_EditFrontSide;
            }];
            break;
        }
        case PPCardImageViewControllerAction_TakePhotoForRearCard:
        {
            self.frontCardImage = cardImageViewController.frontCardImage;
            self.backCardImage = cardImageViewController.rearCardImage;

            [WCImagePickerController showCameraFromViewController:cardImageViewController completion:^(UIImage *pickedImage) {
                self.backCardImage = pickedImage;
                cardImageViewController.cardImageViewControllerDisplayMode = PPCardImageViewControllerDisplayMode_EditBackSide;
            }];
            break;
        }
        case PPCardImageViewControllerAction_SelectPhotoForFrontCard:
        {
            self.frontCardImage = cardImageViewController.frontCardImage;
            self.backCardImage = cardImageViewController.rearCardImage;

            [WCImagePickerController showAlbumFromViewController:cardImageViewController completion:^(UIImage *pickedImage) {
                self.frontCardImage = pickedImage;
                cardImageViewController.cardImageViewControllerDisplayMode = PPCardImageViewControllerDisplayMode_EditFrontSide;
            }];
            break;
        }
        case PPCardImageViewControllerAction_SelectPhotoForRearCard:
        {
            self.frontCardImage = cardImageViewController.frontCardImage;
            self.backCardImage = cardImageViewController.rearCardImage;

            [WCImagePickerController showAlbumFromViewController:cardImageViewController completion:^(UIImage *pickedImage) {
                self.backCardImage = pickedImage;
                cardImageViewController.cardImageViewControllerDisplayMode = PPCardImageViewControllerDisplayMode_EditBackSide;
            }];
            break;
        }
        case PPCardImageViewControllerAction_ImageEnhanceForFrontCard:
        {
            self.frontCardImage = cardImageViewController.frontCardImage;
            self.backCardImage = cardImageViewController.rearCardImage;

            [self showImageEnhanceFromViewController:cardImageViewController sourceImage:self.frontCardImage];
            break;
        }
        case PPCardImageViewControllerAction_ImageEnhanceForRearCard:
        {
            self.frontCardImage = cardImageViewController.frontCardImage;
            self.backCardImage = cardImageViewController.rearCardImage;

            [self showImageEnhanceFromViewController:cardImageViewController sourceImage:self.backCardImage];
            break;
        }
        case PPCardImageViewControllerAction_DeleteFrontCard:
        {
            // !! 要把反面圖變正面
            if (self.backCardImage!=nil && self.frontCardImage!=nil)
            {
                self.isBackBecomeFront = YES;
            }
            
            self.frontCardImage = self.backCardImage;
            self.backCardImage = nil;
            break;
        }
        case PPCardImageViewControllerAction_DeleteRearCard:
        {
            self.backCardImage = nil;
            break;
        }
        default:
        {
            
            break;
        }
    }
}


//================================================================================
//
//================================================================================
- (void)cardImageViewController:(PPCardImageViewController *)cardImageViewController
       didPickingFrontCardImage:(UIImage *)frontCardImage
                  rearCardImage:(UIImage *)rearCardImage
{
    //////////////////////////////////////////////////

    BOOL canLeave = YES;
    // 不存在就不儲存
    if ([self checkExistAndShowToastIfNeededFromViewController:cardImageViewController withCardID:self.cardID])
    {
        if ([self.delegate respondsToSelector:@selector(didFinishWithCardID:frontCardImage:isFrontCardChanged:backCardImage:isBackCardChanged:isBackBecomeFront:)])
        {
            canLeave = [self.delegate didFinishWithCardID:self.cardID
                                           frontCardImage:frontCardImage
                                       isFrontCardChanged:[cardImageViewController frontCardImageFixed]
                                            backCardImage:rearCardImage
                                        isBackCardChanged:[cardImageViewController rearCardImageFixed]
                                        isBackBecomeFront:self.isBackBecomeFront];
        }
    }

    //////////////////////////////////////////////////
    
    if (canLeave)
    {
        [cardImageViewController goBackAnimated:YES];
        self.cardImageViewController = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - PPImageEnhanceViewControllerDelegate


//================================================================================
//
//================================================================================
- (BOOL)imageEnhanceViewController:(PPImageEnhanceViewController *)imageEnhanceViewController action:(ImageEnhanceViewControllerAction)action
{
    switch (action)
    {
        case ImageEnhanceViewControllerAction_Light:
        {
            BOOL result = [self checkExistAndShowToastIfNeededFromViewController:imageEnhanceViewController withCardID:self.cardID];
            return result;
        }
        case ImageEnhanceViewControllerAction_Clip:
        {
            BOOL result = [self checkExistAndShowToastIfNeededFromViewController:imageEnhanceViewController withCardID:self.cardID];
            return result;
        }
            
        case ImageEnhanceViewControllerAction_Done:
        {
            // 不存在就不儲存
            if ([self checkExistAndShowToastIfNeededFromViewController:imageEnhanceViewController withCardID:self.cardID])
            {
                if (self.cardImageViewController.cardImageViewControllerAction == PPCardImageViewControllerAction_ImageEnhanceForFrontCard)
                {
                    self.frontCardImage = imageEnhanceViewController.sourceImage;
                }
                else
                {
                    self.backCardImage = imageEnhanceViewController.sourceImage;
                }
            }
            
            [imageEnhanceViewController goBackAnimated:YES];
            break;
        }
        default:
            break;
    }
    return YES;
}


@end
